/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.HeapBlock;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.runtime.VirtualSpace;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class CodeHeap
extends VMObject {
    private static Field memoryField;
    private static Field segmapField;
    private static CIntegerField log2SegmentSizeField;
    private VirtualSpace memory;
    private VirtualSpace segmentMap;
    private int log2SegmentSize;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("CodeHeap");
        memoryField = type.getField("_memory");
        segmapField = type.getField("_segmap");
        log2SegmentSizeField = type.getCIntegerField("_log2_segment_size");
    }

    public CodeHeap(Address addr) {
        super(addr);
        this.log2SegmentSize = (int)log2SegmentSizeField.getValue(addr);
        this.segmentMap = new VirtualSpace(addr.addOffsetTo(segmapField.getOffset()));
        this.memory = new VirtualSpace(addr.addOffsetTo(memoryField.getOffset()));
    }

    public Address begin() {
        return this.getMemory().low();
    }

    public Address end() {
        return this.getMemory().high();
    }

    public boolean contains(Address p) {
        return this.begin().lessThanOrEqual(p) && this.end().greaterThan(p);
    }

    public Address findStart(Address p) {
        if (!this.contains(p)) {
            return null;
        }
        HeapBlock h = this.blockStart(p);
        if (h == null || h.isFree()) {
            return null;
        }
        return h.getAllocatedSpace();
    }

    public Address nextBlock(Address ptr) {
        Address base = this.blockBase(ptr);
        if (base == null) {
            return null;
        }
        HeapBlock block = this.getBlockAt(base);
        return base.addOffsetTo(block.getLength() * (long)(1 << this.getLog2SegmentSize()));
    }

    private VirtualSpace getMemory() {
        return this.memory;
    }

    private VirtualSpace getSegmentMap() {
        return this.segmentMap;
    }

    private long segmentFor(Address p) {
        return p.minus(this.getMemory().low()) >> this.getLog2SegmentSize();
    }

    private int getLog2SegmentSize() {
        return this.log2SegmentSize;
    }

    private HeapBlock getBlockAt(Address addr) {
        return (HeapBlock)VMObjectFactory.newObject(HeapBlock.class, addr);
    }

    private HeapBlock blockStart(Address p) {
        Address base = this.blockBase(p);
        if (base == null) {
            return null;
        }
        return this.getBlockAt(base);
    }

    private Address blockBase(Address p) {
        long i = this.segmentFor(p);
        Address b = this.getSegmentMap().low();
        if (b.getCIntegerAt(i, 1L, true) == 255L) {
            return null;
        }
        while (b.getCIntegerAt(i, 1L, true) > 0L) {
            i -= b.getCIntegerAt(i, 1L, true);
        }
        return this.getMemory().low().addOffsetTo(i << this.getLog2SegmentSize());
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                CodeHeap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

