/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.profile.TableProfileCreator;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.MonitorableImpl;
import org.apache.log4j.Logger;

public abstract class AbstractTableProfileCreator
implements TableProfileCreator {
    private static final Logger logger = Logger.getLogger(AbstractTableProfileCreator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean doProfile(TableProfileResult tpr) {
        MonitorableImpl pm = (MonitorableImpl)tpr.getProgressMonitor();
        tpr.begin("Profiling");
        try {
            tpr.fireProfileStarted();
            pm.setMessage(((SQLTable)tpr.getProfiledObject()).getName());
            if (!pm.isCancelled()) {
                pm.setStarted(true);
                pm.setFinished(false);
                tpr.setCreateStartTime(System.currentTimeMillis());
                this.doProfileImpl(tpr);
            }
        }
        catch (Exception ex) {
            tpr.setException(ex);
            logger.error((Object)"Profile failed. Saving exception:", (Throwable)ex);
        }
        finally {
            tpr.setCreateEndTime(System.currentTimeMillis());
            pm.setProgress(pm.getProgress() + 1);
            pm.setFinished(true);
            pm.setStarted(false);
            if (pm.isCancelled()) {
                tpr.fireProfileCancelled();
            } else {
                tpr.fireProfileFinished();
            }
        }
        tpr.commit();
        return !pm.isCancelled();
    }

    protected abstract boolean doProfileImpl(TableProfileResult var1) throws Exception;
}

