#!/usr/bin/env python
# -*- mode: python; coding: utf-8; -*-
# ---------------------------------------------------------------------------##
#
# Copyright (C) 1998-2003 Markus Franz Xaver Johannes Oberhumer
# Copyright (C) 2003 Mt. Hood Playing Card Co.
# Copyright (C) 2005-2009 Skomoroh
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# ---------------------------------------------------------------------------##

from pysollib.games.mahjongg.mahjongg import r

# ************************************************************************
# * game definitions
# ************************************************************************

r(5001, "Altar", layout="0aaaacaaiaakaama" +
    "aoaaqaasaauaawaa" +
    "CaaEaaacaccaicck" +
    "ccmccoccqccsccuc" +
    "awcaCcaEcaieckec" +
    "mecoecqecsecueaw" +
    "eaigckgcmgcogcqg" +
    "csgcugawgaiiakia" +
    "miaoiaqiasiauiaw" +
    "iaokaqkaamacmaom" +
    "aqmaCmaEmaaoacoa" +
    "ooaqoaCoaEohabhc" +
    "bhCbhEbkpijpkipm" +
    "hanhcnhCnhEnhpoo" +
    "bboDbobnoDnvlcvn" +
    "cvpcvrcvtcvlevne" +
    "vpevrevtevlgwngw" +
    "pgwrgvtgCocCqcCm" +
    "eCoeCqeCse")
r(5002, "Arena 1", layout="0eaadcaceabgaaia" +
    "aqabsacuadwaeyad" +
    "accccbecagcakcbm" +
    "caocascbuccwcdyc" +
    "caebceaeeameaueb" +
    "wecyebagacgakgbm" +
    "gaogawgbygcaibci" +
    "aeiamiauibwicyid" +
    "akcckbekagkakkbm" +
    "kaokaskbukcwkdyk" +
    "eamdcmcembgmaima" +
    "qmbsmcumdwmeym")
r(5003, "Arena 2", layout="0daadcabeabgaaia" +
    "akaamaaoaaqaasab" +
    "uabwadyadAadaccc" +
    "cbecagcaucbwccyc" +
    "dAcdaecceaeeawec" +
    "yedAedagccgaegaw" +
    "gcygdAgdaicciaei" +
    "awicyidAidakcckb" +
    "ekagkaukbwkcykdA" +
    "kdamdcmbembgmaim" +
    "asmbumbwmdymdAm")
#
r(5004, "Arrow", layout="0aaaaqbaacaccasc" +
    "aqdaudaaeaceaeea" +
    "geaieakeameaoeas" +
    "eaweaqfaufayfaag" +
    "acgaegaggaigakga" +
    "mgaogasgawgaAgaC" +
    "gaqhauhayhaaiaci" +
    "aeiagiaiiakiamia" +
    "oiasiawiaqjaujaa" +
    "kackaskaqlaamhbc" +
    "hrdhbehdehfehheh" +
    "jehlehnehpehtehr" +
    "fhvfhbghdghfghhg" +
    "hjghlghnghpghtgh" +
    "xghrhhvhhbihdihf" +
    "ihhihjihlihnihpi" +
    "htihrjhbkoceoeeo" +
    "geoieokeomeooeoq" +
    "eosfocgoegoggoig" +
    "okgomgoogoqgougo" +
    "shocioeiogioiiok" +
    "iomiooioqivfevhe" +
    "vjevlevnevpevfgv" +
    "hgvjgvlgvngvpgvr" +
    "gvfivhivjivlivni" +
    "vpiCkeCmeCoeCkgC" +
    "mgCogCqgCkiCmiCo" +
    "i")
r(5005, "Art Moderne", layout="0acaaeaagaaiaaka" +
    "amaaoaauaawaaaba" +
    "lcapcatcavcaxcaa" +
    "daddaleapeaseaue" +
    "bxeaafacfalganga" +
    "pgargatgavgaxgaa" +
    "hachaliapiasiaui" +
    "bxiaajadjalkapka" +
    "tkavkaxkaalacmae" +
    "magmaimakmammaom" +
    "aumawmhdahfahhah" +
    "jahlahnahvahxahu" +
    "chwchychedhldhpd" +
    "haehtehvehdfhlfh" +
    "pfhaghsghughwghd" +
    "hhlhhphhaihtihvi" +
    "hejhljhpjhukhwkh" +
    "ykhdmhfmhhmhjmhl" +
    "mhnmhvmhxmowaoya" +
    "ovcoxcozcofdokdo" +
    "ueoweoyeoefokfom" +
    "gotgovgoehokhoui" +
    "owioyiofjokjovko" +
    "xkozkowmoymvgdvj" +
    "dvffvjfvlgvfhvjh" +
    "vgjvjjChdCgfCifC" +
    "kgCghCihChj")
r(5006, "Balance", layout="0eoaeebbgbbibbkb" +
    "bmbbqbbsbbubbwbe" +
    "ybeoccedcydcoecc" +
    "faefcgfcwfayfcAf" +
    "cogachaghawhaAhc" +
    "oiaajacjaejagjai" +
    "jaujawjayjaAjaCj" +
    "cokadlaflaxlazlc" +
    "omagoaioakoamoao" +
    "oaqoasoauoawohbj" +
    "hdjhfjhhjhvjhxjh" +
    "zjhBjjeljylhhoij" +
    "ojloknokpojroito" +
    "hvoocjoejogjowjo" +
    "yjoAjvdjvfjvxjvz" +
    "jCejCyj")
r(5007, "Bat", layout="0ecaeAaaabalbanb" +
    "apbarbaCbcccaeca" +
    "yccAcaadandapdaC" +
    "dcceaeebgeaieaue" +
    "bweayecAeaafanfa" +
    "pfaCfbcgbegaggbi" +
    "gakgasgbugawgbyg" +
    "bAgaahamhbohaqha" +
    "Chbcibeiagibiiak" +
    "iasibuiawibyibAi" +
    "aajamjbojaqjaCjc" +
    "ckaekbgkaikakkas" +
    "kaukbwkaykcAkaal" +
    "aolaClccmaemaima" +
    "kmasmaumaymcAmaa" +
    "naCnecobkobsoeAo" +
    "hobhodhofhaghCgh" +
    "aihCi")
#
r(5008, "Beetle", layout="0aeaagaauaawaaic" +
    "akcamcaocaqcasca" +
    "eeageaieakeameao" +
    "eaqeaseaueadgafg" +
    "ahgajgalgangapga" +
    "rgatgavgaeiagiai" +
    "iakiamiaoiaqiasi" +
    "auiaikakkamkaoka" +
    "qkaskaemagmaumaw" +
    "mhhbhtbhjchlchnc" +
    "hpchrchdehfehheh" +
    "jehlehnehpehreht" +
    "eiegiggiigikgimg" +
    "iogiqgisghughdih" +
    "fihhihjihlihnihp" +
    "ihrihtihjkhlkhnk" +
    "hpkhrkhhlhtloceo" +
    "geoieokeomeooeoq" +
    "eoseociogioiioki" +
    "omiooioqiosivbdv" +
    "hevjevlevnevpevr" +
    "evfgvhgvjgvlgvng" +
    "vpgvrgvhivjivliv" +
    "nivpivrivbjCaaCa" +
    "cCggCigCkgCmgCog" +
    "CqgCakCam")
r(5009, "Big Hole", layout="0daadcadeadgadia" +
    "dkadmadoaaaccccd" +
    "ecdgcdicdkccmcao" +
    "caaeccedeedkecme" +
    "aoeaagccgdegdkgc" +
    "mgaogaaiccideidg" +
    "idiidkicmiaoidak" +
    "dckdekdgkdikdkkd" +
    "mkdok")
r(5010, "Bizarre", layout="0aaaaGadkbdmbdob" +
    "dqbdsbdubdwbdkdc" +
    "mdcodcqdcsdcuddw" +
    "ddkfcmfbofbqfbsf" +
    "cufdwfdkhcmhboha" +
    "qhbshcuhdwhakjbm" +
    "jcojdqjcsjbujawj" +
    "aklbmlcolcqlcslb" +
    "ulawlaknbmnbonbq" +
    "nbsnbunawnakpamp" +
    "aopaqpaspaupawpa" +
    "aqaGq")
r(5011, "Boat", layout="0alaapaataajcblc" +
    "apcbtcavcahebjec" +
    "leapectebveaxeaf" +
    "gbhgcjgdlgapgdtg" +
    "cvgbxgazgadibfic" +
    "hidjieliapietidv" +
    "icxibziaBiapkaam" +
    "bcmbembgmbimbkmb" +
    "mmbombqmbsmbumbw" +
    "mbymbAmbCmaEmado" +
    "bfobhobjoblobnob" +
    "pobrobtobvobxobz" +
    "oaBoaiqbkqbmqboq" +
    "bqqbsqbuqawq")
r(5012, "Bug", layout="0bhabnabtaajbapb" +
    "avbcadaidakdamda" +
    "odaqdasdaudawdac" +
    "eayeagfbifbkfbmf" +
    "bofbqfbsfbufbwfa" +
    "Afdegaygbchbghci" +
    "hckhcmhcohcqhcsh" +
    "cuhbwhaAhdeiayia" +
    "gjbijbkjbmjbojbq" +
    "jbsjbujbwjaAjack" +
    "aykcalailaklamla" +
    "olaqlaslaulawlaj" +
    "napnavnbhobnobto" +
    "hyhojfolfonfopfo" +
    "rfotfovfojjoljon" +
    "jopjorjotjovjvjh" +
    "vlhvnhvphvrhvthC" +
    "khCmhCohCqhCsh")
r(5013, "Butterfly 1", layout="0dmadqaaabaebayb" +
    "aCbagccocawcaada" +
    "edaidaudaydaCdac" +
    "eageakedoeaseawe" +
    "aAeaafaefbifamfa" +
    "qfbufayfaCfacgag" +
    "gbkgeogbsgawgaAg" +
    "aahaehbihbmhbqhb" +
    "uhayhaChaciagibk" +
    "ieoibsiawiaAiaaj" +
    "aejbijamjaqjbuja" +
    "yjaCjackagkakkeo" +
    "kaskawkaAkaalael" +
    "ailaulaylaClacma" +
    "gmeomawmaAmaanae" +
    "naynaCncoohgdhwd" +
    "heehyehcfhgfhwfh" +
    "AfhaghCghaihCihc" +
    "jhgjhwjhAjhekhyk" +
    "hglhwl")
#
r(5014, "Castle", layout="0eaaccaceacgacia" +
    "ckaemacacaccaeca" +
    "gcaicakccmcdaeac" +
    "eaeeageaieakedme" +
    "aoecagacgaegagga" +
    "igakgcmgbogaqgda" +
    "iaciaeiagiaiiaki" +
    "dmiaoicakackaeka" +
    "gkaikakkcmkeamcc" +
    "mcemcgmcimckmemm" +
    "hddhfdhhdhjdhdfh" +
    "ffhhfhjfhdhhfhhh" +
    "hhjhhdjhfjhhjhjj" +
    "oeeogeoieoegoggo" +
    "igoeiogioiivffvh" +
    "fvfhvhhCgg")
r(5015, "Cat and Mouse", layout="0cfabhacjablacna" +
    "bpacrabtacBacFab" +
    "dbbvbbbcbxcbBccD" +
    "cbFcahdajdaldbzd" +
    "baecBebDecFeahfa" +
    "jfalfbagahhajhal" +
    "hbuhbBhbbibsibwi" +
    "bFibqjbBjbckbokb" +
    "xkbFkcelbglcilbk" +
    "lcmlbsmbwmbunbAo" +
    "cCocEocGohiehkeh" +
    "ighkgohdojdoldoh" +
    "fojfolfohhojholh" +
    "oBkoFloAnvievkev" +
    "igvkgvBlvFmCjdCh" +
    "fClfCjh")
r(5016, "Ceremonial", layout="0bcabeaajaalaana" +
    "apaaraataavabAab" +
    "CabdcbfcbzcbBcaa" +
    "dapdaEdbeebgeane" +
    "arebyebAeaafbifb" +
    "kfapfbufbwfaEfbm" +
    "gbsgaahaphaEhbmi" +
    "bsiaajbijbkjapjb" +
    "ujbwjaEjbekbgkan" +
    "karkbykbAkaalapl" +
    "aElbdmbfmbzmbBmb" +
    "cobeoajoaloanoap" +
    "oaroatoavobAobCo" +
    "hkahmahoahqahsah" +
    "uahaehoehqehEeha" +
    "gipghEghaiipihEi" +
    "hakhokhqkhEkhkoh" +
    "mohoohqohsohuoon" +
    "aopaoraopeoahoEh" +
    "opkonoopoorovph")
r(5017, "Checkered", layout="0baabCaacbbebagb" +
    "bibakbbmbaobbqba" +
    "sbbubawbbybaAbbc" +
    "daedbgdaidbkdamd" +
    "bodaqdbsdaudbwda" +
    "ydbAdacfbefagfbi" +
    "fakfbmfaofbqfasf" +
    "bufawfbyfaAfbcha" +
    "ehbghaihbkhamhbo" +
    "haqhbshauhbwhayh" +
    "bAhacjbejagjbija" +
    "kjbmjaojbqjasjbu" +
    "jawjbyjaAjbclael" +
    "bglailbklamlbola" +
    "qlbslaulbwlaylbA" +
    "lacnbenagnbinakn" +
    "bmnaonbqnasnbuna" +
    "wnbynaAnbaobCo")
#
r(5018, "Chip", layout="0aeaaiaamaaqaata" +
    "becbgcbicbkcbmcb" +
    "ocbqcbscbucbwcaa" +
    "dbcdbydaAdbeecge" +
    "cieckecmecoecqec" +
    "secuebweaagbcgbe" +
    "gdggbigakgamgaog" +
    "aqgbsgdugbwgbyga" +
    "Agbeicgiciickicm" +
    "icoicqicsicuibwi" +
    "aajbcjbyjaAjbekb" +
    "gkbikbkkbmkbokbq" +
    "kbskbukbwkaemaim" +
    "ammaqmaum")
r(5019, "Columns", layout="0egaaiaakaamaaoa" +
    "aqaasaauaewaaeba" +
    "ybagcaicaocaucaw" +
    "ceadbcdaedaydbAd" +
    "eCdageekeameaoea" +
    "qeeseawebafbCfag" +
    "gakgasgawgaahamh" +
    "eohaqhaChagiakia" +
    "siawibajbCjagkdk" +
    "kamkaokaqkeskawk" +
    "ealbclaelaylbAle" +
    "Clagmaimaomaumaw" +
    "maenaynegoaioako" +
    "amoaooaqoasoauoe" +
    "wohgfhwfjghjwhhg" +
    "jhwj")
r(5020, "Crown", layout="0baabcabeabgabka" +
    "bmaboabqabsabwab" +
    "yabAabCabacaccae" +
    "cbgcbkcamcbocaqc" +
    "bscbwcaycaAcbCcb" +
    "aeaeebgebkeameaq" +
    "ebsebweayebCebag" +
    "aegbggbigbkgamga" +
    "qgbsgbugbwgaygbC" +
    "gbaiaeiagiaiiaki" +
    "amiaqiasiauiawia" +
    "yibCibakbCkbamac" +
    "maemagmaimakmbom" +
    "asmaumawmaymaAmb" +
    "Cmbaobcobeobgobi" +
    "obkoamobooaqobso" +
    "buobwobyobAobCo")
#
r(5021, "Cupola", layout="0aiaakaamaaoaaqa" +
    "asaagbaubaecawca" +
    "cdaydabfeofazfaa" +
    "hajhalhanhapharh" +
    "athaAhaajeojaAja" +
    "blazlacnaynaeoaw" +
    "oagpaupaiqakqamq" +
    "aoqaqqasqhjbhlbh" +
    "nbhpbhrbhhchtchf" +
    "dhvdhdehxehcghyg" +
    "hkhhmhhohhqhhshh" +
    "bihzihckhykhdmhx" +
    "mhfnhvnhhohtohjp" +
    "hlphnphpphrpokco" +
    "mcoocoqcoidosdog" +
    "eoueoefowfodholh" +
    "onhophorhoxhodjo" +
    "xjoelowlogmoumoi" +
    "nosnokoomoooooqo" +
    "vldvndvpdvjevrev" +
    "hfvtfvfgvvgvmhvo" +
    "hvqhveivwivfkvvk" +
    "vhlvtlvjmvrmvlnv" +
    "nnvpnCifCsfCggCu" +
    "gCnhCphCfiCviCgk" +
    "CukCilCsl")
r(5022, "Deep Well", layout="0acaaeaagaaiaaka" +
    "amaaaccccceccgcc" +
    "icckccmcaocaaecc" +
    "eeeeegeeieekecme" +
    "aoeaagccgeegekgc" +
    "mgaogaaiccieeiek" +
    "icmiaoiaakcckeek" +
    "egkeikekkcmkaoka" +
    "amccmcemcgmcimck" +
    "mcmmaomacoaeoago" +
    "aioakoamo")
r(5023, "Dragon 1", layout="0bgaaiaegceicdkc" +
    "cmcbocbqcbscbuca" +
    "wcaycaceaeeageai" +
    "eakebmeboeaqease" +
    "aueaweayeadgbfga" +
    "hgajgalgangapgaE" +
    "gayhaChaaiaciaei" +
    "agiaiiakiamiaoia" +
    "qiasiauiaAiaEiaC" +
    "jabkadkafkahkajk" +
    "alkaEkaamacmaema" +
    "gmbimakmaaoacobe" +
    "oagoaiockoamoixc" +
    "hdejhejigkkgjmgh" +
    "Ehhbihdikhikjijl" +
    "iiniipihrihtihCi" +
    "hEjhckhgkhkkhbmh" +
    "fmhboihopneocioE" +
    "iobn")
r(5024, "Dude", layout="0bfabtabhbbjbblb" +
    "brbaBbatcavcaxca" +
    "zcaedagdbldbndbp" +
    "dbrdacebjebueaye" +
    "aAeaCeaafbhfcmfc" +
    "ofcqfcsfbwfaEfbf" +
    "gckgcugbygcphbAh" +
    "beickicuicpjbBjc" +
    "jkclkcnkcrkctkcv" +
    "kcjmclmcnmcrmctm" +
    "cvmcpncjocvockqc" +
    "mqcoqcqqcsqcuq")
r(5026, "Enterprise", layout="0agaaiaakaamaaoa" +
    "aqaasaauaawaayaa" +
    "acbccbecbgcbicbk" +
    "cbmcbocbqcbscbuc" +
    "bwcbycbAcbCcaEcd" +
    "qedogdmhaAiaajbc" +
    "jcejdgjeijekjemj" +
    "eojcqjayjaCjaAkh" +
    "haijailainaipair" +
    "aitaivahxaiAjodc" +
    "ofcohcojcolconco" +
    "pcorcotcovcoxcoz" +
    "coBcvkavmavoavqa" +
    "vsavecvgcvicvkcv" +
    "mcvocvqcvscvucvw" +
    "cvycChcCjcClcCnc" +
    "CpcCrcCtcCvc")
#
r(5027, "Eye", layout="0amaaoaakbaqbaic" +
    "amcaocascagdakda" +
    "qdaudaeeaieameao" +
    "easeaweacfagfakf" +
    "aqfaufayfaagaega" +
    "igamgaogasgawgaA" +
    "gachaghakhaqhauh" +
    "ayhaeiaiiamiaoia" +
    "siawiagjakjaqjau" +
    "jaikamkaokaskakl" +
    "aqlammaomhlbhobh" +
    "jchqchhdhldhodhs" +
    "dhfehjehqehuehdf" +
    "hhfhlfhofhsfhwfh" +
    "fghjghqghughdhhh" +
    "hhlhhohhshhwhhfi" +
    "hjihqihuihhjhljh" +
    "ojhsjhjkhqkhllho" +
    "lolcoocojdoqdohe" +
    "oleooeoseoffojfo" +
    "qfoufohgolgoogos" +
    "gowgofhojhoqhouh" +
    "ohioliooiosiojjo" +
    "qjolkookvldvodvj" +
    "evqevhfvlfvofvsf" +
    "vfgvjgvqgvhhvlhv" +
    "ohvshvjivqivljvo" +
    "j")
r(5028, "F-15 Eagle", layout="0aobaqbasbaubbEc" +
    "bGcandapdardatda" +
    "lebDebFeajfanfap" +
    "farfalgatgavgaxg" +
    "azgaBgaDgabhadha" +
    "fhahhajhanhaphar" +
    "haliatiaviaxiazi" +
    "aBiaDiajjanjapja" +
    "rjalkbDkbFkanlap" +
    "larlatlbEmbGmaon" +
    "aqnasnaunhpahrah" +
    "tahvahochqchschu" +
    "chmehoehqehsehif" +
    "hkfhmghoghqghsgh" +
    "ughwghyghAghCgia" +
    "hichjehjghjihjkh" +
    "hmihoihqihsihuih" +
    "wihyihAihCihijhk" +
    "jhmkhokhqkhskhom" +
    "hqmhsmhumhpohroh" +
    "tohvoozfoBfoDfom" +
    "hozjoBjoDjvAfvCf" +
    "vAjvCjCBfCDfCfhC" +
    "hhCjhCBjCDj")
r(5029, "Farandole", layout="0beabgabmaboabqa" +
    "bwabyabcbbibbkbb" +
    "sbbubbAbafcaxcbb" +
    "dbBdckecmecqecse" +
    "bbfbgfcifcufbwfb" +
    "Bfbegbygbahbchaj" +
    "hblhcnhcphbrhath" +
    "bAhbChbeibyibbjb" +
    "gjcijcujbwjbBjck" +
    "kcmkcqkcskbblbBl" +
    "afmaxmbcnbinbknb" +
    "snbunbAnbeobgobm" +
    "oboobqobwobyo")
r(5030, "Fish", layout="0afaajaasaauaawa" +
    "bhbaobaqbaybacca" +
    "mcbscbucbwcaAcak" +
    "dbodbqdaydaCdace" +
    "aeeaiebmebsebueb" +
    "weaEeagfbkfbofbq" +
    "fayfaCfacgaegaig" +
    "bmgbsgbugbwgaAga" +
    "EgakhbohbqhbyhaC" +
    "haciamibsibuibwi" +
    "aAiaojaqjayjahka" +
    "skaukawkbjlcemal" +
    "mbcndgnbCnaaoeio" +
    "aqoasodAoaEodkpb" +
    "opbupdypcmqcwqhc" +
    "dhcfhefhifhchore" +
    "oteolfonfopfovfo" +
    "rgotgovhoxh")
#
r(5031, "Five Pyramids 1", layout="0aaaacaaeaagaaya" +
    "aAaaCaaEaaacacca" +
    "ecagcapcaycaAcaC" +
    "caEcaaeaceaeeage" +
    "apeayeaAeaCeaEea" +
    "agacgaegaggangap" +
    "gargaygaAgaCgaEg" +
    "alhathaniapiaria" +
    "akackaekagkapkay" +
    "kaAkaCkaEkaamacm" +
    "aemagmapmaymaAma" +
    "CmaEmaaoacoaeoag" +
    "oayoaAoaCoaEoaaq" +
    "acqaeqagqayqaAqa" +
    "CqaEqhbbhdbhfbhz" +
    "bhBbhDbhbdhddhfd" +
    "hpdhzdhBdhDdhbfh" +
    "dfhffipfhzfhBfhD" +
    "fhnhhphhrhipjhbl" +
    "hdlhflhplhzlhBlh" +
    "DlhbnhdnhfnhznhB" +
    "nhDnhbphdphfphzp" +
    "hBphDpoccoecoAco" +
    "CcoceoeeoAeoCeoo" +
    "hoqhocmoemoAmoCm" +
    "ocooeooAooCovddv" +
    "BdvphvdnvBn")
r(5033, "Flowers 1", layout="0baaccaceabgaaka" +
    "bmaboaaqaauabwab" +
    "yaaAadacdgcckccq" +
    "ccuccAcbaeccecee" +
    "bgeakebmeboeaqea" +
    "uebwebyeaAeadgan" +
    "gaxgafhahhajhalh" +
    "apharhathavhadia" +
    "niaxiaakbckbekag" +
    "kakkbmkbokaqkauk" +
    "bwkbykaAkcamcgmc" +
    "kmcqmcumcAmaaobc" +
    "obeoagoakobmoboo" +
    "aqoauobwobyoaAoo" +
    "naoxaoneoxeodkon" +
    "koxkodoonooxovda" +
    "vde")
r(5034, "Traditional", layout="0acaaeaagaaiaaka" +
    "amaaoaaqaasaauaa" +
    "waayaagcbicbkcbm" +
    "cbocbqcbscaucaee" +
    "agebieckecmecoec" +
    "qebseaueaweacgae" +
    "gaggbigckgdmgdog" +
    "cqgbsgaugawgayga" +
    "ahaAhaChaciaeiag" +
    "ibiickidmidoicqi" +
    "bsiauiawiayiaeka" +
    "gkbikckkcmkcokcq" +
    "kbskaukawkagmbim" +
    "bkmbmmbombqmbsma" +
    "umacoaeoagoaioak" +
    "oamoaooaqoasoauo" +
    "awoayoCnh")
r(5035, "Fortress Towers", layout="0faaecadeacgabia" +
    "bkacmadoaeqafsae" +
    "acaccagcaicakcam" +
    "caqcescdaeaceage" +
    "aieakeameaqedsed" +
    "agacgaggaigakgam" +
    "gaqgdsgeaiaciagi" +
    "aiiakiamiaqiesif" +
    "akeckdekcgkbikbk" +
    "kcmkdokeqkfskhjc" +
    "hjehjghji")
#
r(5036, "Full Vision 1", layout="0aaaaiaamaaoaaqa" +
    "asaawaaEaacbaeba" +
    "gbaybaAbaCbaacai" +
    "camcaocaqcascawc" +
    "aEcacdaedagdayda" +
    "AdaCdaaeaieaweaE" +
    "eaefamfasfaAfagg" +
    "aigakgaugawgayga" +
    "ehamhashaAhagiai" +
    "iakiauiawiayiaej" +
    "amjasjaAjaakaika" +
    "wkaEkaclaelaglay" +
    "laAlaClaamaimaom" +
    "aqmawmaEmacnaena" +
    "gnamnasnaynaAnaC" +
    "naaoaioaooaqoawo" +
    "aEohpahbbhhbhnbh" +
    "rbhxbhDbhdchfchp" +
    "chzchBchbdhhdhxd" +
    "hDdhfghlghtghzgh" +
    "hhhjhhvhhxhhfihl" +
    "ihtihzihblhhlhxl" +
    "hDlhdmhfmhzmhBmh" +
    "bnhhnhnnhpnhrnhx" +
    "nhDnooboqboccogc" +
    "oycoCcoghokhouho" +
    "yhocmogmoymoCmvp" +
    "b")
#
r(5037, "Full Vision 2", layout="0aaaacaafaahaaka" +
    "amaapaaraauaawaa" +
    "zaaBaaacaccafcah" +
    "cakcamcapcarcauc" +
    "awcazcaBcaaeacea" +
    "feaheakeameapear" +
    "eaueaweazeaBeaag" +
    "acgafgahgakgamga" +
    "pgargaugawgazgaB" +
    "gaajacjaejagjakj" +
    "amjapjarjavjaxja" +
    "zjaBjaalaclaelag" +
    "laklamlaplarlavl" +
    "axlazlaBlaeoagoa" +
    "ioakoamoapoaroat" +
    "oavoaxohbbhgbhlb" +
    "hqbhvbhAbhadhcdh" +
    "fdhhdhkdhmdhpdhr" +
    "dhudhwdhzdhBdhbf" +
    "hgfhlfhqfhvfhAfh" +
    "djhyjhbkhfkhkkhm" +
    "khpkhrkhwkhAkhdl" +
    "hylobcogcolcoqco" +
    "vcoAcobeogeoleoq" +
    "eoveoAeockoekolk" +
    "oqkoxkozkvbdvgdv" +
    "ldvqdvvdvAdvdkvy" +
    "k")
r(5038, "Future", layout="0cgaaiaakaamaboa" +
    "aqaasaauacwaagcc" +
    "icakcamcbocaqcas" +
    "ccucawcaeeageaie" +
    "bkebmeboebqebsea" +
    "ueaweayeacfaAfaa" +
    "gcegcggdigdkgdmg" +
    "dogdqgdsgdugcwgc" +
    "ygaCgachaAhaeiag" +
    "iaiibkibmiboibqi" +
    "bsiauiawiayiagkc" +
    "ikakkamkbokaqkas" +
    "kcukawkcgmaimakm" +
    "ammbomaqmasmaumc" +
    "wmhcghAgoneopeon" +
    "iopiClgCngCpgCrg")
r(5039, "Garden", layout="0adaafaaoaaqaaza" +
    "aBaaabaibalbatba" +
    "wbaEbaccaecagcan" +
    "capcarcaycaAcaCc" +
    "aadaidaldatdawda" +
    "Edaceaeeageaneap" +
    "eareayeaAeaCeaaf" +
    "aifalfatfawfaEfa" +
    "chaehaghanhaphar" +
    "hayhaAhaChaajaij" +
    "aljatjawjaEjacka" +
    "ekagkankapkarkay" +
    "kaAkaCkaalailall" +
    "atlawlaElacmaema" +
    "gmanmapmarmaymaA" +
    "maCmaanainalnatn" +
    "awnaEnadoafoaooa" +
    "qoazoaBoheahpahA" +
    "ahcdhedhgdhndhpd" +
    "hrdhydhAdhCdhdhh" +
    "fhhohhqhhzhhBhhc" +
    "lhelhglhnlhplhrl" +
    "hylhAlhClheohpoh" +
    "Aooddofdoodoqdoz" +
    "doBdoehophoAhodl" +
    "oflooloqlozloBlv" +
    "edvpdvAdvelvplvA" +
    "l")
r(5040, "Gayle's", layout="0dcaceabgaaiaaka" +
    "amaaoaaqaasabuac" +
    "wadyaagcbicckccm" +
    "ccoccqcbscaucake" +
    "bmeboeaqeacgaega" +
    "ggbigbkgbmgbogbq" +
    "gbsgaugawgaygaah" +
    "aAhaciaeiagibiib" +
    "kibmiboibqibsiau" +
    "iawiayiakkbmkbok" +
    "aqkagmbimckmcmmc" +
    "omcqmbsmaumdcoce" +
    "obgoaioakoamoaoo" +
    "aqoasobuocwodyoo" +
    "jholhonhophorhvn" +
    "cvmhvohvnmCnh")
r(5041, "Glade", layout="0aaaacaaCaaEaaac" +
    "accaCcaEcahdejdc" +
    "ldcndbpdcrdctdev" +
    "daxddhfcjfblfbnf" +
    "bpfbrfbtfcvfdxfc" +
    "hhbjhblhanharhbt" +
    "hbvhcxhdhjcjjblj" +
    "bnjbpjbrjbtjcvjd" +
    "xjahlejlcllcnlbp" +
    "lcrlctlevlaxlaam" +
    "acmaCmaEmaaoacoa" +
    "CoaEohbahDahbchD" +
    "chbmhDmhbohDoobb" +
    "oDbobnoDn")
r(5042, "H for Haga", layout="0aaaacaaeaagaaka" +
    "amaaoaaqaaacacca" +
    "ecagcakcamcaocaq" +
    "caaeaceaeeageake" +
    "ameaoeaqeaifaaga" +
    "cgaegaggakgamgao" +
    "gaqgaihaaiaciaei" +
    "agiakiamiaoiaqia" +
    "ijaakackaekagkak" +
    "kamkaokaqkaamacm" +
    "aemagmakmammaoma" +
    "qmaaoacoaeoagoak" +
    "oamoaooaqohbbhdb" +
    "hfbhlbhnbhpbhbdh" +
    "ddhfdhldhndhpdhb" +
    "fhdfhffhlfhnfhpf" +
    "hhghjghbhhdhhfhh" +
    "lhhnhhphhhihjihb" +
    "jhdjhfjhljhnjhpj" +
    "hblhdlhflhllhnlh" +
    "plhbnhdnhfnhlnhn" +
    "nhpnoccoecomcooc" +
    "oceoeeomeooeocgo" +
    "egomgoogoghoihok" +
    "hocioeiomiooiock" +
    "oekomkookocmoemo" +
    "mmoomvddvndvdlvn" +
    "l")

r(5044, "Helios", layout="0eaadcaduaewadac" +
    "bccbucdwcbaeacea" +
    "eeaiedkedmeaoeas" +
    "eauebwebagacgaeg" +
    "aggdigdogaqgasga" +
    "ugbwgblhbaiaciae" +
    "iagidiidoiaqiasi" +
    "auibwibakackaeka" +
    "ikdkkdmkaokaskau" +
    "kbwkdambcmbumdwm" +
    "eaodcoduoewohchh" +
    "ehhghhqhhshhuhCl" +
    "eCihCohClk")
r(5045, "High and Low", layout="0eaadcaceabgaaia" +
    "bkacmadoaeqadacc" +
    "ccdecagcbicckcbm" +
    "ceocdqccaebceeee" +
    "bgeciedkeamedoec" +
    "qebagacgdegcggdi" +
    "gekgbmgcogbqgaai" +
    "bciceidgieiidkic" +
    "miboiaqiaekagkbi" +
    "kakkamkahmajmhim")
#

r(5047, "Inca", layout="0aoaaqaaibakbamb" +
    "asbaubawbbocbqca" +
    "idbkdbmdbsdbudaw" +
    "dcoecqeaifbkfcmf" +
    "csfbufawfaagacgd" +
    "ogdqgaCgaEgahhbj" +
    "hclhcthbvhaxhaai" +
    "acidoidqiaCiaEia" +
    "hjbjjcljctjbvjax" +
    "jaakackdokdqkaCk" +
    "aEkailbklcmlcslb" +
    "ulawlcomcqmainbk" +
    "nbmnbsnbunawnboo" +
    "bqoaipakpampaspa" +
    "upawpaoqaqqhbihD" +
    "iCphCpj")
r(5048, "Inner Circle", layout="0aaaacaayaaAaaac" +
    "eccceccgcbicbkca" +
    "mcaocbqcbsccuccw" +
    "ceycaAcccecyedgf" +
    "cifbkfbqfcsfdufb" +
    "cgbygaghbuhbciby" +
    "iegjdijckjbmjboj" +
    "cqjdsjeujcckcyka" +
    "amecmcemcgmbimbk" +
    "mbqmbsmcumcwmdym" +
    "aAmaaoacoakoaqoa" +
    "yoaAo")
r(5049, "Joker", layout="0aaaaAaadbafbahb" +
    "ajbalbanbapbarba" +
    "tbavbaxbabdbddbf" +
    "dbhdbjdbldbndbpd" +
    "brdbtdbvdbxdazdc" +
    "bfbdfaffahfajfal" +
    "fanfapfarfatfavf" +
    "bxfczfcbhbdhafha" +
    "vhbxhczhajiamiap" +
    "iasicbjbdjafjavj" +
    "bxjczjcblbdlafla" +
    "hlajlallanlaplar" +
    "latlavlbxlczlabn" +
    "bdnbfnbhnbjnblnb" +
    "nnbpnbrnbtnbvnbx" +
    "naznadpafpahpajp" +
    "alpanpapparpatpa" +
    "vpaxpaaqaAqhgghu" +
    "ghgkhuk")
r(5050, "K for Kyodai", layout="0caaccaceacmacoa" +
    "cqacacbcccecckcb" +
    "mccoccaebceceeci" +
    "ebkecmecagbcgceg" +
    "cggbigckgcaibcib" +
    "eibgiciicakbckce" +
    "kcgkbikckkcambcm" +
    "cemcimbkmcmmcaob" +
    "coceockobmocooca" +
    "qccqceqcmqcoqcqq")

r(5052, "Km", layout="0baabcabiaakaboa" +
    "cqacyabAabacaccb" +
    "gcaicbocaqcdscdw" +
    "caycbAcdudbaeace" +
    "beeageboeaqeasea" +
    "weayebAeeufbagac" +
    "gbegaggbogaqgayg" +
    "bAgduhbaiacibgia" +
    "iiboiaqiayibAiba" +
    "kbckbikakkbokbqk" +
    "bykbAkjcfhgfoabo" +
    "oboAboadoodoAdoa" +
    "foefoofoAfoahooh" +
    "oAhoajoojoAjvacv" +
    "ocvAcvaevoevAeva" +
    "gvogvAgvaivoivAi" +
    "CadCodCAdCafCofC" +
    "AfCahCohCAh")
r(5053, "Kujaku", layout="0bnabpabrabtabva" +
    "bxablbczbaBbbhcb" +
    "jcancapcarcatcav" +
    "caxcaddbfdaldazd" +
    "dBdaDdaheajeabfc" +
    "dfaffaAfdCfaEfba" +
    "hcchaehakhamhaoh" +
    "ashaAhdChaEhabjc" +
    "djafjaAjdCjaEjah" +
    "kajkadlbflallazl" +
    "dBlaDlbhmbjmanma" +
    "pmarmatmavmaxmbl" +
    "ncznaBnbnobpobro" +
    "btobvobxohnghpgh" +
    "tghjhhnihpihtioo" +
    "foqfoufoihoojoqj" +
    "oujvpevrevvfvhhv" +
    "vjvpkvrkCwgCCgCg" +
    "hCwiCCi")
r(5054, "Labyrinth", layout="0caaacaaeaagaaia" +
    "akaamaaoaaqaasaa" +
    "uaawaayaaAaaCacE" +
    "aaacbkcbocbucaEc" +
    "aaebcebeebgebkeb" +
    "oebsebuebyebAeaE" +
    "eaagbkgbygaEgaai" +
    "beibiibkiboibqib" +
    "sibuibwibyibAiaE" +
    "iaakbekbokbwkaEk" +
    "aambembgmbimbkmb" +
    "ombqmbsmbwmbAmbC" +
    "maEmaaobkobwoaEo" +
    "caqacqbeqdgqdkqb" +
    "mqaoqaqqasqauqbw" +
    "qdyqdCqbEq")
r(5055, "Lion 1", layout="0bdbbfbcjbclbawb" +
    "aybbbcbhcaucaAcc" +
    "jdcldasdaCdbaeaq" +
    "ecvfczfaDfbbgapg" +
    "aEhcbiceichickia" +
    "oicxiaFjcckcfkci" +
    "kclkbokcwkcykbul" +
    "bAlaElcbmcemchmc" +
    "kmcnmbqmaDnccocf" +
    "ocioclocooaroato" +
    "avoaxoazoaBohvah" +
    "xahzahtbhBbhrchD" +
    "dhpehEfhoghFhhni" +
    "hGjhFlhEnhsohCoh" +
    "uphwphyphApwkc")
r(5056, "Lost", layout="0afaaxaabbadbahb" +
    "ajbblbbnbbpbbrba" +
    "tbavbazbaBbafcax" +
    "cabdaddbkdcodbsd" +
    "azdaBdbiebmebqeb" +
    "ueaafacfaefbgfdo" +
    "fbwfayfaAfaCfaah" +
    "aehbghcihckhdmhd" +
    "ohdqhcshcuhbwhay" +
    "haChaajacjaejbgj" +
    "dojbwjayjaAjaCjb" +
    "ikbmkbqkbukablad" +
    "lbklcolbslazlaBl" +
    "afmaxmabnadnahna" +
    "jnblnbnnbpnbrnat" +
    "navnaznaBnafoaxo" +
    "ombooboqbomnoono" +
    "qn")
r(5057, "Maya", layout="0aaaacaaeaagaaia" +
    "aqaasaauaawaayaa" +
    "acaccaecagcaicaq" +
    "cascaucawcaycaae" +
    "aceaeeageaieakea" +
    "meaoeaqeaseaueaw" +
    "eayeaigakgamgaog" +
    "aqgaiiakiamiaoia" +
    "qiaakackaekagkai" +
    "kakkamkaokaqkask" +
    "aukawkaykaamacma" +
    "emagmaimaqmasmau" +
    "mawmaymaaoacoaeo" +
    "agoaioaqoasoauoa" +
    "woayohcbhebhgbhs" +
    "bhubhwbhcdhedhgd" +
    "hsdhudhwdhkfhmfh" +
    "ofhkhhmhhohhkjhm" +
    "jhojhclhelhglhsl" +
    "hulhwlhcnhenhgnh" +
    "snhunhwnoccoecog" +
    "coscoucowcolfonf" +
    "olhonholjonjocmo" +
    "emogmosmoumowmvd" +
    "cvfcvtcvvcvmfvmh" +
    "vmjvdmvfmvtmvvmC" +
    "ecCucCmgCmiCemCu" +
    "m")
r(5058, "Mesh", layout="0baabcabeabiabka" +
    "bmabqabsabuabyab" +
    "AabCabacbecbicbm" +
    "cbqcbucbycbCcbae" +
    "bcebeeagebiebkeb" +
    "meaoebqebsebueaw" +
    "ebyebAebCeaegbig" +
    "bmgbqgbugaygbaib" +
    "cibeiagibiibkibm" +
    "iaoibqibsibuiawi" +
    "byibAibCibakbekb" +
    "ikbmkbqkbukbykbC" +
    "kbambcmbembimbkm" +
    "bmmbqmbsmbumbymb" +
    "AmbCm")
r(5059, "Moth", layout="0baaccaceabgaana" +
    "apaarabyacAacCab" +
    "Eaaibawbbccagcak" +
    "ccpcaucaycbCcaid" +
    "amdasdawdadeakeb" +
    "oebqeaueaBeamfas" +
    "facgaegahgajgbog" +
    "bqgavgaxgaAgaCga" +
    "mhashadiakiboibq" +
    "iauiaBiaijamjasj" +
    "awjbckagkakkcpka" +
    "ukaykbCkailawlcc" +
    "mcembgmbpmbymcAm" +
    "cCmbanbEnhoahqah" +
    "ichwchmehsehdghi" +
    "ghwghBghmihsihik" +
    "hwkopaoneopeorep" +
    "pgoniopiorivdavB" +
    "avoevqevoivqivdm" +
    "vBmCpeCpi")
r(5060, "N for Namida", layout="0caaccaceacgacqa" +
    "csacuacacbccbecb" +
    "gcbiccqcbsccucca" +
    "ebcebeebgebiebke" +
    "cqebsecuecagbcgc" +
    "egbigbkgbmgcqgbs" +
    "gcugcaibciceibki" +
    "bmiboibqibsicuic" +
    "akbckcekbmkbokbq" +
    "kbskcukcamccmcem" +
    "comcqmcsmcum")

#
r(5063, "Temple 1", layout="0aeaagaaiaakabpa" +
    "auaawaayaaAaacca" +
    "Ccahdajdavdaxdaa" +
    "eacealeateaCeaEe" +
    "anfarfaagacgahga" +
    "pgaCgaEganharhaa" +
    "iacialiatiaCiaEi" +
    "ahjajjavjaxjacka" +
    "Ckaemagmaimakmbp" +
    "maumawmaymaAmhfa" +
    "hhahjahvahxahzah" +
    "cdhidhwdhCdhkehu" +
    "ehafhcfhmfhofhqf" +
    "hsfhCfhEfhahhchh" +
    "mhhohhqhhshhChhE" +
    "hhkihuihcjhijhwj" +
    "hCjhfmhhmhjmhvmh" +
    "xmhzmogaoiaowaoy" +
    "aoceojeoveoCeolf" +
    "otfoagocgongopgo" +
    "rgoCgoEgolhothoc" +
    "iojiovioCiogmoim" +
    "owmoymvhavxavcfv" +
    "kfvufvCfvmgvogvq" +
    "gvsgvchvkhvuhvCh" +
    "vhmvxmCcgClgCngC" +
    "pgCrgCtgCCg")
r(5064, "Order", layout="0afaahaajaalaana" +
    "apaaraataaabayba" +
    "icakcamcaocaqcba" +
    "dacdaedaudawdbyd" +
    "akebmeaoecafbcfa" +
    "efaufbwfcyfaggai" +
    "gakgbmgaogaqgasg" +
    "cahcchbehbuhcwhc" +
    "yhagiaiiakibmiao" +
    "iaqiasicajbcjaej" +
    "aujbwjcyjakkbmka" +
    "okbalaclaelaulaw" +
    "lbylaimakmammaom" +
    "aqmaanaynafoahoa" +
    "joaloanoapoaroat" +
    "ohgahiaikaimaioa" +
    "hqahsahlchnchghh" +
    "ihhkhhohhqhhshhl" +
    "mhnmhgohioikoimo" +
    "ioohqohsoomcpmho" +
    "mm")
r(5065, "Pattern", layout="0aaaacaafaahaaka" +
    "amaapaaraauabwab" +
    "zaaBaaacaccafcah" +
    "cakcamcapcarcbuc" +
    "cwcczcbBccafacfa" +
    "ffchfckfcmfapfar" +
    "fcufawfazfcBfaah" +
    "cchcfhahhakhamhc" +
    "phcrhcuhawhazhcB" +
    "haakackafkahkakk" +
    "cmkcpkarkcukcwkc" +
    "zkcBkaamacmafmah" +
    "mckmammapmcrmaum" +
    "cwmczmaBmibailai" +
    "fbihbibciqciqfil" +
    "hialihl")

r(5067, "Portal", layout="0accagcawcaAcaed" +
    "aydaceageaweaAea" +
    "mgaqgamiaqiackag" +
    "kawkaAkaelaylacm" +
    "agmawmaAmhbbhdbh" +
    "fbhhbhvbhxbhzbhB" +
    "bhbdhhdhvdhBdhbf" +
    "hdfhffhhfhlfhnfh" +
    "pfhrfhvfhxfhzfhB" +
    "fhlhhrhhbjhdjhfj" +
    "hhjhljhnjhpjhrjh" +
    "vjhxjhzjhBjhblhh" +
    "lhvlhBlhbnhdnhfn" +
    "hhnhvnhxnhznhBno" +
    "aaocaoeaogaoiaou" +
    "aowaoyaoAaoCaoac" +
    "oicoucoCcoaeoieo" +
    "keomeooeoqeoseou" +
    "eoCeoagocgoegogg" +
    "oigokgosgougowgo" +
    "ygoAgoCgoaiocioe" +
    "iogioiiokiosioui" +
    "owioyioAioCioako" +
    "ikokkomkookoqkos" +
    "koukoCkoamoimoum" +
    "oCmoaoocooeoogoo" +
    "ioouoowooyooAooC" +
    "o")
r(5068, "Rocket", layout="0amaaoaaqaazaaBa" +
    "aDaakbaicamcaoca" +
    "qcascaxcazcaBcaD" +
    "cagdakdaudaeeaie" +
    "ameaqeaseaweayea" +
    "cfagfakfaofaufaB" +
    "faegasgawgaygaah" +
    "bchbghbihbkhbmhb" +
    "ohcqhauhaAhaChae" +
    "iasiawiayiacjagj" +
    "akjaojaujaBjaeka" +
    "ikamkaqkaskawkay" +
    "kaglaklaulaimamm" +
    "aomaqmasmaxmazma" +
    "BmaDmaknamoaooaq" +
    "oazoaBoaDohnahpa" +
    "hlbhBbhjchnchpch" +
    "hdhsdhfehxehdfhs" +
    "fhughehhshiwhhyh" +
    "huihdjhsjhfkhxkh" +
    "hlhslhjmhnmhpmhl" +
    "nhBnhnohpoonbopb" +
    "osgodhofhohhojho" +
    "lhonhouhosionnop" +
    "nvobvehvghvihvsh" +
    "vonCfh")
r(5069, "Scorpion", layout="0avaacbaebagbaib" +
    "aacaxcazcagdaida" +
    "kdaoeaseayeaAeaa" +
    "facfaefagfaifakf" +
    "cmgaogcqgasgcuga" +
    "wgbygbAgckhciidm" +
    "iaoicqiasiduiawi" +
    "byibAickjcmkaokc" +
    "qkaskcukawkbykaa" +
    "laclaelaglailakl" +
    "aomasmawmagnaina" +
    "knaaoacpaepagpai" +
    "phdbhfbhhbhwbhbc" +
    "hychhdhzehbfhdfh" +
    "ffhhfhjfhofhsfho" +
    "hhshhwhhojhsjhwj" +
    "hblhdlhflhhlhjlh" +
    "olhslhwlhhnhbohd" +
    "phfphhpoogosgoyh" +
    "ooiosiowioyjooko" +
    "skvohvqhvshvojvq" +
    "jvsj")
r(5070, "Screw Up", layout="0ciackacmabgbbob" +
    "cecbicbkcbmccqcb" +
    "gdbodcceceeakeam" +
    "ecqecsebgfbofccg" +
    "cegakgamgcqgcsgb" +
    "ghbohcciceiaiiak" +
    "icqicsibgjbojcck" +
    "cekaikakkcqkcskb" +
    "glbolcembimbkmbm" +
    "mcqmbgnbonciocko" +
    "cmoilfikhijjvbfv" +
    "tfvbhvthvbjvtjCa" +
    "fCufCahCuhCajCuj")
#
r(5071, "Seven", layout="0aaaacaafaahaaka" +
    "amaapaaraauaawaa" +
    "zaaBaaEaaGaaacac" +
    "cafcahcakcamcapc" +
    "arcaucawcazcaBca" +
    "EcaGcaaeaceafeah" +
    "eakeameapeareaue" +
    "aweazeaBeaEeaGea" +
    "agacgafgahgakgam" +
    "gapgargaugawgazg" +
    "aBgaEgaGgaaiacia" +
    "fiahiakiamiapiar" +
    "iauiawiaziaBiaEi" +
    "aGiaakackafkahka" +
    "kkamkapkarkaukaw" +
    "kazkaBkaEkaGkaam" +
    "acmafmahmakmamma" +
    "pmarmaumawmazmaB" +
    "maEmaGmaaoacoafo" +
    "ahoakoamoapoaroa" +
    "uoawoazoaBoaEoaG" +
    "oaaqacqafqahqakq" +
    "amqapqarqauqawqa" +
    "zqaBqaEqaGqhqchl" +
    "ehvehggiqghAghbi" +
    "hlihvihFihgkiqkh" +
    "Akhlmhvmhqo")
#
r(5072, "Seven Pyramids", layout="0aaaacaaeaagaaoa" +
    "aqaayaaAaaCaaEaa" +
    "acaccaecagcaocaq" +
    "caycaAcaCcaEcaae" +
    "aceaeeageayeaAea" +
    "CeaEeaagacgaegag" +
    "gangapgargaygaAg" +
    "aCgaEganiapiaria" +
    "akackaekagkankap" +
    "karkaykaAkaCkaEk" +
    "aamacmaemagmayma" +
    "AmaCmaEmaaoacoae" +
    "oagoaooaqoayoaAo" +
    "aCoaEoaaqacqaeqa" +
    "gqaoqaqqayqaAqaC" +
    "qaEqhbbhdbhfbhpb" +
    "hzbhBbhDbhbdhddh" +
    "fdhzdhBdhDdhbfhd" +
    "fhffhzfhBfhDfhoh" +
    "hqhhojhqjhblhdlh" +
    "flhzlhBlhDlhbnhd" +
    "nhfnhznhBnhDnhbp" +
    "hdphfphpphzphBph" +
    "DpoccoecoAcoCcoc" +
    "eoeeoAeoCeopiocm" +
    "oemoAmoCmocooeoo" +
    "AooCovddvBdvdnvB" +
    "n")
r(5073, "Shield", layout="0aaaacaaeaagaaia" +
    "akaamaaoaaxaaaca" +
    "ccaecagcaicakcam" +
    "caocbxcaaeaceaee" +
    "ageaieakeameaoec" +
    "xeabgadgafgahgaj" +
    "galgangdxgaciaei" +
    "agiaiiakiamidxie" +
    "tjeBjaekagkaikak" +
    "kbvkexkbzkagmaim" +
    "cxmahodxohcbhebh" +
    "gbhibhkbhmbhcdhe" +
    "dhgdhidhkdhmdhcf" +
    "iefigfiifikfhmfh" +
    "dhifhihhijhhlhhe" +
    "jigjiijhkjhglhil" +
    "odbofbohbojbolbo" +
    "ddofdohdojdoldoh" +
    "lvfcvhcvjcvfevhe" +
    "vjevggvigvhiChdC" +
    "hf")
r(5074, "Siam", layout="0afaazaadbahbaxb" +
    "aBbacdaedagdaida" +
    "ndardawdaydaAdaC" +
    "daleateabfadfaff" +
    "ahfajfavfaxfazfa" +
    "BfaDfaahachaehag" +
    "haihakhamhaohaqh" +
    "ashauhawhayhaAha" +
    "ChaEhabjadjafjah" +
    "jajjavjaxjazjaBj" +
    "aDjalkatkaclaela" +
    "glailanlarlawlay" +
    "laAlaCladnahnaxn" +
    "aBnafoazohddhfdh" +
    "hdhxdhzdhBdhcfhe" +
    "fhgfhifhwfhyfhAf" +
    "hCfhbhhdhhfhhhhh" +
    "jhhlhhnhiphhrhht" +
    "hhvhhxhhzhhBhhDh" +
    "hcjhejhgjhijhwjh" +
    "yjhAjhCjhdlhflhh" +
    "lhxlhzlhBloedogd" +
    "oydoAdodfoffohfo" +
    "xfozfoBfochoehog" +
    "hoihowhoyhoAhoCh" +
    "odjofjohjoxjozjo" +
    "BjoelogloyloAl")

r(5076, "Square", layout="0daadcadeadgadia" +
    "dkadacdccdecdgcd" +
    "icdkcdaedcedeedg" +
    "ediedkedagdcgdeg" +
    "dggdigdkgdaidcid" +
    "eidgidiidkidakdc" +
    "kdekdgkdikdkk")
r(5077, "Squares", layout="0caabcaceabgacia" +
    "bkacmaboacqabsac" +
    "uaaacauccddafdah" +
    "dajdaldandapdcrd" +
    "aaeauebdfbrfaagb" +
    "ggcigckgcmgbogau" +
    "gcdhcrhaaibgicii" +
    "ckicmiboiauibdjb" +
    "rjaakaukcdlaflah" +
    "lajlallanlaplcrl" +
    "aamaumcaobcoceob" +
    "gociobkocmoboocq" +
    "obsocuohidikdhmd" +
    "hiliklhmlvjgvlgv" +
    "jivli")
r(5078, "Squaring", layout="0caaacaceaciaaka" +
    "cmacqaasacuacyaa" +
    "AacCaaacaecaicdk" +
    "camcaqcaucaycdAc" +
    "aCccaeaceceeciea" +
    "kecmecqeasecuecy" +
    "eaAecCecahachceh" +
    "cihakhcmhcqhashc" +
    "uhcyhaAhcChaajdc" +
    "jaejaijamjaqjdsj" +
    "aujayjaCjcalaclc" +
    "elcilaklcmlcqlas" +
    "lculcylaAlcCl")
r(5079, "Stairs 1", layout="0aoaaebaybeacdcc" +
    "agcaicakcbmccocb" +
    "qcascaucawcdAceC" +
    "caedayddaeaieaoe" +
    "auedCebefbyfaaga" +
    "igaogaugaCgbchce" +
    "hbghakhbmhbqhash" +
    "bwhcyhbAhaaiaiia" +
    "oiauiaCibejbyjda" +
    "kaikaokaukdCkael" +
    "ayleamdcmagmaima" +
    "kmbmmcombqmasmau" +
    "mawmdAmeCmaenayn" +
    "aoohechychofhahk" +
    "ohhChhojhemhym")
r(5080, "Star Ship", layout="0eoaaabdmbdqbaCb" +
    "accckccscaAcaadb" +
    "idbudaCdbceageco" +
    "eawebAeaafaefamf" +
    "aqfayfaCfecgagga" +
    "igbkgdogbsgaugaw" +
    "geAgaahaehamhaqh" +
    "ayhaChbciagicoia" +
    "wibAiaajbijbujaC" +
    "jackckkcskaAkaal" +
    "dmldqlaCleomhach" +
    "CchaehCehaghegim" +
    "giqghyghCghaihCi" +
    "hakhCkoadoCdoafo" +
    "CfoahoChoajoCjva" +
    "evCevagvCgvaivCi" +
    "CafCCfCahCCh")
#
r(5081, "Steps Pyramid", layout="0aaaacaaeaagaaia" +
    "akaamaaoaaqaaaca" +
    "ccaecagcaicakcam" +
    "caocaqcaaeaceaoe" +
    "aqeaagacgaogaqga" +
    "aiaciaoiaqiaakac" +
    "kaekagkaikakkamk" +
    "aokaqkaamacmaema" +
    "gmaimakmammaomaq" +
    "mhbbhdbhfbhhbhjb" +
    "hlbhnbhpbhbdhddh" +
    "fdhhdhjdhldhndhp" +
    "dhbfhdfhnfhpfhbh" +
    "hdhhnhhphhbjhdjh" +
    "fjhhjhjjhljhnjhp" +
    "jhblhdlhflhhlhjl" +
    "hllhnlhplpccoeco" +
    "gcoicokcomcpococ" +
    "epeepgepiepkepme" +
    "ooeocgpegpmgoogo" +
    "cipeipgipiipkipm" +
    "iooipckoekogkoik" +
    "okkomkpokCffChfC" +
    "jfClfCfhChhCjhCl" +
    "h")
r(5082, "Stonehenge", layout="0cdachackacoacra" +
    "cvacyacCacaccFca" +
    "jeaneareavecagcF" +
    "gddhdhhdlhdphdth" +
    "dxhdBhcajcFjajka" +
    "nkarkavkcancFncd" +
    "pchpckpcopcrpcvp" +
    "cypcCpveavgavlav" +
    "navsavuavzavBava" +
    "dvFdvafvFfvakvFk" +
    "vamvFmvepvgpvlpv" +
    "npvspvupvzpvBpCe" +
    "hCghCihCkhCmhCoh" +
    "CqhCshCuhCwhCyhC" +
    "Ah")
r(5083, "Sun and Moon", layout="0dgaciabkaamabya" +
    "debbrbbBbdccbvcc" +
    "addcecheckecnebD" +
    "ecafbtfbAfdcgdjg" +
    "dlgbxgcahchhcnhd" +
    "cidjidlibribDica" +
    "jbvjdckchkckkcnk" +
    "bAkcalbsldcmbxmd" +
    "enbBndgociobkoam" +
    "obuovaevagvaivak" +
    "Ckh")
r(5084, "Temple 2", layout="0baaacaaeaalaana" +
    "apaaraataaAaaCab" +
    "Eaaacaccalcbncbp" +
    "cbrcatcaCcaEcajd" +
    "avdaaeblebnebpeb" +
    "rebteaEeaffahfaj" +
    "favfaxfazfblgbng" +
    "bpgbrgbtgadhafha" +
    "hhajhavhaxhazhaB" +
    "hblibnibpibribti" +
    "afjahjajjavjaxja" +
    "zjaakblkbnkbpkbr" +
    "kbtkaEkajlavlaam" +
    "acmalmbnmbpmbrma" +
    "tmaCmaEmbaoacoae" +
    "oaloanoapoaroato" +
    "aAoaCobEohhghjgh" +
    "vghxghhihjihvihx" +
    "iooeoqeokgomgoog" +
    "oqgosgougokiomio" +
    "oioqiosiouiookoq" +
    "kvpgvpi")
#

r(5086, "The Door", layout="0amaaoaaqaeicekc" +
    "emceoceqcesceuca" +
    "gediedueaweaegag" +
    "gdigdugawgaygaei" +
    "bgidiiduibwiayia" +
    "ckaekcgkdikakkas" +
    "kdukcwkaykaAkaam" +
    "acmbemcgmdimakma" +
    "smdumcwmbymaAmaC" +
    "maaobcobeocgodio" +
    "akoasoduocwobyob" +
    "AoaCo")
#
r(5087, "The Great Wall", layout="0aaaacaaeaagaaia" +
    "akaamaaoaaqaasaa" +
    "uaawaayaaAaaCaaE" +
    "aaacaccaecagcaic" +
    "akcamcaocaqcasca" +
    "ucawcaycaAcaCcaE" +
    "caaeaceaeeageaie" +
    "akeameaoeaqeasea" +
    "ueaweayeaAeaCeaE" +
    "eaagacgaegaggaig" +
    "akgamgaogaqgasga" +
    "ugawgaygaAgaCgaE" +
    "gaaiaciaeiagiaii" +
    "akiamiaoiaqiasia" +
    "uiawiayiaAiaCiaE" +
    "iaakackaekagkaik" +
    "akkamkaokaqkaska" +
    "ukawkaykaAkaCkaE" +
    "kaamacmaemagmaim" +
    "akmammaomaqmasma" +
    "umawmaymaAmaCmaE" +
    "maaoacoaeoagoaio" +
    "akoamoaooaqoasoa" +
    "uoawoayoaAoaCoaE" +
    "oaaqacqaeqagqaiq" +
    "akqamqaoqaqqasqa" +
    "uqawqayqaAqaCqaE" +
    "q")
r(5088, "Theater", layout="0baaccaceabgaaia" +
    "amaaqabsacuacwab" +
    "yacaccccbecagcak" +
    "cbmcaocascbuccwc" +
    "cyccaebceaeeaieb" +
    "kebmeboeaqeauebw" +
    "ecyebagacgaggaig" +
    "akgbmgaogaqgasga" +
    "wgbygcaibciaeiai" +
    "ibkibmiboiaqiaui" +
    "bwicyicakcckbeka" +
    "gkakkbmkaokaskbu" +
    "kcwkcykbamccmcem" +
    "bgmaimammaqmbsmc" +
    "umcwmbym")
r(5089, "Tile Fighter", layout="0bfaahaatabvadcc" +
    "becakcbmcbocaqcb" +
    "wcdycbaecceaiebk" +
    "ebmeboebqeasecye" +
    "bAebagbigckgamga" +
    "ogcqgbsgbAgcchae" +
    "haghauhawhcyhbai" +
    "biickiamiaoicqib" +
    "sibAibakcckaikbk" +
    "kbmkbokbqkaskcyk" +
    "bAkdcmbemakmbmmb" +
    "omaqmbwmcymbfoah" +
    "oatobvohnhonepaf" +
    "pAfpahpAhpajpAjo" +
    "nk")
r(5090, "Tilepiles", layout="0aaaacaaeaagaaia" +
    "aobaqbasbaubayba" +
    "AbaCbaEbahcajcal" +
    "cacdaedardatdaxd" +
    "azdaBdakeameaoea" +
    "ffahfaufawfayfan" +
    "gapgargaihakhaxh" +
    "azhaqiasiauiajja" +
    "ljanjaAjaCjatkav" +
    "kaxkaelaglailakl" +
    "aolaqlawmaymaAma" +
    "CmaEmabnadnafnah" +
    "najnhbahdahfahha" +
    "hpbhrbhtbhzbhBbh" +
    "Dbhichkchddhsdhy" +
    "dhAdhlehnehgfhvf" +
    "hxfhoghqghjhhyhh" +
    "rihtihkjhmjhBjhu" +
    "khwkhflhhlhjlhpl" +
    "hxmhzmhBmhDmhcnh" +
    "enhgnhinocaoeaog" +
    "aoqbosboAboCbojc" +
    "ozdomeowfopgosio" +
    "ljovkogloiloymoA" +
    "moCmodnofnohnvda" +
    "vfavrbvBbvhlvzmv" +
    "BmvenvgnCeaCAmCf" +
    "n")
r(5091, "Time Tunnel", layout="0aaabcaceaegaeia" +
    "ekaemacoabqaasaa" +
    "acccceeceoccqcas" +
    "caaecceeeeeoecqe" +
    "aseaagccgeegeogc" +
    "qgasgaaiccieeieo" +
    "icqiasiaakbckcek" +
    "egkeikekkemkcokb" +
    "qkaskvcdvqdwcfwq" +
    "fvchvqh")
r(5092, "Tomb", layout="0eaabcabeabgabia" +
    "bkabmaboabqaesab" +
    "accccceccgccicck" +
    "ccmccoccqcbscaae" +
    "dcebeeageaieakea" +
    "meboedqeasebagcc" +
    "gcegeggaigakgemg" +
    "cogcqgbsgdaibcib" +
    "eidgiaiiakidmibo" +
    "ibqidsibgkaikakk" +
    "bmkaimakmhjevfcv" +
    "hcvjcvlcvncCgcCi" +
    "cCkcCmc")

r(5094, "Traditional Reviewed", layout="0acaaeaaiaakaama" +
    "aoaaqaasaawaayaa" +
    "gcaicbkccmccocbq" +
    "cascaucaeeagebie" +
    "bkecmecoebqebsea" +
    "ueaweacgaegbggci" +
    "gckgcmgcogcqgcsg" +
    "bugawgaygaahaAha" +
    "ciaeibgiciickicm" +
    "icoicqicsibuiawi" +
    "ayiaekagkbikbkkc" +
    "mkcokbqkbskaukaw" +
    "kagmaimbkmcmmcom" +
    "bqmasmaumacoaeoa" +
    "ioakoamoaooaqoas" +
    "oawoayovnfvlhwnh" +
    "vphvnj")
r(5095, "Tree of Life", layout="0ababdacfadhacja" +
    "blaanaapabractad" +
    "vacxabzaaBaaccaA" +
    "caadbfdajdaldand" +
    "apdardatdbxdaCda" +
    "ceaAeaafaefagfai" +
    "fbkfbsfaufawfayf" +
    "aCfacgamgaqgaAga" +
    "ehaihauhayhalibo" +
    "iariagjawjblkaok" +
    "brkaambcmcembgma" +
    "imclmaomcrmaumbw" +
    "mcymbAmaCmacoago" +
    "cloaoocroawoaAoa" +
    "iqakqamqcoqaqqas" +
    "qauqhoaicdimdiqd" +
    "iAdhdfiffhhfixfh" +
    "zfilqirq")
#
r(5096, "Twin Temples", layout="0aaaacaaeaagaaia" +
    "akaaqaasaauaawaa" +
    "yaaAaaacakcaqcaA" +
    "camdaodaaeakeaqe" +
    "aAeagfaifamfaofa" +
    "sfaufaagakgaqgaA" +
    "gamhaohaaiakiaqi" +
    "aAiaakackaekagka" +
    "ikakkaqkaskaukaw" +
    "kaykaAkhbbhdbhfb" +
    "hhbhjbhrbhtbhvbh" +
    "xbhzbhbdhjdhldhp" +
    "dhrdhzdhbfhffhvf" +
    "hzfhbhhjhhlhhphh" +
    "rhhzhhbjhdjhfjhh" +
    "jhjjhrjhtjhvjhxj" +
    "hzjoccoecogcoico" +
    "scoucowcoycokdoq" +
    "doceoieoseoyeocg" +
    "oigosgoygokhoqho" +
    "cioeiogioiiosiou" +
    "iowioyivddvfdvhd" +
    "vjdvrdvtdvvdvxdv" +
    "dfvhfvjfvrfvtfvx" +
    "fvdhvfhvhhvjhvrh" +
    "vthvvhvxhCeeCgeC" +
    "ueCweCegCggCugCw" +
    "g")
r(5097, "Vi", layout="0aaaaEaaacaccaCc" +
    "aEcbaeaceaeeaAea" +
    "CebEecagbcgaegag" +
    "gaygaAgbCgcEgcai" +
    "bcibeiagiaiiawia" +
    "yibAibCicEicakcc" +
    "kbekbgkaikakkauk" +
    "awkbykbAkcCkcEkd" +
    "amccmcembgmbimak" +
    "mammasmaumbwmbym" +
    "cAmcCmdEmeaodcoc" +
    "eocgobiobkoamoao" +
    "oaqoasobuobwocyo" +
    "cAodCoeEo")
r(5098, "Victory Arrow", layout="0ataaabbcbbebbgb" +
    "bibbkbambavbaxca" +
    "adamdbvdazdadebf" +
    "ebheajeaBeaafamf" +
    "aofbvfbxfbzfaDfa" +
    "dgajgaqgaahagham" +
    "haohbshbuhbwhbyh" +
    "bAhbChbEhadiajia" +
    "qiaajamjaojbvjbx" +
    "jbzjaDjadkbfkbhk" +
    "ajkaBkaalamlbvla" +
    "zlaxmaanbcnbenbg" +
    "nbinbknamnavnato" +
    "hachmchaehmehdfh" +
    "jfhaghmghoghdhhj" +
    "hhqhhaihmihoihdj" +
    "hjjhakhmkhamhmmo" +
    "dbofbohbojboadom" +
    "doafomfoahonhoph" +
    "orhothovhoxhozho" +
    "Bhoajomjoalomlod" +
    "nofnohnojn")
r(5099, "Wavelets", layout="0agaaqaaAaagcaqc" +
    "aAccaeaeeaieaoea" +
    "seayeaCecGeaggaq" +
    "gaAgcaiaeiaiiaoi" +
    "asiayiaCicGiagka" +
    "qkaAkcamaemaimao" +
    "masmaymaCmcGmago" +
    "aqoaAoagqaqqaAqh" +
    "gbhqbhAbhdehjehn" +
    "ehtehxehDehghhqh" +
    "hAhhdihjihnihtih" +
    "xihDihgjhqjhAjhd" +
    "mhjmhnmhtmhxmhDm" +
    "hgphqphApogcoqco" +
    "Acoceokeomeoueow" +
    "eoEeoggoqgoAgoci" +
    "okiomiouiowioEio" +
    "gkoqkoAkocmokmom" +
    "moumowmoEmogooqo" +
    "oAovgdvqdvAdvbev" +
    "levvevFevgfvqfvA" +
    "fvghvqhvAhvbivli" +
    "vvivFivgjvqjvAjv" +
    "glvqlvAlvbmvlmvv" +
    "mvFmvgnvqnvAn")
r(5100, "Well 1", layout="0aiaakaamaaoaagc" +
    "aicakcamcaocaqca" +
    "cebeeegeeieekeem" +
    "eeoeeqebseaueaaf" +
    "awfacgbegeggaiga" +
    "kgamgaogeqgbsgau" +
    "gaahawhacibeiegi" +
    "aiiakiamiaoieqib" +
    "siauiaajawjackbe" +
    "kegkeikekkemkeok" +
    "eqkbskaukbimakma" +
    "mmbomaioakoamoao" +
    "ohcfhufhchhuhhcj" +
    "huj")

r(5102, "Yummy", layout="0aoaaibakbbmbbqb" +
    "asbaubaocagdbidb" +
    "kdbmdbqdbsdbudaw" +
    "daoeaefbgfcifckf" +
    "dmfdqfcsfcufbwfa" +
    "yfaogaahachbehcg" +
    "hbihakhashbuhcwh" +
    "byhaAhaChaoiaejb" +
    "gjcijckjdmjdqjcs" +
    "jcujbwjayjaokagl" +
    "bilbklbmlbqlbslb" +
    "ulawlaomainaknbm" +
    "nbqnasnaunaooiob" +
    "iodkofkohkojioli" +
    "on")
