/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class CityeasyProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().groupBegin().number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("([AV]),").number("(d+),").number("([NS]),(d+.d+),").number("([EW]),(d+.d+),").number("(d+.d),").number("(d+.d),").number("(d+.d)").groupEnd("?").text(";").number("(d+),").number("(d+),").number("(d+),").number("(d+)").any().compile();
    public static final int MSG_ADDRESS_REQUEST = 1;
    public static final int MSG_STATUS = 2;
    public static final int MSG_LOCATION_REPORT = 3;
    public static final int MSG_LOCATION_REQUEST = 4;
    public static final int MSG_LOCATION_INTERVAL = 5;
    public static final int MSG_PHONE_NUMBER = 6;
    public static final int MSG_MONITORING = 7;
    public static final int MSG_TIMEZONE = 8;

    public CityeasyProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.readUnsignedShort();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(7));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei, imei + Checksum.luhn(Long.parseLong(imei)));
        if (deviceSession == null) {
            return null;
        }
        int type = buf.readUnsignedShort();
        if (type == 3 || type == 4) {
            String sentence = buf.toString(buf.readerIndex(), buf.readableBytes() - 8, StandardCharsets.US_ASCII);
            Parser parser = new Parser(PATTERN, sentence);
            if (!parser.matches()) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            if (parser.hasNext(15)) {
                position.setTime(parser.nextDateTime());
                position.setValid(parser.next().equals("A"));
                position.set("sat", parser.nextInt());
                position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
                position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
                position.setSpeed(parser.nextDouble(0.0));
                position.set("hdop", parser.nextDouble(0.0));
                position.setAltitude(parser.nextDouble(0.0));
            } else {
                this.getLastLocation(position, null);
            }
            position.setNetwork(new Network(CellTower.from(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0), parser.nextInt(0))));
            return position;
        }
        return null;
    }
}

