/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Declare a flat interpolation dmat2x3 inside a struct.
 *
 * The OpenGL Shading Language 4.00 spec states:
 *
 *    "4.3.4 Inputs
 *    ...
 *        Fragment shader inputs that are signed or unsigned integers,
 *        integer vectors, or any double-precision floating-point type
 *        must be qualified with the interpolation qualifier flat."
 */

#version 400

struct S {
	dmat2x3 u;
};

flat in S s;
out vec4 color;

void main()
{
	color = vec4(s.u[0].xyzx);
}
