/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleVersionCatalogHandler;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\f\u001a\u00020\r\"\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"getVersionCatalogFiles", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "getGradleStaticallyHandledExtensions", "", "getVersionCatalogAccessor", "Lcom/intellij/psi/PsiClass;", "context", "Lcom/intellij/psi/PsiElement;", "name", "getAccessorsForAllCatalogs", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleVersionCatalogHandler;", "intellij.gradle.java"})
public final class GradleVersionCatalogHandlerKt {
    @NotNull
    private static final ExtensionPointName<GradleVersionCatalogHandler> EP_NAME = ExtensionPointName.Companion.create("org.jetbrains.plugins.gradle.externallyHandledExtensions");

    @Deprecated(message="Doesn't work for included builds of a composite build", replaceWith=@ReplaceWith(expression="getVersionCatalogFiles(module)", imports={}))
    @NotNull
    public static final Map<String, VirtualFile> getVersionCatalogFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map container = new LinkedHashMap();
        for (GradleVersionCatalogHandler extension : EP_NAME.getExtensionList()) {
            container.putAll(extension.getVersionCatalogFiles(project));
        }
        return container;
    }

    @NotNull
    public static final Map<String, VirtualFile> getVersionCatalogFiles(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map container = new LinkedHashMap();
        for (GradleVersionCatalogHandler extension : EP_NAME.getExtensionList()) {
            container.putAll(extension.getVersionCatalogFiles(module));
        }
        return container;
    }

    @Deprecated(message="Doesn't work for included builds of a composite build", replaceWith=@ReplaceWith(expression="getVersionCatalogFiles(module)", imports={}))
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final Set<String> getGradleStaticallyHandledExtensions(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set container = new LinkedHashSet();
        for (GradleVersionCatalogHandler extension : EP_NAME.getExtensionList()) {
            container.addAll((Collection)extension.getExternallyHandledExtension(project));
        }
        return container;
    }

    @Nullable
    public static final PsiClass getVersionCatalogAccessor(@NotNull PsiElement context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (GradleVersionCatalogHandler extension : EP_NAME.getExtensionList()) {
            PsiClass psiClass = extension.getAccessorClass(context, name);
            if (psiClass == null) continue;
            return psiClass;
        }
        return null;
    }

    @NotNull
    public static final Map<String, PsiClass> getAccessorsForAllCatalogs(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map container = new LinkedHashMap();
        for (GradleVersionCatalogHandler extension : EP_NAME.getExtensionList()) {
            container.putAll(extension.getAccessorsForAllCatalogs(context));
        }
        return container;
    }
}

