/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.xml;

import com.intellij.coverage.CoverageEditorAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.JavaCoverageViewExtension;
import com.intellij.coverage.xml.XMLReportAnnotator;
import com.intellij.coverage.xml.XMLReportEditorAnnotator;
import com.intellij.coverage.xml.XMLReportEngineKt;
import com.intellij.coverage.xml.XMLReportRunner;
import com.intellij.coverage.xml.XMLReportSuite;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J:\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001bH\u0016J\u001c\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u00182\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0014\u0010$\u001a\u00020\u00162\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0016J\u0012\u0010'\u001a\f0\u0007\u00a2\u0006\u0002\b(\u00a2\u0006\u0002\b)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0018H\u0016J\u0014\u0010/\u001a\u00020-2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0016\u00a8\u00060"}, d2={"Lcom/intellij/coverage/xml/XMLReportEngine;", "Lcom/intellij/coverage/CoverageEngine;", "<init>", "()V", "createCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "runner", "Lcom/intellij/coverage/CoverageRunner;", "fileProvider", "Lcom/intellij/coverage/CoverageFileProvider;", "timestamp", "", "config", "Lcom/intellij/execution/configurations/coverage/CoverageEnabledConfiguration;", "createEmptyCoverageSuite", "Lcom/intellij/coverage/xml/XMLReportSuite;", "coverageRunner", "coverageEditorHighlightingApplicableTo", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "acceptedByFilters", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "createCoverageViewExtension", "Lcom/intellij/coverage/view/JavaCoverageViewExtension;", "suiteBundle", "createSrcFileAnnotator", "Lcom/intellij/coverage/CoverageEditorAnnotator;", "file", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "conf", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "getPresentableText", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getCoverageAnnotator", "Lcom/intellij/coverage/xml/XMLReportAnnotator;", "getQualifiedNames", "", "sourceFile", "createCoverageEnabledConfiguration", "intellij.java.coverage"})
public final class XMLReportEngine
extends CoverageEngine {
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        if (!(runner instanceof XMLReportRunner)) {
            return null;
        }
        return (CoverageSuite)new XMLReportSuite(name, project, (XMLReportRunner)runner, fileProvider, timestamp, this);
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp, @NotNull CoverageEnabledConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        throw new IllegalStateException("Should not be called".toString());
    }

    @Nullable
    public XMLReportSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
        if (!(coverageRunner instanceof XMLReportRunner)) {
            return null;
        }
        return new XMLReportSuite(this);
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile instanceof PsiClassOwner;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Pair<String, String> pair = XMLReportEngineKt.packageAndFileName(psiFile);
        if (pair == null) {
            return false;
        }
        Pair<String, String> pair2 = pair;
        String packageName = (String)pair2.component1();
        String fileName = (String)pair2.component2();
        for (CoverageSuite xmlSuite : suite.getSuites()) {
            if (!(xmlSuite instanceof XMLReportSuite) || ((XMLReportSuite)xmlSuite).getFileInfo(packageName, fileName) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public JavaCoverageViewExtension createCoverageViewExtension(@NotNull Project project, @Nullable CoverageSuitesBundle suiteBundle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        XMLReportAnnotator xMLReportAnnotator = this.getCoverageAnnotator(project);
        return new JavaCoverageViewExtension(project, suiteBundle, xMLReportAnnotator){

            protected boolean isBranchInfoAvailable(CoverageRunner coverageRunner, boolean branchCoverage) {
                return true;
            }
        };
    }

    @NotNull
    public CoverageEditorAnnotator createSrcFileAnnotator(@Nullable PsiFile file, @Nullable Editor editor) {
        return (CoverageEditorAnnotator)new XMLReportEditorAnnotator(file, editor);
    }

    public boolean isApplicableTo(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        return false;
    }

    @NotNull
    public String getPresentableText() {
        String string = JavaCoverageBundle.message("coverage.xml.report.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public XMLReportAnnotator getCoverageAnnotator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return XMLReportAnnotator.Companion.getInstance(project);
    }

    @NotNull
    public Void getQualifiedNames(@NotNull PsiFile sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        throw new IllegalStateException("Should not be called".toString());
    }

    @NotNull
    public Void createCoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        throw new IllegalStateException("Should not be called".toString());
    }
}

