/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.vegalite;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.datetime.Date;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.commons.intern.datetime.Month;
import org.jetbrains.letsPlot.commons.intern.datetime.tz.TimeZone;
import org.jetbrains.letsPlot.commons.intern.json.JsonSupport;
import org.jetbrains.letsPlot.core.spec.vegalite.VegaDataUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J`\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\u00062:\b\u0002\u0010\r\u001a4\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eH\u0002J\u0016\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/spec/vegalite/VegaDataUtil;", "", "()V", "dateTimeToEpoch", "", "year", "", "month", "day", "parseCsv", "", "", "string", "transform", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "columnName", "columnValue", "parseVegaDataset", "content", "url", "plot-stem"})
public final class VegaDataUtil {
    @NotNull
    public static final VegaDataUtil INSTANCE = new VegaDataUtil();

    private VegaDataUtil() {
    }

    @NotNull
    public final Object parseVegaDataset(@NotNull String content, @NotNull String url) {
        List<Map<String, Object>> list2;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.endsWith$default((String)url, (String)".json", (boolean)false, (int)2, null)) {
            List<Map<String, Object>> list3 = JsonSupport.INSTANCE.parse(content);
            list2 = list3;
            Intrinsics.checkNotNull((Object)list3);
        } else {
            list2 = StringsKt.endsWith$default((String)url, (String)"data/stocks.csv", (boolean)false, (int)2, null) ? this.parseCsv(content, (Function2<? super String, ? super String, ? extends Object>)((Function2)parseVegaDataset.1.INSTANCE)) : (StringsKt.endsWith$default((String)url, (String)"data/seattle-weather.csv", (boolean)false, (int)2, null) ? this.parseCsv(content, (Function2<? super String, ? super String, ? extends Object>)((Function2)parseVegaDataset.2.INSTANCE)) : VegaDataUtil.parseCsv$default(this, content, null, 2, null));
        }
        return list2;
    }

    private final long dateTimeToEpoch(String year, String month, String day) {
        Date date = new Date(Integer.parseInt(day), Month.Companion.values()[Integer.parseInt(month) - 1], Integer.parseInt(year));
        return TimeZone.Companion.getUTC().toInstant(new DateTime(date, null, 2, null)).getTimeSinceEpoch();
    }

    private final List<Map<String, Object>> parseCsv(String string, Function2<? super String, ? super String, ? extends Object> transform2) {
        String[] stringArray = new String[]{","};
        List columns = StringsKt.split$default((CharSequence)((CharSequence)SequencesKt.first((Sequence)StringsKt.lineSequence((CharSequence)string))), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        List data2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.drop((Sequence)StringsKt.lineSequence((CharSequence)string), (int)1), (Function1)((Function1)new Function1<String, Map<String, ? extends Object>>((List<String>)columns, transform2){
            final /* synthetic */ List<String> $columns;
            final /* synthetic */ Function2<String, String, Object> $transform;
            {
                this.$columns = $columns;
                this.$transform = $transform;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, Object> invoke(@NotNull String line2) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
                Object object = new String[]{","};
                object = CollectionsKt.zip((Iterable)this.$columns, (Iterable)StringsKt.split$default((CharSequence)line2, (String[])object, (boolean)false, (int)0, (int)6, null));
                Function2<String, String, Object> function2 = this.$transform;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var6_6 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    Pair pair2 = (Pair)element$iv$iv;
                    boolean bl = false;
                    String column = (String)pair2.component1();
                    String value = (String)pair2.component2();
                    pair2 = TuplesKt.to((Object)column, (Object)function2.invoke((Object)column, (Object)value));
                    map2.put(pair2.getFirst(), pair2.getSecond());
                }
                return destination$iv$iv;
            }
        })));
        return data2;
    }

    static /* synthetic */ List parseCsv$default(VegaDataUtil vegaDataUtil, String string, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = parseCsv.1.INSTANCE;
        }
        return vegaDataUtil.parseCsv(string, (Function2<? super String, ? super String, ? extends Object>)function2);
    }

    public static final /* synthetic */ long access$dateTimeToEpoch(VegaDataUtil $this, String year, String month, String day) {
        return $this.dateTimeToEpoch(year, month, day);
    }
}

