/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.coord;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.coord.CoordinatesMapper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\u0001H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/coord/DefaultCoordinateSystem;", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "coordMapper", "Lorg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper;", "(Lorg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper;)V", "clientBottom", "", "clientLeft", "isLinear", "", "()Z", "isPolar", "flip", "fromClient", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "p", "fromScreen", "toClient", "toScreen", "unitSize", "plot-base"})
public final class DefaultCoordinateSystem
implements CoordinateSystem {
    @NotNull
    private final CoordinatesMapper coordMapper;
    private final double clientLeft;
    private final double clientBottom;
    private final boolean isLinear;
    private final boolean isPolar;

    public DefaultCoordinateSystem(@NotNull CoordinatesMapper coordMapper) {
        Intrinsics.checkNotNullParameter((Object)coordMapper, (String)"coordMapper");
        this.coordMapper = coordMapper;
        this.clientLeft = this.coordMapper.getClientBounds().xRange().getLowerEnd();
        this.clientBottom = this.coordMapper.getClientBounds().yRange().getUpperEnd();
        this.isLinear = this.coordMapper.isLinear();
    }

    @Override
    public boolean isLinear() {
        return this.isLinear;
    }

    @Override
    public boolean isPolar() {
        return this.isPolar;
    }

    @Override
    @Nullable
    public DoubleVector toClient(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleVector mapped = this.coordMapper.toClient(p);
        return mapped != null ? this.toScreen(mapped) : null;
    }

    @Override
    @Nullable
    public DoubleVector fromClient(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleVector mapped = this.fromScreen(p);
        return this.coordMapper.fromClient(mapped);
    }

    @Override
    @NotNull
    public DoubleVector unitSize(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.coordMapper.unitSize(p);
    }

    @Override
    @NotNull
    public CoordinateSystem flip() {
        return new DefaultCoordinateSystem(this.coordMapper.flip());
    }

    private final DoubleVector toScreen(DoubleVector p) {
        double x2 = p.getX() - this.clientLeft;
        double y2 = this.clientBottom - p.getY();
        return new DoubleVector(x2, y2);
    }

    private final DoubleVector fromScreen(DoubleVector p) {
        double x2 = p.getX() + this.clientLeft;
        double y2 = this.clientBottom - p.getY();
        return new DoubleVector(x2, y2);
    }

    @Override
    @Nullable
    public DoubleRectangle toClient(@NotNull DoubleRectangle r) {
        return CoordinateSystem.DefaultImpls.toClient(this, r);
    }
}

