/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/awt/util/RgbToDataUrl;", "", "()V", "png", "", "width", "", "height", "argbValues", "", "toPngDataUri", "image", "Ljava/awt/image/BufferedImage;", "base64EncodedPngImage", "platf-awt"})
public final class RgbToDataUrl {
    @NotNull
    public static final RgbToDataUrl INSTANCE = new RgbToDataUrl();

    private RgbToDataUrl() {
    }

    @NotNull
    public final String png(int width2, int height, @NotNull int[] argbValues) {
        Intrinsics.checkNotNullParameter((Object)argbValues, (String)"argbValues");
        BufferedImage image = new BufferedImage(width2, height, 2);
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width2; ++x2) {
                image.setRGB(x2, y2, argbValues[y2 * width2 + x2]);
            }
        }
        try {
            return this.toPngDataUri(image);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't build image " + width2 + " X " + height, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String toPngDataUri(BufferedImage image) throws IOException {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream stream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            ImageIO.write((RenderedImage)image, "png", stream);
            byte[] bytes = stream.toByteArray();
            String base64String = Base64.getEncoder().encodeToString(bytes);
            Intrinsics.checkNotNull((Object)base64String);
            String string = INSTANCE.toPngDataUri(base64String);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String toPngDataUri(String base64EncodedPngImage) {
        return "data:image/png;base64," + base64EncodedPngImage;
    }
}

