/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.k2.scriptingSupport;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.scriptingSupport.ScriptingEntitiesConsistencyVerifier;
import com.intellij.kotlin.jupyter.core.scriptingSupport.UtilKt;
import com.intellij.kotlin.jupyter.k2.project.model.LibrariesRootsKt;
import com.intellij.kotlin.jupyter.k2.project.model.SearchKt;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.KotlinNotebookScriptModelKt;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.NotebookScriptConfigurationsManager;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.ScriptingEntitiesConsistencyVerifierK2$filterTypesPresentInIndexes$lambda$7$;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImplKt;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.KotlinType;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationConfigurationKeys;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationWithSdk;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinStringStubIndexHelper;
import org.jetbrains.kotlin.idea.stubindex.KotlinStringStubIndexHelperKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0097@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kotlin/jupyter/k2/scriptingSupport/ScriptingEntitiesConsistencyVerifierK2;", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/ScriptingEntitiesConsistencyVerifier;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getDependencyRootsForNotebook", "", "Lcom/intellij/platform/workspace/jps/entities/LibraryRoot;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "checkSourceIsNotEmpty", "", "checkArtifactPresentInLibrary", "virtualFile", "lastCompiledScriptPath", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "filterTypesPresentInIndexes", "", "Lkotlin/script/experimental/api/KotlinType;", "types", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isScriptPathConsistentWithModel", "isScriptFileConfigurationConsistentWithModel", "compilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "compareConfigurationsData", "current", "cached", "intellij.kotlin.jupyter.k2"})
@SourceDebugExtension(value={"SMAP\nScriptingEntitiesConsistencyVerifierK2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingEntitiesConsistencyVerifierK2.kt\ncom/intellij/kotlin/jupyter/k2/scriptingSupport/ScriptingEntitiesConsistencyVerifierK2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 indexSearch.kt\ncom/intellij/kotlin/jupyter/core/projectModel/kotlin/IndexSearchKt\n+ 7 KotlinStringStubIndexHelper.kt\norg/jetbrains/kotlin/idea/stubindex/KotlinStringStubIndexHelper\n*L\n1#1,129:1\n1374#2:130\n1460#2,5:131\n1761#2,3:138\n774#2:145\n865#2,2:146\n774#2:172\n865#2,2:173\n30#3,2:136\n30#3,2:149\n13#4:141\n61#5,3:142\n65#5:148\n10#6,6:151\n75#7,15:157\n*S KotlinDebug\n*F\n+ 1 ScriptingEntitiesConsistencyVerifierK2.kt\ncom/intellij/kotlin/jupyter/k2/scriptingSupport/ScriptingEntitiesConsistencyVerifierK2\n*L\n41#1:130\n41#1:131,5\n57#1:138,3\n63#1:145\n63#1:146,2\n84#1:172\n84#1:173,2\n45#1:136,2\n93#1:149,2\n62#1:141\n62#1:142,3\n62#1:148\n81#1:151,6\n81#1:157,15\n*E\n"})
final class ScriptingEntitiesConsistencyVerifierK2
implements ScriptingEntitiesConsistencyVerifier {
    @NotNull
    private final Project project;

    public ScriptingEntitiesConsistencyVerifierK2(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LibraryRoot> getDependencyRootsForNotebook(BackedNotebookVirtualFile notebookFile) {
        void $this$flatMapTo$iv$iv;
        ImmutableEntityStorage snapshot = UtilKt.getWorkSpaceSnapshot(this.project);
        List<LibraryEntity> dependencyAsLibraries = LibrariesRootsKt.notebookScriptLibrariesEntities(notebookFile, this.project, (EntityStorage)snapshot);
        Iterable $this$flatMap$iv = dependencyAsLibraries;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LibraryEntity it = (LibraryEntity)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getRoots();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean checkSourceIsNotEmpty(BackedNotebookVirtualFile notebookFile) {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<NotebookScriptConfigurationsManager> serviceClass$iv = NotebookScriptConfigurationsManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ConcurrentHashMap<VirtualFile, ScriptConfigurationWithSdk> scriptConfigurationsSource = ((NotebookScriptConfigurationsManager)object).getCache();
        return KotlinNotebookScriptModelKt.getConfigurationForNotebook((Map<VirtualFile, ScriptConfigurationWithSdk>)scriptConfigurationsSource, notebookFile.getFile()) != null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkArtifactPresentInLibrary(BackedNotebookVirtualFile virtualFile, VirtualFileUrl lastCompiledScriptPath) {
        void $this$filterTo$iv$iv;
        void $this$debug_u24default$iv;
        boolean bl;
        String artifactName = lastCompiledScriptPath.getFileName();
        List<LibraryRoot> libraryRoots = this.getDependencyRootsForNotebook(virtualFile);
        Iterable $this$any$iv = libraryRoots;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                LibraryRoot root = (LibraryRoot)element$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)root.getType(), (Object)LibraryRootTypeId.Companion.getCOMPILED())) {
                    String string = root.getUrl().getPresentableUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
                    Intrinsics.checkNotNull((Object)artifactName);
                    if (StringsKt.endsWith$default((String)string, (String)artifactName, (boolean)false, (int)2, null)) {
                        return true;
                    }
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        boolean isPresent = bl;
        if (isPresent) return isPresent;
        ScriptingEntitiesConsistencyVerifierK2 $this$notebookLogger$iv = this;
        boolean $i$f$notebookLogger = false;
        $this$notebookLogger$iv = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(ScriptingEntitiesConsistencyVerifierK2.class));
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if (!$this$debug_u24default$iv.isDebugEnabled()) return isPresent;
        void var20_15 = $this$debug_u24default$iv;
        boolean bl4 = false;
        Iterable $this$filter$iv = libraryRoots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LibraryRoot it = (LibraryRoot)element$iv$iv;
            boolean bl5 = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)LibraryRootTypeId.Companion.getCOMPILED())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String loggedRoots = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)((List)destination$iv$iv), (int)10), (CharSequence)"\n", null, null, (int)0, null, ScriptingEntitiesConsistencyVerifierK2::checkArtifactPresentInLibrary$lambda$4$lambda$3, (int)30, null);
        var20_15.debug("For notebook " + virtualFile.getFile().getName() + " no dependency '" + artifactName + "' found among roots of size " + libraryRoots.size() + ", last roots:\n " + loggedRoots, e$iv);
        return isPresent;
    }

    @Override
    @RequiresReadLock
    @Nullable
    public Object filterTypesPresentInIndexes(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull Collection<KotlinType> types, @NotNull Continuation<? super Collection<KotlinType>> $completion) {
        Module module = SearchKt.findK2WorkspaceModule(virtualFile, this.project);
        if (module == null) {
            return SetsKt.emptySet();
        }
        Module module2 = module;
        return CoroutinesKt.smartReadAction((Project)this.project, () -> ScriptingEntitiesConsistencyVerifierK2.filterTypesPresentInIndexes$lambda$7(module2, this, types), $completion);
    }

    @Override
    public boolean isScriptPathConsistentWithModel(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull VirtualFileUrl lastCompiledScriptPath) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)lastCompiledScriptPath, (String)"lastCompiledScriptPath");
        return this.checkSourceIsNotEmpty(virtualFile) && this.checkArtifactPresentInLibrary(virtualFile, lastCompiledScriptPath);
    }

    @Override
    public boolean isScriptFileConfigurationConsistentWithModel(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull ScriptCompilationConfiguration compilationConfiguration) {
        VirtualFileUrl virtualFileUrl;
        Path path;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)compilationConfiguration, (String)"compilationConfiguration");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<NotebookScriptConfigurationsManager> serviceClass$iv = NotebookScriptConfigurationsManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ConcurrentHashMap<VirtualFile, ScriptConfigurationWithSdk> configurationsCache = ((NotebookScriptConfigurationsManager)object).getCache();
        ScriptCompilationConfigurationWrapper configurationForNotebook = KotlinNotebookScriptModelKt.getConfigurationForNotebook((Map<VirtualFile, ScriptConfigurationWithSdk>)configurationsCache, virtualFile.getFile());
        if (configurationForNotebook == null) {
            return false;
        }
        ScriptCompilationConfiguration scriptCompilationConfiguration = configurationForNotebook.getConfiguration();
        if (scriptCompilationConfiguration == null) {
            return false;
        }
        ScriptCompilationConfiguration configuration = scriptCompilationConfiguration;
        boolean presentInConfigurationSource = this.compareConfigurationsData(compilationConfiguration, configuration);
        if (!presentInConfigurationSource) {
            return false;
        }
        VirtualFileUrlManager urlManager = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getVirtualFileUrlManager();
        File file = (File)CollectionsKt.lastOrNull((List)configurationForNotebook.getDependenciesClassPath());
        if (file == null || (path = file.toPath()) == null || (virtualFileUrl = VirtualFileUrlImplKt.toVirtualFileUrl((Path)path, (VirtualFileUrlManager)urlManager)) == null) {
            return false;
        }
        VirtualFileUrl lastDependencyVFUrl = virtualFileUrl;
        boolean presentInModuleDependencies = this.checkArtifactPresentInLibrary(virtualFile, lastDependencyVFUrl);
        return presentInModuleDependencies;
    }

    private final boolean compareConfigurationsData(ScriptCompilationConfiguration current, ScriptCompilationConfiguration cached) {
        return Intrinsics.areEqual((Object)current.get(ScriptCompilationKt.getBaseClass((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion))), (Object)cached.get(ScriptCompilationKt.getBaseClass((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion)))) && Intrinsics.areEqual((Object)current.get(ScriptCompilationKt.getImplicitReceivers((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion))), (Object)cached.get(ScriptCompilationKt.getImplicitReceivers((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion)))) && Intrinsics.areEqual((Object)current.get(ScriptCompilationKt.getDependencies((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion))), (Object)cached.get(ScriptCompilationKt.getDependencies((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion))));
    }

    private static final CharSequence checkArtifactPresentInLibrary$lambda$4$lambda$3(LibraryRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getUrl().getPresentableUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
        return string;
    }

    private static final String filterTypesPresentInIndexes$lambda$7$lambda$5(KtClassOrObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FqName fqName = it.getFqName();
        return fqName != null ? fqName.asString() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List filterTypesPresentInIndexes$lambda$7(Module $module, ScriptingEntitiesConsistencyVerifierK2 this$0, Collection $types) {
        void $this$filterTo$iv$iv;
        void scope$iv$iv;
        void project$iv$iv;
        void $this$iv$iv;
        void $this$getIndexedTopLevelClassifiersFiltered_u24default$iv;
        Module module = $module;
        Project project$iv = this$0.project;
        boolean $i$f$getIndexedTopLevelClassifiersFiltered = false;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)$this$getIndexedTopLevelClassifiersFiltered_u24default$iv);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope searchScope$iv = globalSearchScope;
        KotlinStringStubIndexHelper kotlinStringStubIndexHelper = (KotlinStringStubIndexHelper)KotlinFullClassNameIndex.Helper;
        Project project = project$iv;
        GlobalSearchScope globalSearchScope2 = searchScope$iv;
        Function1 valueFilter$iv$iv = (Function1)new Function1<KtClassOrObject, Boolean>(){

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke(KtClassOrObject it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                if (string != null) {
                    void it2;
                    String string2 = string;
                    boolean bl2 = false;
                    bl = StringsKt.startsWith$default((String)it2, (String)"Line_", (boolean)false, (int)2, null);
                } else {
                    bl = false;
                }
                return bl;
            }
        };
        Function1 keyFilter$iv$iv = filterTypesPresentInIndexes$lambda$7$$inlined$getIndexedTopLevelClassifiersFiltered$default$2.INSTANCE;
        boolean $i$f$getAllElements = false;
        List results$iv$iv = new ArrayList();
        Processor processor$iv$iv = KotlinStringStubIndexHelperKt.cancelableCollectFilterProcessor((Collection)results$iv$iv, (Function1)valueFilter$iv$iv);
        Function1 function1 = new Function1<Key, Boolean>(processor$iv$iv){
            final /* synthetic */ Processor $processor;
            {
                this.$processor = $processor;
            }

            public final Boolean invoke(Key key) {
                return key instanceof KtClassOrObject ? this.$processor.process(key) : true;
            }
        };
        $this$iv$iv.processAllElements((Project)project$iv$iv, (GlobalSearchScope)scope$iv$iv, keyFilter$iv$iv, new Processor(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean process(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
        Sequence allIndexed = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)results$iv$iv), ScriptingEntitiesConsistencyVerifierK2::filterTypesPresentInIndexes$lambda$7$lambda$5);
        Iterable $this$filter$iv = $types;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl = false;
            if (!SequencesKt.contains((Sequence)allIndexed, (Object)it.getTypeName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

