/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.KnownHostsVerifyResult;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.OpenSshLikeHostKeyVerifierImplKt;
import com.intellij.ssh.SingleKnownHostsDelegate;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ssh/OpenSshLikeHostKeyVerifierImpl;", "Lnet/schmizz/sshj/transport/verification/HostKeyVerifier;", "info", "Lcom/intellij/ssh/OpenSshLikeHostKeyVerifier;", "<init>", "(Lcom/intellij/ssh/OpenSshLikeHostKeyVerifier;)V", "delegates", "", "Lcom/intellij/ssh/SingleKnownHostsDelegate;", "verify", "", "hostname", "", "port", "", "key", "Ljava/security/PublicKey;", "findExistingAlgorithms", "", "writeKey", "", "firstDelegate", "makeHostEntry", "Lnet/schmizz/sshj/transport/verification/OpenSSHKnownHosts$HostEntry;", "Factory", "intellij.platform.ssh"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nOpenSshLikeHostKeyVerifierImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshLikeHostKeyVerifierImpl.kt\ncom/intellij/ssh/OpenSshLikeHostKeyVerifierImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,279:1\n1617#2,9:280\n1869#2:289\n1870#2:291\n1626#2:292\n1#3:290\n1#3:293\n608#4:294\n14#5:295\n*S KotlinDebug\n*F\n+ 1 OpenSshLikeHostKeyVerifierImpl.kt\ncom/intellij/ssh/OpenSshLikeHostKeyVerifierImpl\n*L\n41#1:280,9\n41#1:289\n41#1:291\n41#1:292\n41#1:290\n123#1:294\n172#1:295\n*E\n"})
public final class OpenSshLikeHostKeyVerifierImpl
implements HostKeyVerifier {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final OpenSshLikeHostKeyVerifier info;
    @NotNull
    private final List<SingleKnownHostsDelegate> delegates;
    @NotNull
    private static final ConcurrentMap<String, ReadWriteLock> knownHostsFileLock;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy<File> alternativeKnownHostsFile$delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public OpenSshLikeHostKeyVerifierImpl(@NotNull OpenSshLikeHostKeyVerifier info) {
        void list;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.info = info;
        Iterable iterable = this.info.getKnownHostsFiles();
        OpenSshLikeHostKeyVerifierImpl openSshLikeHostKeyVerifierImpl = this;
        boolean $i$f$mapNotNull22 = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SingleKnownHostsDelegate it$iv$iv;
            SingleKnownHostsDelegate singleKnownHostsDelegate;
            Lock lock;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File file = (File)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)OpenSshLikeHostKeyVerifierImpl.Factory.getRwLock(file).readLock(), (String)"readLock(...)");
            lock.lock();
            try {
                SingleKnownHostsDelegate singleKnownHostsDelegate2;
                boolean bl3 = false;
                try {
                    singleKnownHostsDelegate2 = new SingleKnownHostsDelegate(file);
                }
                catch (IOException err) {
                    LOG.warn("Failed to read file " + file);
                    singleKnownHostsDelegate2 = null;
                }
                singleKnownHostsDelegate = singleKnownHostsDelegate2;
            }
            finally {
                lock.unlock();
            }
            if (singleKnownHostsDelegate == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $i$f$mapNotNull22 = iterable = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl5 = !((Collection)list).isEmpty();
        Iterable iterable2 = bl5 ? iterable : null;
        if (iterable2 == null) {
            iterable2 = CollectionsKt.listOf((Object)((Object)new SingleKnownHostsDelegate(OpenSshLikeHostKeyVerifierImpl.Factory.getAlternativeKnownHostsFile())));
        }
        openSshLikeHostKeyVerifierImpl.delegates = iterable2;
    }

    public boolean verify(@NotNull String hostname, int port, @NotNull PublicKey key) {
        Pair pair;
        Pair pair2;
        block24: {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            for (SingleKnownHostsDelegate delegate : (Iterable)this.delegates) {
                boolean bl = false;
                KnownHostsVerifyResult result = delegate.customVerify(hostname, port, key);
                Pair pair3 = switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
                    case 1, 2 -> TuplesKt.to((Object)((Object)delegate), (Object)((Object)result));
                    case 3 -> null;
                    default -> throw new NoWhenBranchMatchedException();
                };
                if (pair3 == null) continue;
                pair2 = pair3;
                break block24;
            }
            pair2 = pair = null;
        }
        if (pair2 == null) {
            pair = TuplesKt.to((Object)CollectionsKt.firstOrNull(this.delegates), (Object)((Object)KnownHostsVerifyResult.UNKNOWN_OR_BROKEN));
        }
        Pair pair4 = pair;
        SingleKnownHostsDelegate delegate = (SingleKnownHostsDelegate)((Object)pair4.component1());
        KnownHostsVerifyResult verifyResult = (KnownHostsVerifyResult)((Object)pair4.component2());
        String adjustedHostname = OpenSshLikeHostKeyVerifierImplKt.access$adjustHostname(hostname, port);
        return switch (WhenMappings.$EnumSwitchMapping$0[verifyResult.ordinal()]) {
            case 1 -> true;
            case 2 -> {
                switch (WhenMappings.$EnumSwitchMapping$1[this.info.getStrictHostKeyChecking().ordinal()]) {
                    case 1: {
                        yield true;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        KeyType type = KeyType.fromKey((Key)key);
                        String fingerprint = SecurityUtils.getFingerprint((PublicKey)key);
                        Object v4 = delegate;
                        if (v4 == null || (v4 = v4.getFile()) == null || (v4 = ((File)v4).getAbsolutePath()) == null) {
                            v4 = "";
                        }
                        SingleKnownHostsDelegate path = v4;
                        Function4<String, String, String, String, Boolean> v5 = this.info.getAcceptChangedHostKey();
                        String v6 = type.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toString(...)");
                        Intrinsics.checkNotNull((Object)fingerprint);
                        if (((Boolean)v5.invoke((Object)adjustedHostname, (Object)v6, (Object)fingerprint, (Object)path)).booleanValue()) {
                            this.writeKey(adjustedHostname, key, delegate);
                            yield true;
                        }
                        yield false;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3 -> {
                switch (WhenMappings.$EnumSwitchMapping$1[this.info.getStrictHostKeyChecking().ordinal()]) {
                    case 2: {
                        yield false;
                    }
                    case 1: 
                    case 3: {
                        this.writeKey(adjustedHostname, key, delegate);
                        yield true;
                    }
                    case 4: {
                        KeyType type = KeyType.fromKey((Key)key);
                        String fingerprint = SecurityUtils.getFingerprint((PublicKey)key);
                        Object v7 = delegate;
                        if (v7 == null || (v7 = v7.getFile()) == null || (v7 = ((File)v7).getAbsolutePath()) == null) {
                            v7 = "";
                        }
                        SingleKnownHostsDelegate path = v7;
                        Function4<String, String, String, String, Boolean> v8 = this.info.getAcceptUnknownHostKey();
                        String v9 = type.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"toString(...)");
                        Intrinsics.checkNotNull((Object)fingerprint);
                        if (((Boolean)v8.invoke((Object)adjustedHostname, (Object)v9, (Object)fingerprint, (Object)path)).booleanValue()) {
                            this.writeKey(adjustedHostname, key, delegate);
                            yield true;
                        }
                        yield false;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> findExistingAlgorithms(@NotNull String hostname, int port) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        LinkedHashSet result = new LinkedHashSet();
        for (SingleKnownHostsDelegate delegate : this.delegates) {
            Lock lock;
            File file = delegate.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            Intrinsics.checkNotNullExpressionValue((Object)OpenSshLikeHostKeyVerifierImpl.Factory.getRwLock(file).readLock(), (String)"readLock(...)");
            lock.lock();
            try {
                boolean bl = false;
                CollectionsKt.addAll((Collection)result, (Iterable)delegate.findExistingAlgorithms(hostname, port));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
        return CollectionsKt.toMutableList((Collection)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeKey(String hostname, PublicKey key, SingleKnownHostsDelegate firstDelegate) {
        Sequence $this$sortedBy$iv = CollectionsKt.asSequence((Iterable)this.delegates);
        boolean $i$f$sortedBy = false;
        Sequence delegates = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(firstDelegate){
            final /* synthetic */ SingleKnownHostsDelegate $firstDelegate$inlined;
            {
                this.$firstDelegate$inlined = singleKnownHostsDelegate;
            }

            public final int compare(T a, T b) {
                SingleKnownHostsDelegate it = (SingleKnownHostsDelegate)((Object)a);
                boolean bl = false;
                int n = it == this.$firstDelegate$inlined ? 0 : 1;
                it = (SingleKnownHostsDelegate)((Object)b);
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it == this.$firstDelegate$inlined ? 0 : 1));
            }
        });
        KeyType type = KeyType.fromKey((Key)key);
        OpenSSHKnownHosts.HostEntry hostEntry = this.makeHostEntry(hostname, key);
        for (SingleKnownHostsDelegate delegate : delegates) {
            List list = delegate.entries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entries(...)");
            List oldEntries = CollectionsKt.toList((Iterable)list);
            try {
                Path path = delegate.getFile().toPath().getParent();
                if (path != null) {
                    Path p0 = path;
                    boolean bl = false;
                    NioFiles.createDirectories((Path)p0);
                }
                if (delegate.entries().removeIf(arg_0 -> OpenSshLikeHostKeyVerifierImpl.writeKey$lambda$7(arg_0 -> OpenSshLikeHostKeyVerifierImpl.writeKey$lambda$6(hostname, type, arg_0), arg_0))) {
                    List list2 = delegate.entries();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"entries(...)");
                    ((Collection)list2).add(hostEntry);
                    File file = delegate.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                    Lock lock = OpenSshLikeHostKeyVerifierImpl.Factory.getRwLock(file).writeLock();
                    Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"writeLock(...)");
                    Lock lock2 = lock;
                    lock2.lock();
                    try {
                        boolean $i$a$-withLock-OpenSshLikeHostKeyVerifierImpl$writeKey$52 = false;
                        delegate.write();
                        Unit $i$a$-withLock-OpenSshLikeHostKeyVerifierImpl$writeKey$52 = Unit.INSTANCE;
                        break;
                    }
                    finally {
                        lock2.unlock();
                    }
                }
                List list3 = delegate.entries();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"entries(...)");
                ((Collection)list3).add(hostEntry);
                File file = delegate.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                Lock lock = OpenSshLikeHostKeyVerifierImpl.Factory.getRwLock(file).writeLock();
                Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"writeLock(...)");
                Lock lock3 = lock;
                lock3.lock();
                try {
                    boolean bl = false;
                    delegate.write((OpenSSHKnownHosts.KnownHostEntry)hostEntry);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                finally {
                    lock3.unlock();
                }
            }
            catch (IOException err) {
                delegate.entries().clear();
                List list4 = delegate.entries();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"entries(...)");
                CollectionsKt.addAll((Collection)list4, (Iterable)oldEntries);
                UtilKt.getSSHJ_LOG().info("Failed to write to " + delegate.getFile() + ": " + err);
            }
        }
    }

    private final OpenSSHKnownHosts.HostEntry makeHostEntry(String hostname, PublicKey key) {
        String hostPart = this.info.getHashKnownHosts() ? OpenSshLikeHostKeyVerifierImplKt.hashHostName(hostname) : hostname;
        return new OpenSSHKnownHosts.HostEntry(null, hostPart, KeyType.fromKey((Key)key), key);
    }

    private static final boolean writeKey$lambda$6(String $hostname, KeyType $type, OpenSSHKnownHosts.KnownHostEntry it) {
        return it.appliesTo($hostname) && it.getType() == $type;
    }

    private static final boolean writeKey$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final File alternativeKnownHostsFile_delegate$lambda$11() {
        File file;
        File $this$alternativeKnownHostsFile_delegate_u24lambda_u2411_u24lambda_u2410 = file = FileUtil.createTempFile((String)"known_hosts", (String)"", (boolean)true);
        boolean bl = false;
        $this$alternativeKnownHostsFile_delegate_u24lambda_u2411_u24lambda_u2410.setReadable(false, false);
        $this$alternativeKnownHostsFile_delegate_u24lambda_u2411_u24lambda_u2410.setReadable(true);
        $this$alternativeKnownHostsFile_delegate_u24lambda_u2411_u24lambda_u2410.setWritable(false, false);
        $this$alternativeKnownHostsFile_delegate_u24lambda_u2411_u24lambda_u2410.setWritable(true);
        return file;
    }

    static {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        knownHostsFileLock = concurrentMap;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OpenSshLikeHostKeyVerifierImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        alternativeKnownHostsFile$delegate = LazyKt.lazy(OpenSshLikeHostKeyVerifierImpl::alternativeKnownHostsFile_delegate$lambda$11);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\t*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ssh/OpenSshLikeHostKeyVerifierImpl$Factory;", "", "<init>", "()V", "knownHostsFileLock", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljava/util/concurrent/locks/ReadWriteLock;", "rwLock", "Ljava/io/File;", "getRwLock", "(Ljava/io/File;)Ljava/util/concurrent/locks/ReadWriteLock;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "alternativeKnownHostsFile", "getAlternativeKnownHostsFile", "()Ljava/io/File;", "alternativeKnownHostsFile$delegate", "Lkotlin/Lazy;", "intellij.platform.ssh"})
    public static final class Factory {
        private Factory() {
        }

        private final ReadWriteLock getRwLock(File $this$rwLock) {
            ReadWriteLock readWriteLock = knownHostsFileLock.computeIfAbsent($this$rwLock.getAbsolutePath(), arg_0 -> Factory._get_rwLock_$lambda$1(Factory::_get_rwLock_$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)readWriteLock, (String)"computeIfAbsent(...)");
            return readWriteLock;
        }

        private final File getAlternativeKnownHostsFile() {
            Lazy lazy = alternativeKnownHostsFile$delegate;
            return (File)lazy.getValue();
        }

        private static final ReadWriteLock _get_rwLock_$lambda$0(String it) {
            return new ReentrantReadWriteLock();
        }

        private static final ReadWriteLock _get_rwLock_$lambda$1(Function1 $tmp0, Object p0) {
            return (ReadWriteLock)$tmp0.invoke(p0);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KnownHostsVerifyResult.values().length];
            try {
                nArray[KnownHostsVerifyResult.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KnownHostsVerifyResult.CHANGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KnownHostsVerifyResult.UNKNOWN_OR_BROKEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.values().length];
            try {
                nArray[SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.YES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ACCEPT_NEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

