/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.archetype.common.MavenJDOMWriter;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.common.util.Format;
import org.apache.maven.archetype.common.util.PomUtils;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.archetype.old.ArchetypeTemplateProcessingException;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.SAXException;

@Component(role=PomManager.class)
public class DefaultPomManager
extends AbstractLogEnabled
implements PomManager {
    @Override
    public void addModule(File pom, String artifactId) throws IOException, ParserConfigurationException, TransformerException, SAXException, InvalidPackaging, ArchetypeTemplateProcessingException {
        StringWriter out = new StringWriter();
        boolean found = PomUtils.addNewModule(artifactId, (Reader)ReaderFactory.newXmlReader((File)pom), out);
        if (found) {
            FileUtils.fileWrite((String)pom.getAbsolutePath(), (String)out.toString());
        }
    }

    @Override
    public void addParent(File pom, File parentPom) throws IOException, XmlPullParserException {
        Model generatedModel = this.readPom(pom);
        if (null != generatedModel.getParent()) {
            this.getLogger().info("Parent element not overwritten in " + pom);
            return;
        }
        Model parentModel = this.readPom(parentPom);
        Parent parent = new Parent();
        parent.setGroupId(parentModel.getGroupId());
        if (parent.getGroupId() == null) {
            parent.setGroupId(parentModel.getParent().getGroupId());
        }
        parent.setArtifactId(parentModel.getArtifactId());
        parent.setVersion(parentModel.getVersion());
        if (parent.getVersion() == null) {
            parent.setVersion(parentModel.getParent().getVersion());
        }
        generatedModel.setParent(parent);
        this.writePom(generatedModel, pom, pom);
    }

    @Override
    public void mergePoms(File pom, File temporaryPom) throws IOException, XmlPullParserException {
        Model model = this.readPom(pom);
        Model generatedModel = this.readPom(temporaryPom);
        model.getProperties().putAll((Map<?, ?>)generatedModel.getProperties());
        this.mergeModelBase((ModelBase)model, (ModelBase)generatedModel);
        this.mergeModelBuild(model, generatedModel);
        this.mergeProfiles(model, generatedModel);
        this.mergeReportPlugins(model, generatedModel);
        this.writePom(model, pom, pom);
    }

    @Override
    public Model readPom(File pomFile) throws IOException, XmlPullParserException {
        try (XmlStreamReader pomReader = ReaderFactory.newXmlReader((File)pomFile);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)pomReader);
            return model;
        }
    }

    @Override
    public Model readPom(InputStream pomStream) throws IOException, XmlPullParserException {
        try (XmlStreamReader pomReader = ReaderFactory.newXmlReader((InputStream)pomStream);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)pomReader);
            return model;
        }
    }

    @Override
    public void writePom(Model model, File pomFile, File initialPomFile) throws IOException {
        Document doc;
        Throwable throwable;
        String fileEncoding = StringUtils.isEmpty((String)model.getModelEncoding()) ? "UTF-8" : model.getModelEncoding();
        try {
            throwable = null;
            try (FileInputStream inputStream = new FileInputStream(initialPomFile);){
                SAXBuilder builder = new SAXBuilder();
                doc = builder.build((InputStream)inputStream);
            }
            catch (Throwable builder) {
                throwable = builder;
                throw builder;
            }
        }
        catch (JDOMException exc) {
            throw new IOException("Cannot parse the POM by JDOM while reading " + initialPomFile + ": " + exc.getMessage(), exc);
        }
        if (!pomFile.exists() && !pomFile.createNewFile()) {
            this.getLogger().warn("Could not create new file \"" + pomFile.getPath() + "\" or the file already exists.");
        }
        try {
            throwable = null;
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(pomFile), fileEncoding);){
                MavenJDOMWriter writer = new MavenJDOMWriter();
                String ls = System.lineSeparator();
                Format form = Format.getRawFormat().setEncoding(fileEncoding).setLineSeparator(ls);
                writer.write(model, doc, outputStreamWriter, form);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException e) {
            this.getLogger().debug("Creating pom file " + pomFile);
            try (OutputStreamWriter pomWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(pomFile), fileEncoding);){
                MavenXpp3Writer writer = new MavenXpp3Writer();
                writer.write((Writer)pomWriter, model);
            }
        }
    }

    private Map<String, Dependency> createDependencyMap(List<Dependency> dependencies) {
        HashMap<String, Dependency> dependencyMap = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            dependencyMap.put(dependency.getManagementKey(), dependency);
        }
        return dependencyMap;
    }

    private void mergeModelBuild(Model model, Model generatedModel) {
        if (generatedModel.getBuild() != null) {
            if (model.getBuild() == null) {
                model.setBuild(new Build());
            }
            this.mergeBuildPlugins((BuildBase)model.getBuild(), (BuildBase)generatedModel.getBuild());
        }
    }

    private void mergeProfiles(Model model, Model generatedModel) {
        List generatedProfiles = generatedModel.getProfiles();
        if (generatedProfiles != null && generatedProfiles.size() > 0) {
            ArrayList modelProfiles = model.getProfiles();
            HashMap<String, Profile> modelProfileIdMap = new HashMap<String, Profile>();
            if (modelProfiles == null) {
                modelProfiles = new ArrayList();
                model.setProfiles(modelProfiles);
            } else if (modelProfiles.size() > 0) {
                for (Profile modelProfile : modelProfiles) {
                    modelProfileIdMap.put(modelProfile.getId(), modelProfile);
                }
            }
            for (Profile generatedProfile : generatedProfiles) {
                String generatedProfileId = generatedProfile.getId();
                if (!modelProfileIdMap.containsKey(generatedProfileId)) {
                    model.addProfile(generatedProfile);
                    continue;
                }
                this.getLogger().warn("Try to merge profiles with id " + generatedProfileId);
                this.mergeModelBase((ModelBase)modelProfileIdMap.get(generatedProfileId), (ModelBase)generatedProfile);
                this.mergeProfileBuild((Profile)modelProfileIdMap.get(generatedProfileId), generatedProfile);
            }
        }
    }

    private void mergeProfileBuild(Profile modelProfile, Profile generatedProfile) {
        if (generatedProfile.getBuild() != null) {
            if (modelProfile.getBuild() == null) {
                modelProfile.setBuild((BuildBase)new Build());
            }
            this.mergeBuildPlugins(modelProfile.getBuild(), generatedProfile.getBuild());
        }
    }

    private void mergeModelBase(ModelBase model, ModelBase generatedModel) {
        Map<String, Dependency> dependenciesByIds = this.createDependencyMap(model.getDependencies());
        Map<String, Dependency> generatedDependenciesByIds = this.createDependencyMap(generatedModel.getDependencies());
        for (String generatedDependencyId : generatedDependenciesByIds.keySet()) {
            if (!dependenciesByIds.containsKey(generatedDependencyId)) {
                model.addDependency(generatedDependenciesByIds.get(generatedDependencyId));
            } else {
                this.getLogger().warn("Can not override property: " + generatedDependencyId);
            }
            model.getProperties().putAll((Map<?, ?>)generatedModel.getProperties());
        }
    }

    private void mergeReportPlugins(Model model, Model generatedModel) {
        if (generatedModel.getReporting() != null) {
            if (model.getReporting() == null) {
                model.setReporting(new Reporting());
            }
            Map reportPluginsByIds = model.getReporting().getReportPluginsAsMap();
            Map generatedReportPluginsByIds = generatedModel.getReporting().getReportPluginsAsMap();
            for (String generatedReportPluginsId : generatedReportPluginsByIds.keySet()) {
                if (!reportPluginsByIds.containsKey(generatedReportPluginsId)) {
                    model.getReporting().addPlugin((ReportPlugin)generatedReportPluginsByIds.get(generatedReportPluginsId));
                    continue;
                }
                this.getLogger().warn("Can not override report: " + generatedReportPluginsId);
            }
        }
    }

    private void mergeBuildPlugins(BuildBase modelBuild, BuildBase generatedModelBuild) {
        Map pluginsByIds = modelBuild.getPluginsAsMap();
        List generatedPlugins = generatedModelBuild.getPlugins();
        for (Plugin generatedPlugin : generatedPlugins) {
            String generatedPluginsId = generatedPlugin.getKey();
            if (!pluginsByIds.containsKey(generatedPluginsId)) {
                modelBuild.addPlugin(generatedPlugin);
                continue;
            }
            this.getLogger().info("Try to merge plugin configuration of plugins with id: " + generatedPluginsId);
            Plugin modelPlugin = (Plugin)pluginsByIds.get(generatedPluginsId);
            modelPlugin.setConfiguration((Object)Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)generatedPlugin.getConfiguration()), (Xpp3Dom)((Xpp3Dom)modelPlugin.getConfiguration())));
        }
    }
}

