/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetSocketAddress;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.DataHelper;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.util.Addresses;
import net.i2p.util.Log;

class InboundEstablishState {
    protected final RouterContext _context;
    protected final Log _log;
    private byte[] _receivedX;
    protected byte[] _bobIP;
    protected final int _bobPort;
    protected final byte[] _aliceIP;
    protected final int _alicePort;
    protected long _sentRelayTag;
    private long _sentSignedOnTime;
    private byte[][] _receivedIdentity;
    private long _receivedSignedOnTime;
    private byte[] _receivedSignature;
    protected RouterIdentity _receivedUnconfirmedIdentity;
    protected RouterIdentity _receivedConfirmedIdentity;
    protected final long _establishBegin;
    protected long _lastSend;
    protected long _nextSend;
    protected final RemoteHostId _remoteHostId;
    protected InboundState _currentState;
    private final Queue<OutNetMessage> _queuedMessages;
    protected int _createdSentCount;
    protected boolean _introductionRequested;
    protected int _rtt;
    protected static final long RETRANSMIT_DELAY = 1000L;
    protected static final long MAX_DELAY = 12000L;

    protected InboundEstablishState(RouterContext ctx, InetSocketAddress addr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._aliceIP = addr.getAddress().getAddress();
        this._alicePort = addr.getPort();
        this._remoteHostId = new RemoteHostId(this._aliceIP, this._alicePort);
        this._bobPort = 0;
        this._currentState = InboundState.IB_STATE_UNKNOWN;
        this._establishBegin = ctx.clock().now();
        this._queuedMessages = new LinkedBlockingQueue<OutNetMessage>();
    }

    public int getVersion() {
        return 1;
    }

    public synchronized InboundState getState() {
        return this._currentState;
    }

    public synchronized boolean isComplete() {
        return this._currentState == InboundState.IB_STATE_COMPLETE || this._currentState == InboundState.IB_STATE_FAILED;
    }

    public synchronized void complete() {
        this._currentState = InboundState.IB_STATE_COMPLETE;
    }

    public void addMessage(OutNetMessage msg) {
        if (!this._queuedMessages.contains(msg)) {
            this._queuedMessages.offer(msg);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("attempt to add duplicate msg to queue: " + msg);
        }
    }

    public OutNetMessage getNextQueuedMessage() {
        return this._queuedMessages.poll();
    }

    public synchronized boolean sessionRequestReceived() {
        return this._receivedX != null;
    }

    public synchronized byte[] getReceivedX() {
        return this._receivedX;
    }

    public synchronized byte[] getReceivedOurIP() {
        return this._bobIP;
    }

    public synchronized boolean isIntroductionRequested() {
        return this._introductionRequested;
    }

    public byte[] getSentIP() {
        return this._aliceIP;
    }

    public int getSentPort() {
        return this._alicePort;
    }

    public synchronized void fail() {
        this._currentState = InboundState.IB_STATE_FAILED;
    }

    public synchronized long getSentRelayTag() {
        return this._sentRelayTag;
    }

    public synchronized void setSentRelayTag(long tag) {
        this._sentRelayTag = tag;
    }

    public synchronized long getSentSignedOnTime() {
        return this._sentSignedOnTime;
    }

    public synchronized void createdPacketSent() {
        this._lastSend = this._context.clock().now();
        long delay = this._createdSentCount == 0 ? 1000L : Math.min(1000L << this._createdSentCount, 12000L);
        ++this._createdSentCount;
        this._nextSend = this._lastSend + delay;
        if (this._currentState == InboundState.IB_STATE_UNKNOWN || this._currentState == InboundState.IB_STATE_REQUEST_RECEIVED) {
            this._currentState = InboundState.IB_STATE_CREATED_SENT;
        }
    }

    public long getLifetime() {
        return this.getLifetime(this._context.clock().now());
    }

    public long getLifetime(long now) {
        return now - this._establishBegin;
    }

    public long getEstablishBeginTime() {
        return this._establishBegin;
    }

    public synchronized long getNextSendTime() {
        return this._nextSend;
    }

    synchronized int getRTT() {
        return this._rtt;
    }

    RemoteHostId getRemoteHostId() {
        return this._remoteHostId;
    }

    protected boolean confirmedFullyReceived() {
        if (this._receivedIdentity != null) {
            for (int i = 0; i < this._receivedIdentity.length; ++i) {
                if (this._receivedIdentity[i] != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized RouterIdentity getConfirmedIdentity() {
        return this._receivedConfirmedIdentity;
    }

    protected void packetReceived() {
        this._nextSend = this._context.clock().now();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("IES ");
        buf.append(Addresses.toString(this._aliceIP, this._alicePort));
        buf.append(" lifetime: ").append(DataHelper.formatDuration(this.getLifetime()));
        if (this._sentRelayTag > 0L) {
            buf.append(" RelayTag: ").append(this._sentRelayTag);
        }
        buf.append(' ').append((Object)this._currentState);
        return buf.toString();
    }

    public static enum InboundState {
        IB_STATE_UNKNOWN,
        IB_STATE_REQUEST_RECEIVED,
        IB_STATE_CREATED_SENT,
        IB_STATE_CONFIRMED_PARTIALLY,
        IB_STATE_CONFIRMED_COMPLETELY,
        IB_STATE_FAILED,
        IB_STATE_COMPLETE,
        IB_STATE_TOKEN_REQUEST_RECEIVED,
        IB_STATE_REQUEST_BAD_TOKEN_RECEIVED,
        IB_STATE_RETRY_SENT;

    }
}

