/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import java.awt.Color;

public class PColorActivity
extends PInterpolatingActivity {
    private Color source;
    private Color destination;
    private Target target;

    public PColorActivity(long l, long l2, Target target) {
        this(l, l2, target, null);
    }

    public PColorActivity(long l, long l2, Target target, Color color) {
        this(l, l2, 1, 1, target, color);
    }

    public PColorActivity(long l, long l2, int n, int n2, Target target, Color color) {
        super(l, l2, n, n2);
        this.target = target;
        this.destination = color;
    }

    protected boolean isAnimation() {
        return true;
    }

    public Color getDestinationColor() {
        return this.destination;
    }

    public void setDestinationColor(Color color) {
        this.destination = color;
    }

    protected void activityStarted() {
        if (this.getFirstLoop()) {
            this.source = this.target.getColor();
        }
        super.activityStarted();
    }

    public void setRelativeTargetValue(float f) {
        super.setRelativeTargetValue(f);
        float f2 = (float)this.source.getRed() + f * (float)(this.destination.getRed() - this.source.getRed());
        float f3 = (float)this.source.getGreen() + f * (float)(this.destination.getGreen() - this.source.getGreen());
        float f4 = (float)this.source.getBlue() + f * (float)(this.destination.getBlue() - this.source.getBlue());
        float f5 = (float)this.source.getAlpha() + f * (float)(this.destination.getAlpha() - this.source.getAlpha());
        this.target.setColor(new Color(f2 / 255.0f, f3 / 255.0f, f4 / 255.0f, f5 / 255.0f));
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("source=" + (this.source == null ? "null" : this.source.toString()));
        stringBuffer.append(",destination=" + (this.destination == null ? "null" : this.destination.toString()));
        stringBuffer.append(',');
        stringBuffer.append(super.paramString());
        return stringBuffer.toString();
    }

    public static interface Target {
        public void setColor(Color var1);

        public Color getColor();
    }
}

