/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.view.TabbedPanel2;

public class TabbedPanelTab
extends JPanel {
    private static final Icon CLOSE_TAB_GREY_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/cross-small-grey.png")));
    private static final Icon CLOSE_TAB_RED_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/cross-small-red.png")));
    private static final Icon PIN_TAB_GREY_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/pin-small-grey.png")));
    private static final Icon PIN_TAB_LIGHT_GREY_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/pin-small-ltgrey.png")));
    private static final Icon PIN_TAB_RED_ICON = DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource("/resource/icon/fugue/pin-small-red.png")));
    private static final long serialVersionUID = 1L;
    private JButton btnPin = new JButton();
    private JButton btnClose = new JButton();
    private AbstractPanel ap = null;

    public TabbedPanelTab(final TabbedPanel2 parent, String title, Icon icon, final Component c, boolean hideable, boolean isPinned) {
        super(new FlowLayout(1, 0, 0));
        this.setOpaque(false);
        if (!Model.getSingleton().getOptionsParam().getViewParam().getShowTabNames()) {
            title = "";
        }
        if (c.getName() == null) {
            c.setName(title);
        }
        JLabel lblTitle = new JLabel(title);
        lblTitle.setIcon(icon);
        lblTitle.setFont(FontUtils.getFont(FontUtils.Size.standard));
        this.add(lblTitle);
        if (hideable) {
            if (c instanceof AbstractPanel) {
                this.ap = (AbstractPanel)c;
                this.ap.setPinned(isPinned);
                this.btnPin.setOpaque(false);
                this.btnPin.setRolloverEnabled(true);
                this.btnPin.setToolTipText(Constant.messages.getString("all.button.pin"));
                this.btnPin.setContentAreaFilled(false);
                if (this.ap.isPinned()) {
                    this.btnPin.setIcon(PIN_TAB_GREY_ICON);
                    this.btnPin.setRolloverIcon(PIN_TAB_RED_ICON);
                } else {
                    this.btnPin.setIcon(PIN_TAB_LIGHT_GREY_ICON);
                    this.btnPin.setRolloverIcon(PIN_TAB_RED_ICON);
                }
                this.btnPin.setBorder(new EmptyBorder(0, 6, 0, 0));
                this.btnPin.setBorderPainted(false);
                this.btnPin.setFocusable(false);
                this.btnPin.setEnabled(false);
                this.btnPin.setVisible(false);
                ActionListener pinListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TabbedPanelTab.this.setPinned(!TabbedPanelTab.this.ap.isPinned());
                        parent.saveTabState(TabbedPanelTab.this.ap);
                    }
                };
                this.btnPin.addActionListener(pinListener);
                this.add(this.btnPin);
            }
            this.btnClose.setOpaque(false);
            this.btnClose.setRolloverIcon(CLOSE_TAB_RED_ICON);
            this.btnClose.setRolloverEnabled(true);
            this.btnClose.setContentAreaFilled(false);
            this.btnClose.setToolTipText(Constant.messages.getString("all.button.close"));
            this.btnClose.setIcon(CLOSE_TAB_GREY_ICON);
            this.btnClose.setBorder(new EmptyBorder(0, 6, 0, 0));
            this.btnClose.setBorderPainted(false);
            this.btnClose.setFocusable(false);
            this.btnClose.setEnabled(false);
            this.btnClose.setVisible(false);
            ActionListener closeListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    parent.setVisible(c, false);
                }
            };
            this.btnClose.addActionListener(closeListener);
            this.add(this.btnClose);
        }
    }

    public void setPinned(boolean pinned) {
        if (this.ap == null) {
            return;
        }
        this.ap.setPinned(pinned);
        if (this.ap.isPinned()) {
            this.btnPin.setIcon(PIN_TAB_GREY_ICON);
            this.btnPin.setRolloverIcon(PIN_TAB_RED_ICON);
            this.btnPin.setToolTipText(Constant.messages.getString("all.button.unpin"));
        } else {
            this.btnPin.setIcon(PIN_TAB_LIGHT_GREY_ICON);
            this.btnPin.setRolloverIcon(PIN_TAB_RED_ICON);
            this.btnPin.setToolTipText(Constant.messages.getString("all.button.pin"));
        }
        this.btnClose.setEnabled(!this.ap.isPinned());
        this.btnClose.setVisible(!this.ap.isPinned());
    }

    public void setLocked(boolean locked) {
        if (this.ap == null) {
            return;
        }
        this.ap.setLocked(locked);
        this.btnPin.setVisible(!locked);
        if (!this.ap.isPinned()) {
            this.btnClose.setVisible(!locked);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.ap != null && this.ap.isLocked()) {
            return;
        }
        this.btnPin.setEnabled(enabled);
        this.btnPin.setVisible(enabled);
        if (this.ap == null || !this.ap.isPinned()) {
            this.btnClose.setEnabled(enabled);
            this.btnClose.setVisible(enabled);
        }
    }

    protected AbstractPanel getAbstractPanel() {
        return this.ap;
    }
}

