/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.WebResult;

public class StopJobServlet
extends HttpServlet {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/stopJob";
    private static LogWriter log = LogWriter.getInstance();
    private JobMap jobMap;

    public StopJobServlet(JobMap jobMap) {
        this.jobMap = jobMap;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getContextPath().equals(CONTEXT_PATH)) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("StopJobServlet.log.StopJobRequested"), new Object[0]);
        }
        String jobName = request.getParameter("name");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        try {
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            } else {
                response.setContentType("text/html");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>Stop job</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=/kettle/jobStatus?name=" + URLEncoder.encode(jobName, "UTF-8") + "\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            Job job = this.jobMap.getJob(jobName);
            if (job != null) {
                job.stopAll();
                String message = Messages.getString("JobStatusServlet.Log.JobStopRequested", jobName);
                if (useXML) {
                    out.println(new WebResult("OK", message).getXML());
                } else {
                    out.println("<H1>" + message + "</H1>");
                    out.println("<a href=\"/kettle/jobStatus?name=" + URLEncoder.encode(jobName, "UTF-8") + "\">" + Messages.getString("JobStatusServlet.BackToJobStatusPage") + "</a><p>");
                }
            } else {
                String message = Messages.getString("StopJobServlet.Log.CoundNotFindJob", jobName);
                if (useXML) {
                    out.println(new WebResult("ERROR", message).getXML());
                } else {
                    out.println("<H1>" + message + "</H1>");
                    out.println("<a href=\"/kettle/status\">" + Messages.getString("TransStatusServlet.BackToStatusPage") + "</a><p>");
                }
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)).getXML());
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Stop job";
    }
}

