/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.swingx.JXPanel;

public class JXGlassBox
extends JXPanel {
    private static final int SHOW_DELAY = 30;
    private static final int TIMER_INCREMENT = 10;
    private float alphaStart = 0.01f;
    private float alphaEnd = 0.8f;
    private Timer animateTimer;
    private float alphaIncrement = 0.02f;
    private boolean dismissOnClick = false;
    private MouseAdapter dismissListener = null;

    public JXGlassBox() {
        this.setOpaque(false);
        this.setAlpha(this.alphaStart);
        this.setBackground(Color.white);
        this.setDismissOnClick(true);
        this.animateTimer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JXGlassBox.this.setAlpha(Math.min(JXGlassBox.this.alphaEnd, JXGlassBox.this.getAlpha() + JXGlassBox.this.alphaIncrement));
            }
        });
    }

    public JXGlassBox(float alpha) {
        this();
        this.setAlpha(alpha);
    }

    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        this.alphaIncrement = (this.alphaEnd - this.alphaStart) / 3.0f;
    }

    public void setDismissOnClick(boolean dismissOnClick) {
        boolean oldDismissOnClick = this.dismissOnClick;
        this.dismissOnClick = dismissOnClick;
        if (dismissOnClick && !oldDismissOnClick) {
            if (this.dismissListener == null) {
                this.dismissListener = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        JXGlassBox glassBox = JXGlassBox.this;
                        JComponent parent = (JComponent)glassBox.getParent();
                        Container toplevel = parent.getTopLevelAncestor();
                        parent.remove(glassBox);
                        toplevel.validate();
                        toplevel.repaint();
                    }
                };
            }
            this.addMouseListener(this.dismissListener);
        } else if (!dismissOnClick && oldDismissOnClick) {
            this.removeMouseListener(this.dismissListener);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (!this.animateTimer.isRunning() && this.getAlpha() < this.alphaEnd) {
            this.animateTimer.start();
        }
        if (this.animateTimer.isRunning() && this.getAlpha() >= this.alphaEnd) {
            this.animateTimer.stop();
        }
    }

    public void setVisible(boolean visible) {
        this.setAlpha(this.alphaStart);
        super.setVisible(visible);
    }

    private Container getTopLevel() {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof Window) && !(p instanceof Applet); p = p.getParent()) {
        }
        return p;
    }

    public void showOnGlassPane(Container glassPane, Component component, int componentX, int componentY, int positionHint) {
        Dimension boxPrefSize = this.getPreferredSize();
        Dimension glassSize = glassPane.getSize();
        Rectangle compRect = component.getBounds();
        int boxX = 0;
        int boxY = 0;
        int boxWidth = Math.min(boxPrefSize.width, glassSize.width);
        int boxHeight = Math.min(boxPrefSize.height, glassSize.height);
        Point compLocation = SwingUtilities.convertPoint(component.getParent(), compRect.x, compRect.y, glassPane);
        if (positionHint == 1) {
            boxX = compLocation.x + componentX + boxWidth <= glassSize.width ? compLocation.x + componentX : glassSize.width - boxWidth;
            boxY = compLocation.y - boxHeight;
            if (boxY < 0) {
                boxY = compLocation.y + compRect.height <= glassSize.height ? compLocation.y + compRect.height : 0;
            }
        }
        glassPane.setLayout(null);
        this.setBounds(boxX, boxY, boxWidth, boxHeight);
        glassPane.add(this);
        glassPane.setVisible(true);
        Container topLevel = this.getTopLevel();
        topLevel.validate();
        topLevel.repaint();
    }

    public void showOnGlassPane(Container glassPane, int originX, int originY) {
        Dimension boxPrefSize = this.getPreferredSize();
        Dimension glassSize = glassPane.getSize();
        int boxX = 0;
        int boxY = 0;
        int boxWidth = 0;
        int boxHeight = 0;
        boxWidth = Math.min(boxPrefSize.width, glassSize.width);
        boxHeight = Math.min(boxPrefSize.height, glassSize.height);
        boxY = originY - boxHeight >= 0 ? originY - boxHeight : (originY + boxHeight <= glassSize.height ? originY : glassSize.height - boxHeight);
        boxX = originX + boxWidth <= glassSize.width ? originX : (originX >= boxWidth ? originX - boxWidth : glassSize.width - boxWidth);
        glassPane.setLayout(null);
        this.setBounds(boxX, boxY, boxWidth, boxHeight);
        glassPane.add(this);
        glassPane.setVisible(true);
        Container topLevel = this.getTopLevel();
        topLevel.validate();
        topLevel.repaint();
    }
}

