/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.text.MessageFormat;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

final class FSException
extends IOException {
    private Object[] args;

    private FSException(String string, Object[] objectArray) {
        super(string);
        this.args = objectArray;
    }

    public String getMessage() {
        return " " + this.getLocalizedMessage();
    }

    public String getLocalizedMessage() {
        String string = super.getMessage();
        String string2 = FileSystem.getString(string);
        if (this.args != null) {
            return MessageFormat.format(string2, this.args);
        }
        return string2;
    }

    public static void io(String string) throws IOException {
        FSException fSException = new FSException(string, null);
        Exceptions.attachLocalizedMessage((Throwable)fSException, (String)fSException.getLocalizedMessage());
        throw fSException;
    }

    public static void io(String string, Object[] objectArray) throws IOException {
        FSException fSException = new FSException(string, objectArray);
        Exceptions.attachLocalizedMessage((Throwable)fSException, (String)fSException.getLocalizedMessage());
        throw fSException;
    }

    public static void io(String string, Object object) throws IOException {
        FSException fSException = new FSException(string, new Object[]{object});
        Exceptions.attachLocalizedMessage((Throwable)fSException, (String)fSException.getLocalizedMessage());
        throw fSException;
    }

    public static void io(String string, Object object, Object object2) throws IOException {
        FSException fSException = new FSException(string, new Object[]{object, object2});
        Exceptions.attachLocalizedMessage((Throwable)fSException, (String)fSException.getLocalizedMessage());
        throw fSException;
    }

    public static void io(String string, Object object, Object object2, Object object3) throws IOException {
        FSException fSException = new FSException(string, new Object[]{object, object2, object3});
        Exceptions.attachLocalizedMessage((Throwable)fSException, (String)fSException.getLocalizedMessage());
        throw fSException;
    }

    public static void io(String string, Object object, Object object2, Object object3, Object object4) throws IOException {
        FSException fSException = new FSException(string, new Object[]{object, object2, object3, object4});
        Exceptions.attachLocalizedMessage((Throwable)fSException, (String)fSException.getLocalizedMessage());
        throw fSException;
    }
}

