/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.Util;

class UnixUserPrincipals {
    static final User SPECIAL_OWNER = UnixUserPrincipals.createSpecial("OWNER@");
    static final User SPECIAL_GROUP = UnixUserPrincipals.createSpecial("GROUP@");
    static final User SPECIAL_EVERYONE = UnixUserPrincipals.createSpecial("EVERYONE@");

    UnixUserPrincipals() {
    }

    private static User createSpecial(String string) {
        return new User(-1, string);
    }

    static User fromUid(int n) {
        String string = null;
        try {
            string = Util.toString(UnixNativeDispatcher.getpwuid(n));
        }
        catch (UnixException unixException) {
            string = Integer.toString(n);
        }
        return new User(n, string);
    }

    static Group fromGid(int n) {
        String string = null;
        try {
            string = Util.toString(UnixNativeDispatcher.getgrgid(n));
        }
        catch (UnixException unixException) {
            string = Integer.toString(n);
        }
        return new Group(n, string);
    }

    private static int lookupName(String string, boolean bl) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("lookupUserInformation"));
        }
        int n = -1;
        try {
            n = bl ? UnixNativeDispatcher.getgrnam(string) : UnixNativeDispatcher.getpwnam(string);
        }
        catch (UnixException unixException) {
            throw new IOException(string + ": " + unixException.errorString());
        }
        if (n == -1) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UserPrincipalNotFoundException(string);
            }
        }
        return n;
    }

    static UserPrincipal lookupUser(String string) throws IOException {
        if (string.equals(SPECIAL_OWNER.getName())) {
            return SPECIAL_OWNER;
        }
        if (string.equals(SPECIAL_GROUP.getName())) {
            return SPECIAL_GROUP;
        }
        if (string.equals(SPECIAL_EVERYONE.getName())) {
            return SPECIAL_EVERYONE;
        }
        int n = UnixUserPrincipals.lookupName(string, false);
        return new User(n, string);
    }

    static GroupPrincipal lookupGroup(String string) throws IOException {
        int n = UnixUserPrincipals.lookupName(string, true);
        return new Group(n, string);
    }

    static class Group
    extends User
    implements GroupPrincipal {
        Group(int n, String string) {
            super(n, true, string);
        }
    }

    static class User
    implements UserPrincipal {
        private final int id;
        private final boolean isGroup;
        private final String name;

        private User(int n, boolean bl, String string) {
            this.id = n;
            this.isGroup = bl;
            this.name = string;
        }

        User(int n, String string) {
            this(n, false, string);
        }

        int uid() {
            if (this.isGroup) {
                throw new AssertionError();
            }
            return this.id;
        }

        int gid() {
            if (this.isGroup) {
                return this.id;
            }
            throw new AssertionError();
        }

        boolean isSpecial() {
            return this.id == -1;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof User)) {
                return false;
            }
            User user = (User)object;
            if (this.id != user.id || this.isGroup != user.isGroup) {
                return false;
            }
            if (this.id == -1 && user.id == -1) {
                return this.name.equals(user.name);
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.id != -1 ? this.id : this.name.hashCode();
        }
    }
}

