/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.bootstrap;

import java.lang.reflect.Method;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.DefaultClassPathProvider;
import org.gradle.api.internal.DefaultClassPathRegistry;
import org.gradle.api.internal.classpath.DefaultModuleRegistry;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.installation.CurrentGradleInstallation;

public class ProcessBootstrap {
    public static void run(String mainClassName, String[] args) {
        try {
            ProcessBootstrap.runNoExit(mainClassName, args);
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runNoExit(String mainClassName, String[] args) throws Exception {
        DefaultClassPathRegistry classPathRegistry = new DefaultClassPathRegistry(new ClassPathProvider[]{new DefaultClassPathProvider((ModuleRegistry)new DefaultModuleRegistry(CurrentGradleInstallation.get()))});
        DefaultClassLoaderFactory classLoaderFactory = new DefaultClassLoaderFactory();
        ClassPath antClasspath = classPathRegistry.getClassPath("ANT");
        ClassPath runtimeClasspath = classPathRegistry.getClassPath("GRADLE_RUNTIME");
        ClassLoader antClassLoader = classLoaderFactory.createIsolatedClassLoader("ant-loader", antClasspath);
        VisitableURLClassLoader runtimeClassLoader = VisitableURLClassLoader.fromClassPath("ant-and-gradle-loader", antClassLoader, runtimeClasspath);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(runtimeClassLoader);
        try {
            Class<?> mainClass = runtimeClassLoader.loadClass(mainClassName);
            Object entryPoint = mainClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method mainMethod = mainClass.getMethod("run", String[].class);
            mainMethod.invoke(entryPoint, new Object[]{args});
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            ClassLoaderUtils.tryClose(runtimeClassLoader);
            ClassLoaderUtils.tryClose(antClassLoader);
        }
    }
}

