/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.sms;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.DataConverter;
import org.traccar.notification.MessageException;
import org.traccar.sms.SmsManager;

public class HttpSmsClient
implements SmsManager {
    private final Client client;
    private final String url;
    private final String authorizationHeader;
    private final String authorization;
    private final String template;
    private final MediaType mediaType;

    public HttpSmsClient(Config config, Client client) {
        this.client = client;
        this.url = config.getString(Keys.SMS_HTTP_URL);
        this.authorizationHeader = config.getString(Keys.SMS_HTTP_AUTHORIZATION_HEADER);
        if (config.hasKey(Keys.SMS_HTTP_AUTHORIZATION)) {
            this.authorization = config.getString(Keys.SMS_HTTP_AUTHORIZATION);
        } else {
            String user = config.getString(Keys.SMS_HTTP_USER);
            String password = config.getString(Keys.SMS_HTTP_PASSWORD);
            this.authorization = user != null && password != null ? "Basic " + DataConverter.printBase64((user + ":" + password).getBytes(StandardCharsets.UTF_8)) : null;
        }
        this.template = config.getString(Keys.SMS_HTTP_TEMPLATE).trim();
        this.mediaType = this.template.charAt(0) == '<' ? MediaType.APPLICATION_XML_TYPE : (this.template.charAt(0) == '{' || this.template.charAt(0) == '[' ? MediaType.APPLICATION_JSON_TYPE : MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    private String prepareValue(String value) throws UnsupportedEncodingException {
        if (this.mediaType == MediaType.APPLICATION_FORM_URLENCODED_TYPE) {
            return URLEncoder.encode(value, StandardCharsets.UTF_8);
        }
        if (this.mediaType == MediaType.APPLICATION_JSON_TYPE) {
            return new String(JsonStringEncoder.getInstance().quoteAsString(value));
        }
        return value;
    }

    private String preparePayload(String phone, String message) {
        try {
            return this.template.replace("{phone}", this.prepareValue(phone)).replace("{message}", this.prepareValue(message));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private Invocation.Builder getRequestBuilder() {
        Invocation.Builder builder = this.client.target(this.url).request();
        if (this.authorization != null) {
            builder = builder.header(this.authorizationHeader, (Object)this.authorization);
        }
        return builder;
    }

    @Override
    public void sendMessage(String phone, String message, boolean command) throws MessageException {
        try (Response response = this.getRequestBuilder().post(Entity.entity((Object)this.preparePayload(phone, message), (MediaType)this.mediaType));){
            if (response.getStatus() / 100 != 2) {
                throw new MessageException((String)response.readEntity(String.class));
            }
        }
    }
}

