/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import nokogiri.Html4Document;
import nokogiri.XmlAttr;
import nokogiri.XmlAttributeDecl;
import nokogiri.XmlDocument;
import nokogiri.XmlElementDecl;
import nokogiri.XmlEntityDecl;
import nokogiri.XmlNamespace;
import nokogiri.XmlNodeSet;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.HtmlDomParserContext;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNamespaceCache;
import nokogiri.internals.SaveContextVisitor;
import nokogiri.internals.XmlDomParserContext;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@JRubyClass(name={"Nokogiri::XML::Node"})
public class XmlNode
extends RubyObject {
    private static final long serialVersionUID = 1L;
    protected static final String TEXT_WRAPPER_NAME = "nokogiri_text_wrapper";
    protected Node node;
    protected IRubyObject content = null;
    private transient XmlDocument doc;
    protected transient RubyString name;
    protected static final int IDENTICAL_ELEMENTS = 0;
    protected static final int IN_DIFFERENT_DOCUMENTS = 1;
    protected static final int SECOND_PRECEDES_FIRST = 2;
    protected static final int FIRST_PRECEDES_SECOND = 4;
    protected static final int SECOND_CONTAINS_FIRST = 8;
    protected static final int FIRST_CONTAINS_SECOND = 16;

    protected static XmlNode asXmlNode(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof XmlNode)) {
            Ruby ruby = threadContext.runtime;
            throw ruby.newTypeError(iRubyObject == null ? ruby.getNil() : iRubyObject, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Node"));
        }
        return (XmlNode)iRubyObject;
    }

    protected static XmlNode asXmlNodeOrNull(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject == null || iRubyObject.isNil()) {
            return null;
        }
        return XmlNode.asXmlNode(threadContext, iRubyObject);
    }

    public static void coalesceTextNodes(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        XmlNode xmlNode2 = XmlNode.asXmlNode(threadContext, iRubyObject2);
        Node node = xmlNode.node;
        Node node2 = xmlNode2.node;
        node.setNodeValue(node.getNodeValue() + node2.getNodeValue());
        xmlNode.content = null;
        xmlNode2.assimilateXmlNode(threadContext, (IRubyObject)xmlNode);
    }

    protected static void coalesceTextNodes(ThreadContext threadContext, IRubyObject iRubyObject, AdoptScheme adoptScheme) {
        boolean bl;
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        XmlNode xmlNode2 = XmlNode.asXmlNodeOrNull(threadContext, xmlNode.previous_sibling(threadContext));
        XmlNode xmlNode3 = XmlNode.asXmlNodeOrNull(threadContext, xmlNode.next_sibling(threadContext));
        Node node = xmlNode2 == null ? null : xmlNode2.node;
        Node node2 = xmlNode.node;
        Node node3 = xmlNode3 == null ? null : xmlNode3.node;
        Node node4 = node2.getParentNode();
        boolean bl2 = adoptScheme == AdoptScheme.NEXT_SIBLING || adoptScheme == AdoptScheme.CHILD || adoptScheme == AdoptScheme.REPLACEMENT;
        boolean bl3 = bl = adoptScheme == AdoptScheme.PREV_SIBLING || adoptScheme == AdoptScheme.REPLACEMENT;
        if (bl && node3 != null && node3.getNodeType() == 3) {
            xmlNode.setContent(node2.getNodeValue() + node3.getNodeValue());
            node4.removeChild(node3);
            xmlNode3.assimilateXmlNode(threadContext, (IRubyObject)xmlNode);
        }
        if (bl2 && node != null && node.getNodeType() == 3) {
            xmlNode2.setContent(node.getNodeValue() + node2.getNodeValue());
            node4.removeChild(node2);
            xmlNode.assimilateXmlNode(threadContext, (IRubyObject)xmlNode2);
        }
    }

    public XmlNode(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public XmlNode(Ruby ruby, RubyClass rubyClass, Node node) {
        super(ruby, rubyClass);
        this.setNode(ruby, node);
    }

    protected void decorate(Ruby ruby) {
        if (this.node != null) {
            this.resetCache();
            if (this.node.getNodeType() != 9) {
                XmlNode.setDocumentAndDecorate(ruby.getCurrentContext(), this, this.document(ruby));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void resetCache() {
        this.node.setUserData("NOKOGIRI_CACHED_NODE", (Object)this, null);
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = threadContext.runtime;
        RubyClass rubyClass = (RubyClass)iRubyObject;
        if ("Nokogiri::XML::Node".equals(rubyClass.getName())) {
            rubyClass = NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Element");
        }
        XmlNode xmlNode = (XmlNode)rubyClass.allocate();
        xmlNode.init(threadContext, iRubyObjectArray);
        xmlNode.callInit(iRubyObjectArray, block);
        assert (xmlNode.node != null);
        if (block.isGiven()) {
            block.call(threadContext, (IRubyObject)xmlNode);
        }
        return xmlNode;
    }

    protected void init(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        Document document;
        if (iRubyObjectArray.length < 2) {
            throw threadContext.runtime.newArgumentError(iRubyObjectArray.length, 2);
        }
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        if (!(iRubyObject2 instanceof XmlNode)) {
            throw threadContext.runtime.newArgumentError("document must be a Nokogiri::XML::Node");
        }
        if (!(iRubyObject2 instanceof XmlDocument)) {
            threadContext.runtime.getWarnings().warn("Passing a Node as the second parameter to Node.new is deprecated. Please pass a Document instead, or prefer an alternative constructor like Node#add_child. This will become an error in Nokogiri v1.17.0.");
        }
        if ((document = XmlNode.asXmlNode(threadContext, iRubyObject2).getOwnerDocument()) == null) {
            throw threadContext.runtime.newArgumentError("node must have owner document");
        }
        String string = NokogiriHelpers.rubyStringToString(iRubyObject);
        String string2 = NokogiriHelpers.getPrefix(string);
        String string3 = null;
        if (document.getDocumentElement() != null) {
            string3 = document.getDocumentElement().lookupNamespaceURI(string2);
        }
        Element element = document.createElementNS(string3, string);
        this.setNode(threadContext.runtime, element);
    }

    protected void assimilateXmlNode(ThreadContext threadContext, IRubyObject iRubyObject) {
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        this.node = xmlNode.node;
        this.content = null;
    }

    public void normalize() {
        this.node.normalize();
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isComment() {
        return false;
    }

    public boolean isElement() {
        return this.node instanceof Element;
    }

    public boolean isProcessingInstruction() {
        return false;
    }

    protected IRubyObject getAttribute(ThreadContext threadContext, String string) {
        return this.getAttribute(threadContext.runtime, string);
    }

    protected IRubyObject getAttribute(Ruby ruby, String string) {
        String string2 = this.getAttribute(string);
        return NokogiriHelpers.nonEmptyStringOrNil(ruby, string2);
    }

    protected String getAttribute(String string) {
        if (this.node.getNodeType() != 1) {
            return null;
        }
        String string2 = ((Element)this.node).getAttribute(string);
        return string2.length() == 0 ? null : string2;
    }

    public void relink_namespace(ThreadContext threadContext) {
        if (!(this.node instanceof Element)) {
            return;
        }
        Element element = (Element)this.node;
        element.getOwnerDocument().setStrictErrorChecking(false);
        String string = element.getPrefix();
        String string2 = element.lookupNamespaceURI(string);
        this.node = NokogiriHelpers.renameNode(element, string2, element.getNodeName());
        if (string2 == null || string2.isEmpty()) {
            RubyBoolean rubyBoolean = (RubyBoolean)this.document(threadContext.runtime).getInstanceVariable("@namespace_inheritance");
            if (rubyBoolean.isTrue()) {
                this.set_namespace(threadContext, ((XmlNode)this.parent(threadContext)).namespace(threadContext));
            }
            return;
        }
        String string3 = element.getParentNode().lookupPrefix(string2);
        String string4 = element.getParentNode().lookupNamespaceURI(string);
        boolean bl = element.getParentNode().isDefaultNamespace(string2);
        if (element.getParentNode().getNodeType() == 9) {
            element.setAttribute(string == null ? "xmlns" : "xmlns:" + string, string2);
        } else if (string == null) {
            if (!bl) {
                element.setAttribute("xmlns", string2);
            }
        } else if (!string.equals(string3) || string2.equals(string4)) {
            element.setAttribute("xmlns:" + string, string2);
        }
        if (element.hasAttributes()) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string5 = attr.getPrefix();
                if (string5 == null) {
                    string5 = NokogiriHelpers.getPrefix(attr.getNodeName());
                }
                String string6 = attr.getNodeName();
                String string7 = "xml".equals(string5) ? "http://www.w3.org/XML/1998/namespace" : ("xmlns".equals(string5) || string6.equals("xmlns") ? "http://www.w3.org/2000/xmlns/" : attr.lookupNamespaceURI(string5));
                if (string7 != null && string7.equals(element.getNamespaceURI())) {
                    string7 = null;
                }
                if (string7 != null && !"".equals(string7) && !"http://www.w3.org/XML/1998/namespace".equals(string7)) {
                    XmlNamespace.createFromAttr(threadContext.runtime, attr);
                }
                NokogiriHelpers.renameNode(attr, string7, string6);
            }
        }
        if (this.node.hasChildNodes()) {
            XmlNode.relink_namespace(threadContext, this.getChildren());
        }
    }

    static void relink_namespace(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (!(iRubyObjectArray[i] instanceof XmlNode)) continue;
            ((XmlNode)iRubyObjectArray[i]).relink_namespace(threadContext);
        }
    }

    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        saveContextVisitor.enter(this.node);
        this.acceptChildren(threadContext, this.getChildren(), saveContextVisitor);
        saveContextVisitor.leave(this.node);
    }

    void acceptChildren(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, SaveContextVisitor saveContextVisitor) {
        if (iRubyObjectArray.length > 0) {
            for (int i = 0; i < iRubyObjectArray.length; ++i) {
                IRubyObject iRubyObject = iRubyObjectArray[i];
                if (iRubyObject instanceof XmlNode) {
                    ((XmlNode)iRubyObject).accept(threadContext, saveContextVisitor);
                    continue;
                }
                if (!(iRubyObject instanceof XmlNamespace)) continue;
                ((XmlNamespace)iRubyObject).accept(threadContext, saveContextVisitor);
            }
        }
    }

    RubyString doSetName(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            this.name = null;
            return null;
        }
        this.name = iRubyObject.convertToString();
        return this.name;
    }

    public void setDocument(ThreadContext threadContext, XmlDocument xmlDocument) {
        this.doc = xmlDocument;
        XmlNode.setDocumentAndDecorate(threadContext, this, xmlDocument);
    }

    static void setDocumentAndDecorate(ThreadContext threadContext, RubyObject rubyObject, XmlDocument xmlDocument) {
        rubyObject.setInstanceVariable("@document", (IRubyObject)(xmlDocument == null ? threadContext.nil : xmlDocument));
        if (xmlDocument != null) {
            Helpers.invoke((ThreadContext)threadContext, (IRubyObject)xmlDocument, (String)"decorate", (IRubyObject)rubyObject);
        }
    }

    public void setNode(Ruby ruby, Node node) {
        this.node = node;
        this.decorate(ruby);
        if (this instanceof XmlAttr) {
            ((XmlAttr)this).setNamespaceIfNecessary(ruby);
        }
    }

    protected IRubyObject getNodeName(ThreadContext threadContext) {
        if (this.name != null) {
            return this.name;
        }
        String string = null;
        if (this.node != null) {
            string = NokogiriHelpers.getLocalPart(this.node.getNodeName());
        }
        if (string == null) {
            string = "";
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        this.name = threadContext.runtime.newString(string);
        return this.name;
    }

    @JRubyMethod(name={"add_namespace_definition", "add_namespace"})
    public IRubyObject add_namespace_definition(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Object object;
        Node node;
        String string;
        String string2;
        String string3 = string2 = iRubyObject.isNil() ? null : iRubyObject.convertToString().decodeString();
        if (iRubyObject2.isNil()) {
            string = this.findNamespaceHref(threadContext, string2);
            if (string == null) {
                return threadContext.nil;
            }
            iRubyObject2 = threadContext.runtime.newString(string);
        } else {
            string = NokogiriHelpers.rubyStringToString(iRubyObject2.convertToString());
        }
        if (this.node.getNodeType() == 1) {
            node = this.node;
            object = iRubyObject.isNil() ? "xmlns" : "xmlns:" + string2;
            ((Element)this.node).setAttributeNS("http://www.w3.org/2000/xmlns/", (String)object, string);
        } else {
            node = this.node.getNodeType() == 2 ? ((Attr)this.node).getOwnerElement() : this.node.getParentNode();
        }
        object = NokogiriHelpers.getNamespaceCache(this.node);
        XmlNamespace xmlNamespace = ((NokogiriNamespaceCache)object).get(string2, string);
        if (xmlNamespace == null) {
            xmlNamespace = XmlNamespace.createImpl(node, iRubyObject, string2, iRubyObject2, string);
        }
        if (this.node != node) {
            this.node = NokogiriHelpers.renameNode(this.node, xmlNamespace.getHref(), xmlNamespace.getPrefix() + ':' + this.node.getLocalName());
        }
        this.updateNodeNamespaceIfNecessary(xmlNamespace);
        return xmlNamespace;
    }

    private void updateNodeNamespaceIfNecessary(XmlNamespace xmlNamespace) {
        boolean bl;
        String string = this.node.getPrefix();
        boolean bl2 = bl = string == null && xmlNamespace.getPrefix() == null || string != null && string.equals(xmlNamespace.getPrefix());
        if (bl) {
            this.node = NokogiriHelpers.renameNode(this.node, xmlNamespace.getHref(), this.node.getNodeName());
        }
    }

    @JRubyMethod(name={"attribute", "attr"})
    public IRubyObject attribute(ThreadContext threadContext, IRubyObject iRubyObject) {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        String string = NokogiriHelpers.rubyStringToString(iRubyObject);
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string2 = node.getLocalName();
            if (string2 == null || !string2.equals(string)) continue;
            return NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node);
        }
        return threadContext.nil;
    }

    @JRubyMethod
    public IRubyObject attribute_nodes(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        if (namedNodeMap == null) {
            return ruby.newEmptyArray();
        }
        RubyArray rubyArray = ruby.newArray(namedNodeMap.getLength());
        XmlDocument xmlDocument = this.document(threadContext.runtime);
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            if (!(xmlDocument instanceof Html4Document) && NokogiriHelpers.isNamespace(namedNodeMap.item(i))) continue;
            rubyArray.append(NokogiriHelpers.getCachedNodeOrCreate(ruby, namedNodeMap.item(i)));
        }
        return rubyArray;
    }

    @JRubyMethod
    public IRubyObject attribute_with_ns(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = NokogiriHelpers.rubyStringToString(iRubyObject);
        String string2 = iRubyObject2.isNil() ? null : NokogiriHelpers.rubyStringToString(iRubyObject2);
        Node node = this.node.getAttributes().getNamedItemNS(string2, string);
        if (node == null) {
            return threadContext.nil;
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node);
    }

    @JRubyMethod(name={"blank?"})
    public IRubyObject blank_p(ThreadContext threadContext) {
        if (this.node.getNodeType() == 3 || this.node.getNodeType() == 4) {
            String string = this.node.getTextContent();
            return threadContext.runtime.newBoolean(string == null || NokogiriHelpers.isBlank(string));
        }
        return threadContext.runtime.getFalse();
    }

    @JRubyMethod
    public IRubyObject child(ThreadContext threadContext) {
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getFirstChild());
    }

    @JRubyMethod
    public IRubyObject children(ThreadContext threadContext) {
        IRubyObject[] iRubyObjectArray = this.getChildren();
        if (iRubyObjectArray.length == 0) {
            return XmlNodeSet.newEmptyNodeSet(threadContext, this);
        }
        return XmlNodeSet.newNodeSet(threadContext.runtime, iRubyObjectArray);
    }

    IRubyObject[] getChildren() {
        NodeList nodeList = this.node.getChildNodes();
        if (nodeList.getLength() > 0) {
            return NokogiriHelpers.nodeListToRubyArray(this.getRuntime(), nodeList);
        }
        return IRubyObject.NULL_ARRAY;
    }

    @JRubyMethod
    public IRubyObject first_element_child(ThreadContext threadContext) {
        List<Node> list = XmlNode.getElements(this.node, true);
        if (list.size() == 0) {
            return threadContext.nil;
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, list.get(0));
    }

    @JRubyMethod
    public IRubyObject last_element_child(ThreadContext threadContext) {
        List<Node> list = XmlNode.getElements(this.node, false);
        if (list.size() == 0) {
            return threadContext.nil;
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, list.get(list.size() - 1));
    }

    @JRubyMethod(name={"element_children", "elements"})
    public IRubyObject element_children(ThreadContext threadContext) {
        List<Node> list = XmlNode.getElements(this.node, false);
        IRubyObject[] iRubyObjectArray = NokogiriHelpers.nodeListToArray(threadContext.runtime, list);
        return XmlNodeSet.newNodeSet(threadContext.runtime, iRubyObjectArray, this);
    }

    private static List<Node> getElements(Node node, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            arrayList.add(node2);
            if (!bl) continue;
            return arrayList;
        }
        return arrayList;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject compare(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof XmlNode)) {
            return threadContext.runtime.newFixnum(-2);
        }
        Node node = XmlNode.asXmlNode((ThreadContext)threadContext, (IRubyObject)iRubyObject).node;
        if (this.node.getNodeType() == 9 || node.getNodeType() == 9) {
            return threadContext.runtime.newFixnum(1);
        }
        try {
            short s = this.node.compareDocumentPosition(node);
            if ((s & 4) == 4) {
                return threadContext.runtime.newFixnum(-1);
            }
            if ((s & 2) == 2) {
                return threadContext.runtime.newFixnum(1);
            }
            if (s == 0) {
                return threadContext.runtime.newFixnum(0);
            }
            return threadContext.runtime.newFixnum(-2);
        }
        catch (Exception exception) {
            return threadContext.runtime.newFixnum(-2);
        }
    }

    @JRubyMethod(required=2, visibility=Visibility.PRIVATE)
    public IRubyObject in_context(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyArray<?> rubyArray;
        RubyObject rubyObject;
        XmlDomParserContext xmlDomParserContext;
        RubyClass rubyClass;
        Ruby ruby = threadContext.runtime;
        XmlDocument xmlDocument = this.document(ruby);
        if (xmlDocument == null) {
            return threadContext.nil;
        }
        if (xmlDocument instanceof Html4Document) {
            rubyClass = NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::HTML4::Document");
            xmlDomParserContext = new HtmlDomParserContext(ruby, iRubyObject2);
            ((HtmlDomParserContext)xmlDomParserContext).enableDocumentFragment();
            xmlDomParserContext.setStringInputSource(threadContext, iRubyObject, threadContext.nil);
        } else {
            rubyClass = NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document");
            xmlDomParserContext = new XmlDomParserContext(ruby, iRubyObject2);
            xmlDomParserContext.setStringInputSource(threadContext, iRubyObject, threadContext.nil);
        }
        if (xmlDocument instanceof Html4Document && xmlDocument.getEncoding() != null && !xmlDocument.getEncoding().isNil()) {
            rubyObject = (HtmlDomParserContext)xmlDomParserContext;
            rubyObject.setEncoding(xmlDocument.getEncoding().asJavaString());
        }
        rubyObject = xmlDomParserContext.parse(threadContext, rubyClass, threadContext.nil);
        RubyArray<?> rubyArray2 = XmlNode.getErrors(xmlDocument);
        if (XmlNode.checkNewErrors(rubyArray2, rubyArray = XmlNode.getErrors((XmlDocument)rubyObject))) {
            for (int i = 0; i < rubyArray.getLength(); ++i) {
                rubyArray2.append(rubyArray.entry(i));
            }
            xmlDocument.setInstanceVariable("@errors", (IRubyObject)rubyArray2);
            return XmlNodeSet.newNodeSet(threadContext.runtime, IRubyObject.NULL_ARRAY, this);
        }
        Node node = rubyObject.node.getFirstChild().getNodeType() == 10 ? rubyObject.node.getFirstChild().getNextSibling() : rubyObject.node.getFirstChild();
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{NokogiriHelpers.getCachedNodeOrCreate(ruby, node)};
        return XmlNodeSet.newNodeSet(threadContext.runtime, iRubyObjectArray, this);
    }

    private static RubyArray<?> getErrors(XmlDocument xmlDocument) {
        IRubyObject iRubyObject = xmlDocument.getInstanceVariable("@errors");
        if (iRubyObject instanceof RubyArray) {
            return (RubyArray)iRubyObject;
        }
        return RubyArray.newEmptyArray((Ruby)xmlDocument.getRuntime());
    }

    private static boolean checkNewErrors(RubyArray<?> rubyArray, RubyArray<?> rubyArray2) {
        int n = ((RubyArray)rubyArray2.op_diff(rubyArray)).size();
        return n > 0;
    }

    @JRubyMethod(name={"content", "text", "inner_text"})
    public IRubyObject content(ThreadContext threadContext) {
        return NokogiriHelpers.stringOrNil(threadContext.runtime, this.getContentImpl());
    }

    public CharSequence getContentImpl() {
        CharSequence charSequence;
        if (!(this.node.hasChildNodes() || this.node.getNodeValue() != null || this.node.getNodeType() != 3 && this.node.getNodeType() != 4)) {
            return null;
        }
        if (this instanceof XmlDocument) {
            Element element = ((Document)this.node).getDocumentElement();
            if (element == null) {
                charSequence = "";
            } else {
                Element element2 = ((Document)this.node).getDocumentElement();
                charSequence = XmlNode.getTextContentRecursively(new StringBuilder(), element2);
            }
        } else {
            charSequence = XmlNode.getTextContentRecursively(new StringBuilder(), this.node);
        }
        return charSequence;
    }

    private static StringBuilder getTextContentRecursively(StringBuilder stringBuilder, Node node) {
        CharSequence charSequence = node.getNodeValue();
        if (charSequence != null && NokogiriHelpers.shouldDecode(node)) {
            charSequence = NokogiriHelpers.decodeJavaString(charSequence);
        }
        if (charSequence != null) {
            stringBuilder.append(charSequence);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!XmlNode.hasTextContent(node2)) continue;
            XmlNode.getTextContentRecursively(stringBuilder, node2);
        }
        return stringBuilder;
    }

    private static boolean hasTextContent(Node node) {
        return node.getNodeType() != 8 && node.getNodeType() != 7;
    }

    @JRubyMethod
    public final IRubyObject document(ThreadContext threadContext) {
        return this.document(threadContext.runtime);
    }

    XmlDocument document(Ruby ruby) {
        return this.document(ruby, true);
    }

    XmlDocument document(Ruby ruby, boolean bl) {
        if (this.doc == null) {
            this.doc = (XmlDocument)((Object)this.node.getOwnerDocument().getUserData("NOKOGIRI_CACHED_NODE"));
            if (this.doc == null && bl) {
                this.doc = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(ruby, this.node.getOwnerDocument());
                this.node.getOwnerDocument().setUserData("NOKOGIRI_CACHED_NODE", (Object)this.doc, null);
            }
        }
        return this.doc;
    }

    @JRubyMethod(visibility=Visibility.PROTECTED)
    public IRubyObject initialize_copy_with_args(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        boolean bl = iRubyObject2 instanceof RubyInteger && RubyFixnum.fix2int((IRubyObject)iRubyObject2) != 0;
        this.node = XmlNode.asXmlNode((ThreadContext)threadContext, (IRubyObject)iRubyObject).node.cloneNode(bl);
        this.setDocument(threadContext, (XmlDocument)iRubyObject3);
        return this;
    }

    public static RubyString encode_special_chars(ThreadContext threadContext, IRubyObject iRubyObject) {
        CharSequence charSequence = NokogiriHelpers.encodeJavaString(NokogiriHelpers.rubyStringToString(iRubyObject));
        return RubyString.newString((Ruby)threadContext.runtime, (CharSequence)charSequence);
    }

    @JRubyMethod(name={"encode_special_chars"})
    public IRubyObject i_encode_special_chars(ThreadContext threadContext, IRubyObject iRubyObject) {
        return XmlNode.encode_special_chars(threadContext, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject get(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.node instanceof Element) {
            if (iRubyObject == null || iRubyObject.isNil()) {
                return threadContext.nil;
            }
            Element element = (Element)this.node;
            String string = NokogiriHelpers.rubyStringToString(iRubyObject);
            if (!element.hasAttribute(string)) {
                return threadContext.nil;
            }
            String string2 = element.getAttribute(string);
            return NokogiriHelpers.stringOrNil(threadContext.runtime, string2);
        }
        return threadContext.nil;
    }

    protected Document getOwnerDocument() {
        if (this.node.getNodeType() == 9) {
            return (Document)this.node;
        }
        return this.node.getOwnerDocument();
    }

    @JRubyMethod
    public IRubyObject internal_subset(ThreadContext threadContext) {
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject = xmlDocument.getInternalSubset(threadContext);
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject create_internal_subset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        IRubyObject iRubyObject4 = this.internal_subset(threadContext);
        if (!iRubyObject4.isNil()) {
            throw threadContext.runtime.newRuntimeError("Document already has internal subset");
        }
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject5 = xmlDocument.createInternalSubset(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        return iRubyObject5;
    }

    @JRubyMethod
    public IRubyObject external_subset(ThreadContext threadContext) {
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject = xmlDocument.getExternalSubset(threadContext);
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject create_external_subset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        IRubyObject iRubyObject4 = this.external_subset(threadContext);
        if (!iRubyObject4.isNil()) {
            throw threadContext.runtime.newRuntimeError("Document already has external subset");
        }
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject5 = xmlDocument.createExternalSubset(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        return iRubyObject5;
    }

    @JRubyMethod(name={"key?", "has_attribute?"})
    public IRubyObject key_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.node instanceof Element) {
            Element element = (Element)this.node;
            String string = NokogiriHelpers.rubyStringToString(iRubyObject);
            if (element.hasAttribute(string)) {
                return threadContext.runtime.getTrue();
            }
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                if (!string.equals(node.getLocalName())) continue;
                return threadContext.runtime.getTrue();
            }
            return threadContext.runtime.getFalse();
        }
        return threadContext.nil;
    }

    @JRubyMethod
    public IRubyObject namespace(ThreadContext threadContext) {
        XmlDocument xmlDocument = this.document(threadContext.runtime);
        if (xmlDocument instanceof Html4Document) {
            return threadContext.nil;
        }
        String string = this.node.getNamespaceURI();
        if (string == null || string.isEmpty()) {
            return threadContext.nil;
        }
        String string2 = this.node.getPrefix();
        NokogiriNamespaceCache nokogiriNamespaceCache = NokogiriHelpers.getNamespaceCache(this.node);
        XmlNamespace xmlNamespace = nokogiriNamespaceCache.get(string2, string);
        if (xmlNamespace == null || xmlNamespace.isEmpty()) {
            xmlNamespace = new XmlNamespace(threadContext.runtime, null, string2, string, (IRubyObject)xmlDocument);
        }
        return xmlNamespace;
    }

    @JRubyMethod
    public RubyArray<?> namespace_definitions(ThreadContext threadContext) {
        XmlDocument xmlDocument = this.document(threadContext.runtime);
        if (xmlDocument == null) {
            return threadContext.runtime.newEmptyArray();
        }
        if (xmlDocument instanceof Html4Document) {
            return threadContext.runtime.newEmptyArray();
        }
        List<XmlNamespace> list = xmlDocument.getNamespaceCache().get(this.node);
        return RubyArray.newArray((Ruby)threadContext.runtime, list);
    }

    @JRubyMethod
    public RubyArray<?> namespace_scopes(ThreadContext threadContext) {
        XmlDocument xmlDocument = this.document(threadContext.runtime);
        if (xmlDocument == null) {
            return threadContext.runtime.newEmptyArray();
        }
        if (xmlDocument instanceof Html4Document) {
            return threadContext.runtime.newEmptyArray();
        }
        Node node = this.node.getNodeType() == 1 ? this.node : (this.node.getNodeType() == 2 ? ((Attr)this.node).getOwnerElement() : this.findPreviousElement(this.node));
        if (node == null) {
            return threadContext.runtime.newEmptyArray();
        }
        RubyArray rubyArray = threadContext.runtime.newArray();
        HashSet<String> hashSet = new HashSet<String>(8);
        NokogiriNamespaceCache nokogiriNamespaceCache = NokogiriHelpers.getNamespaceCache(node);
        Node node2 = node;
        while (node2 != null) {
            List<XmlNamespace> list = nokogiriNamespaceCache.get(node2);
            for (XmlNamespace xmlNamespace : list) {
                if (hashSet.contains(xmlNamespace.getPrefix())) continue;
                rubyArray.append((IRubyObject)xmlNamespace);
                hashSet.add(xmlNamespace.getPrefix());
            }
            node2 = this.findPreviousElement(node2);
        }
        return rubyArray;
    }

    private Node findPreviousElement(Node node) {
        Node node2;
        Node node3 = node2 = node.getPreviousSibling() == null ? node.getParentNode() : node.getPreviousSibling();
        if (node2 == null || node2.getNodeType() == 9) {
            return null;
        }
        if (node2.getNodeType() == 1) {
            return node2;
        }
        return this.findPreviousElement(node2);
    }

    @JRubyMethod(name={"namespaced_key?"})
    public IRubyObject namespaced_key_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.attribute_with_ns(threadContext, iRubyObject, iRubyObject2).isNil() ? threadContext.runtime.getFalse() : threadContext.runtime.getTrue();
    }

    protected void setContent(IRubyObject iRubyObject) {
        String string = NokogiriHelpers.rubyStringToString(iRubyObject);
        this.node.setTextContent(string);
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.node.getNodeType() == 3 || this.node.getNodeType() == 4) {
            return;
        }
        if (this.node.getFirstChild() != null) {
            this.node.getFirstChild().setUserData("NOKOGIRI_ENCODED_STRING", true, null);
        }
    }

    private void setContent(String string) {
        this.node.setTextContent(string);
        this.content = null;
    }

    @JRubyMethod(name={"native_content="})
    public IRubyObject native_content_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.setContent(iRubyObject);
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject lang(ThreadContext threadContext) {
        XmlNode xmlNode = this;
        while (!xmlNode.isNil()) {
            XmlNode xmlNode2 = XmlNode.asXmlNode(threadContext, (IRubyObject)xmlNode);
            IRubyObject iRubyObject = xmlNode2.getAttribute(threadContext.runtime, "xml:lang");
            if (!iRubyObject.isNil()) {
                return iRubyObject;
            }
            xmlNode = xmlNode2.parent(threadContext);
        }
        return threadContext.nil;
    }

    @JRubyMethod(name={"lang="})
    public IRubyObject set_lang(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.setAttribute(threadContext, "xml:lang", NokogiriHelpers.rubyStringToString(iRubyObject));
        return threadContext.nil;
    }

    @JRubyMethod(required=4, visibility=Visibility.PRIVATE)
    public IRubyObject native_write_to(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubyString rubyString;
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        IRubyObject iRubyObject3 = iRubyObjectArray[2];
        IRubyObject iRubyObject4 = iRubyObjectArray[3];
        int n = RubyFixnum.fix2int((IRubyObject)iRubyObject4);
        String string = NokogiriHelpers.rubyStringToString(iRubyObject2);
        if ((n & 0x20) == 0 && (n & 0x10) == 0 && (n & 0x40) == 0 && this.isHtmlDoc(threadContext)) {
            n |= 0x46;
        }
        SaveContextVisitor saveContextVisitor = new SaveContextVisitor(n, NokogiriHelpers.rubyStringToString(iRubyObject3), string, this.isHtmlDoc(threadContext), this.isFragment(), 0);
        this.accept(threadContext, saveContextVisitor);
        if (NokogiriHelpers.isUTF8(string)) {
            rubyString = NokogiriHelpers.convertString(threadContext.runtime, saveContextVisitor.getInternalBuffer());
        } else {
            ByteBuffer byteBuffer = NokogiriHelpers.convertEncoding(Charset.forName(string), saveContextVisitor.getInternalBuffer());
            ByteList byteList = new ByteList(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
            rubyString = RubyString.newString((Ruby)threadContext.runtime, (ByteList)byteList);
        }
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"write", (IRubyObject)rubyString);
        return iRubyObject;
    }

    private boolean isHtmlDoc(ThreadContext threadContext) {
        return this.document(threadContext).getMetaClass().isKindOfModule((RubyModule)NokogiriHelpers.getNokogiriClass(threadContext.runtime, "Nokogiri::HTML4::Document"));
    }

    private boolean isFragment() {
        if (this.node instanceof DocumentFragment) {
            return true;
        }
        return this.node.getParentNode() != null && this.node.getParentNode() instanceof DocumentFragment;
    }

    @JRubyMethod(name={"next_sibling", "next"})
    public IRubyObject next_sibling(ThreadContext threadContext) {
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getNextSibling());
    }

    @JRubyMethod(name={"previous_sibling", "previous"})
    public IRubyObject previous_sibling(ThreadContext threadContext) {
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getPreviousSibling());
    }

    @JRubyMethod(name={"node_name", "name"})
    public IRubyObject node_name(ThreadContext threadContext) {
        return this.getNodeName(threadContext);
    }

    @JRubyMethod(name={"node_name=", "name="})
    public IRubyObject node_name_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        String string = (iRubyObject = this.doSetName(iRubyObject)) == null ? null : NokogiriHelpers.rubyStringToString((RubyString)iRubyObject);
        this.node = NokogiriHelpers.renameNode(this.node, null, string);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject set(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (this.node instanceof Element) {
            this.setAttribute(threadContext, NokogiriHelpers.rubyStringToString(iRubyObject), NokogiriHelpers.rubyStringToString(iRubyObject2));
            return this;
        }
        return iRubyObject2;
    }

    private void setAttribute(ThreadContext threadContext, String string, String string2) {
        Element element = (Element)this.node;
        String string3 = null;
        int n = string.indexOf(":");
        if (n > 0) {
            String string4 = string.substring(0, n);
            string3 = string4.equals("xml") ? "http://www.w3.org/XML/1998/namespace" : (string4.equals("xmlns") ? "http://www.w3.org/2000/xmlns/" : this.node.lookupNamespaceURI(string4));
        }
        if (n > 0 && string3 == null) {
            element.setAttribute(string, string2);
        } else {
            element.setAttributeNS(string3, string, string2);
        }
        NokogiriHelpers.clearXpathContext(this.node);
    }

    private String findNamespaceHref(ThreadContext threadContext, String string) {
        XmlNode xmlNode = this;
        XmlDocument xmlDocument = this.document(threadContext.runtime);
        while (xmlNode != xmlDocument) {
            RubyArray<?> rubyArray = xmlNode.namespace_scopes(threadContext);
            for (int i = 0; i < rubyArray.size(); ++i) {
                XmlNamespace xmlNamespace = (XmlNamespace)rubyArray.eltInternal(i);
                if (!xmlNamespace.hasPrefix(string)) continue;
                return xmlNamespace.getHref();
            }
            IRubyObject iRubyObject = xmlNode.parent(threadContext);
            if (iRubyObject == threadContext.nil) break;
            xmlNode = (XmlNode)iRubyObject;
        }
        return null;
    }

    @JRubyMethod
    public IRubyObject parent(ThreadContext threadContext) {
        if (this.node.getOwnerDocument() != null && this.node.getOwnerDocument().getDocumentElement() == this.node) {
            return this.document(threadContext);
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, this.node.getParentNode());
    }

    @JRubyMethod
    public IRubyObject path(ThreadContext threadContext) {
        return RubyString.newString((Ruby)threadContext.runtime, (String)NokogiriHelpers.getNodeCompletePath(this.node));
    }

    @JRubyMethod
    public IRubyObject pointer_id(ThreadContext threadContext) {
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)this.node.hashCode());
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject set_namespace(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            XmlDocument xmlDocument = this.document(threadContext.runtime);
            if (xmlDocument != null) {
                Node node = this.node;
                xmlDocument.getNamespaceCache().remove(node);
                this.node = NokogiriHelpers.renameNode(node, null, NokogiriHelpers.getLocalPart(node.getNodeName()));
            }
        } else {
            XmlNamespace xmlNamespace = (XmlNamespace)iRubyObject;
            String string = NokogiriHelpers.newQName(xmlNamespace.getPrefix(), this.node);
            this.node = NokogiriHelpers.renameNode(this.node, xmlNamespace.getHref(), string);
        }
        NokogiriHelpers.clearXpathContext(this.getNode());
        return this;
    }

    @JRubyMethod(name={"unlink", "remove"})
    public IRubyObject unlink(ThreadContext threadContext) {
        Node node = this.node.getParentNode();
        if (node != null) {
            node.removeChild(this.node);
            NokogiriHelpers.clearXpathContext(node);
        }
        return this;
    }

    @JRubyMethod(name={"node_type", "type"})
    public IRubyObject node_type(ThreadContext threadContext) {
        String string;
        switch (this.node.getNodeType()) {
            case 1: {
                if (this instanceof XmlElementDecl) {
                    string = "ELEMENT_DECL";
                    break;
                }
                if (this instanceof XmlAttributeDecl) {
                    string = "ATTRIBUTE_DECL";
                    break;
                }
                if (this instanceof XmlEntityDecl) {
                    string = "ENTITY_DECL";
                    break;
                }
                string = "ELEMENT_NODE";
                break;
            }
            case 2: {
                string = "ATTRIBUTE_NODE";
                break;
            }
            case 3: {
                string = "TEXT_NODE";
                break;
            }
            case 4: {
                string = "CDATA_SECTION_NODE";
                break;
            }
            case 5: {
                string = "ENTITY_REF_NODE";
                break;
            }
            case 6: {
                string = "ENTITY_NODE";
                break;
            }
            case 7: {
                string = "PI_NODE";
                break;
            }
            case 8: {
                string = "COMMENT_NODE";
                break;
            }
            case 9: {
                if (this instanceof Html4Document) {
                    string = "HTML_DOCUMENT_NODE";
                    break;
                }
                string = "DOCUMENT_NODE";
                break;
            }
            case 10: {
                string = "DOCUMENT_TYPE_NODE";
                break;
            }
            case 11: {
                string = "DOCUMENT_FRAG_NODE";
                break;
            }
            case 12: {
                string = "NOTATION_NODE";
                break;
            }
            default: {
                return threadContext.runtime.newFixnum(0);
            }
        }
        return NokogiriHelpers.getNokogiriClass(threadContext.runtime, "Nokogiri::XML::Node").getConstant(string);
    }

    @JRubyMethod
    public IRubyObject line(ThreadContext threadContext) {
        Document document = this.getOwnerDocument();
        int[] nArray = new int[1];
        this.count(document, nArray);
        return RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)(nArray[0] + 2));
    }

    private boolean count(Node node, int[] nArray) {
        if (node == this.node) {
            return true;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = null;
            if (node2 instanceof Text) {
                string = ((Text)node2).getData();
            } else if (node2 instanceof Comment) {
                string = ((Comment)node2).getData();
            }
            if (string != null) {
                int n = string.length();
                for (int j = 0; j < n; ++j) {
                    if (string.charAt(j) != '\n') continue;
                    nArray[0] = nArray[0] + 1;
                }
            }
            if (!this.count(node2, nArray)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod
    public IRubyObject next_element(ThreadContext threadContext) {
        Node node = this.node.getNextSibling();
        if (node == null) {
            return threadContext.nil;
        }
        if (node instanceof Element) {
            return NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node);
        }
        Node node2 = node.getNextSibling();
        if (node2 == null) {
            return threadContext.nil;
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node2);
    }

    @JRubyMethod
    public IRubyObject previous_element(ThreadContext threadContext) {
        Node node = this.node.getPreviousSibling();
        if (node == null) {
            return threadContext.nil;
        }
        if (node instanceof Element) {
            return NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node);
        }
        Node node2 = node.getPreviousSibling();
        if (node2 == null) {
            return threadContext.nil;
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node2);
    }

    protected IRubyObject adoptAs(ThreadContext threadContext, AdoptScheme adoptScheme, IRubyObject iRubyObject) {
        RubyArray<?> rubyArray = XmlNode.asXmlNode(threadContext, iRubyObject);
        if (this.doc != null) {
            rubyArray.setDocument(threadContext, this.doc);
        }
        RubyArray<?> rubyArray2 = rubyArray;
        Node node = this.node;
        Node node2 = rubyArray.node;
        try {
            Node node3;
            Document document = node2.getOwnerDocument();
            Document document2 = node.getOwnerDocument();
            if (document2 == null && node instanceof Document) {
                document2 = (Document)node;
            }
            NokogiriHelpers.clearXpathContext(document);
            NokogiriHelpers.clearXpathContext(document2);
            if (document2 != null && document2 != node2.getOwnerDocument()) {
                node3 = document2.adoptNode(node2);
                if (node3 == null) {
                    throw threadContext.runtime.newRuntimeError("Failed to take ownership of node");
                }
                XmlNode.fixUserData(document, node3);
                node2 = node3;
            }
            node3 = node.getParentNode();
            switch (adoptScheme) {
                case CHILD: {
                    Node[] nodeArray = this.adoptAsChild(node, node2);
                    if (nodeArray.length == 1 && node2 == nodeArray[0]) break;
                    rubyArray2 = NokogiriHelpers.nodeArrayToRubyArray(threadContext.runtime, nodeArray);
                    break;
                }
                case PREV_SIBLING: {
                    this.adoptAsPrevSibling(threadContext, node3, node, node2);
                    break;
                }
                case NEXT_SIBLING: {
                    this.adoptAsNextSibling(threadContext, node3, node, node2);
                    break;
                }
                case REPLACEMENT: {
                    this.adoptAsReplacement(threadContext, node3, node, node2);
                }
            }
        }
        catch (Exception exception) {
            throw threadContext.runtime.newRuntimeError(exception.toString());
        }
        if (node2.getNodeType() == 3) {
            XmlNode.coalesceTextNodes(threadContext, (IRubyObject)rubyArray, adoptScheme);
        }
        if (this instanceof XmlDocument) {
            ((XmlDocument)this).resetNamespaceCache(threadContext);
        }
        rubyArray.relink_namespace(threadContext);
        return rubyArray2;
    }

    private static void fixUserData(Document document, Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)document;
            node2.setUserData("NOKOGIRI_ENCODED_STRING", coreDocumentImpl.getUserData(node2, "NOKOGIRI_ENCODED_STRING"), null);
            XmlNode.fixUserData(document, node2);
        }
    }

    private Node[] adoptAsChild(Node node, Node node2) {
        if (node.getNodeType() == 9 && node2.getNodeType() == 3) {
            Element element = (Element)node.getFirstChild();
            if (element == null || !element.getNodeName().equals(TEXT_WRAPPER_NAME)) {
                element = ((Document)node).createElement(TEXT_WRAPPER_NAME);
                this.adoptAsChild(node, element);
            }
            element.appendChild(node2);
            node2 = element;
        } else {
            node.appendChild(node2);
        }
        return new Node[]{node2};
    }

    protected void adoptAsPrevSibling(ThreadContext threadContext, Node node, Node node2, Node node3) {
        if (node == null) {
            if (node3.getParentNode() != null) {
                node3.getParentNode().removeChild(node3);
            }
            return;
        }
        node.insertBefore(node3, node2);
    }

    protected void adoptAsNextSibling(ThreadContext threadContext, Node node, Node node2, Node node3) {
        if (node == null) {
            if (node3.getParentNode() != null) {
                node3.getParentNode().removeChild(node3);
            }
            return;
        }
        Node node4 = node2.getNextSibling();
        if (node4 != null) {
            node.insertBefore(node3, node4);
        } else {
            node.appendChild(node3);
        }
    }

    protected void adoptAsReplacement(ThreadContext threadContext, Node node, Node node2, Node node3) {
        if (node == null) {
            return;
        }
        try {
            node.replaceChild(node3, node2);
        }
        catch (Exception exception) {
            String string = "could not replace child: ";
            throw threadContext.runtime.newRuntimeError(string + exception.toString());
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject add_child_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.CHILD, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject replace_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.REPLACEMENT, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject add_previous_sibling_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.PREV_SIBLING, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject add_next_sibling_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.NEXT_SIBLING, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject process_xincludes(ThreadContext threadContext, IRubyObject iRubyObject) {
        XmlDocument xmlDocument = (XmlDocument)this.document(threadContext);
        RubyArray rubyArray = (RubyArray)xmlDocument.getInstanceVariable("@errors");
        while (rubyArray.getLength() > 0) {
            XmlSyntaxError xmlSyntaxError = (XmlSyntaxError)rubyArray.shift(threadContext);
            if (!xmlSyntaxError.toString().contains("Include operation failed")) continue;
            throw xmlSyntaxError.toThrowable();
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject clear_xpath_context(ThreadContext threadContext) {
        NokogiriHelpers.clearXpathContext(this.getNode());
        return threadContext.nil;
    }

    public <T> T toJava(Class<T> clazz) {
        if (clazz == Object.class || Node.class.isAssignableFrom(clazz)) {
            return (T)this.getNode();
        }
        return (T)super.toJava(clazz);
    }

    protected static enum AdoptScheme {
        CHILD,
        PREV_SIBLING,
        NEXT_SIBLING,
        REPLACEMENT;

    }
}

