/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCApplicationProtocolSelector;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ProvSSLParameters {
    private final ProvSSLContextSpi context;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean wantClientAuth = false;
    private boolean needClientAuth = false;
    private String endpointIdentificationAlgorithm;
    private BCAlgorithmConstraints algorithmConstraints = ProvAlgorithmConstraints.DEFAULT;
    private List<BCSNIServerName> sniServerNames;
    private List<BCSNIMatcher> sniMatchers;
    private boolean useCipherSuitesOrder = true;
    private boolean enableRetransmissions = true;
    private int maximumPacketSize = 0;
    private String[] applicationProtocols = TlsUtils.EMPTY_STRINGS;
    private String[] signatureSchemes = null;
    private String[] namedGroups = null;
    private BCApplicationProtocolSelector<SSLEngine> engineAPSelector;
    private BCApplicationProtocolSelector<SSLSocket> socketAPSelector;
    private ProvSSLSession sessionToResume;

    private static <T> List<T> copyList(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    ProvSSLParameters(ProvSSLContextSpi provSSLContextSpi, String[] stringArray, String[] stringArray2) {
        this.context = provSSLContextSpi;
        this.cipherSuites = stringArray;
        this.protocols = stringArray2;
    }

    ProvSSLParameters copy() {
        ProvSSLParameters provSSLParameters = new ProvSSLParameters(this.context, this.cipherSuites, this.protocols);
        provSSLParameters.wantClientAuth = this.wantClientAuth;
        provSSLParameters.needClientAuth = this.needClientAuth;
        provSSLParameters.endpointIdentificationAlgorithm = this.endpointIdentificationAlgorithm;
        provSSLParameters.algorithmConstraints = this.algorithmConstraints;
        provSSLParameters.sniServerNames = this.sniServerNames;
        provSSLParameters.sniMatchers = this.sniMatchers;
        provSSLParameters.useCipherSuitesOrder = this.useCipherSuitesOrder;
        provSSLParameters.enableRetransmissions = this.enableRetransmissions;
        provSSLParameters.maximumPacketSize = this.maximumPacketSize;
        provSSLParameters.applicationProtocols = this.applicationProtocols;
        provSSLParameters.signatureSchemes = this.signatureSchemes;
        provSSLParameters.namedGroups = this.namedGroups;
        provSSLParameters.engineAPSelector = this.engineAPSelector;
        provSSLParameters.socketAPSelector = this.socketAPSelector;
        provSSLParameters.sessionToResume = this.sessionToResume;
        return provSSLParameters;
    }

    ProvSSLParameters copyForConnection() {
        ProvSSLParameters provSSLParameters = this.copy();
        if (ProvAlgorithmConstraints.DEFAULT != provSSLParameters.algorithmConstraints) {
            provSSLParameters.algorithmConstraints = new ProvAlgorithmConstraints(provSSLParameters.algorithmConstraints, true);
        }
        return provSSLParameters;
    }

    public String[] getCipherSuites() {
        return (String[])this.cipherSuites.clone();
    }

    String[] getCipherSuitesArray() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String[] stringArray) {
        this.cipherSuites = this.context.getSupportedCipherSuites(stringArray);
    }

    void setCipherSuitesArray(String[] stringArray) {
        this.cipherSuites = stringArray;
    }

    public String[] getProtocols() {
        return (String[])this.protocols.clone();
    }

    String[] getProtocolsArray() {
        return this.protocols;
    }

    public void setProtocols(String[] stringArray) {
        if (!this.context.isSupportedProtocols(stringArray)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.protocols = (String[])stringArray.clone();
    }

    void setProtocolsArray(String[] stringArray) {
        this.protocols = stringArray;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.needClientAuth = false;
        this.wantClientAuth = bl;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
        this.wantClientAuth = false;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String string) {
        this.endpointIdentificationAlgorithm = string;
    }

    public BCAlgorithmConstraints getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(BCAlgorithmConstraints bCAlgorithmConstraints) {
        this.algorithmConstraints = bCAlgorithmConstraints;
    }

    public List<BCSNIServerName> getServerNames() {
        return ProvSSLParameters.copyList(this.sniServerNames);
    }

    public void setServerNames(List<BCSNIServerName> list) {
        this.sniServerNames = ProvSSLParameters.copyList(list);
    }

    public Collection<BCSNIMatcher> getSNIMatchers() {
        return ProvSSLParameters.copyList(this.sniMatchers);
    }

    public void setSNIMatchers(Collection<BCSNIMatcher> collection) {
        this.sniMatchers = ProvSSLParameters.copyList(collection);
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean bl) {
        this.useCipherSuitesOrder = bl;
    }

    public boolean getEnableRetransmissions() {
        return this.enableRetransmissions;
    }

    public void setEnableRetransmissions(boolean bl) {
        this.enableRetransmissions = bl;
    }

    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public void setMaximumPacketSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The maximum packet size cannot be negative");
        }
        this.maximumPacketSize = n;
    }

    public String[] getApplicationProtocols() {
        return (String[])this.applicationProtocols.clone();
    }

    public void setApplicationProtocols(String[] stringArray) {
        this.applicationProtocols = (String[])stringArray.clone();
    }

    public String[] getSignatureSchemes() {
        return TlsUtils.clone(this.signatureSchemes);
    }

    public void setSignatureSchemes(String[] stringArray) {
        this.signatureSchemes = TlsUtils.clone(stringArray);
    }

    public String[] getNamedGroups() {
        return TlsUtils.clone(this.namedGroups);
    }

    public void setNamedGroups(String[] stringArray) {
        this.namedGroups = TlsUtils.clone(stringArray);
    }

    public BCApplicationProtocolSelector<SSLEngine> getEngineAPSelector() {
        return this.engineAPSelector;
    }

    public void setEngineAPSelector(BCApplicationProtocolSelector<SSLEngine> bCApplicationProtocolSelector) {
        this.engineAPSelector = bCApplicationProtocolSelector;
    }

    public BCApplicationProtocolSelector<SSLSocket> getSocketAPSelector() {
        return this.socketAPSelector;
    }

    public void setSocketAPSelector(BCApplicationProtocolSelector<SSLSocket> bCApplicationProtocolSelector) {
        this.socketAPSelector = bCApplicationProtocolSelector;
    }

    public ProvSSLSession getSessionToResume() {
        return this.sessionToResume;
    }

    public void setSessionToResume(ProvSSLSession provSSLSession) {
        this.sessionToResume = provSSLSession;
    }
}

