/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.pipeline;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.plugins.pipeline.AddressState;
import org.logstash.plugins.pipeline.PipelineBusV1;
import org.logstash.plugins.pipeline.PipelineBusV2;
import org.logstash.plugins.pipeline.PipelineInput;
import org.logstash.plugins.pipeline.PipelineOutput;

public interface PipelineBus {
    public static final Logger LOGGER = LogManager.getLogger(PipelineBus.class);

    public static PipelineBus create() {
        String pipelineBusImplementation;
        switch (pipelineBusImplementation = System.getProperty("logstash.pipelinebus.implementation", "v2")) {
            case "v1": {
                return new PipelineBusV1();
            }
            case "v2": {
                return new PipelineBusV2();
            }
        }
        LOGGER.warn("unknown pipeline-bus implementation: {}", (Object)pipelineBusImplementation);
        return new PipelineBusV1();
    }

    public void sendEvents(PipelineOutput var1, Collection<JrubyEventExtLibrary.RubyEvent> var2, boolean var3);

    public void registerSender(PipelineOutput var1, Iterable<String> var2);

    public void unregisterSender(PipelineOutput var1, Iterable<String> var2);

    public boolean listen(PipelineInput var1, String var2);

    public void unlisten(PipelineInput var1, String var2) throws InterruptedException;

    public void setBlockOnUnlisten(boolean var1);

    @VisibleForTesting
    public static interface Testable
    extends PipelineBus {
        @VisibleForTesting
        public Optional<AddressState.ReadOnly> getAddressState(String var1);

        @VisibleForTesting
        public Optional<Set<AddressState.ReadOnly>> getAddressStates(PipelineOutput var1);

        @VisibleForTesting
        public boolean isBlockOnUnlisten();
    }
}

