/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.FieldVariableAccessor;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class VariableSite
extends MutableCallSite {
    private final String name;
    private VariableAccessor accessor = VariableAccessor.DUMMY_ACCESSOR;
    private boolean rawValue;
    private final String file;
    private final int line;
    private int chainCount;
    private static final Logger LOG = LoggerFactory.getLogger(VariableSite.class);
    public static final Handle IVAR_ASM_HANDLE = new Handle(6, CodegenUtils.p(VariableSite.class), "ivar", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);

    public VariableSite(MethodType type2, String name2, boolean rawValue, String file2, int line) {
        super(type2);
        this.name = name2;
        this.rawValue = rawValue;
        this.file = file2;
        this.line = line;
        this.chainCount = 0;
    }

    public synchronized int chainCount() {
        return this.chainCount;
    }

    public synchronized void incrementChainCount() {
        ++this.chainCount;
    }

    public synchronized void clearChainCount() {
        this.chainCount = 0;
    }

    public String file() {
        return this.file;
    }

    public int line() {
        return this.line;
    }

    public String name() {
        return this.name;
    }

    public static CallSite ivar(MethodHandles.Lookup lookup, String name2, MethodType type2) throws Throwable {
        String[] names2 = name2.split(":");
        String operation = names2[0];
        String varName = names2[1];
        boolean rawValue = names2.length > 2;
        VariableSite site = new VariableSite(type2, varName, rawValue, "noname", 0);
        MethodHandle handle = lookup.findVirtual(VariableSite.class, operation, type2);
        handle = handle.bindTo(site);
        site.setTarget(handle.asType(site.type()));
        return site;
    }

    public IRubyObject ivarGet(IRubyObject self2) throws Throwable {
        MethodHandle getValue2;
        RubyClass realClass = self2.getMetaClass().getRealClass();
        VariableAccessor accessor = realClass.getVariableAccessorForRead(this.name());
        MethodHandle nullToNil = this.rawValue ? self2.getRuntime().getNullToUndefinedHandle() : self2.getRuntime().getNullToNilHandle();
        boolean direct = false;
        if (accessor instanceof FieldVariableAccessor) {
            direct = true;
            getValue2 = ((FieldVariableAccessor)accessor).getGetter();
            getValue2 = MethodHandles.explicitCastArguments(getValue2, MethodType.methodType(Object.class, IRubyObject.class));
        } else {
            getValue2 = VariableSite.findStatic(VariableAccessor.class, "getVariable", MethodType.methodType(Object.class, RubyBasicObject.class, Integer.TYPE));
            getValue2 = MethodHandles.explicitCastArguments(getValue2, MethodType.methodType(Object.class, IRubyObject.class, Integer.TYPE));
            getValue2 = MethodHandles.insertArguments(getValue2, 1, accessor.getIndex());
        }
        getValue2 = MethodHandles.filterReturnValue(getValue2, nullToNil);
        MethodHandle fallback = null;
        if (this.chainCount() + 1 > Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tqet on type " + self2.getMetaClass().id + " failed (polymorphic)" + this.extractSourceInfo(), new Object[0]);
            }
            fallback = VariableSite.findVirtual(VariableSite.class, "ivarGetFail", MethodType.methodType(IRubyObject.class, IRubyObject.class));
            fallback = fallback.bindTo(this);
            this.setTarget(fallback);
            return (IRubyObject)fallback.invokeWithArguments(self2);
        }
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            if (direct) {
                LOG.info(this.name() + "\tget field on type " + self2.getMetaClass().id + " added to PIC" + this.extractSourceInfo(), new Object[0]);
            } else {
                LOG.info(this.name() + "\tget on type " + self2.getMetaClass().id + " added to PIC" + this.extractSourceInfo(), new Object[0]);
            }
        }
        fallback = this.getTarget();
        this.incrementChainCount();
        MethodHandle test2 = VariableSite.findStatic(VariableSite.class, "testRealClass", MethodType.methodType(Boolean.TYPE, Integer.TYPE, IRubyObject.class));
        test2 = MethodHandles.insertArguments(test2, 0, accessor.getClassId());
        getValue2 = MethodHandles.guardWithTest(test2, getValue2, fallback);
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.info(this.name() + "\tget on class " + self2.getMetaClass().id + " bound directly" + this.extractSourceInfo(), new Object[0]);
        }
        this.setTarget(getValue2);
        return getValue2.invokeExact(self2);
    }

    public IRubyObject ivarGetFail(IRubyObject self2) {
        IRubyObject value2;
        VariableAccessor variableAccessor = this.accessor;
        RubyClass cls = self2.getMetaClass().getRealClass();
        if (variableAccessor.getClassId() != cls.hashCode()) {
            this.accessor = variableAccessor = cls.getVariableAccessorForRead(this.name);
        }
        if ((value2 = (IRubyObject)variableAccessor.get(self2)) != null) {
            return value2;
        }
        return this.rawValue ? UndefinedValue.UNDEFINED : self2.getRuntime().getNil();
    }

    public void ivarSet(IRubyObject self2, IRubyObject value2) throws Throwable {
        MethodHandle setValue2;
        RubyClass realClass = self2.getMetaClass().getRealClass();
        VariableAccessor accessor = realClass.getVariableAccessorForWrite(this.name());
        boolean direct = false;
        if (accessor instanceof FieldVariableAccessor) {
            direct = true;
            setValue2 = ((FieldVariableAccessor)accessor).getSetter();
            setValue2 = MethodHandles.explicitCastArguments(setValue2, MethodType.methodType(Void.TYPE, IRubyObject.class, IRubyObject.class));
        } else {
            setValue2 = VariableSite.findStatic(accessor.getClass(), "setVariableChecked", MethodType.methodType(Void.TYPE, RubyBasicObject.class, RubyClass.class, Integer.TYPE, Object.class));
            setValue2 = MethodHandles.explicitCastArguments(setValue2, MethodType.methodType(Void.TYPE, IRubyObject.class, RubyClass.class, Integer.TYPE, IRubyObject.class));
            setValue2 = MethodHandles.insertArguments(setValue2, 1, realClass, accessor.getIndex());
        }
        MethodHandle fallback = null;
        if (this.chainCount() + 1 > Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tset on type " + self2.getMetaClass().id + " failed (polymorphic)" + this.extractSourceInfo(), new Object[0]);
            }
            fallback = VariableSite.findVirtual(VariableSite.class, "ivarSetFail", MethodType.methodType(Void.TYPE, IRubyObject.class, IRubyObject.class));
            fallback = fallback.bindTo(this);
            this.setTarget(fallback);
            fallback.invokeExact(self2, value2);
        } else {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                if (direct) {
                    LOG.info(this.name() + "\tset field on type " + self2.getMetaClass().id + " added to PIC" + this.extractSourceInfo(), new Object[0]);
                } else {
                    LOG.info(this.name() + "\tset on type " + self2.getMetaClass().id + " added to PIC" + this.extractSourceInfo(), new Object[0]);
                }
            }
            fallback = this.getTarget();
            this.incrementChainCount();
        }
        MethodHandle test2 = VariableSite.findStatic(VariableSite.class, "testRealClass", MethodType.methodType(Boolean.TYPE, Integer.TYPE, IRubyObject.class));
        test2 = MethodHandles.insertArguments(test2, 0, accessor.getClassId());
        test2 = MethodHandles.dropArguments(test2, 1, new Class[]{IRubyObject.class});
        setValue2 = MethodHandles.guardWithTest(test2, setValue2, fallback);
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.info(this.name() + "\tset on class " + self2.getMetaClass().id + " bound directly" + this.extractSourceInfo(), new Object[0]);
        }
        this.setTarget(setValue2);
        setValue2.invokeExact(self2, value2);
    }

    public void ivarSetFail(IRubyObject self2, IRubyObject value2) {
        VariableAccessor variableAccessor = this.accessor;
        RubyClass cls = self2.getMetaClass().getRealClass();
        if (variableAccessor.getClassId() != cls.hashCode()) {
            this.accessor = variableAccessor = cls.getVariableAccessorForWrite(this.name);
        }
        variableAccessor.set(self2, value2);
    }

    private static MethodHandle findStatic(Class target2, String name2, MethodType type2) {
        return VariableSite.findStatic(MethodHandles.lookup(), target2, name2, type2);
    }

    private static MethodHandle findStatic(MethodHandles.Lookup lookup, Class target2, String name2, MethodType type2) {
        try {
            return lookup.findStatic(target2, name2, type2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static MethodHandle findVirtual(Class target2, String name2, MethodType type2) {
        return VariableSite.findVirtual(MethodHandles.lookup(), target2, name2, type2);
    }

    private static MethodHandle findVirtual(MethodHandles.Lookup lookup, Class target2, String name2, MethodType type2) {
        try {
            return lookup.findVirtual(target2, name2, type2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String extractSourceInfo() {
        return " (" + this.file() + ":" + this.line() + ")";
    }

    public static boolean testRealClass(int id2, IRubyObject self2) {
        return id2 == ((RubyBasicObject)self2).getMetaClass().getRealClass().id;
    }
}

