/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.GlobalRpcCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.CrossSiteIllegalLifecycleStateException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.commands.remote.XSiteRequest;

@Scope(value=Scopes.GLOBAL)
public class GlobalInboundInvocationHandler
implements InboundInvocationHandler {
    private static final Log log = LogFactory.getLog(GlobalInboundInvocationHandler.class);
    @Inject
    BlockingManager blockingManager;
    @Inject
    GlobalComponentRegistry globalComponentRegistry;

    private static Response shuttingDownResponse() {
        return CacheNotFoundResponse.INSTANCE;
    }

    private static ExceptionResponse exceptionHandlingCommand(Throwable throwable) {
        if (throwable instanceof Exception) {
            return new ExceptionResponse((Exception)throwable);
        }
        return new ExceptionResponse((Exception)new CacheException("Problems invoking command.", throwable));
    }

    @Override
    public void handleFromCluster(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
        command.setOrigin(origin);
        try {
            if (command.getCommandId() == 30) {
                reply.reply(null);
            } else if (command instanceof CacheRpcCommand) {
                this.handleCacheRpcCommand(origin, (CacheRpcCommand)command, reply, order);
            } else {
                this.handleReplicableCommand(origin, command, reply, order);
            }
        }
        catch (Throwable t) {
            if (command.logThrowable(t)) {
                Log.CLUSTER.exceptionHandlingCommand(command, t);
            }
            reply.reply(GlobalInboundInvocationHandler.exceptionHandlingCommand(t));
        }
    }

    @Override
    public void handleFromRemoteSite(String origin, XSiteRequest<?> command, Reply reply, DeliverOrder order) {
        if (log.isTraceEnabled()) {
            log.tracef("Handling command %s from remote site %s", command, origin);
        }
        XSiteResponseConsumer rspConsumer = new XSiteResponseConsumer(reply, command);
        if (!this.globalComponentRegistry.getStatus().allowInvocations()) {
            rspConsumer.accept((Object)null, (Throwable)log.xsiteCacheManagerDoesNotAllowInvocations(origin));
            return;
        }
        command.invokeInLocalSite(origin, this.globalComponentRegistry).whenComplete(rspConsumer);
    }

    private void handleCacheRpcCommand(Address origin, CacheRpcCommand command, Reply reply, DeliverOrder mode) {
        ByteString cacheName;
        ComponentRegistry cr;
        if (log.isTraceEnabled()) {
            log.tracef("Attempting to execute CacheRpcCommand: %s [sender=%s]", command, origin);
        }
        if ((cr = this.globalComponentRegistry.getNamedComponentRegistry(cacheName = command.getCacheName())) == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Silently ignoring that %s cache is not defined", cacheName);
            }
            reply.reply(CacheNotFoundResponse.INSTANCE);
            return;
        }
        CommandsFactory commandsFactory = cr.getCommandsFactory();
        commandsFactory.initializeReplicableCommand(command, true);
        PerCacheInboundInvocationHandler handler = cr.getPerCacheInboundInvocationHandler();
        handler.handle(command, reply, mode);
    }

    private void handleReplicableCommand(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
        if (log.isTraceEnabled()) {
            log.tracef("Attempting to execute non-CacheRpcCommand: %s [sender=%s]", command, origin);
        }
        ReplicableCommandRunner runnable = new ReplicableCommandRunner(command, reply, this.globalComponentRegistry, order.preserveOrder());
        if (order.preserveOrder() || !command.canBlock()) {
            runnable.run();
        } else {
            this.blockingManager.runBlocking(runnable, "[blocking] " + String.valueOf(command));
        }
    }

    private static class XSiteResponseConsumer
    extends BaseResponseConsumer<XSiteRequest<?>> {
        private final XSiteRequest<?> command;

        private XSiteResponseConsumer(Reply reply, XSiteRequest<?> command) {
            super(reply);
            this.command = command;
        }

        @Override
        XSiteRequest<?> getCommand() {
            return this.command;
        }

        @Override
        boolean logThrowable(Throwable throwable) {
            return !(throwable instanceof CrossSiteIllegalLifecycleStateException);
        }
    }

    private static class ReplicableCommandRunner
    extends ResponseConsumer
    implements Runnable {
        private final GlobalComponentRegistry globalComponentRegistry;
        private final boolean preserveOrder;

        private ReplicableCommandRunner(ReplicableCommand command, Reply reply, GlobalComponentRegistry globalComponentRegistry, boolean preserveOrder) {
            super(command, reply);
            this.globalComponentRegistry = globalComponentRegistry;
            this.preserveOrder = preserveOrder;
        }

        @Override
        public void run() {
            try {
                CompletionStage stage;
                if (this.command instanceof GlobalRpcCommand) {
                    stage = ((GlobalRpcCommand)this.command).invokeAsync(this.globalComponentRegistry).whenComplete(this);
                } else {
                    this.globalComponentRegistry.wireDependencies(this.command);
                    stage = this.command.invokeAsync().whenComplete((BiConsumer)this);
                }
                if (this.preserveOrder) {
                    CompletionStages.join((CompletionStage)stage);
                }
            }
            catch (Throwable throwable) {
                this.accept((Object)null, throwable);
            }
        }
    }

    private static abstract class BaseResponseConsumer<T>
    implements BiConsumer<Object, Throwable> {
        private final Reply reply;

        private BaseResponseConsumer(Reply reply) {
            this.reply = reply;
        }

        @Override
        public void accept(Object retVal, Throwable throwable) {
            this.reply.reply(this.convertToResponse(retVal, throwable));
        }

        abstract T getCommand();

        abstract boolean logThrowable(Throwable var1);

        private Response convertToResponse(Object retVal, Throwable throwable) {
            if (throwable != null) {
                if ((throwable = CompletableFutures.extractException((Throwable)throwable)) instanceof InterruptedException || throwable instanceof IllegalLifecycleStateException) {
                    Log.CLUSTER.debugf("Shutdown while handling command %s", this.getCommand());
                    return GlobalInboundInvocationHandler.shuttingDownResponse();
                }
                if (this.logThrowable(throwable)) {
                    Log.CLUSTER.exceptionHandlingCommand(this.getCommand(), throwable);
                }
                return GlobalInboundInvocationHandler.exceptionHandlingCommand(throwable);
            }
            if (retVal == null || retVal instanceof Response) {
                return (Response)retVal;
            }
            return SuccessfulResponse.create(retVal);
        }
    }

    private static class ResponseConsumer
    extends BaseResponseConsumer<ReplicableCommand> {
        final ReplicableCommand command;

        private ResponseConsumer(ReplicableCommand command, Reply reply) {
            super(reply);
            this.command = command;
        }

        @Override
        ReplicableCommand getCommand() {
            return this.command;
        }

        @Override
        boolean logThrowable(Throwable throwable) {
            return this.command.logThrowable(throwable);
        }
    }
}

