/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Objects;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.TracingExporterProtocol;
import org.infinispan.configuration.parsing.Attribute;

public class GlobalTracingConfiguration {
    public static final AttributeDefinition<String> COLLECTOR_ENDPOINT = AttributeDefinition.builder((Enum)Attribute.COLLECTOR_ENDPOINT, null, String.class).immutable().build();
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)true, Boolean.class).immutable().build();
    public static final AttributeDefinition<TracingExporterProtocol> EXPORTER_PROTOCOL = AttributeDefinition.builder((Enum)Attribute.EXPORTER_PROTOCOL, (Object)((Object)TracingExporterProtocol.OTLP)).immutable().build();
    public static final AttributeDefinition<String> SERVICE_NAME = AttributeDefinition.builder((Enum)Attribute.SERVICE_NAME, (Object)"infinispan-server").immutable().build();
    public static final AttributeDefinition<Boolean> SECURITY = AttributeDefinition.builder((Enum)Attribute.SECURITY, (Object)false, Boolean.class).immutable().build();
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalTracingConfiguration.class, new AttributeDefinition[]{COLLECTOR_ENDPOINT, ENABLED, EXPORTER_PROTOCOL, SERVICE_NAME, SECURITY});
    }

    GlobalTracingConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String collectorEndpoint() {
        return (String)this.attributes.attribute(COLLECTOR_ENDPOINT).get();
    }

    public boolean enabled() {
        return this.collectorEndpoint() != null && (Boolean)this.attributes.attribute(ENABLED).get() != false;
    }

    public TracingExporterProtocol exporterProtocol() {
        return (TracingExporterProtocol)((Object)this.attributes.attribute(EXPORTER_PROTOCOL).get());
    }

    public String serviceName() {
        return (String)this.attributes.attribute(SERVICE_NAME).get();
    }

    public boolean security() {
        return this.enabled() && (Boolean)this.attributes.attribute(SECURITY).get() != false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalTracingConfiguration that = (GlobalTracingConfiguration)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }

    public String toString() {
        return "GlobalTracingConfiguration{attributes=" + String.valueOf(this.attributes) + "}";
    }
}

