/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.InputExecutionState;
import org.gradle.internal.execution.model.InputNormalizer;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.operations.execution.FilePropertyVisitor;

@NonNullApi
public abstract class BaseSnapshotInputsBuildOperationResult
implements CustomOperationTraceSerialization {
    @VisibleForTesting
    final CachingState cachingState;

    public BaseSnapshotInputsBuildOperationResult(CachingState cachingState) {
        this.cachingState = cachingState;
    }

    protected abstract Map<String, Object> fileProperties();

    @Nullable
    public Map<String, byte[]> getInputValueHashesBytes() {
        return this.getBeforeExecutionState().map(InputExecutionState::getInputProperties).filter(inputValueFingerprints -> !inputValueFingerprints.isEmpty()).map(inputValueFingerprints -> inputValueFingerprints.entrySet().stream().collect(BaseSnapshotInputsBuildOperationResult.toLinkedHashMap(valueSnapshot -> {
            Hasher hasher = Hashing.newHasher();
            valueSnapshot.appendToHasher(hasher);
            return hasher.hash().toByteArray();
        }))).orElse(null);
    }

    @Nullable
    public byte[] getClassLoaderHashBytes() {
        return this.getBeforeExecutionState().map(InputExecutionState::getImplementation).map(BaseSnapshotInputsBuildOperationResult::getClassLoaderHashBytesOrNull).orElse(null);
    }

    @Nullable
    public String getImplementationClassName() {
        return this.getBeforeExecutionState().map(InputExecutionState::getImplementation).map(ImplementationSnapshot::getClassIdentifier).orElse(null);
    }

    @Nullable
    public List<byte[]> getActionClassLoaderHashesBytes() {
        return this.getBeforeExecutionState().map(InputExecutionState::getAdditionalImplementations).filter(additionalImplementation -> !additionalImplementation.isEmpty()).map(additionalImplementations -> additionalImplementations.stream().map(BaseSnapshotInputsBuildOperationResult::getClassLoaderHashBytesOrNull).collect(Collectors.toList())).orElse(null);
    }

    @Nullable
    private static byte[] getClassLoaderHashBytesOrNull(ImplementationSnapshot implementation) {
        HashCode hash = implementation.getClassLoaderHash();
        return hash == null ? null : hash.toByteArray();
    }

    @Nullable
    public List<String> getActionClassNames() {
        return this.getBeforeExecutionState().map(InputExecutionState::getAdditionalImplementations).filter(additionalImplementations -> !additionalImplementations.isEmpty()).map(additionalImplementations -> additionalImplementations.stream().map(ImplementationSnapshot::getClassIdentifier).collect(Collectors.toList())).orElse(null);
    }

    @Nullable
    public List<String> getOutputPropertyNames() {
        return this.getBeforeExecutionState().map(BeforeExecutionState::getOutputFileLocationSnapshots).map(ImmutableSortedMap::keySet).filter(outputPropertyNames -> !outputPropertyNames.isEmpty()).map(ImmutableCollection::asList).orElse(null);
    }

    @Nullable
    public byte[] getHashBytes() {
        return this.getKey().map(BuildCacheKey::toByteArray).orElse(null);
    }

    @Override
    public Object getCustomOperationTraceSerializableModel() {
        TreeMap<String, Object> model = new TreeMap<String, Object>();
        List<byte[]> actionClassLoaderHashesBytes = this.getActionClassLoaderHashesBytes();
        if (actionClassLoaderHashesBytes != null) {
            List actionClassloaderHashes = this.getActionClassLoaderHashesBytes().stream().map(hash -> hash == null ? null : HashCode.fromBytes((byte[])hash).toString()).collect(Collectors.toList());
            model.put("actionClassLoaderHashes", actionClassloaderHashes);
        } else {
            model.put("actionClassLoaderHashes", null);
        }
        model.put("actionClassNames", this.getActionClassNames());
        byte[] hashBytes = this.getHashBytes();
        if (hashBytes != null) {
            model.put("hash", HashCode.fromBytes((byte[])hashBytes).toString());
        } else {
            model.put("hash", null);
        }
        byte[] classLoaderHashBytes = this.getClassLoaderHashBytes();
        if (classLoaderHashBytes != null) {
            model.put("classLoaderHash", HashCode.fromBytes((byte[])classLoaderHashBytes).toString());
        } else {
            model.put("classLoaderHash", null);
        }
        model.put("implementationClassName", this.getImplementationClassName());
        model.put("inputFileProperties", this.fileProperties());
        Map<String, byte[]> inputValueHashesBytes = this.getInputValueHashesBytes();
        if (inputValueHashesBytes != null) {
            Map inputValueHashes = inputValueHashesBytes.entrySet().stream().collect(BaseSnapshotInputsBuildOperationResult.toLinkedHashMap(value -> value == null ? null : HashCode.fromBytes((byte[])value).toString()));
            model.put("inputValueHashes", inputValueHashes);
        } else {
            model.put("inputValueHashes", null);
        }
        model.put("outputPropertyNames", this.getOutputPropertyNames());
        return model;
    }

    private static <K, V, U> Collector<Map.Entry<K, V>, ?, LinkedHashMap<K, U>> toLinkedHashMap(Function<? super V, ? extends U> valueMapper) {
        return Collectors.toMap(Map.Entry::getKey, entry -> valueMapper.apply((Object)entry.getValue()), (a, b) -> b, LinkedHashMap::new);
    }

    protected Optional<BeforeExecutionState> getBeforeExecutionState() {
        return (Optional)this.cachingState.fold(enabled -> Optional.of(enabled.getBeforeExecutionState()), CachingState.Disabled::getBeforeExecutionState);
    }

    private Optional<BuildCacheKey> getKey() {
        return (Optional)this.cachingState.fold(enabled -> Optional.of(enabled.getKey()), CachingState.Disabled::getKey);
    }

    protected static abstract class BaseFilePropertyCollectingVisitor<STATE extends FilePropertyVisitor.VisitState> {
        private final Map<String, Object> fileProperties = new TreeMap<String, Object>();
        Property property;
        final Deque<DirEntry> dirStack = new ArrayDeque<DirEntry>();

        public Map<String, Object> getFileProperties() {
            return this.fileProperties;
        }

        protected abstract Property createProperty(STATE var1);

        public void preProperty(STATE state) {
            this.property = this.createProperty(state);
            this.fileProperties.put(state.getPropertyName(), this.property);
        }

        public void preRoot(STATE state) {
        }

        public void preDirectory(STATE state) {
            boolean isRoot = this.dirStack.isEmpty();
            DirEntry dir = new DirEntry(isRoot ? state.getPath() : state.getName());
            if (isRoot) {
                this.property.roots.add(dir);
            } else {
                this.dirStack.peek().children.add(dir);
            }
            this.dirStack.push(dir);
        }

        public void file(STATE state) {
            boolean isRoot = this.dirStack.isEmpty();
            FileEntry file = new FileEntry(isRoot ? state.getPath() : state.getName(), HashCode.fromBytes((byte[])state.getHashBytes()).toString());
            if (isRoot) {
                this.property.roots.add(file);
            } else {
                this.dirStack.peek().children.add(file);
            }
        }

        public void postDirectory() {
            this.dirStack.pop();
        }

        public void postRoot() {
        }

        public void postProperty() {
        }

        static class DirEntry
        extends Entry {
            private final List<Entry> children = new ArrayList<Entry>();

            DirEntry(String path) {
                super(path);
            }

            public Collection<Entry> getChildren() {
                return this.children;
            }
        }

        static class FileEntry
        extends Entry {
            private final String hash;

            FileEntry(String path, String hash) {
                super(path);
                this.hash = hash;
            }

            public String getHash() {
                return this.hash;
            }
        }

        public static abstract class Entry {
            private final String path;

            public Entry(String path) {
                this.path = path;
            }

            public String getPath() {
                return this.path;
            }
        }

        protected static class Property {
            private final String hash;
            private final Set<String> attributes;
            private final List<Entry> roots = new ArrayList<Entry>();

            public Property(String hash, Set<String> attributes) {
                this.hash = hash;
                this.attributes = attributes;
            }

            public String getHash() {
                return this.hash;
            }

            public Set<String> getAttributes() {
                return this.attributes;
            }

            public Collection<Entry> getRoots() {
                return this.roots;
            }
        }
    }

    static enum FilePropertyAttribute {
        FINGERPRINTING_STRATEGY_ABSOLUTE_PATH,
        FINGERPRINTING_STRATEGY_NAME_ONLY,
        FINGERPRINTING_STRATEGY_RELATIVE_PATH,
        FINGERPRINTING_STRATEGY_IGNORED_PATH,
        FINGERPRINTING_STRATEGY_CLASSPATH,
        FINGERPRINTING_STRATEGY_COMPILE_CLASSPATH,
        DIRECTORY_SENSITIVITY_DEFAULT,
        DIRECTORY_SENSITIVITY_IGNORE_DIRECTORIES,
        LINE_ENDING_SENSITIVITY_DEFAULT,
        LINE_ENDING_SENSITIVITY_NORMALIZE_LINE_ENDINGS;

        private static final Map<FileNormalizer, FilePropertyAttribute> BY_NORMALIZER;
        private static final Map<DirectorySensitivity, FilePropertyAttribute> BY_DIRECTORY_SENSITIVITY;
        private static final Map<LineEndingSensitivity, FilePropertyAttribute> BY_LINE_ENDING_SENSITIVITY;

        private static <T> FilePropertyAttribute findFor(T value, Map<T, FilePropertyAttribute> mapping) {
            FilePropertyAttribute attribute = mapping.get(value);
            if (attribute == null) {
                throw new IllegalStateException("Did not find property attribute mapping for '" + value + "' (from: " + mapping.keySet() + ")");
            }
            return attribute;
        }

        static FilePropertyAttribute fromNormalizer(FileNormalizer normalizer) {
            return FilePropertyAttribute.findFor(normalizer, BY_NORMALIZER);
        }

        static FilePropertyAttribute from(DirectorySensitivity directorySensitivity) {
            return FilePropertyAttribute.findFor(directorySensitivity, BY_DIRECTORY_SENSITIVITY);
        }

        static FilePropertyAttribute from(LineEndingSensitivity lineEndingSensitivity) {
            return FilePropertyAttribute.findFor(lineEndingSensitivity, BY_LINE_ENDING_SENSITIVITY);
        }

        static {
            BY_NORMALIZER = ImmutableMap.builder().put((Object)InputNormalizer.RUNTIME_CLASSPATH, (Object)FINGERPRINTING_STRATEGY_CLASSPATH).put((Object)InputNormalizer.COMPILE_CLASSPATH, (Object)FINGERPRINTING_STRATEGY_COMPILE_CLASSPATH).put((Object)InputNormalizer.ABSOLUTE_PATH, (Object)FINGERPRINTING_STRATEGY_ABSOLUTE_PATH).put((Object)InputNormalizer.RELATIVE_PATH, (Object)FINGERPRINTING_STRATEGY_RELATIVE_PATH).put((Object)InputNormalizer.NAME_ONLY, (Object)FINGERPRINTING_STRATEGY_NAME_ONLY).put((Object)InputNormalizer.IGNORE_PATH, (Object)FINGERPRINTING_STRATEGY_IGNORED_PATH).build();
            BY_DIRECTORY_SENSITIVITY = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)DirectorySensitivity.DEFAULT, (Object)DIRECTORY_SENSITIVITY_DEFAULT).put((Object)DirectorySensitivity.IGNORE_DIRECTORIES, (Object)DIRECTORY_SENSITIVITY_IGNORE_DIRECTORIES).build());
            BY_LINE_ENDING_SENSITIVITY = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)LineEndingSensitivity.DEFAULT, (Object)LINE_ENDING_SENSITIVITY_DEFAULT).put((Object)LineEndingSensitivity.NORMALIZE_LINE_ENDINGS, (Object)LINE_ENDING_SENSITIVITY_NORMALIZE_LINE_ENDINGS).build());
        }
    }
}

