/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;

public class SymbolInformationTypeAdapter
extends TypeAdapter<SymbolInformation> {
    private static final TypeToken<List<SymbolTag>> TAGS_TYPE_TOKEN = new TypeToken<List<SymbolTag>>(){};
    private final Gson gson;

    protected void writeLocation(JsonWriter out, Location value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("uri");
        out.value(value.getUri());
        out.name("range");
        this.writeRange(out, value.getRange());
        out.endObject();
    }

    protected void writeRange(JsonWriter out, Range value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("start");
        this.writePosition(out, value.getStart());
        out.name("end");
        this.writePosition(out, value.getEnd());
        out.endObject();
    }

    protected void writePosition(JsonWriter out, Position value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("line");
        out.value((long)value.getLine());
        out.name("character");
        out.value((long)value.getCharacter());
        out.endObject();
    }

    public SymbolInformationTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public SymbolInformation read(JsonReader in) throws IOException {
        JsonToken nextToken = in.peek();
        if (nextToken == JsonToken.NULL) {
            return null;
        }
        SymbolInformation result = new SymbolInformation();
        in.beginObject();
        block16: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "name": {
                    result.setName(this.readName(in));
                    continue block16;
                }
                case "kind": {
                    result.setKind(this.readKind(in));
                    continue block16;
                }
                case "tags": {
                    result.setTags(this.readTags(in));
                    continue block16;
                }
                case "deprecated": {
                    result.setDeprecated(this.readDeprecated(in));
                    continue block16;
                }
                case "location": {
                    result.setLocation(this.readLocation(in));
                    continue block16;
                }
                case "containerName": {
                    result.setContainerName(this.readContainerName(in));
                    continue block16;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return result;
    }

    protected String readName(JsonReader in) throws IOException {
        return (String)this.gson.fromJson(in, String.class);
    }

    protected SymbolKind readKind(JsonReader in) throws IOException {
        return (SymbolKind)((Object)this.gson.fromJson(in, SymbolKind.class));
    }

    protected List<SymbolTag> readTags(JsonReader in) throws IOException {
        return (List)this.gson.fromJson(in, TAGS_TYPE_TOKEN.getType());
    }

    protected Boolean readDeprecated(JsonReader in) throws IOException {
        return (Boolean)this.gson.fromJson(in, Boolean.class);
    }

    protected Location readLocation(JsonReader in) throws IOException {
        return (Location)this.gson.fromJson(in, Location.class);
    }

    protected String readContainerName(JsonReader in) throws IOException {
        return (String)this.gson.fromJson(in, String.class);
    }

    public void write(JsonWriter out, SymbolInformation value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("name");
        this.writeName(out, value.getName());
        out.name("kind");
        this.writeKind(out, value.getKind());
        out.name("tags");
        this.writeTags(out, value.getTags());
        out.name("deprecated");
        this.writeDeprecated(out, value.getDeprecated());
        out.name("location");
        this.writeLocation(out, value.getLocation());
        out.name("containerName");
        this.writeContainerName(out, value.getContainerName());
        out.endObject();
    }

    protected void writeName(JsonWriter out, String value) throws IOException {
        out.value(value);
    }

    protected void writeKind(JsonWriter out, SymbolKind value) throws IOException {
        this.gson.toJson((Object)value, SymbolKind.class, out);
    }

    protected void writeTags(JsonWriter out, List<SymbolTag> value) throws IOException {
        this.gson.toJson(value, TAGS_TYPE_TOKEN.getType(), out);
    }

    protected void writeDeprecated(JsonWriter out, Boolean value) throws IOException {
        out.value(value);
    }

    protected void writeContainerName(JsonWriter out, String value) throws IOException {
        out.value(value);
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!SymbolInformation.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new SymbolInformationTypeAdapter(gson);
        }
    }
}

