/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.configuration;

import de.focus_shift.jollyday.core.configuration.ConfigurationProvider;
import de.focus_shift.jollyday.core.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

class ClasspathConfigurationProvider
implements ConfigurationProvider {
    private static final String DEFAULT_CONFIGURATION_FILE_NAME = "jollyday.properties";
    private URL configurationFile = this.getConfigurationFile("jollyday.properties");

    @Override
    public Properties getProperties() {
        return this.mapConfigurationFromUrl(this.configurationFile);
    }

    public void overrideConfigurationFileName(String configurationFile) {
        this.configurationFile = this.getConfigurationFile(configurationFile);
    }

    private Properties mapConfigurationFromUrl(URL url) {
        Properties properties = new Properties();
        try (InputStream inputStream = url.openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load default configuration from classpath.", e);
        }
        return properties;
    }

    private URL getConfigurationFile(String configurationFileName) {
        URL configuration = ResourceUtil.getResource(configurationFileName);
        if (configuration == null) {
            throw new IllegalStateException("Configuration file '" + configurationFileName + "' not found on classpath.");
        }
        return configuration;
    }
}

