typedef const unsigned short table_t[1024];

static const int prime_factor = 89, prime_step = 281;

static const struct value_desc values[] = {
    { 0,  },
    { GL_ALPHA_BITS, BUFFER_INT(Visual.alphaBits), extra_new_buffers },
    { GL_BLEND, CONTEXT_BIT0(Color.BlendEnabled), NO_EXTRA },
    { GL_BLEND_SRC, CONTEXT_ENUM16(Color.Blend[0].SrcRGB), NO_EXTRA },
    { GL_COLOR_CLEAR_VALUE, LOC_CUSTOM, TYPE_FLOATN_4, 0, NO_EXTRA },
    { GL_COLOR_WRITEMASK, LOC_CUSTOM, TYPE_INT_4, 0, NO_EXTRA },
    { GL_CULL_FACE, CONTEXT_BOOL(Polygon.CullFlag), NO_EXTRA },
    { GL_CULL_FACE_MODE, CONTEXT_ENUM16(Polygon.CullFaceMode), NO_EXTRA },
    { GL_DEPTH_CLEAR_VALUE, CONTEXT_FIELD(Depth.Clear, TYPE_DOUBLEN), NO_EXTRA },
    { GL_DEPTH_FUNC, CONTEXT_ENUM16(Depth.Func), NO_EXTRA },
    { GL_DEPTH_RANGE, LOC_CUSTOM, TYPE_DOUBLEN_2, 0, NO_EXTRA },
    { GL_DEPTH_TEST, CONTEXT_BOOL(Depth.Test), NO_EXTRA },
    { GL_DEPTH_WRITEMASK, CONTEXT_BOOL(Depth.Mask), NO_EXTRA },
    { GL_DITHER, CONTEXT_BOOL(Color.DitherFlag), NO_EXTRA },
    { GL_FRONT_FACE, CONTEXT_ENUM16(Polygon.FrontFace), NO_EXTRA },
    { GL_LINE_WIDTH, CONTEXT_FLOAT(Line.Width), NO_EXTRA },
    { GL_ALIASED_LINE_WIDTH_RANGE, CONTEXT_FLOAT2(Const.MinLineWidth), NO_EXTRA },
    { GL_MAX_ELEMENTS_VERTICES, CONTEXT_INT(Const.MaxArrayLockSize), NO_EXTRA },
    { GL_MAX_ELEMENTS_INDICES, CONTEXT_INT(Const.MaxArrayLockSize), NO_EXTRA },
    { GL_MAX_TEXTURE_SIZE, CONTEXT_INT(Const.MaxTextureSize), NO_EXTRA },
    { GL_MAX_VIEWPORT_DIMS, CONTEXT_INT2(Const.MaxViewportWidth), NO_EXTRA },
    { GL_PACK_ALIGNMENT, CONTEXT_INT(Pack.Alignment), NO_EXTRA },
    { GL_ALIASED_POINT_SIZE_RANGE, CONTEXT_FLOAT2(Const.MinPointSize), NO_EXTRA },
    { GL_POLYGON_OFFSET_FACTOR, CONTEXT_FLOAT(Polygon.OffsetFactor ), NO_EXTRA },
    { GL_POLYGON_OFFSET_UNITS, CONTEXT_FLOAT(Polygon.OffsetUnits ), NO_EXTRA },
    { GL_POLYGON_OFFSET_FILL, CONTEXT_BOOL(Polygon.OffsetFill), NO_EXTRA },
    { GL_SCISSOR_BOX, LOC_CUSTOM, TYPE_INT_4, 0, NO_EXTRA },
    { GL_SCISSOR_TEST, LOC_CUSTOM, TYPE_BOOLEAN, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_CLEAR_VALUE, CONTEXT_INT(Stencil.Clear), NO_EXTRA },
    { GL_STENCIL_FAIL, LOC_CUSTOM, TYPE_ENUM16, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_FUNC, LOC_CUSTOM, TYPE_ENUM16, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_PASS_DEPTH_FAIL, LOC_CUSTOM, TYPE_ENUM16, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_PASS_DEPTH_PASS, LOC_CUSTOM, TYPE_ENUM16, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_REF, LOC_CUSTOM, TYPE_UINT, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_TEST, CONTEXT_BOOL(Stencil.Enabled), NO_EXTRA },
    { GL_STENCIL_VALUE_MASK, LOC_CUSTOM, TYPE_UINT, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_WRITEMASK, LOC_CUSTOM, TYPE_UINT, NO_OFFSET, NO_EXTRA },
    { GL_SUBPIXEL_BITS, CONTEXT_INT(Const.SubPixelBits), NO_EXTRA },
    { GL_TEXTURE_BINDING_2D, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_INDEX, NO_EXTRA },
    { GL_UNPACK_ALIGNMENT, CONTEXT_INT(Unpack.Alignment), NO_EXTRA },
    { GL_VIEWPORT, LOC_CUSTOM, TYPE_FLOAT_4, 0, NO_EXTRA },
    { GL_ACTIVE_TEXTURE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_TEXTURE_BINDING_CUBE_MAP_ARB, LOC_CUSTOM, TYPE_INT, TEXTURE_CUBE_INDEX, NO_EXTRA },
    { GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, Const.MaxCubeTextureLevels), NO_EXTRA },
    { GL_BLEND_SRC_RGB, CONTEXT_ENUM16(Color.Blend[0].SrcRGB), NO_EXTRA },
    { GL_BLEND_DST_RGB, CONTEXT_ENUM16(Color.Blend[0].DstRGB), NO_EXTRA },
    { GL_BLEND_SRC_ALPHA, CONTEXT_ENUM16(Color.Blend[0].SrcA), NO_EXTRA },
    { GL_BLEND_DST_ALPHA, CONTEXT_ENUM16(Color.Blend[0].DstA), NO_EXTRA },
    { GL_BLEND_EQUATION, CONTEXT_ENUM16(Color.Blend[0].EquationRGB), NO_EXTRA },
    { GL_BLEND_EQUATION_ALPHA_EXT, CONTEXT_ENUM16(Color.Blend[0].EquationA), NO_EXTRA },
    { GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_COMPRESSED_TEXTURE_FORMATS, LOC_CUSTOM, TYPE_INT_N, 0, NO_EXTRA },
    { GL_SAMPLE_ALPHA_TO_COVERAGE_ARB, CONTEXT_BOOL(Multisample.SampleAlphaToCoverage), NO_EXTRA },
    { GL_SAMPLE_COVERAGE_ARB, CONTEXT_BOOL(Multisample.SampleCoverage), NO_EXTRA },
    { GL_SAMPLE_COVERAGE_VALUE_ARB, CONTEXT_FLOAT(Multisample.SampleCoverageValue), NO_EXTRA },
    { GL_SAMPLE_COVERAGE_INVERT_ARB, CONTEXT_BOOL(Multisample.SampleCoverageInvert), NO_EXTRA },
    { GL_SAMPLE_BUFFERS_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_new_buffers },
    { GL_SAMPLES_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_new_buffers },
    { GL_SAMPLE_SHADING_ARB, CONTEXT_BOOL(Multisample.SampleShading), extra_gl40_ARB_sample_shading },
    { GL_MIN_SAMPLE_SHADING_VALUE_ARB, CONTEXT_FLOAT(Multisample.MinSampleShadingValue), extra_gl40_ARB_sample_shading },
    { GL_GENERATE_MIPMAP_HINT_SGIS, CONTEXT_ENUM16(Hint.GenerateMipmap), NO_EXTRA },
    { GL_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_CLAMP_VERTEX_COLOR, CONTEXT_ENUM16(Light.ClampVertexColor), extra_ARB_color_buffer_float },
    { GL_CLAMP_FRAGMENT_COLOR, CONTEXT_ENUM16(Color.ClampFragmentColor), extra_ARB_color_buffer_float },
    { GL_CLAMP_READ_COLOR, CONTEXT_ENUM16(Color.ClampReadColor), extra_ARB_color_buffer_float_or_glcore },
    { GL_COPY_READ_BUFFER, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_COPY_WRITE_BUFFER, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_IMPLEMENTATION_COLOR_READ_TYPE_OES, LOC_CUSTOM, TYPE_INT, 0, extra_new_buffers },
    { GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES, LOC_CUSTOM, TYPE_INT, 0, extra_new_buffers },
    { GL_FRAMEBUFFER_BINDING_EXT, BUFFER_INT(Name), NO_EXTRA },
    { GL_RENDERBUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MAX_RENDERBUFFER_SIZE_EXT, CONTEXT_INT(Const.MaxRenderbufferSize), NO_EXTRA },
    { GL_MAX_CLIP_PLANES, CONTEXT_INT(Const.MaxClipPlanes), NO_EXTRA },
    { GL_VERTEX_ARRAY_BINDING, ARRAY_INT(Name), NO_EXTRA },
    { GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, CONTEXT_FLOAT(Const.MaxTextureMaxAnisotropy), extra_EXT_texture_filter_anisotropic },
    { GL_DEBUG_OUTPUT, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_DEBUG_OUTPUT_SYNCHRONOUS, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_DEBUG_LOGGED_MESSAGES, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MAX_DEBUG_LOGGED_MESSAGES, CONST(MAX_DEBUG_LOGGED_MESSAGES), NO_EXTRA },
    { GL_MAX_DEBUG_MESSAGE_LENGTH, CONST(MAX_DEBUG_MESSAGE_LENGTH), NO_EXTRA },
    { GL_MAX_LABEL_LENGTH, CONST(MAX_LABEL_LENGTH), NO_EXTRA },
    { GL_MAX_DEBUG_GROUP_STACK_DEPTH, CONST(MAX_DEBUG_GROUP_STACK_DEPTH), NO_EXTRA },
    { GL_DEBUG_GROUP_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_POLYGON_OFFSET_CLAMP_EXT, CONTEXT_FLOAT(Polygon.OffsetClamp), extra_ARB_polygon_offset_clamp },
    { GL_NUM_DEVICE_UUIDS_EXT, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_DRIVER_UUID_EXT, LOC_CUSTOM, TYPE_INT_4, NO_OFFSET, NO_EXTRA },
    { GL_DEVICE_UUID_EXT, LOC_CUSTOM, TYPE_INT_4, NO_OFFSET, NO_EXTRA },
    { GL_DEVICE_LUID_EXT, LOC_CUSTOM, TYPE_INT_2, NO_OFFSET, NO_EXTRA },
    { GL_DEVICE_NODE_MASK_EXT, LOC_CUSTOM, TYPE_INT_4, NO_OFFSET, NO_EXTRA },
    { GL_MAX_LIGHTS, CONTEXT_INT(Const.MaxLights), NO_EXTRA },
    { GL_LIGHT0, CONTEXT_BOOL(Light.Light[0].Enabled), NO_EXTRA },
    { GL_LIGHT1, CONTEXT_BOOL(Light.Light[1].Enabled), NO_EXTRA },
    { GL_LIGHT2, CONTEXT_BOOL(Light.Light[2].Enabled), NO_EXTRA },
    { GL_LIGHT3, CONTEXT_BOOL(Light.Light[3].Enabled), NO_EXTRA },
    { GL_LIGHT4, CONTEXT_BOOL(Light.Light[4].Enabled), NO_EXTRA },
    { GL_LIGHT5, CONTEXT_BOOL(Light.Light[5].Enabled), NO_EXTRA },
    { GL_LIGHT6, CONTEXT_BOOL(Light.Light[6].Enabled), NO_EXTRA },
    { GL_LIGHT7, CONTEXT_BOOL(Light.Light[7].Enabled), NO_EXTRA },
    { GL_LIGHTING, CONTEXT_BOOL(Light.Enabled), NO_EXTRA },
    { GL_LIGHT_MODEL_AMBIENT, CONTEXT_FIELD(Light.Model.Ambient[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_LIGHT_MODEL_TWO_SIDE, CONTEXT_BOOL(Light.Model.TwoSide), NO_EXTRA },
    { GL_ALPHA_TEST, CONTEXT_BOOL(Color.AlphaEnabled), NO_EXTRA },
    { GL_ALPHA_TEST_FUNC, CONTEXT_ENUM16(Color.AlphaFunc), NO_EXTRA },
    { GL_ALPHA_TEST_REF, LOC_CUSTOM, TYPE_FLOATN, 0, NO_EXTRA },
    { GL_BLEND_DST, CONTEXT_ENUM16(Color.Blend[0].DstRGB), NO_EXTRA },
    { GL_CLIP_DISTANCE0, CONTEXT_BIT0(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE1, CONTEXT_BIT1(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE2, CONTEXT_BIT2(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE3, CONTEXT_BIT3(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE4, CONTEXT_BIT4(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE5, CONTEXT_BIT5(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE6, CONTEXT_BIT6(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE7, CONTEXT_BIT7(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_COLOR_MATERIAL, CONTEXT_BOOL(Light.ColorMaterialEnabled), NO_EXTRA },
    { GL_CURRENT_COLOR, CONTEXT_FIELD(Current.Attrib[VERT_ATTRIB_COLOR0][0], TYPE_FLOATN_4), extra_flush_current },
    { GL_CURRENT_NORMAL, CONTEXT_FIELD(Current.Attrib[VERT_ATTRIB_NORMAL][0], TYPE_FLOATN_3), extra_flush_current },
    { GL_CURRENT_TEXTURE_COORDS, LOC_CUSTOM, TYPE_FLOAT_4, 0, extra_flush_current_valid_texture_unit },
    { GL_POINT_DISTANCE_ATTENUATION, CONTEXT_FLOAT3(Point.Params[0]), NO_EXTRA },
    { GL_FOG, CONTEXT_BOOL(Fog.Enabled), NO_EXTRA },
    { GL_FOG_COLOR, LOC_CUSTOM, TYPE_FLOATN_4, 0, NO_EXTRA },
    { GL_FOG_DENSITY, CONTEXT_FLOAT(Fog.Density), NO_EXTRA },
    { GL_FOG_END, CONTEXT_FLOAT(Fog.End), NO_EXTRA },
    { GL_FOG_HINT, CONTEXT_ENUM16(Hint.Fog), NO_EXTRA },
    { GL_FOG_MODE, CONTEXT_ENUM16(Fog.Mode), NO_EXTRA },
    { GL_FOG_START, CONTEXT_FLOAT(Fog.Start), NO_EXTRA },
    { GL_LINE_SMOOTH, CONTEXT_BOOL(Line.SmoothFlag), NO_EXTRA },
    { GL_LINE_SMOOTH_HINT, CONTEXT_ENUM16(Hint.LineSmooth), NO_EXTRA },
    { GL_LINE_WIDTH_RANGE, CONTEXT_FLOAT2(Const.MinLineWidthAA), NO_EXTRA },
    { GL_COLOR_LOGIC_OP, CONTEXT_BOOL(Color.ColorLogicOpEnabled), NO_EXTRA },
    { GL_LOGIC_OP_MODE, CONTEXT_ENUM16(Color.LogicOp), NO_EXTRA },
    { GL_MATRIX_MODE, CONTEXT_ENUM16(Transform.MatrixMode), NO_EXTRA },
    { GL_MAX_MODELVIEW_STACK_DEPTH, CONST(MAX_MODELVIEW_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_PROJECTION_STACK_DEPTH, CONST(MAX_PROJECTION_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_TEXTURE_STACK_DEPTH, CONST(MAX_TEXTURE_STACK_DEPTH), NO_EXTRA },
    { GL_MODELVIEW_MATRIX, CONTEXT_MATRIX(ModelviewMatrixStack.Top), NO_EXTRA },
    { GL_MODELVIEW_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, ModelviewMatrixStack.Depth), NO_EXTRA },
    { GL_NORMALIZE, CONTEXT_BOOL(Transform.Normalize), NO_EXTRA },
    { GL_PACK_SKIP_IMAGES, CONTEXT_INT(Pack.SkipImages), NO_EXTRA },
    { GL_PERSPECTIVE_CORRECTION_HINT, CONTEXT_ENUM16(Hint.PerspectiveCorrection), NO_EXTRA },
    { GL_POINT_SIZE, CONTEXT_FLOAT(Point.Size), NO_EXTRA },
    { GL_POINT_SIZE_RANGE, CONTEXT_FLOAT2(Const.MinPointSizeAA), NO_EXTRA },
    { GL_POINT_SMOOTH, CONTEXT_BOOL(Point.SmoothFlag), NO_EXTRA },
    { GL_POINT_SMOOTH_HINT, CONTEXT_ENUM16(Hint.PointSmooth), NO_EXTRA },
    { GL_POINT_SIZE_MIN_EXT, CONTEXT_FLOAT(Point.MinSize), NO_EXTRA },
    { GL_POINT_SIZE_MAX_EXT, CONTEXT_FLOAT(Point.MaxSize), NO_EXTRA },
    { GL_POINT_FADE_THRESHOLD_SIZE_EXT, CONTEXT_FLOAT(Point.Threshold), NO_EXTRA },
    { GL_PROJECTION_MATRIX, CONTEXT_MATRIX(ProjectionMatrixStack.Top), NO_EXTRA },
    { GL_PROJECTION_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, ProjectionMatrixStack.Depth), NO_EXTRA },
    { GL_RESCALE_NORMAL, CONTEXT_BOOL(Transform.RescaleNormals), NO_EXTRA },
    { GL_SHADE_MODEL, CONTEXT_ENUM16(Light.ShadeModel), NO_EXTRA },
    { GL_TEXTURE_2D, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_TEXTURE_MATRIX, LOC_CUSTOM, TYPE_MATRIX, 0, extra_valid_texture_unit },
    { GL_TEXTURE_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, 0, extra_valid_texture_unit },
    { GL_VERTEX_ARRAY, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_VERTEX_ARRAY_SIZE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_VERTEX_ARRAY_TYPE, ARRAY_ENUM16(VertexAttrib[VERT_ATTRIB_POS].Format.User.Type), NO_EXTRA },
    { GL_VERTEX_ARRAY_STRIDE, ARRAY_SHORT(VertexAttrib[VERT_ATTRIB_POS].Stride), NO_EXTRA },
    { GL_NORMAL_ARRAY, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_NORMAL_ARRAY_TYPE, ARRAY_ENUM16(VertexAttrib[VERT_ATTRIB_NORMAL].Format.User.Type), NO_EXTRA },
    { GL_NORMAL_ARRAY_STRIDE, ARRAY_SHORT(VertexAttrib[VERT_ATTRIB_NORMAL].Stride), NO_EXTRA },
    { GL_COLOR_ARRAY, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_COLOR_ARRAY_SIZE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_COLOR_ARRAY_TYPE, ARRAY_ENUM16(VertexAttrib[VERT_ATTRIB_COLOR0].Format.User.Type), NO_EXTRA },
    { GL_COLOR_ARRAY_STRIDE, ARRAY_SHORT(VertexAttrib[VERT_ATTRIB_COLOR0].Stride), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_SIZE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_TYPE, LOC_CUSTOM, TYPE_ENUM16, offsetof(struct gl_array_attributes, Format.User.Type), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_STRIDE, LOC_CUSTOM, TYPE_SHORT, offsetof(struct gl_array_attributes, Stride), NO_EXTRA },
    { GL_MAX_TEXTURE_UNITS, CONTEXT_INT(Const.MaxTextureUnits), NO_EXTRA },
    { GL_CLIENT_ACTIVE_TEXTURE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_TEXTURE_CUBE_MAP_ARB, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_TEXTURE_GEN_STR_OES, LOC_TEXUNIT, TYPE_BIT_0, offsetof(struct gl_fixedfunc_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_MULTISAMPLE_ARB, CONTEXT_BOOL(Multisample.Enabled), NO_EXTRA },
    { GL_SAMPLE_ALPHA_TO_ONE_ARB, CONTEXT_BOOL(Multisample.SampleAlphaToOne), NO_EXTRA },
    { GL_VERTEX_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, BufferBinding[VERT_ATTRIB_POS].BufferObj), NO_EXTRA },
    { GL_NORMAL_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, BufferBinding[VERT_ATTRIB_NORMAL].BufferObj), NO_EXTRA },
    { GL_COLOR_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, BufferBinding[VERT_ATTRIB_COLOR0].BufferObj), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_POINT_SPRITE, CONTEXT_BOOL(Point.PointSprite), NO_EXTRA },
    { GL_POINT_SIZE_ARRAY_OES, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_POINT_SIZE_ARRAY_TYPE_OES, ARRAY_FIELD(VertexAttrib[VERT_ATTRIB_POINT_SIZE].Format.User.Type, TYPE_ENUM16), NO_EXTRA },
    { GL_POINT_SIZE_ARRAY_STRIDE_OES, ARRAY_FIELD(VertexAttrib[VERT_ATTRIB_POINT_SIZE].Stride, TYPE_SHORT), NO_EXTRA },
    { GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_RED_BITS, BUFFER_INT(Visual.redBits), extra_new_buffers_compat_es },
    { GL_GREEN_BITS, BUFFER_INT(Visual.greenBits), extra_new_buffers_compat_es },
    { GL_BLUE_BITS, BUFFER_INT(Visual.blueBits), extra_new_buffers_compat_es },
    { GL_DEPTH_BITS, BUFFER_INT(Visual.depthBits), extra_new_buffers_compat_es },
    { GL_STENCIL_BITS, BUFFER_INT(Visual.stencilBits), extra_new_buffers_compat_es },
    { GL_GPU_DISJOINT_EXT, LOC_CUSTOM, TYPE_INT, 0, extra_EXT_disjoint_timer_query },
    { GL_PACK_REVERSE_ROW_ORDER_ANGLE, CONTEXT_BOOL(Pack.Invert), NO_EXTRA },
    { GL_MAX_TEXTURE_COORDS_ARB, CONTEXT_INT(Const.MaxTextureCoordUnits), extra_ARB_fragment_program },
    { GL_PACK_IMAGE_HEIGHT, CONTEXT_INT(Pack.ImageHeight), NO_EXTRA },
    { GL_PACK_ROW_LENGTH, CONTEXT_INT(Pack.RowLength), NO_EXTRA },
    { GL_PACK_SKIP_PIXELS, CONTEXT_INT(Pack.SkipPixels), NO_EXTRA },
    { GL_PACK_SKIP_ROWS, CONTEXT_INT(Pack.SkipRows), NO_EXTRA },
    { GL_UNPACK_ROW_LENGTH, CONTEXT_INT(Unpack.RowLength), NO_EXTRA },
    { GL_UNPACK_SKIP_PIXELS, CONTEXT_INT(Unpack.SkipPixels), NO_EXTRA },
    { GL_UNPACK_SKIP_ROWS, CONTEXT_INT(Unpack.SkipRows), NO_EXTRA },
    { GL_UNPACK_SKIP_IMAGES, CONTEXT_INT(Unpack.SkipImages), NO_EXTRA },
    { GL_UNPACK_IMAGE_HEIGHT, CONTEXT_INT(Unpack.ImageHeight), NO_EXTRA },
    { GL_CLIP_DEPTH_MODE, CONTEXT_ENUM16(Transform.ClipDepthMode), extra_ARB_clip_control },
    { GL_CLIP_ORIGIN, CONTEXT_ENUM16(Transform.ClipOrigin), extra_ARB_clip_control },
    { GL_MAX_DRAW_BUFFERS_ARB, CONTEXT_INT(Const.MaxDrawBuffers), NO_EXTRA },
    { GL_MAX_SHADER_COMPILER_THREADS_ARB, CONTEXT_INT(Hint.MaxShaderCompilerThreads), NO_EXTRA },
    { GL_MAX_COLOR_ATTACHMENTS, CONTEXT_INT(Const.MaxColorAttachments), NO_EXTRA },
    { GL_DRAW_BUFFER0_ARB, BUFFER_ENUM16(ColorDrawBuffer[0]), NO_EXTRA },
    { GL_DRAW_BUFFER1_ARB, BUFFER_ENUM16(ColorDrawBuffer[1]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER2_ARB, BUFFER_ENUM16(ColorDrawBuffer[2]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER3_ARB, BUFFER_ENUM16(ColorDrawBuffer[3]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER4_ARB, BUFFER_ENUM16(ColorDrawBuffer[4]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER5_ARB, BUFFER_ENUM16(ColorDrawBuffer[5]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER6_ARB, BUFFER_ENUM16(ColorDrawBuffer[6]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER7_ARB, BUFFER_ENUM16(ColorDrawBuffer[7]), extra_valid_draw_buffer },
    { GL_BLEND_COLOR_EXT, LOC_CUSTOM, TYPE_FLOATN_4, 0, NO_EXTRA },
    { GL_MAX_TEXTURE_IMAGE_UNITS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxTextureImageUnits), extra_ARB_fragment_program },
    { GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxTextureImageUnits), extra_ARB_vertex_shader },
    { GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB, CONTEXT_INT(Const.MaxCombinedTextureImageUnits), extra_ARB_vertex_shader },
    { GL_CURRENT_PROGRAM, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_STENCIL_BACK_FUNC, CONTEXT_ENUM16(Stencil.Function[1]), NO_EXTRA },
    { GL_STENCIL_BACK_VALUE_MASK, CONTEXT_UINT(Stencil.ValueMask[1]), NO_EXTRA },
    { GL_STENCIL_BACK_WRITEMASK, CONTEXT_UINT(Stencil.WriteMask[1]), NO_EXTRA },
    { GL_STENCIL_BACK_REF, LOC_CUSTOM, TYPE_UINT, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_BACK_FAIL, CONTEXT_ENUM16(Stencil.FailFunc[1]), NO_EXTRA },
    { GL_STENCIL_BACK_PASS_DEPTH_FAIL, CONTEXT_ENUM16(Stencil.ZFailFunc[1]), NO_EXTRA },
    { GL_STENCIL_BACK_PASS_DEPTH_PASS, CONTEXT_ENUM16(Stencil.ZPassFunc[1]), NO_EXTRA },
    { GL_MAX_VERTEX_ATTRIBS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxAttribs), extra_ARB_vertex_program_api_es2 },
    { GL_TEXTURE_BINDING_3D, LOC_CUSTOM, TYPE_INT, TEXTURE_3D_INDEX, NO_EXTRA },
    { GL_MAX_3D_TEXTURE_SIZE, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, Const.Max3DTextureLevels), NO_EXTRA },
    { GL_FRAGMENT_SHADER_DERIVATIVE_HINT, CONTEXT_ENUM16(Hint.FragmentShaderDerivative), extra_ARB_fragment_shader },
    { GL_READ_BUFFER, LOC_CUSTOM, TYPE_ENUM16, NO_OFFSET, extra_NV_read_buffer_api_gl },
    { GL_SHADER_COMPILER, CONST(1), extra_ARB_ES2_compatibility_api_es2 },
    { GL_MAX_VARYING_VECTORS, CONTEXT_INT(Const.MaxVarying), extra_ARB_ES2_compatibility_api_es2 },
    { GL_MAX_VERTEX_UNIFORM_VECTORS, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_ES2_compatibility_api_es2 },
    { GL_MAX_FRAGMENT_UNIFORM_VECTORS, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_ES2_compatibility_api_es2 },
    { GL_NUM_SHADER_BINARY_FORMATS, CONTEXT_UINT(Const.NumShaderBinaryFormats), extra_ARB_gl_spirv_or_es2_compat },
    { GL_SHADER_BINARY_FORMATS, LOC_CUSTOM, TYPE_INT_N, 0, extra_ARB_gl_spirv_or_es2_compat },
    { GL_NUM_PROGRAM_BINARY_FORMATS, CONTEXT_UINT(Const.NumProgramBinaryFormats), NO_EXTRA },
    { GL_PROGRAM_BINARY_FORMATS, LOC_CUSTOM, TYPE_INT_N, 0, NO_EXTRA },
    { GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL, CONST(MAX_PERFQUERY_QUERY_NAME_LENGTH), extra_INTEL_performance_query },
    { GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL, CONST(MAX_PERFQUERY_COUNTER_NAME_LENGTH), extra_INTEL_performance_query },
    { GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL, CONST(MAX_PERFQUERY_COUNTER_DESC_LENGTH), extra_INTEL_performance_query },
    { GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL, CONST(PERFQUERY_HAVE_GPA_EXTENDED_COUNTERS), extra_INTEL_performance_query },
    { GL_CONTEXT_RELEASE_BEHAVIOR, CONTEXT_ENUM16(Const.ContextReleaseBehavior), NO_EXTRA },
    { GL_MAX_DUAL_SOURCE_DRAW_BUFFERS, CONTEXT_INT(Const.MaxDualSourceDrawBuffers), extra_ARB_blend_func_extended },
    { GL_BLEND_ADVANCED_COHERENT_KHR, CONTEXT_BOOL(Color.BlendCoherent), extra_KHR_blend_equation_advanced_coherent },
    { GL_CONTEXT_ROBUST_ACCESS, CONTEXT_ENUM16(Const.RobustAccess), extra_KHR_robustness },
    { GL_RESET_NOTIFICATION_STRATEGY_ARB, CONTEXT_ENUM16(Const.ResetStrategy), extra_KHR_robustness_or_GL },
    { GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV, CONTEXT_UINT(SubpixelPrecisionBias[0]), extra_NV_conservative_raster },
    { GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV, CONTEXT_UINT(SubpixelPrecisionBias[1]), extra_NV_conservative_raster },
    { GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV, CONTEXT_UINT(Const.MaxSubpixelPrecisionBiasBits), extra_NV_conservative_raster },
    { GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV, CONTEXT_FLOAT2(Const.ConservativeRasterDilateRange), extra_NV_conservative_raster_dilate },
    { GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV, CONTEXT_FLOAT(Const.ConservativeRasterDilateGranularity), extra_NV_conservative_raster_dilate },
    { GL_CONSERVATIVE_RASTER_DILATE_NV, CONTEXT_FLOAT(ConservativeRasterDilate), extra_NV_conservative_raster_dilate },
    { GL_CONSERVATIVE_RASTER_MODE_NV, CONTEXT_ENUM16(ConservativeRasterMode), extra_NV_conservative_raster_pre_snap_triangles },
    { GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD, CONTEXT_INT(Const.MaxColorFramebufferSamples), extra_AMD_framebuffer_multisample_advanced },
    { GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD, CONTEXT_INT(Const.MaxColorFramebufferStorageSamples), extra_AMD_framebuffer_multisample_advanced },
    { GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD, CONTEXT_INT(Const.MaxDepthStencilFramebufferSamples), extra_AMD_framebuffer_multisample_advanced },
    { GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD, CONTEXT_INT(Const.NumSupportedMultisampleModes), extra_AMD_framebuffer_multisample_advanced },
    { GL_SUPPORTED_MULTISAMPLE_MODES_AMD, LOC_CUSTOM, TYPE_INT_N, 0, extra_AMD_framebuffer_multisample_advanced },
    { GL_ALPHA_TO_COVERAGE_DITHER_MODE_NV, CONTEXT_ENUM(Multisample.SampleAlphaToCoverageDitherControl ), NO_EXTRA },
    { GL_PIXEL_PACK_BUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_PIXEL_UNPACK_BUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MAX_SAMPLES, CONTEXT_INT(Const.MaxSamples), extra_ARB_framebuffer_object_or_EXT_framebuffer_multisample_or_EXT_multisampled_render_to_texture },
    { GL_MAX_TEXTURE_LOD_BIAS_EXT, CONTEXT_FLOAT(Const.MaxTextureLodBias), NO_EXTRA },
    { GL_TIMESTAMP, LOC_CUSTOM, TYPE_INT64, 0, extra_ARB_timer_query_or_EXT_disjoint_timer_query },
    { GL_NUM_EXTENSIONS, LOC_CUSTOM, TYPE_INT, 0, extra_gl30_es3 },
    { GL_MAJOR_VERSION, LOC_CUSTOM, TYPE_INT, 0, extra_gl30_es3 },
    { GL_MINOR_VERSION, LOC_CUSTOM, TYPE_INT, 0, extra_gl30_es3 },
    { GL_MAX_VERTEX_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxOutputComponents), extra_gl32_es3 },
    { GL_MAX_FRAGMENT_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxInputComponents), extra_gl32_es3 },
    { GL_MAX_ELEMENT_INDEX, CONTEXT_INT64(Const.MaxElementIndex), extra_ARB_ES3_compatibility_api_es3 },
    { GL_PRIMITIVE_RESTART_FIXED_INDEX, CONTEXT_BOOL(Array.PrimitiveRestartFixedIndex), extra_ARB_ES3_compatibility_api_es3 },
    { GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxUniformComponents), extra_ARB_fragment_shader },
    { GL_SAMPLER_BINDING, LOC_CUSTOM, TYPE_INT, GL_SAMPLER_BINDING, NO_EXTRA },
    { GL_NUM_SPIR_V_EXTENSIONS, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_spirv_extensions },
    { GL_MAX_SERVER_WAIT_TIMEOUT, CONTEXT_INT64(Const.MaxServerWaitTimeout), extra_ARB_sync },
    { GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_ARB_transform_feedback2_api_es3 },
    { GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_ARB_transform_feedback2_api_es3 },
    { GL_TRANSFORM_FEEDBACK_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_transform_feedback2_api_es3 },
    { GL_MAX_VERTEX_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxUniformBlocks), extra_ARB_uniform_buffer_object },
    { GL_MAX_FRAGMENT_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxUniformBlocks), extra_ARB_uniform_buffer_object },
    { GL_MAX_COMBINED_UNIFORM_BLOCKS, CONTEXT_INT(Const.MaxCombinedUniformBlocks), extra_ARB_uniform_buffer_object },
    { GL_MAX_UNIFORM_BLOCK_SIZE, CONTEXT_UINT(Const.MaxUniformBlockSize), extra_ARB_uniform_buffer_object },
    { GL_MAX_UNIFORM_BUFFER_BINDINGS, CONTEXT_INT(Const.MaxUniformBufferBindings), extra_ARB_uniform_buffer_object },
    { GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS, CONTEXT_INT64(Const.Program[MESA_SHADER_VERTEX].MaxCombinedUniformComponents), extra_ARB_uniform_buffer_object },
    { GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS, CONTEXT_INT64(Const.Program[MESA_SHADER_FRAGMENT].MaxCombinedUniformComponents), extra_ARB_uniform_buffer_object },
    { GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT, CONTEXT_INT(Const.UniformBufferOffsetAlignment), extra_ARB_uniform_buffer_object },
    { GL_UNIFORM_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_uniform_buffer_object },
    { GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxUniformComponents), extra_ARB_vertex_shader },
    { GL_MAX_VARYING_FLOATS_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_vertex_shader },
    { GL_READ_FRAMEBUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MIN_PROGRAM_TEXEL_OFFSET, CONTEXT_INT(Const.MinProgramTexelOffset), extra_GLSL_130_es3_gpushader4 },
    { GL_MAX_PROGRAM_TEXEL_OFFSET, CONTEXT_INT(Const.MaxProgramTexelOffset), extra_GLSL_130_es3_gpushader4 },
    { GL_TEXTURE_BINDING_2D_ARRAY, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_ARRAY_INDEX, extra_EXT_texture_array_es3 },
    { GL_MAX_ARRAY_TEXTURE_LAYERS_EXT, CONTEXT_INT(Const.MaxArrayTextureLayers), extra_EXT_texture_array_es3 },
    { GL_TRANSFORM_FEEDBACK_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_EXT_transform_feedback },
    { GL_RASTERIZER_DISCARD, CONTEXT_BOOL(RasterDiscard), extra_EXT_transform_feedback },
    { GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS, CONTEXT_INT(Const.MaxTransformFeedbackInterleavedComponents), extra_EXT_transform_feedback },
    { GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS, CONTEXT_INT(Const.MaxTransformFeedbackBuffers), extra_EXT_transform_feedback },
    { GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS, CONTEXT_INT(Const.MaxTransformFeedbackSeparateComponents), extra_EXT_transform_feedback },
    { GL_MAX_WINDOW_RECTANGLES_EXT, CONTEXT_INT(Const.MaxWindowRectangles), extra_EXT_window_rectangles },
    { GL_NUM_WINDOW_RECTANGLES_EXT, CONTEXT_INT(Scissor.NumWindowRects), extra_EXT_window_rectangles },
    { GL_WINDOW_RECTANGLE_MODE_EXT, CONTEXT_ENUM16(Scissor.WindowRectMode), extra_EXT_window_rectangles },
    { GL_MIN_FRAGMENT_INTERPOLATION_OFFSET, CONTEXT_FLOAT(Const.MinFragmentInterpolationOffset), extra_ARB_gpu_shader5_or_OES_sample_variables },
    { GL_MAX_FRAGMENT_INTERPOLATION_OFFSET, CONTEXT_FLOAT(Const.MaxFragmentInterpolationOffset), extra_ARB_gpu_shader5_or_OES_sample_variables },
    { GL_FRAGMENT_INTERPOLATION_OFFSET_BITS, CONST(FRAGMENT_INTERPOLATION_OFFSET_BITS), extra_ARB_gpu_shader5_or_OES_sample_variables },
    { GL_FRAMEBUFFER_SRGB_EXT, CONTEXT_BOOL(Color.sRGBEnabled), extra_EXT_framebuffer_sRGB },
    { GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT, CONTEXT_BOOL(Extensions.EXT_shader_framebuffer_fetch), extra_EXT_shader_framebuffer_fetch },
    { GL_TEXTURE_BINDING_EXTERNAL_OES, LOC_CUSTOM, TYPE_INT, TEXTURE_EXTERNAL_INDEX, extra_OES_EGL_image_external },
    { GL_TEXTURE_EXTERNAL_OES, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_OES_EGL_image_external },
    { GL_MAX_TEXTURE_BUFFER_SIZE_ARB, CONTEXT_UINT(Const.MaxTextureBufferSize), extra_texture_buffer_object },
    { GL_TEXTURE_BINDING_BUFFER_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB, LOC_CUSTOM, TYPE_INT, TEXTURE_BUFFER_INDEX, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_FORMAT_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT, CONTEXT_INT(Const.TextureBufferOffsetAlignment), extra_ARB_texture_buffer_range },
    { GL_MAX_IMAGE_UNITS, CONTEXT_INT(Const.MaxImageUnits), extra_ARB_shader_image_load_store_es31 },
    { GL_MAX_VERTEX_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxImageUniforms), extra_ARB_shader_image_load_store_es31 },
    { GL_MAX_FRAGMENT_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxImageUniforms), extra_ARB_shader_image_load_store_es31 },
    { GL_MAX_COMBINED_IMAGE_UNIFORMS, CONTEXT_INT(Const.MaxCombinedImageUniforms), extra_ARB_shader_image_load_store_es31 },
    { GL_ATOMIC_COUNTER_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS, CONTEXT_INT(Const.MaxAtomicBufferBindings), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE, CONTEXT_INT(Const.MaxAtomicBufferSize), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_VERTEX_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxAtomicCounters), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_FRAGMENT_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxAtomicCounters), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.MaxCombinedAtomicBuffers), extra_ARB_shader_atomic_counters_es31 },
    { GL_MAX_COMBINED_ATOMIC_COUNTERS, CONTEXT_INT(Const.MaxCombinedAtomicCounters), extra_ARB_shader_atomic_counters_es31 },
    { GL_TEXTURE_BINDING_2D_MULTISAMPLE, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_MULTISAMPLE_INDEX, extra_ARB_texture_multisample },
    { GL_MAX_COLOR_TEXTURE_SAMPLES, CONTEXT_INT(Const.MaxColorTextureSamples), extra_ARB_texture_multisample },
    { GL_MAX_DEPTH_TEXTURE_SAMPLES, CONTEXT_INT(Const.MaxDepthTextureSamples), extra_ARB_texture_multisample },
    { GL_MAX_INTEGER_SAMPLES, CONTEXT_INT(Const.MaxIntegerSamples), extra_ARB_texture_multisample },
    { GL_SAMPLE_MASK, CONTEXT_BOOL(Multisample.SampleMask), extra_ARB_texture_multisample },
    { GL_MAX_SAMPLE_MASK_WORDS, CONST(1), extra_ARB_texture_multisample },
    { GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_MULTISAMPLE_ARRAY_INDEX, extra_ARB_texture_multisample },
    { GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET, CONTEXT_INT(Const.MinProgramTextureGatherOffset), extra_ARB_texture_gather },
    { GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET, CONTEXT_INT(Const.MaxProgramTextureGatherOffset), extra_ARB_texture_gather },
    { GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS, CONTEXT_INT(Const.MaxComputeWorkGroupInvocations), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxUniformBlocks), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxTextureImageUnits), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxAtomicBuffers), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxAtomicCounters), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_SHARED_MEMORY_SIZE, CONTEXT_INT(Const.MaxComputeSharedMemorySize), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxUniformComponents), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxImageUniforms), extra_ARB_compute_shader_es31 },
    { GL_DISPATCH_INDIRECT_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_compute_shader_es31 },
    { GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS, CONTEXT_INT64(Const.Program[MESA_SHADER_COMPUTE].MaxCombinedUniformComponents), extra_ARB_compute_shader_es31 },
    { GL_MAX_FRAMEBUFFER_WIDTH, CONTEXT_INT(Const.MaxFramebufferWidth), extra_ARB_framebuffer_no_attachments },
    { GL_MAX_FRAMEBUFFER_HEIGHT, CONTEXT_INT(Const.MaxFramebufferHeight), extra_ARB_framebuffer_no_attachments },
    { GL_MAX_FRAMEBUFFER_SAMPLES, CONTEXT_INT(Const.MaxFramebufferSamples), extra_ARB_framebuffer_no_attachments },
    { GL_MAX_FRAMEBUFFER_LAYERS, CONTEXT_INT(Const.MaxFramebufferLayers), extra_ARB_framebuffer_no_attachments_and_geometry_shader },
    { GL_MAX_UNIFORM_LOCATIONS, CONTEXT_INT(Const.MaxUserAssignableUniformLocations), extra_ARB_explicit_uniform_location },
    { GL_PROGRAM_PIPELINE_BINDING, LOC_CUSTOM, TYPE_INT, GL_PROGRAM_PIPELINE_BINDING, NO_EXTRA },
    { GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET, CONTEXT_INT(Const.MaxVertexAttribRelativeOffset), NO_EXTRA },
    { GL_MAX_VERTEX_ATTRIB_BINDINGS, CONTEXT_INT(Const.MaxVertexAttribBindings), NO_EXTRA },
    { GL_MAX_VERTEX_ATTRIB_STRIDE, CONTEXT_UINT(Const.MaxVertexAttribStride), NO_EXTRA },
    { GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.MaxCombinedShaderStorageBlocks), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_SHADER_STORAGE_BLOCK_SIZE, CONTEXT_UINT(Const.MaxShaderStorageBlockSize), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS, CONTEXT_INT(Const.MaxShaderStorageBufferBindings), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT, CONTEXT_INT(Const.ShaderStorageBufferOffsetAlignment), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_SHADER_STORAGE_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES, CONTEXT_INT(Const.MaxCombinedShaderOutputResources), extra_ARB_shader_image_load_store_shader_storage_buffer_object_es31 },
    { GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB, LOC_CUSTOM, TYPE_INT, TEXTURE_CUBE_ARRAY_INDEX, extra_ARB_texture_cube_map_array_OES_texture_cube_map_array },
    { GL_NUM_SHADING_LANGUAGE_VERSIONS, LOC_CUSTOM, TYPE_INT, 0, extra_version_43 },
    { GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB, LOC_CUSTOM, TYPE_UINT, 0, extra_ARB_sample_locations },
    { GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB, LOC_CUSTOM, TYPE_UINT, 0, extra_ARB_sample_locations },
    { GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB, LOC_CUSTOM, TYPE_UINT, 0, extra_ARB_sample_locations },
    { GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB, LOC_CUSTOM, TYPE_UINT, 0, extra_ARB_sample_locations },
    { GL_DRAW_INDIRECT_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_draw_indirect },
    { GL_MAX_GEOMETRY_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxInputComponents), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxOutputComponents), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxTextureImageUnits), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_OUTPUT_VERTICES, CONTEXT_INT(Const.MaxGeometryOutputVertices), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS, CONTEXT_INT(Const.MaxGeometryTotalOutputComponents), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxUniformComponents), extra_version_32_OES_geometry_shader },
    { GL_PATCH_VERTICES, CONTEXT_INT(TessCtrlProgram.patch_vertices), extra_ARB_tessellation_shader },
    { GL_PATCH_DEFAULT_OUTER_LEVEL, CONTEXT_FLOAT4(TessCtrlProgram.patch_default_outer_level), extra_ARB_tessellation_shader },
    { GL_PATCH_DEFAULT_INNER_LEVEL, CONTEXT_FLOAT2(TessCtrlProgram.patch_default_inner_level), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_GEN_LEVEL, CONTEXT_INT(Const.MaxTessGenLevel), extra_ARB_tessellation_shader },
    { GL_MAX_PATCH_VERTICES, CONTEXT_INT(Const.MaxPatchVertices), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxUniformComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxUniformComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxTextureImageUnits), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxTextureImageUnits), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxOutputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_PATCH_COMPONENTS, CONTEXT_INT(Const.MaxTessPatchComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS, CONTEXT_INT(Const.MaxTessControlTotalOutputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxOutputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxInputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxInputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxUniformBlocks), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxUniformBlocks), extra_ARB_tessellation_shader },
    { GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS, CONTEXT_INT64(Const.Program[MESA_SHADER_TESS_CTRL].MaxCombinedUniformComponents), extra_ARB_tessellation_shader },
    { GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS, CONTEXT_INT64(Const.Program[MESA_SHADER_TESS_EVAL].MaxCombinedUniformComponents), extra_ARB_tessellation_shader },
    { GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED, CONTEXT_BOOL(Const.PrimitiveRestartForPatches), extra_ARB_tessellation_shader },
    { GL_MAX_GEOMETRY_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxImageUniforms), extra_ARB_shader_image_load_store_and_geometry_shader },
    { GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxImageUniforms), extra_ARB_shader_image_load_store_and_tessellation },
    { GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxImageUniforms), extra_ARB_shader_image_load_store_and_tessellation },
    { GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_and_geometry_shader  },
    { GL_MAX_GEOMETRY_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxAtomicCounters), extra_ARB_shader_atomic_counters_and_geometry_shader },
    { GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxAtomicCounters), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxAtomicCounters), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object_and_geometry_shader },
    { GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object },
    { GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object },
    { GL_MAX_GEOMETRY_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxUniformBlocks), extra_ARB_uniform_buffer_object_and_geometry_shader },
    { GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS, CONTEXT_INT64(Const.Program[MESA_SHADER_GEOMETRY].MaxCombinedUniformComponents), extra_ARB_uniform_buffer_object_and_geometry_shader },
    { GL_LAYER_PROVOKING_VERTEX, CONTEXT_ENUM16(Const.LayerAndVPIndexProvokingVertex), extra_ARB_viewport_array_or_oes_geometry_shader },
    { GL_MAX_GEOMETRY_SHADER_INVOCATIONS, CONTEXT_INT(Const.MaxGeometryShaderInvocations), extra_ARB_gpu_shader5_or_oes_geometry_shader },
    { GL_PRIMITIVE_BOUNDING_BOX_ARB, CONTEXT_FLOAT8(PrimitiveBoundingBox), extra_OES_primitive_bounding_box },
    { GL_MAX_VIEWPORTS, CONTEXT_INT(Const.MaxViewports), extra_ARB_viewport_array_or_oes_viewport_array },
    { GL_VIEWPORT_SUBPIXEL_BITS, CONTEXT_INT(Const.ViewportSubpixelBits), extra_ARB_viewport_array_or_oes_viewport_array },
    { GL_VIEWPORT_BOUNDS_RANGE, CONTEXT_FLOAT2(Const.ViewportBounds), extra_ARB_viewport_array_or_oes_viewport_array },
    { GL_VIEWPORT_INDEX_PROVOKING_VERTEX, CONTEXT_ENUM16(Const.LayerAndVPIndexProvokingVertex), extra_ARB_viewport_array_or_oes_viewport_array },
    { GL_CONSERVATIVE_RASTERIZATION_INTEL, CONTEXT_BOOL(IntelConservativeRasterization), extra_INTEL_conservative_rasterization },
    { GL_VIEWPORT_SWIZZLE_X_NV, LOC_CUSTOM, TYPE_ENUM, 0, extra_NV_viewport_swizzle },
    { GL_VIEWPORT_SWIZZLE_Y_NV, LOC_CUSTOM, TYPE_ENUM, 0, extra_NV_viewport_swizzle },
    { GL_VIEWPORT_SWIZZLE_Z_NV, LOC_CUSTOM, TYPE_ENUM, 0, extra_NV_viewport_swizzle },
    { GL_VIEWPORT_SWIZZLE_W_NV, LOC_CUSTOM, TYPE_ENUM, 0, extra_NV_viewport_swizzle },
    { GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB, CONTEXT_FLOAT2(Const.MinLineWidthAA), extra_ES32 },
    { GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB, CONTEXT_FLOAT(Const.LineWidthGranularity), extra_ES32 },
    { GL_CONTEXT_FLAGS, CONTEXT_INT(Const.ContextFlags), extra_version_30 },
    { GL_ACCUM_RED_BITS, BUFFER_INT(Visual.accumRedBits), NO_EXTRA },
    { GL_ACCUM_GREEN_BITS, BUFFER_INT(Visual.accumGreenBits), NO_EXTRA },
    { GL_ACCUM_BLUE_BITS, BUFFER_INT(Visual.accumBlueBits), NO_EXTRA },
    { GL_ACCUM_ALPHA_BITS, BUFFER_INT(Visual.accumAlphaBits), NO_EXTRA },
    { GL_ACCUM_CLEAR_VALUE, CONTEXT_FIELD(Accum.ClearColor[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_ALPHA_BIAS, CONTEXT_FLOAT(Pixel.AlphaBias), NO_EXTRA },
    { GL_ALPHA_SCALE, CONTEXT_FLOAT(Pixel.AlphaScale), NO_EXTRA },
    { GL_ATTRIB_STACK_DEPTH, CONTEXT_INT(AttribStackDepth), NO_EXTRA },
    { GL_AUTO_NORMAL, CONTEXT_BOOL(Eval.AutoNormal), NO_EXTRA },
    { GL_AUX_BUFFERS, CONST(0), NO_EXTRA },
    { GL_BLUE_BIAS, CONTEXT_FLOAT(Pixel.BlueBias), NO_EXTRA },
    { GL_BLUE_SCALE, CONTEXT_FLOAT(Pixel.BlueScale), NO_EXTRA },
    { GL_CLIENT_ATTRIB_STACK_DEPTH, CONTEXT_INT(ClientAttribStackDepth), NO_EXTRA },
    { GL_COLOR_MATERIAL_FACE, CONTEXT_ENUM16(Light.ColorMaterialFace), NO_EXTRA },
    { GL_COLOR_MATERIAL_PARAMETER, CONTEXT_ENUM16(Light.ColorMaterialMode), NO_EXTRA },
    { GL_CURRENT_INDEX, CONTEXT_FLOAT(Current.Attrib[VERT_ATTRIB_COLOR_INDEX][0]), extra_flush_current },
    { GL_CURRENT_RASTER_COLOR, CONTEXT_FIELD(Current.RasterColor[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_CURRENT_RASTER_DISTANCE, CONTEXT_FLOAT(Current.RasterDistance), NO_EXTRA },
    { GL_CURRENT_RASTER_INDEX, CONST(1), NO_EXTRA },
    { GL_CURRENT_RASTER_POSITION, CONTEXT_FLOAT4(Current.RasterPos[0]), NO_EXTRA },
    { GL_CURRENT_RASTER_SECONDARY_COLOR, CONTEXT_FIELD(Current.RasterSecondaryColor[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_CURRENT_RASTER_TEXTURE_COORDS, LOC_CUSTOM, TYPE_FLOAT_4, 0, extra_valid_texture_unit },
    { GL_CURRENT_RASTER_POSITION_VALID, CONTEXT_BOOL(Current.RasterPosValid), NO_EXTRA },
    { GL_DEPTH_BIAS, CONTEXT_FLOAT(Pixel.DepthBias), NO_EXTRA },
    { GL_DEPTH_SCALE, CONTEXT_FLOAT(Pixel.DepthScale), NO_EXTRA },
    { GL_DOUBLEBUFFER, BUFFER_INT(Visual.doubleBufferMode), NO_EXTRA },
    { GL_DRAW_BUFFER, BUFFER_ENUM16(ColorDrawBuffer[0]), NO_EXTRA },
    { GL_EDGE_FLAG, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_flush_current },
    { GL_FEEDBACK_BUFFER_SIZE, CONTEXT_INT(Feedback.BufferSize), NO_EXTRA },
    { GL_FEEDBACK_BUFFER_TYPE, CONTEXT_ENUM16(Feedback.Type), NO_EXTRA },
    { GL_FOG_INDEX, CONTEXT_FLOAT(Fog.Index), NO_EXTRA },
    { GL_GREEN_BIAS, CONTEXT_FLOAT(Pixel.GreenBias), NO_EXTRA },
    { GL_GREEN_SCALE, CONTEXT_FLOAT(Pixel.GreenScale), NO_EXTRA },
    { GL_INDEX_BITS, CONST(0), NO_EXTRA },
    { GL_INDEX_CLEAR_VALUE, CONTEXT_INT(Color.ClearIndex), NO_EXTRA },
    { GL_INDEX_MODE, CONST(0) , NO_EXTRA },
    { GL_INDEX_OFFSET, CONTEXT_INT(Pixel.IndexOffset), NO_EXTRA },
    { GL_INDEX_SHIFT, CONTEXT_INT(Pixel.IndexShift), NO_EXTRA },
    { GL_INDEX_WRITEMASK, CONTEXT_INT(Color.IndexMask), NO_EXTRA },
    { GL_LIGHT_MODEL_COLOR_CONTROL, CONTEXT_ENUM16(Light.Model.ColorControl), NO_EXTRA },
    { GL_LIGHT_MODEL_LOCAL_VIEWER, CONTEXT_BOOL(Light.Model.LocalViewer), NO_EXTRA },
    { GL_LINE_STIPPLE, CONTEXT_BOOL(Line.StippleFlag), NO_EXTRA },
    { GL_LINE_STIPPLE_PATTERN, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_LINE_STIPPLE_REPEAT, CONTEXT_INT(Line.StippleFactor), NO_EXTRA },
    { GL_LINE_WIDTH_GRANULARITY, CONTEXT_FLOAT(Const.LineWidthGranularity), NO_EXTRA },
    { GL_LIST_BASE, CONTEXT_INT(List.ListBase), NO_EXTRA },
    { GL_LIST_INDEX, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_LIST_MODE, LOC_CUSTOM, TYPE_ENUM16, 0, NO_EXTRA },
    { GL_INDEX_LOGIC_OP, CONTEXT_BOOL(Color.IndexLogicOpEnabled), NO_EXTRA },
    { GL_MAP1_COLOR_4, CONTEXT_BOOL(Eval.Map1Color4), NO_EXTRA },
    { GL_MAP1_GRID_DOMAIN, CONTEXT_FLOAT2(Eval.MapGrid1u1), NO_EXTRA },
    { GL_MAP1_GRID_SEGMENTS, CONTEXT_INT(Eval.MapGrid1un), NO_EXTRA },
    { GL_MAP1_INDEX, CONTEXT_BOOL(Eval.Map1Index), NO_EXTRA },
    { GL_MAP1_NORMAL, CONTEXT_BOOL(Eval.Map1Normal), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_1, CONTEXT_BOOL(Eval.Map1TextureCoord1), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_2, CONTEXT_BOOL(Eval.Map1TextureCoord2), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_3, CONTEXT_BOOL(Eval.Map1TextureCoord3), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_4, CONTEXT_BOOL(Eval.Map1TextureCoord4), NO_EXTRA },
    { GL_MAP1_VERTEX_3, CONTEXT_BOOL(Eval.Map1Vertex3), NO_EXTRA },
    { GL_MAP1_VERTEX_4, CONTEXT_BOOL(Eval.Map1Vertex4), NO_EXTRA },
    { GL_MAP2_COLOR_4, CONTEXT_BOOL(Eval.Map2Color4), NO_EXTRA },
    { GL_MAP2_GRID_DOMAIN, LOC_CUSTOM, TYPE_FLOAT_4, 0, NO_EXTRA },
    { GL_MAP2_GRID_SEGMENTS, CONTEXT_INT2(Eval.MapGrid2un), NO_EXTRA },
    { GL_MAP2_INDEX, CONTEXT_BOOL(Eval.Map2Index), NO_EXTRA },
    { GL_MAP2_NORMAL, CONTEXT_BOOL(Eval.Map2Normal), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_1, CONTEXT_BOOL(Eval.Map2TextureCoord1), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_2, CONTEXT_BOOL(Eval.Map2TextureCoord2), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_3, CONTEXT_BOOL(Eval.Map2TextureCoord3), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_4, CONTEXT_BOOL(Eval.Map2TextureCoord4), NO_EXTRA },
    { GL_MAP2_VERTEX_3, CONTEXT_BOOL(Eval.Map2Vertex3), NO_EXTRA },
    { GL_MAP2_VERTEX_4, CONTEXT_BOOL(Eval.Map2Vertex4), NO_EXTRA },
    { GL_MAP_COLOR, CONTEXT_BOOL(Pixel.MapColorFlag), NO_EXTRA },
    { GL_MAP_STENCIL, CONTEXT_BOOL(Pixel.MapStencilFlag), NO_EXTRA },
    { GL_MAX_ATTRIB_STACK_DEPTH, CONST(MAX_ATTRIB_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_CLIENT_ATTRIB_STACK_DEPTH, CONST(MAX_CLIENT_ATTRIB_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_EVAL_ORDER, CONST(MAX_EVAL_ORDER), NO_EXTRA },
    { GL_MAX_LIST_NESTING, CONST(MAX_LIST_NESTING), NO_EXTRA },
    { GL_MAX_NAME_STACK_DEPTH, CONST(MAX_NAME_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_PIXEL_MAP_TABLE, CONST(MAX_PIXEL_MAP_TABLE), NO_EXTRA },
    { GL_NAME_STACK_DEPTH, CONTEXT_INT(Select.NameStackDepth), NO_EXTRA },
    { GL_PACK_LSB_FIRST, CONTEXT_BOOL(Pack.LsbFirst), NO_EXTRA },
    { GL_PACK_SWAP_BYTES, CONTEXT_BOOL(Pack.SwapBytes), NO_EXTRA },
    { GL_PACK_INVERT_MESA, CONTEXT_BOOL(Pack.Invert), NO_EXTRA },
    { GL_PIXEL_MAP_A_TO_A_SIZE, CONTEXT_INT(PixelMaps.AtoA.Size), NO_EXTRA },
    { GL_PIXEL_MAP_B_TO_B_SIZE, CONTEXT_INT(PixelMaps.BtoB.Size), NO_EXTRA },
    { GL_PIXEL_MAP_G_TO_G_SIZE, CONTEXT_INT(PixelMaps.GtoG.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_A_SIZE, CONTEXT_INT(PixelMaps.ItoA.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_B_SIZE, CONTEXT_INT(PixelMaps.ItoB.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_G_SIZE, CONTEXT_INT(PixelMaps.ItoG.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_I_SIZE, CONTEXT_INT(PixelMaps.ItoI.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_R_SIZE, CONTEXT_INT(PixelMaps.ItoR.Size), NO_EXTRA },
    { GL_PIXEL_MAP_R_TO_R_SIZE, CONTEXT_INT(PixelMaps.RtoR.Size), NO_EXTRA },
    { GL_PIXEL_MAP_S_TO_S_SIZE, CONTEXT_INT(PixelMaps.StoS.Size), NO_EXTRA },
    { GL_POINT_SIZE_GRANULARITY, CONTEXT_FLOAT(Const.PointSizeGranularity), NO_EXTRA },
    { GL_POLYGON_MODE, CONTEXT_ENUM2(Polygon.FrontMode), NO_EXTRA },
    { GL_POLYGON_OFFSET_POINT, CONTEXT_BOOL(Polygon.OffsetPoint), NO_EXTRA },
    { GL_POLYGON_OFFSET_LINE, CONTEXT_BOOL(Polygon.OffsetLine), NO_EXTRA },
    { GL_POLYGON_SMOOTH, CONTEXT_BOOL(Polygon.SmoothFlag), NO_EXTRA },
    { GL_POLYGON_SMOOTH_HINT, CONTEXT_ENUM16(Hint.PolygonSmooth), NO_EXTRA },
    { GL_POLYGON_STIPPLE, CONTEXT_BOOL(Polygon.StippleFlag), NO_EXTRA },
    { GL_RED_BIAS, CONTEXT_FLOAT(Pixel.RedBias), NO_EXTRA },
    { GL_RED_SCALE, CONTEXT_FLOAT(Pixel.RedScale), NO_EXTRA },
    { GL_RENDER_MODE, CONTEXT_ENUM16(RenderMode), NO_EXTRA },
    { GL_RGBA_MODE, CONST(1), NO_EXTRA },
    { GL_SELECTION_BUFFER_SIZE, CONTEXT_INT(Select.BufferSize), NO_EXTRA },
    { GL_STEREO, BUFFER_INT(Visual.stereoMode), NO_EXTRA },
    { GL_TEXTURE_1D, LOC_CUSTOM, TYPE_BOOLEAN, NO_OFFSET, NO_EXTRA },
    { GL_TEXTURE_3D, LOC_CUSTOM, TYPE_BOOLEAN, NO_OFFSET, NO_EXTRA },
    { GL_TEXTURE_BINDING_1D, LOC_CUSTOM, TYPE_INT, TEXTURE_1D_INDEX, NO_EXTRA },
    { GL_TEXTURE_BINDING_1D_ARRAY, LOC_CUSTOM, TYPE_INT, TEXTURE_1D_ARRAY_INDEX, extra_EXT_texture_array },
    { GL_TEXTURE_GEN_S, LOC_TEXUNIT, TYPE_BIT_0, offsetof(struct gl_fixedfunc_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_TEXTURE_GEN_T, LOC_TEXUNIT, TYPE_BIT_1, offsetof(struct gl_fixedfunc_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_TEXTURE_GEN_R, LOC_TEXUNIT, TYPE_BIT_2, offsetof(struct gl_fixedfunc_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_TEXTURE_GEN_Q, LOC_TEXUNIT, TYPE_BIT_3, offsetof(struct gl_fixedfunc_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_UNPACK_LSB_FIRST, CONTEXT_BOOL(Unpack.LsbFirst), NO_EXTRA },
    { GL_UNPACK_SWAP_BYTES, CONTEXT_BOOL(Unpack.SwapBytes), NO_EXTRA },
    { GL_ZOOM_X, CONTEXT_FLOAT(Pixel.ZoomX), NO_EXTRA },
    { GL_ZOOM_Y, CONTEXT_FLOAT(Pixel.ZoomY), NO_EXTRA },
    { GL_VERTEX_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_NORMAL_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_COLOR_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_INDEX_ARRAY, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_INDEX_ARRAY_TYPE, ARRAY_ENUM16(VertexAttrib[VERT_ATTRIB_COLOR_INDEX].Format.User.Type), NO_EXTRA },
    { GL_INDEX_ARRAY_STRIDE, ARRAY_SHORT(VertexAttrib[VERT_ATTRIB_COLOR_INDEX].Stride), NO_EXTRA },
    { GL_INDEX_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY_STRIDE, ARRAY_SHORT(VertexAttrib[VERT_ATTRIB_EDGEFLAG].Stride), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_TEXTURE_COMPRESSION_HINT_ARB, CONTEXT_ENUM16(Hint.TextureCompression), NO_EXTRA },
    { GL_ARRAY_ELEMENT_LOCK_FIRST_EXT, CONTEXT_INT(Array.LockFirst), NO_EXTRA },
    { GL_ARRAY_ELEMENT_LOCK_COUNT_EXT, CONTEXT_INT(Array.LockCount), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_WIDTH, CONTEXT_INT(Unpack.CompressedBlockWidth), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_HEIGHT, CONTEXT_INT(Unpack.CompressedBlockHeight), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_DEPTH, CONTEXT_INT(Unpack.CompressedBlockDepth), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_SIZE, CONTEXT_INT(Unpack.CompressedBlockSize), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_WIDTH, CONTEXT_INT(Pack.CompressedBlockWidth), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_HEIGHT, CONTEXT_INT(Pack.CompressedBlockHeight), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_DEPTH, CONTEXT_INT(Pack.CompressedBlockDepth), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_SIZE, CONTEXT_INT(Pack.CompressedBlockSize), NO_EXTRA },
    { GL_TRANSPOSE_MODELVIEW_MATRIX_ARB, CONTEXT_MATRIX_T(ModelviewMatrixStack), NO_EXTRA },
    { GL_TRANSPOSE_PROJECTION_MATRIX_ARB, CONTEXT_MATRIX_T(ProjectionMatrixStack.Top), NO_EXTRA },
    { GL_TRANSPOSE_TEXTURE_MATRIX_ARB, CONTEXT_MATRIX_T(TextureMatrixStack), NO_EXTRA },
    { GL_COLOR_SUM, CONTEXT_BOOL(Fog.ColorSumEnabled), NO_EXTRA },
    { GL_CURRENT_SECONDARY_COLOR, CONTEXT_FIELD(Current.Attrib[VERT_ATTRIB_COLOR1][0], TYPE_FLOATN_4), extra_flush_current },
    { GL_SECONDARY_COLOR_ARRAY, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_TYPE, ARRAY_ENUM16(VertexAttrib[VERT_ATTRIB_COLOR1].Format.User.Type), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_STRIDE, ARRAY_SHORT(VertexAttrib[VERT_ATTRIB_COLOR1].Stride), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_SIZE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_CURRENT_FOG_COORDINATE, CONTEXT_FLOAT(Current.Attrib[VERT_ATTRIB_FOG][0]), extra_flush_current },
    { GL_FOG_COORDINATE_ARRAY, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_FOG_COORDINATE_ARRAY_TYPE, ARRAY_ENUM16(VertexAttrib[VERT_ATTRIB_FOG].Format.User.Type), NO_EXTRA },
    { GL_FOG_COORDINATE_ARRAY_STRIDE, ARRAY_SHORT(VertexAttrib[VERT_ATTRIB_FOG].Stride), NO_EXTRA },
    { GL_FOG_COORDINATE_SOURCE, CONTEXT_ENUM16(Fog.FogCoordinateSource), NO_EXTRA },
    { GL_FOG_DISTANCE_MODE_NV, CONTEXT_ENUM16(Fog.FogDistanceMode), extra_NV_fog_distance },
    { GL_RASTER_POSITION_UNCLIPPED_IBM, CONTEXT_BOOL(Transform.RasterPositionUnclipped), NO_EXTRA },
    { GL_POINT_SPRITE_COORD_ORIGIN, CONTEXT_ENUM16(Point.SpriteOrigin), NO_EXTRA },
    { GL_TEXTURE_RECTANGLE_NV, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_NV_texture_rectangle },
    { GL_TEXTURE_BINDING_RECTANGLE_NV, LOC_CUSTOM, TYPE_INT, TEXTURE_RECT_INDEX, extra_NV_texture_rectangle },
    { GL_MAX_RECTANGLE_TEXTURE_SIZE_NV, CONTEXT_INT(Const.MaxTextureRectSize), extra_NV_texture_rectangle },
    { GL_STENCIL_TEST_TWO_SIDE_EXT, CONTEXT_BOOL(Stencil.TestTwoSide), extra_EXT_stencil_two_side },
    { GL_ACTIVE_STENCIL_FACE_EXT, LOC_CUSTOM, TYPE_ENUM16, NO_OFFSET, NO_EXTRA },
    { GL_MAX_SHININESS_NV, CONTEXT_FLOAT(Const.MaxShininess), NO_EXTRA },
    { GL_MAX_SPOT_EXPONENT_NV, CONTEXT_FLOAT(Const.MaxSpotExponent), NO_EXTRA },
    { GL_PRIMITIVE_RESTART_NV, CONTEXT_BOOL(Array.PrimitiveRestart), extra_NV_primitive_restart },
    { GL_PRIMITIVE_RESTART_INDEX_NV, CONTEXT_INT(Array.RestartIndex), extra_NV_primitive_restart },
    { GL_INDEX_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, BufferBinding[VERT_ATTRIB_COLOR_INDEX].BufferObj), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, BufferBinding[VERT_ATTRIB_EDGEFLAG].BufferObj), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, BufferBinding[VERT_ATTRIB_COLOR1].BufferObj), NO_EXTRA },
    { GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, BufferBinding[VERT_ATTRIB_FOG].BufferObj), NO_EXTRA },
    { GL_VERTEX_PROGRAM_ARB, CONTEXT_BOOL(VertexProgram.Enabled), extra_ARB_vertex_program },
    { GL_VERTEX_PROGRAM_POINT_SIZE_ARB, CONTEXT_BOOL(VertexProgram.PointSizeEnabled), extra_ARB_vertex_program },
    { GL_VERTEX_PROGRAM_TWO_SIDE_ARB, CONTEXT_BOOL(VertexProgram.TwoSideEnabled), extra_ARB_vertex_program },
    { GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB, CONTEXT_INT(Const.MaxProgramMatrixStackDepth), extra_ARB_vertex_program_ARB_fragment_program },
    { GL_MAX_PROGRAM_MATRICES_ARB, CONTEXT_INT(Const.MaxProgramMatrices), extra_ARB_vertex_program_ARB_fragment_program },
    { GL_CURRENT_MATRIX_STACK_DEPTH_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_vertex_program_ARB_fragment_program },
    { GL_CURRENT_MATRIX_ARB, LOC_CUSTOM, TYPE_MATRIX, 0, extra_ARB_vertex_program_ARB_fragment_program },
    { GL_TRANSPOSE_CURRENT_MATRIX_ARB, LOC_CUSTOM, TYPE_MATRIX_T, 0, extra_ARB_vertex_program_ARB_fragment_program },
    { GL_PROGRAM_ERROR_POSITION_ARB, CONTEXT_INT(Program.ErrorPos), extra_ARB_vertex_program_ARB_fragment_program },
    { GL_FRAGMENT_PROGRAM_ARB, CONTEXT_BOOL(FragmentProgram.Enabled), extra_ARB_fragment_program },
    { GL_RGBA_SIGNED_COMPONENTS_EXT, LOC_CUSTOM, TYPE_INT_4, 0, extra_EXT_packed_float },
    { GL_DEPTH_BOUNDS_TEST_EXT, CONTEXT_BOOL(Depth.BoundsTest), extra_EXT_depth_bounds_test },
    { GL_DEPTH_BOUNDS_EXT, CONTEXT_FLOAT2(Depth.BoundsMin), extra_EXT_depth_bounds_test },
    { GL_DEPTH_CLAMP, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_ARB_depth_clamp },
    { GL_FRAGMENT_SHADER_ATI, CONTEXT_BOOL(ATIFragmentShader.Enabled), extra_ATI_fragment_shader },
    { GL_NUM_FRAGMENT_REGISTERS_ATI, CONST(6), extra_ATI_fragment_shader },
    { GL_NUM_FRAGMENT_CONSTANTS_ATI, CONST(8), extra_ATI_fragment_shader },
    { GL_NUM_PASSES_ATI, CONST(2), extra_ATI_fragment_shader },
    { GL_NUM_INSTRUCTIONS_PER_PASS_ATI, CONST(8), extra_ATI_fragment_shader },
    { GL_NUM_INSTRUCTIONS_TOTAL_ATI, CONST(16), extra_ATI_fragment_shader },
    { GL_COLOR_ALPHA_PAIRING_ATI, CONST(GL_TRUE), extra_ATI_fragment_shader },
    { GL_NUM_LOOPBACK_COMPONENTS_ATI, CONST(3), extra_ATI_fragment_shader },
    { GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI, CONST(3), extra_ATI_fragment_shader },
    { GL_PROVOKING_VERTEX_EXT, CONTEXT_ENUM16(Light.ProvokingVertex), extra_EXT_provoking_vertex },
    { GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT, CONTEXT_BOOL(Const.QuadsFollowProvokingVertexConvention), extra_EXT_provoking_vertex_32 },
    { GL_TEXTURE_CUBE_MAP_SEAMLESS, CONTEXT_BOOL(Texture.CubeMapSeamless), extra_ARB_seamless_cube_map },
    { GL_RGBA_INTEGER_MODE_EXT, LOC_CUSTOM, TYPE_INT, 0, extra_EXT_texture_integer_and_new_buffers },
    { GL_MAX_TRANSFORM_FEEDBACK_BUFFERS, CONTEXT_INT(Const.MaxTransformFeedbackBuffers), extra_ARB_transform_feedback3 },
    { GL_MAX_VERTEX_STREAMS, CONTEXT_INT(Const.MaxVertexStreams), extra_ARB_transform_feedback3_ARB_gpu_shader5 },
    { GL_RGBA_FLOAT_MODE_ARB, BUFFER_FIELD(Visual.floatMode, TYPE_BOOLEAN), extra_core_ARB_color_buffer_float_and_new_buffers },
    { GL_MAX_SPARSE_TEXTURE_SIZE_ARB, CONTEXT_INT(Const.MaxSparseTextureSize), extra_ARB_sparse_texture },
    { GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB, CONTEXT_INT(Const.MaxSparse3DTextureSize), extra_ARB_sparse_texture },
    { GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB, CONTEXT_INT(Const.MaxSparseArrayTextureLayers), extra_ARB_sparse_texture },
    { GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB, CONTEXT_BOOL(Const.SparseTextureFullArrayCubeMipmaps), extra_ARB_sparse_texture },
    { GL_FRAMEBUFFER_SRGB_CAPABLE_EXT, BUFFER_INT(Visual.sRGBCapable), extra_EXT_framebuffer_sRGB_and_new_buffers },
    { GL_PRIMITIVE_RESTART, CONTEXT_BOOL(Array.PrimitiveRestart), extra_version_31 },
    { GL_PRIMITIVE_RESTART_INDEX, CONTEXT_INT(Array.RestartIndex), extra_version_31 },
    { GL_CONTEXT_PROFILE_MASK, CONTEXT_INT(Const.ProfileMask), extra_version_32 },
    { GL_MIN_MAP_BUFFER_ALIGNMENT, CONTEXT_INT(Const.MinMapBufferAlignment), NO_EXTRA },
    { GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB, CONTEXT_INT(Const.MaxProgramTextureGatherComponents), extra_ARB_texture_gather },
    { GL_MAX_IMAGE_SAMPLES, CONTEXT_INT(Const.MaxImageSamples), extra_ARB_shader_image_load_store },
    { GL_QUERY_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_query_buffer_object },
    { GL_VBO_FREE_MEMORY_ATI, LOC_CUSTOM, TYPE_INT_4, NO_OFFSET, extra_ATI_meminfo },
    { GL_TEXTURE_FREE_MEMORY_ATI, LOC_CUSTOM, TYPE_INT_4, NO_OFFSET, extra_ATI_meminfo },
    { GL_RENDERBUFFER_FREE_MEMORY_ATI, LOC_CUSTOM, TYPE_INT_4, NO_OFFSET, extra_ATI_meminfo },
    { GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX, LOC_CUSTOM, TYPE_INT, NO_OFFSET, extra_NVX_gpu_memory_info },
    { GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX, LOC_CUSTOM, TYPE_INT, NO_OFFSET, extra_NVX_gpu_memory_info },
    { GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX, LOC_CUSTOM, TYPE_INT, NO_OFFSET, extra_NVX_gpu_memory_info },
    { GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX, LOC_CUSTOM, TYPE_INT, NO_OFFSET, extra_NVX_gpu_memory_info },
    { GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX, LOC_CUSTOM, TYPE_INT, NO_OFFSET, extra_NVX_gpu_memory_info },
    { GL_MAX_CULL_DISTANCES, CONTEXT_INT(Const.MaxClipPlanes), extra_ARB_cull_distance },
    { GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES, CONTEXT_INT(Const.MaxClipPlanes), extra_ARB_cull_distance },
    { GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB, CONTEXT_INT(Const.MaxComputeVariableGroupInvocations), extra_ARB_compute_variable_group_size },
    { GL_SPARSE_BUFFER_PAGE_SIZE_ARB, CONTEXT_INT(Const.SparseBufferPageSize), extra_ARB_sparse_buffer },
    { GL_MAX_SUBROUTINES, CONST(MAX_SUBROUTINES), NO_EXTRA },
    { GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS, CONST(MAX_SUBROUTINE_UNIFORM_LOCATIONS), NO_EXTRA },
    { GL_PARAMETER_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_indirect_parameters },
    { GL_DEPTH_CLAMP_NEAR_AMD, CONTEXT_BOOL(Transform.DepthClampNear), extra_AMD_depth_clamp_separate },
    { GL_DEPTH_CLAMP_FAR_AMD, CONTEXT_BOOL(Transform.DepthClampFar), extra_AMD_depth_clamp_separate },
};

static table_t table_API_OPENGL = {
      92,  563,  502,    0,
     149,  219,    0,    0,
     250,  506,  574,  118,
     312,  405,  417,    0,
       0,    0,  345,  608,
     288,  267,    0,  395,
       0,    0,    0,  484,
       0,    0,    0,  507,
     421,    0,  197,  361,
       0,    0,  176,  161,
     538,  144,  150,    5,
       0,    0,  435,    0,
     348,    0,  428,  292,
     151,  370,  473,    0,
      59,  629,    0,    0,
       0,  246,  354,    0,
     605,    0,    0,  234,
       0,    0,  259,  317,
       0,  618,  432,   81,
     567,  530,  241,    0,
       0,  258,  379,  300,
     155,    0,  388,    0,
     264,   93,  564,    0,
       0,  154,    0,    0,
     120,  251,  475,  631,
     439,  313,  328,  261,
       0,    0,    0,  346,
     319,    0,  398,    0,
       0,  580,    0,    0,
     485,    0,    0,    0,
     134,    0,    0,  199,
     268,    0,    0,  177,
     301,   38,  128,    0,
     204,    0,    0,  454,
       0,  442,   68,    0,
       0,  443,  371,    0,
     143,  650,  641,    0,
     603,  440,  331,    0,
       0,  606,    0,    0,
     233,    0,    0,  260,
       0,    0,  619,  433,
      80,  568,  546,   75,
      17,    0,  551,  223,
     557,  159,  575,  609,
     465,  594,   94,    0,
     466,  497,  136,    0,
     607,  460,  290,  476,
     632,  448,    0,  330,
       0,    0,  590,    0,
     343,    0,    0,  399,
       0,  458,    0,    0,
       0,  486,    0,    0,
      37,  135,  270,    0,
     198,  364,    0,    0,
     178,  163,  228,  483,
     610,  207,    0,    0,
     106,    0,    0,   69,
       0,    0,  444,  372,
       0,  141,  651,    0,
     325,    0,  418,  337,
     627,  336,   77,  281,
       0,  235,    0,    0,
     500,    0,    0,  622,
       0,   78,  569,  547,
     243,   18,    0,  499,
     221,  558,  162,  450,
     646,  533,  595,   95,
       0,  531,  265,  148,
      34,  254,  122,  291,
       0,    0,  451,    0,
     324,  107,    0,  591,
       0,  344,    0,    0,
     600,    0,  459,  630,
       0,    0,   86,    0,
       0,  463,   20,  375,
       0,   39,  363,    0,
     519,  596,  164,  139,
     124,   49,  208,    0,
       0,    3,    0,    0,
       0,    0,    0,  115,
     373,    0,  142,  244,
       0,  406,    0,  581,
       0,  437,  355,   79,
     413,    0,    0,  654,
     480,  308,    0,    0,
     621,    0,  392,    0,
     462,  510,    0,  366,
     638,  222,    0,  498,
     540,  647,  455,  584,
      96,    0,    0,    0,
     153,   28,  252,  126,
     217,  495,    0,  449,
       0,  356,  108,    0,
       0,  385,  349,  613,
       0,  400,  274,  490,
       0,  446,    0,   88,
     422,  273,  185,  504,
     376,  624,  588,  206,
      45,  522,  179,  165,
     193,  582,    0,  209,
      26,    0,    2,    0,
     247,  362,    0,    0,
     423,  527,  227,  304,
       0,  358,  408,    0,
       0,  396,  381,  305,
       0,  282,    0,    0,
     655,  481,  634,    0,
       0,  620,    0,  393,
     505,  275,  194,  340,
       0,    0,   70,  297,
     166,  180,  648,  535,
     539,   97,    0,    0,
     103,   72,   30,  253,
     123,  218,   66,    0,
     452,    0,  357,  109,
       0,    0,  384,    0,
       0,    0,  586,  298,
     534,    0,    0,    0,
      87,    0,    0,  186,
       0,  271,  332,    0,
      41,   44,  520,  597,
     550,   22,    0,    0,
     210,   27,    0,  429,
       0,    0,  636,    0,
      10,  424,  529,  633,
     302,    0,    0,  404,
       0,  453,  397,  383,
     306,    0,  283,    0,
      24,    0,  491,  341,
       0,    0,    0,  436,
     593,   91,   63,  196,
       0,    0,    0,   71,
     611,  556,  542,  649,
       0,  295,   98,    0,
       0,  104,  289,   35,
       0,  125,    0,   67,
     127,  447,  617,    0,
     110,    0,    0,  386,
       0,  335,    0,  278,
     299,    0,    0,    0,
     205,   89,  220,  272,
     187,    0,  145,  333,
     589,  171,   47,  518,
     598,  552,   16,  487,
     532,  211,    0,  642,
     585,    0,  587,  639,
       0,   11,  425,  374,
       0,  303,    0,    0,
     327,    0,   50,    0,
     382,  307,    0,  285,
     579,  524,    0,  492,
     342,    0,    0,    0,
     173,    0,   73,   64,
     195,  262,  359,    0,
      56,  612,  156,  543,
       0,    0,  657,   99,
     131,    0,  105,    0,
      29,    0,  121,    0,
     318,   15,    0,    0,
     323,  111,    0,    0,
     387,    0,    0,  469,
     279,  555,    0,  380,
       0,  493,   90,  224,
       0,    1,    0,  146,
     334,    0,  170,   46,
     517,  174,  553,  537,
     488,  438,  212,    0,
     643,    0,    0,    0,
     132,    0,   12,  426,
       6,  394,  351,    0,
      82,  329,    0,   51,
       0,  640,  338,    0,
     284,  512,  526,    0,
     523,  347,    0,    0,
       0,    0,    0,   19,
      43,   21,    0,  410,
       0,   57,    0,  157,
       0,    0,   58,  658,
     592,  478,  461,    0,
       0,   31,    0,    0,
     100,  367,  129,    0,
       0,    0,  112,    0,
       0,  242,    0,    0,
       0,  280,    0,  496,
     378,  645,  494,    0,
     225,    0,  188,  513,
     147,  277,    0,  570,
     403,  516,   52,  554,
       0,  489,    0,  213,
     623,  644,    0,    0,
       0,  138,    0,    8,
     203,    7,  200,  353,
     116,  369,  326,    0,
       0,    0,    0,  339,
       0,  286,    0,    0,
       0,  528,    0,    0,
     479,    0,  635,    0,
     508,  419,    0,  263,
     411,    0,   54,  583,
     158,    0,    0,   25,
     464,   48,  130,  441,
     601,    0,   32,    0,
       0,  470,  656,  474,
       0,    0,    0,  113,
       0,    0,  389,    0,
       0,    0,    0,    0,
     237,  152,    0,  256,
       0,  226,  615,  189,
       0,  119,  467,    0,
     571,  401,  521,  175,
     167,  192,  578,  322,
     214,  276,  238,  637,
      13,    0,   40,  230,
       9,  202,   14,  201,
     352,  445,  377,  407,
       0,    0,    0,    0,
       0,    0,  414,   85,
     457,    0,  350,    0,
     560,  482,    0,  614,
       0,  503,  420,    0,
     545,  412,  525,   55,
      61,  548,    0,  625,
      23,  468,  368,  559,
     416,  293,    0,   33,
     434,    0,  102,  653,
     471,    0,    0,    0,
     114,    0,    0,  390,
      83,    0,    0,    0,
       0,  236,    0,    0,
     257,    0,  511,  616,
     430,    0,  565,  172,
     245,  572,  320,  515,
      53,  168,  216,  576,
     456,  314,    0,  239,
     562,  501,    0,  137,
     402,    0,  599,  249,
     477,  573,  117,  316,
     409,    0,    0,    0,
       0,  365,    0,  287,
     269,  652,    0,    0,
       0,  561,   60,    0,
       0,  255,  133,  415,
       0,  544,  360,  549,
       0,   62,  160,    0,
     140,    0,    4,    0,
     604,   65,  294,    0,
      36,  427,    0,  101,
       0,  472,    0,  628,
      76,  602,    0,    0,
     391,   84,  248,    0,
     266,    0,  232,  541,
       0,   74,  626,  215,
     509,  431,  296,  566,
      42,  240,    0,  321,
     514,  536,  169,  229,
     577,  231,  315,    0,
};

static table_t table_API_OPENGLES = {
      92,    0,    0,    0,
     149,    0,    0,    0,
       0,    0,    0,  118,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  311,    0,    0,
       0,    0,    0,    0,
       0,    0,  176,  161,
       0,  144,  150,    5,
       0,    0,    0,    0,
       0,    0,    0,    0,
     151,    0,    0,    0,
      59,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   81,
       0,    0,    0,    0,
       0,    0,    0,    0,
     155,    0,    0,    0,
       0,   93,    0,    0,
       0,  154,    0,    0,
     120,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     134,    0,    0,    0,
       0,    0,    0,  177,
       0,   38,  128,    0,
       0,    0,    0,    0,
       0,    0,   68,    0,
       0,    0,    0,    0,
     143,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      80,    0,    0,   75,
      17,    0,    0,    0,
       0,  159,    0,    0,
       0,    0,   94,    0,
       0,    0,  136,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  310,
      37,  135,    0,    0,
       0,    0,    0,    0,
     178,  163,    0,    0,
       0,    0,    0,    0,
     106,    0,    0,   69,
       0,    0,    0,    0,
       0,  141,    0,    0,
       0,    0,    0,    0,
       0,    0,   77,    0,
       0,    0,    0,    0,
       0,    0,  182,    0,
       0,   78,    0,    0,
       0,   18,    0,    0,
       0,    0,  162,    0,
       0,    0,    0,   95,
       0,    0,    0,  148,
      34,    0,  122,    0,
       0,    0,    0,    0,
       0,  107,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   86,    0,
       0,    0,   20,    0,
       0,   39,    0,    0,
       0,    0,  164,  139,
     124,   49,    0,    0,
       0,    3,    0,    0,
     181,    0,    0,  115,
       0,    0,  142,    0,
       0,    0,    0,    0,
       0,    0,    0,   79,
       0,    0,    0,    0,
       0,    0,    0,  183,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      96,    0,    0,    0,
     153,   28,    0,  126,
       0,    0,    0,    0,
       0,    0,  108,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   88,
       0,    0,  185,    0,
       0,    0,    0,    0,
      45,    0,  179,  165,
       0,    0,    0,    0,
      26,    0,    2,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   70,    0,
     166,  180,    0,    0,
       0,   97,    0,    0,
     103,   72,   30,    0,
     123,    0,   66,    0,
       0,    0,    0,  109,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      87,    0,    0,  186,
       0,    0,    0,    0,
      41,   44,    0,    0,
       0,   22,    0,    0,
       0,   27,    0,    0,
       0,    0,    0,    0,
      10,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      24,    0,    0,    0,
       0,    0,    0,    0,
       0,   91,   63,    0,
       0,    0,    0,   71,
       0,    0,    0,    0,
       0,    0,   98,    0,
       0,  104,    0,   35,
       0,  125,    0,   67,
     127,    0,    0,    0,
     110,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   89,    0,    0,
     187,    0,  145,    0,
       0,  171,   47,    0,
       0,    0,   16,    0,
       0,    0,    0,    0,
       0,    0,    0,  184,
       0,   11,    0,    0,
       0,    0,    0,    0,
       0,    0,   50,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     173,    0,   73,   64,
       0,    0,    0,    0,
      56,    0,  156,    0,
       0,    0,    0,   99,
     131,    0,  105,    0,
      29,    0,  121,    0,
       0,   15,    0,    0,
       0,  111,    0,    0,
       0,    0,  309,    0,
       0,    0,    0,    0,
       0,    0,   90,    0,
       0,    1,    0,  146,
       0,    0,  170,   46,
       0,  174,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     132,    0,   12,    0,
       6,    0,    0,    0,
      82,    0,    0,   51,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   19,
      43,   21,    0,    0,
       0,   57,    0,  157,
       0,    0,   58,    0,
       0,    0,    0,    0,
       0,   31,    0,    0,
     100,    0,  129,    0,
       0,    0,  112,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  188,    0,
     147,    0,    0,    0,
       0,    0,   52,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  138,    0,    8,
       0,    7,    0,    0,
     116,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   54,    0,
     158,    0,    0,   25,
       0,   48,  130,    0,
       0,    0,   32,    0,
       0,    0,    0,    0,
       0,    0,    0,  113,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  152,    0,    0,
       0,    0,    0,  189,
       0,  119,    0,    0,
       0,    0,    0,  175,
     167,    0,    0,    0,
       0,    0,    0,    0,
      13,    0,   40,    0,
       9,    0,   14,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   85,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   55,
      61,    0,    0,    0,
      23,    0,    0,    0,
       0,    0,    0,   33,
       0,    0,  102,    0,
       0,    0,    0,    0,
     114,    0,    0,    0,
      83,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  172,
       0,    0,    0,    0,
      53,  168,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  137,
       0,    0,    0,    0,
       0,    0,  117,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   60,    0,
       0,    0,  133,    0,
       0,    0,    0,    0,
       0,   62,  160,    0,
     140,    0,    4,    0,
       0,   65,    0,    0,
      36,    0,    0,  101,
       0,    0,    0,    0,
      76,    0,    0,    0,
       0,   84,    0,    0,
     266,    0,    0,    0,
       0,   74,    0,    0,
       0,    0,    0,    0,
      42,  265,    0,    0,
       0,    0,  169,    0,
       0,    0,    0,    0,
};

static table_t table_API_OPENGLES2 = {
     220,    0,    0,  190,
     191,  219,    0,    0,
     250,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  311,    0,    0,
       0,    0,  197,    0,
       0,    0,    0,    0,
       0,    0,    0,    5,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      59,    0,    0,    0,
       0,  246,    0,    0,
       0,    0,    0,  234,
       0,    0,  259,    0,
       0,    0,    0,   81,
       0,    0,  241,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     264,  224,    0,    0,
       0,    0,    0,    0,
       0,  251,    0,    0,
       0,    0,    0,  261,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  199,
       0,    0,    0,    0,
       0,   38,    0,    0,
     204,    0,    0,    0,
       0,    0,   68,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     233,    0,    0,  260,
       0,    0,    0,    0,
      80,    0,    0,   75,
      17,    0,    0,  223,
       0,    0,    0,    0,
       0,    0,  225,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  310,
      37,    0,    0,    0,
     198,    0,    0,    0,
       0,    0,  228,    0,
       0,  207,    0,    0,
       0,    0,    0,   69,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   77,    0,
       0,  235,    0,    0,
       0,    0,    0,    0,
       0,   78,    0,    0,
     243,   18,    0,    0,
     221,    0,  258,    0,
       0,    0,    0,  226,
       0,    0,    0,    0,
      34,  254,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   86,    0,
       0,    0,   20,    0,
       0,   39,    0,    0,
       0,    0,    0,    0,
       0,   49,  208,    0,
       0,    3,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  244,
       0,    0,    0,    0,
       0,    0,    0,   79,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  222,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   28,  252,    0,
     217,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   88,
       0,    0,  185,    0,
       0,    0,    0,  206,
      45,    0,    0,    0,
     193,    0,    0,  209,
      26,    0,    2,    0,
     247,    0,    0,    0,
       0,    0,  227,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  194,    0,
       0,    0,   70,    0,
       0,    0,    0,    0,
       0,  215,    0,    0,
     242,   72,   30,  253,
       0,  218,   66,    0,
       0,    0,    0,  231,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      87,    0,    0,  186,
       0,    0,    0,    0,
      41,   44,    0,    0,
       0,   22,    0,    0,
     210,   27,    0,    0,
       0,    0,    0,    0,
      10,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      24,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   63,  196,
       0,    0,    0,   71,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   35,
       0,    0,    0,   67,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     205,   89,    0,    0,
     187,    0,    0,    0,
       0,    0,   47,    0,
       0,    0,   16,    0,
       0,  211,    0,    0,
       0,    0,    0,    0,
       0,   11,    0,    0,
       0,    0,    0,    0,
       0,    0,   50,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   73,   64,
     195,  262,    0,    0,
      56,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      29,    0,    0,    0,
       0,   15,    0,    0,
       0,    0,    0,    0,
       0,    0,  309,    0,
       0,    0,    0,    0,
       0,    0,   90,    0,
       0,    1,    0,    0,
       0,    0,    0,   46,
       0,    0,    0,    0,
       0,    0,  212,    0,
       0,    0,    0,    0,
       0,    0,   12,    0,
       6,    0,    0,    0,
      82,    0,    0,   51,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   19,
      43,   21,    0,    0,
       0,   57,    0,    0,
       0,    0,   58,    0,
       0,    0,    0,    0,
       0,   31,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  188,    0,
       0,    0,    0,    0,
       0,    0,   52,    0,
       0,    0,    0,  213,
       0,    0,    0,    0,
       0,    0,    0,    8,
     203,    7,  200,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  263,
       0,    0,   54,    0,
       0,    0,    0,   25,
       0,   48,    0,    0,
       0,    0,   32,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     237,    0,    0,  256,
       0,    0,    0,  189,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  192,    0,    0,
     214,    0,  238,    0,
      13,    0,   40,  230,
       9,  202,   14,  201,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   85,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   55,
      61,    0,    0,    0,
      23,    0,    0,    0,
       0,    0,    0,   33,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      83,    0,    0,    0,
       0,  236,    0,    0,
     257,    0,    0,    0,
       0,    0,    0,    0,
     245,    0,    0,    0,
      53,    0,  216,    0,
       0,    0,    0,  239,
       0,    0,    0,    0,
       0,    0,    0,  249,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   60,    0,
       0,  255,    0,    0,
       0,    0,    0,    0,
       0,   62,    0,    0,
       0,    0,    4,    0,
       0,   65,    0,    0,
      36,    0,    0,    0,
       0,    0,    0,    0,
      76,    0,    0,    0,
       0,   84,  248,    0,
       0,    0,  232,    0,
       0,   74,    0,    0,
       0,    0,    0,    0,
      42,  240,    0,    0,
       0,    0,    0,  229,
       0,    0,    0,    0,
};

static table_t table_API_OPENGLES3 = {
     220,    0,    0,  190,
     191,  219,    0,    0,
     250,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     288,  267,    0,    0,
       0,    0,    0,    0,
       0,  311,    0,    0,
       0,    0,  197,    0,
       0,    0,    0,    0,
       0,    0,    0,    5,
       0,    0,    0,    0,
       0,    0,    0,  292,
       0,    0,    0,    0,
      59,    0,    0,    0,
       0,  246,    0,    0,
       0,    0,    0,  234,
       0,    0,  259,    0,
       0,    0,    0,   81,
       0,    0,  241,    0,
       0,    0,    0,  300,
       0,    0,    0,    0,
     189,  224,    0,    0,
       0,    0,    0,    0,
       0,  251,    0,    0,
       0,    0,  276,  261,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  199,
     268,    0,    0,    0,
     301,   38,    0,    0,
     204,    0,    0,    0,
       0,    0,   68,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     233,    0,    0,  260,
       0,    0,    0,    0,
      80,    0,    0,   75,
      17,    0,    0,  223,
       0,    0,    0,    0,
       0,    0,  225,    0,
       0,    0,    0,    0,
       0,    0,  290,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  310,
      37,    0,  270,    0,
     198,    0,    0,    0,
       0,    0,  228,    0,
       0,  207,    0,    0,
       0,    0,    0,   69,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   77,  281,
       0,  235,    0,    0,
       0,    0,    0,    0,
       0,   78,    0,    0,
     243,   18,    0,    0,
     221,    0,  258,    0,
       0,    0,    0,  226,
       0,    0,  265,    0,
      34,  254,    0,  291,
       0,    0,    0,    0,
       0,    0,    0,    0,
     190,  191,    0,    0,
       0,    0,    0,    0,
       0,    0,   86,    0,
       0,    0,   20,    0,
       0,   39,    0,    0,
       0,    0,    0,    0,
       0,   49,  208,    0,
       0,    3,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  244,
       0,    0,    0,    0,
       0,    0,    0,   79,
       0,    0,    0,    0,
       0,  308,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  222,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   28,  252,    0,
     217,    0,    0,    0,
       0,  264,    0,    0,
       0,    0,    0,    0,
       0,    0,  274,    0,
       0,    0,    0,   88,
       0,  273,  185,    0,
       0,    0,    0,  206,
      45,    0,    0,    0,
     193,    0,    0,  209,
      26,    0,    2,    0,
     247,    0,    0,    0,
       0,    0,  227,  304,
       0,    0,    0,    0,
       0,    0,    0,  305,
       0,  282,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  275,  194,    0,
       0,    0,   70,  297,
       0,    0,    0,    0,
       0,  215,    0,    0,
     242,   72,   30,  253,
       0,  218,   66,    0,
       0,    0,    0,  231,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      87,    0,    0,  186,
       0,  271,    0,    0,
      41,   44,    0,    0,
       0,   22,    0,    0,
     210,   27,    0,    0,
       0,    0,    0,    0,
      10,    0,    0,    0,
     302,    0,    0,    0,
       0,    0,    0,    0,
     306,    0,  283,    0,
      24,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   63,  196,
       0,    0,    0,   71,
       0,    0,    0,    0,
       0,  295,    0,    0,
       0,    0,  289,   35,
       0,    0,    0,   67,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  278,
       0,    0,    0,    0,
     205,   89,    0,  272,
     187,    0,    0,    0,
       0,    0,   47,    0,
       0,    0,   16,    0,
       0,  211,    0,    0,
       0,    0,    0,    0,
       0,   11,    0,    0,
       0,  303,    0,    0,
       0,    0,   50,    0,
       0,  307,    0,  285,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   73,   64,
     195,  262,    0,    0,
      56,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      29,    0,    0,    0,
       0,   15,    0,    0,
       0,    0,    0,    0,
       0,    0,  309,    0,
     279,    0,    0,    0,
       0,    0,   90,    0,
       0,    1,    0,    0,
       0,    0,    0,   46,
       0,    0,    0,    0,
       0,    0,  212,  185,
       0,    0,    0,    0,
       0,    0,   12,    0,
       6,    0,    0,    0,
      82,    0,    0,   51,
       0,    0,    0,    0,
     284,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   19,
      43,   21,    0,    0,
       0,   57,    0,    0,
       0,    0,   58,    0,
       0,    0,    0,    0,
       0,   31,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  296,    0,    0,
       0,  280,    0,    0,
       0,    0,    0,    0,
       0,    0,  188,    0,
       0,  277,    0,    0,
       0,    0,   52,    0,
       0,    0,    0,  213,
     186,    0,    0,    0,
       0,    0,    0,    8,
     203,    7,  200,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  286,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  263,
       0,    0,   54,    0,
       0,    0,    0,   25,
       0,   48,    0,    0,
       0,    0,   32,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     237,    0,    0,  256,
       0,    0,    0,  189,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  192,    0,    0,
     214,  187,  238,    0,
      13,    0,   40,  230,
       9,  202,   14,  201,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   85,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   55,
      61,    0,    0,    0,
      23,    0,    0,    0,
       0,  293,    0,   33,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      83,    0,    0,    0,
       0,  236,    0,    0,
     257,    0,    0,    0,
       0,    0,    0,    0,
     245,    0,    0,    0,
      53,  298,  216,    0,
       0,    0,    0,  239,
       0,    0,    0,    0,
       0,    0,    0,  249,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  287,
     269,    0,    0,    0,
       0,    0,   60,    0,
       0,  255,    0,    0,
       0,    0,    0,    0,
       0,   62,    0,    0,
       0,    0,    4,    0,
       0,   65,  294,    0,
      36,    0,    0,    0,
       0,    0,    0,    0,
      76,    0,    0,    0,
       0,   84,  248,    0,
     266,    0,  232,    0,
       0,   74,    0,    0,
       0,    0,    0,    0,
      42,  240,    0,    0,
       0,    0,  299,  229,
       0,    0,    0,  188,
};

static table_t table_API_OPENGLES31 = {
     220,    0,    0,  190,
     191,  219,    0,    0,
     250,    0,    0,    0,
     312,  405,  417,    0,
       0,    0,  345,    0,
     288,  267,    0,  395,
       0,    0,    0,    0,
       0,  311,    0,    0,
     421,    0,  197,  361,
       0,    0,    0,    0,
       0,    0,    0,    5,
       0,    0,    0,    0,
     348,    0,    0,  292,
       0,  370,    0,    0,
      59,    0,    0,    0,
       0,  246,  354,    0,
       0,    0,    0,  234,
       0,    0,  259,  317,
       0,    0,    0,   81,
       0,    0,  241,    0,
       0,    0,    0,  300,
       0,    0,    0,    0,
     189,  224,    0,    0,
       0,    0,    0,    0,
       0,  251,    0,    0,
       0,  313,  276,  261,
       0,    0,    0,  346,
     319,    0,  398,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  199,
     268,    0,    0,    0,
     301,   38,    0,    0,
     204,    0,    0,    0,
       0,    0,   68,    0,
       0,    0,  371,    0,
       0,    0,    0,    0,
       0,    0,  331,    0,
       0,    0,    0,    0,
     233,    0,    0,  260,
       0,    0,    0,    0,
      80,    0,    0,   75,
      17,    0,    0,  223,
       0,    0,    0,    0,
       0,    0,  225,    0,
       0,    0,    0,    0,
       0,    0,  290,    0,
       0,    0,    0,  330,
       0,    0,    0,    0,
     343,    0,    0,  399,
       0,    0,    0,    0,
       0,    0,    0,  310,
      37,    0,  270,    0,
     198,  364,    0,    0,
       0,    0,  228,    0,
       0,  207,    0,    0,
       0,    0,    0,   69,
       0,    0,    0,  372,
       0,    0,    0,    0,
     325,    0,  418,  337,
       0,  336,   77,  281,
       0,  235,    0,    0,
       0,    0,    0,    0,
       0,   78,    0,    0,
     243,   18,    0,    0,
     221,    0,  258,    0,
       0,    0,    0,  226,
       0,    0,  265,    0,
      34,  254,    0,  291,
       0,    0,    0,    0,
     324,  322,    0,    0,
     190,  191,    0,    0,
       0,    0,    0,    0,
       0,    0,   86,    0,
       0,    0,   20,  375,
       0,   39,  363,    0,
       0,    0,    0,    0,
       0,   49,  208,    0,
       0,    3,    0,    0,
       0,    0,    0,    0,
     373,    0,    0,  244,
       0,  406,    0,    0,
       0,    0,  355,   79,
     413,    0,    0,    0,
       0,  308,    0,    0,
       0,    0,  392,    0,
       0,    0,    0,  366,
       0,  222,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   28,  252,    0,
     217,    0,    0,    0,
       0,  264,    0,    0,
       0,  385,  349,    0,
       0,  400,  274,    0,
       0,    0,    0,   88,
     422,  273,  185,    0,
     376,    0,    0,  206,
      45,    0,    0,    0,
     193,    0,    0,  209,
      26,    0,    2,    0,
     247,  362,    0,    0,
     423,    0,  227,  304,
       0,  358,  408,    0,
       0,  396,  381,  305,
       0,  282,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  393,
       0,  275,  194,  340,
       0,    0,   70,  297,
       0,    0,    0,    0,
       0,  215,    0,    0,
     242,   72,   30,  253,
       0,  218,   66,    0,
       0,    0,  357,  231,
       0,    0,  384,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      87,    0,    0,  186,
       0,  271,  332,    0,
      41,   44,    0,    0,
       0,   22,    0,    0,
     210,   27,    0,    0,
       0,    0,    0,    0,
      10,  424,    0,    0,
     302,    0,    0,  404,
       0,    0,  397,  383,
     306,    0,  283,    0,
      24,    0,    0,  341,
       0,    0,    0,    0,
       0,    0,   63,  196,
       0,    0,    0,   71,
       0,    0,    0,    0,
       0,  295,    0,    0,
       0,    0,  289,   35,
       0,    0,    0,   67,
       0,    0,    0,    0,
       0,    0,    0,  386,
       0,  335,    0,  278,
       0,    0,    0,    0,
     205,   89,    0,  272,
     187,    0,  344,  333,
       0,    0,   47,    0,
       0,    0,   16,    0,
       0,  211,    0,    0,
       0,    0,    0,    0,
       0,   11,  425,  374,
       0,  303,    0,    0,
     327,    0,   50,    0,
     382,  307,    0,  285,
       0,    0,    0,    0,
     342,    0,    0,    0,
       0,    0,   73,   64,
     195,  262,  359,    0,
      56,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      29,    0,    0,    0,
     318,   15,    0,    0,
     323,    0,    0,    0,
     387,    0,  309,    0,
     279,    0,    0,  380,
       0,    0,   90,    0,
       0,    1,    0,    0,
     334,    0,    0,   46,
       0,    0,    0,    0,
     328,    0,  212,  185,
       0,    0,    0,    0,
     365,    0,   12,  426,
       6,  394,  351,    0,
      82,  329,    0,   51,
       0,    0,  338,    0,
     284,    0,    0,    0,
       0,  347,    0,    0,
       0,    0,    0,   19,
      43,   21,    0,  410,
       0,   57,    0,    0,
       0,    0,   58,    0,
       0,    0,    0,    0,
       0,   31,    0,    0,
       0,  367,    0,    0,
       0,    0,    0,    0,
       0,  296,    0,    0,
       0,  280,    0,    0,
     378,    0,    0,    0,
       0,    0,  188,    0,
       0,  277,    0,    0,
     403,    0,   52,    0,
       0,    0,    0,  213,
     186,    0,    0,    0,
       0,    0,    0,    8,
     203,    7,  200,  353,
       0,  369,  326,    0,
       0,    0,    0,  339,
       0,  286,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  419,    0,  263,
     411,    0,   54,    0,
       0,    0,    0,   25,
       0,   48,    0,    0,
       0,    0,   32,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  389,    0,
       0,    0,    0,    0,
     237,  379,    0,  256,
       0,    0,    0,  189,
       0,    0,    0,    0,
       0,  401,    0,    0,
       0,  192,    0,    0,
     214,  187,  238,    0,
      13,    0,   40,  230,
       9,  202,   14,  201,
     352,    0,  377,  407,
       0,    0,    0,    0,
       0,    0,  414,   85,
       0,    0,  350,    0,
       0,    0,    0,    0,
       0,    0,  420,    0,
       0,  412,    0,   55,
      61,    0,    0,    0,
      23,    0,  368,    0,
     416,  293,    0,   33,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  390,
      83,    0,    0,    0,
       0,  236,    0,    0,
     257,    0,    0,    0,
       0,    0,    0,    0,
     245,    0,  320,    0,
      53,  298,  216,  356,
       0,  314,    0,  239,
       0,    0,    0,    0,
     402,    0,    0,  249,
       0,    0,    0,  316,
     409,    0,    0,    0,
       0,    0,    0,  287,
     269,    0,    0,    0,
       0,    0,   60,    0,
       0,  255,    0,  415,
       0,    0,  360,    0,
       0,   62,    0,    0,
       0,    0,    4,    0,
       0,   65,  294,    0,
      36,    0,    0,    0,
       0,    0,    0,    0,
      76,    0,    0,    0,
     391,   84,  248,    0,
     266,    0,  232,    0,
       0,   74,    0,    0,
       0,    0,  388,    0,
      42,  240,    0,  321,
       0,    0,  299,  229,
       0,    0,  315,  188,
};

static table_t table_API_OPENGLES32 = {
     220,    0,    0,  190,
     191,  219,    0,    0,
     250,    0,    0,    0,
     312,  405,  417,    0,
       0,    0,  345,    0,
     288,  267,    0,  395,
       0,    0,    0,    0,
       0,  311,    0,    0,
     421,    0,  197,  361,
       0,    0,    0,    0,
       0,    0,    0,    5,
       0,    0,    0,    0,
     348,    0,  428,  292,
       0,  370,    0,    0,
      59,    0,    0,    0,
       0,  246,  354,    0,
       0,    0,    0,  234,
       0,    0,  259,  317,
       0,    0,    0,   81,
       0,    0,  241,    0,
       0,    0,    0,  300,
       0,    0,    0,    0,
     189,  224,    0,    0,
       0,    0,    0,    0,
       0,  251,    0,    0,
       0,  313,  276,  261,
       0,    0,    0,  346,
     319,    0,  398,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  199,
     268,    0,    0,    0,
     301,   38,    0,    0,
     204,    0,    0,    0,
       0,    0,   68,    0,
       0,    0,  371,    0,
       0,    0,    0,    0,
       0,    0,  331,    0,
       0,    0,    0,    0,
     233,    0,    0,  260,
       0,    0,    0,    0,
      80,    0,    0,   75,
      17,    0,    0,  223,
       0,    0,    0,    0,
       0,    0,  225,    0,
       0,    0,    0,    0,
       0,    0,  290,    0,
       0,    0,    0,  330,
       0,    0,    0,    0,
     343,    0,    0,  399,
       0,    0,    0,    0,
       0,    0,    0,  310,
      37,    0,  270,    0,
     198,  364,    0,    0,
       0,    0,  228,    0,
       0,  207,    0,    0,
       0,    0,    0,   69,
       0,    0,    0,  372,
       0,    0,    0,    0,
     325,    0,  418,  337,
       0,  336,   77,  281,
       0,  235,    0,    0,
       0,    0,    0,    0,
       0,   78,    0,    0,
     243,   18,    0,    0,
     221,    0,  258,    0,
       0,    0,    0,  226,
       0,    0,  265,    0,
      34,  254,    0,  291,
       0,    0,    0,    0,
     324,  322,    0,    0,
     190,  191,    0,    0,
       0,    0,    0,    0,
       0,    0,   86,    0,
       0,    0,   20,  375,
       0,   39,  363,    0,
       0,    0,    0,    0,
       0,   49,  208,    0,
       0,    3,    0,    0,
       0,    0,    0,    0,
     373,    0,    0,  244,
       0,  406,    0,    0,
       0,    0,  355,   79,
     413,    0,    0,    0,
       0,  308,    0,    0,
       0,    0,  392,    0,
       0,    0,    0,  366,
       0,  222,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   28,  252,    0,
     217,    0,    0,    0,
       0,  264,    0,    0,
       0,  385,  349,    0,
       0,  400,  274,    0,
       0,    0,    0,   88,
     422,  273,  185,    0,
     376,    0,    0,  206,
      45,    0,    0,    0,
     193,    0,    0,  209,
      26,    0,    2,    0,
     247,  362,    0,    0,
     423,    0,  227,  304,
       0,  358,  408,    0,
       0,  396,  381,  305,
       0,  282,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  393,
       0,  275,  194,  340,
       0,    0,   70,  297,
       0,    0,    0,    0,
       0,  215,    0,    0,
     242,   72,   30,  253,
       0,  218,   66,    0,
       0,    0,  357,  231,
       0,    0,  384,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      87,    0,    0,  186,
       0,  271,  332,    0,
      41,   44,    0,    0,
       0,   22,    0,    0,
     210,   27,    0,    0,
       0,    0,    0,    0,
      10,  424,    0,    0,
     302,    0,    0,  404,
       0,    0,  397,  383,
     306,    0,  283,    0,
      24,    0,    0,  341,
       0,    0,    0,    0,
       0,    0,   63,  196,
       0,    0,    0,   71,
       0,    0,    0,    0,
       0,  295,    0,    0,
       0,    0,  289,   35,
       0,    0,    0,   67,
       0,    0,    0,    0,
       0,    0,    0,  386,
       0,  335,    0,  278,
       0,    0,    0,    0,
     205,   89,    0,  272,
     187,    0,  344,  333,
       0,    0,   47,    0,
       0,    0,   16,    0,
       0,  211,    0,    0,
       0,    0,    0,    0,
       0,   11,  425,  374,
       0,  303,    0,    0,
     327,    0,   50,    0,
     382,  307,    0,  285,
       0,    0,    0,    0,
     342,    0,    0,    0,
       0,    0,   73,   64,
     195,  262,  359,    0,
      56,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      29,    0,    0,    0,
     318,   15,    0,    0,
     323,    0,    0,    0,
     387,    0,  309,    0,
     279,    0,    0,  380,
       0,    0,   90,    0,
       0,    1,    0,    0,
     334,    0,    0,   46,
       0,    0,    0,    0,
     328,    0,  212,  185,
       0,    0,    0,    0,
     365,    0,   12,  426,
       6,  394,  351,    0,
      82,  329,    0,   51,
       0,    0,  338,    0,
     284,    0,    0,    0,
       0,  347,    0,    0,
       0,    0,    0,   19,
      43,   21,    0,  410,
       0,   57,    0,    0,
       0,    0,   58,    0,
       0,    0,    0,    0,
       0,   31,    0,    0,
       0,  367,    0,    0,
       0,    0,    0,    0,
       0,  296,    0,    0,
       0,  280,    0,    0,
     378,    0,    0,    0,
       0,    0,  188,    0,
       0,  277,    0,    0,
     403,    0,   52,    0,
       0,    0,    0,  213,
     186,    0,    0,    0,
       0,    0,    0,    8,
     203,    7,  200,  353,
       0,  369,  326,    0,
       0,    0,    0,  339,
       0,  286,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  419,    0,  263,
     411,    0,   54,    0,
       0,    0,    0,   25,
       0,   48,    0,    0,
       0,    0,   32,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  389,    0,
       0,    0,    0,    0,
     237,  379,    0,  256,
       0,    0,    0,  189,
       0,    0,    0,    0,
       0,  401,    0,    0,
       0,  192,    0,    0,
     214,  187,  238,    0,
      13,    0,   40,  230,
       9,  202,   14,  201,
     352,    0,  377,  407,
       0,    0,    0,    0,
       0,    0,  414,   85,
       0,    0,  350,    0,
       0,    0,    0,    0,
       0,    0,  420,    0,
       0,  412,    0,   55,
      61,    0,    0,    0,
      23,    0,  368,    0,
     416,  293,    0,   33,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  390,
      83,    0,    0,    0,
       0,  236,    0,    0,
     257,    0,    0,    0,
       0,    0,    0,    0,
     245,    0,  320,    0,
      53,  298,  216,  356,
       0,  314,    0,  239,
       0,    0,    0,    0,
     402,    0,    0,  249,
       0,    0,    0,  316,
     409,    0,    0,    0,
       0,  429,    0,  287,
     269,    0,    0,    0,
       0,    0,   60,    0,
       0,  255,    0,  415,
       0,    0,  360,    0,
       0,   62,    0,    0,
       0,    0,    4,    0,
       0,   65,  294,    0,
      36,  427,    0,    0,
       0,    0,    0,    0,
      76,    0,    0,    0,
     391,   84,  248,    0,
     266,    0,  232,    0,
       0,   74,    0,    0,
       0,    0,  388,    0,
      42,  240,    0,  321,
       0,    0,  299,  229,
       0,    0,  315,  188,
};

static table_t table_API_OPENGL_CORE = {
      92,  563,  502,    0,
     149,  219,    0,    0,
     250,  506,  574,  118,
     312,  405,  417,    0,
       0,    0,  345,  608,
     288,  267,    0,  395,
       0,    0,    0,  484,
       0,    0,    0,  507,
     421,    0,  197,  361,
       0,    0,  176,  161,
     538,  144,  150,    5,
       0,    0,  435,    0,
     348,    0,  428,  292,
     151,  370,  473,    0,
      59,  629,    0,    0,
       0,  246,  354,    0,
     605,    0,    0,  234,
       0,    0,  259,  317,
       0,  618,  432,   81,
     567,  530,  241,    0,
       0,  258,  379,  300,
     155,    0,  388,    0,
       0,   93,  564,    0,
       0,  154,    0,    0,
     120,  251,  475,  631,
     439,  313,  328,  261,
       0,    0,    0,  346,
     319,    0,  398,    0,
       0,  580,    0,    0,
     485,    0,    0,    0,
     134,    0,    0,  199,
     268,    0,    0,  177,
     301,   38,  128,    0,
     204,    0,    0,  454,
       0,  442,   68,    0,
       0,  443,  371,    0,
     143,  650,  641,    0,
     603,  440,  331,    0,
       0,  606,    0,    0,
     233,    0,    0,  260,
       0,    0,  619,  433,
      80,  568,  546,   75,
      17,    0,  551,  223,
     557,  159,  575,  609,
     465,  594,   94,    0,
     466,  497,  136,    0,
     607,  460,  290,  476,
     632,  448,    0,  330,
       0,    0,  590,    0,
     343,    0,    0,  399,
       0,  458,    0,    0,
       0,  486,    0,    0,
      37,  135,  270,    0,
     198,  364,    0,    0,
     178,  163,  228,  483,
     610,  207,    0,    0,
     106,    0,    0,   69,
       0,    0,  444,  372,
       0,  141,  651,    0,
     325,    0,  418,  337,
     627,  336,   77,  281,
       0,  235,    0,    0,
     500,    0,    0,  622,
       0,   78,  569,  547,
     243,   18,    0,  499,
     221,  558,  162,  450,
     646,  533,  595,   95,
       0,  531,  265,  148,
      34,  254,  122,  291,
       0,    0,  451,    0,
     324,  107,    0,  591,
       0,  344,    0,    0,
     600,    0,  459,  630,
       0,    0,   86,    0,
       0,  463,   20,  375,
       0,   39,  363,    0,
     519,  596,  164,  139,
     124,   49,  208,    0,
       0,    3,    0,    0,
       0,    0,    0,  115,
     373,    0,  142,  244,
       0,  406,    0,  581,
       0,  437,  355,   79,
     413,    0,    0,  654,
     480,  308,    0,    0,
     621,    0,  392,    0,
     462,  510,    0,  366,
     638,  222,    0,  498,
     540,  647,  455,  584,
      96,    0,    0,    0,
     153,   28,  252,  126,
     217,  495,    0,  449,
       0,  356,  108,    0,
       0,  385,  349,  613,
       0,  400,  274,  490,
       0,  446,    0,   88,
     422,  273,    0,  504,
     376,  624,  588,  206,
      45,  522,  179,  165,
     193,  582,    0,  209,
      26,    0,    2,    0,
     247,  362,    0,    0,
     423,  527,  227,  304,
       0,  358,  408,    0,
       0,  396,  381,  305,
       0,  282,    0,    0,
     655,  481,  634,    0,
       0,  620,    0,  393,
     505,  275,  194,  340,
       0,    0,   70,  297,
     166,  180,  648,  535,
     539,   97,    0,    0,
     103,   72,   30,  253,
     123,  218,   66,    0,
     452,    0,  357,  109,
       0,    0,  384,    0,
       0,    0,  586,  298,
     534,    0,    0,    0,
      87,    0,    0,  623,
       0,  271,  332,    0,
      41,   44,  520,  597,
     550,   22,    0,    0,
     210,   27,    0,  429,
       0,    0,  636,    0,
      10,  424,  529,  633,
     302,    0,    0,  404,
       0,  453,  397,  383,
     306,    0,  283,    0,
      24,    0,  491,  341,
       0,    0,    0,  436,
     593,   91,   63,  196,
       0,    0,    0,   71,
     611,  556,  542,  649,
       0,  295,   98,    0,
       0,  104,  289,   35,
       0,  125,    0,   67,
     127,  447,  617,    0,
     110,    0,    0,  386,
       0,  335,    0,  278,
     299,    0,    0,    0,
     205,   89,  220,  272,
     276,    0,  145,  333,
     589,  171,   47,  518,
     598,  552,   16,  487,
     532,  211,    0,  642,
     585,    0,  587,  639,
       0,   11,  425,  374,
       0,  303,    0,    0,
     327,    0,   50,    0,
     382,  307,    0,  285,
     579,  524,    0,  492,
     342,    0,    0,    0,
     173,    0,   73,   64,
     195,  262,  359,    0,
      56,  612,  156,  543,
       0,    0,  657,   99,
     131,    0,  105,    0,
      29,    0,  121,    0,
     318,   15,    0,    0,
     323,  111,    0,    0,
     387,    0,    0,  469,
     279,  555,    0,  380,
       0,  493,   90,  224,
       0,    1,    0,  146,
     334,    0,  170,   46,
     517,  174,  553,  537,
     488,  438,  212,    0,
     643,    0,    0,    0,
     132,    0,   12,  426,
       6,  394,  351,    0,
      82,  329,    0,   51,
       0,  640,  338,    0,
     284,  512,  526,    0,
     523,  347,    0,    0,
       0,    0,    0,   19,
      43,   21,    0,  410,
       0,   57,    0,  157,
       0,    0,   58,  658,
     592,  478,  461,    0,
       0,   31,    0,    0,
     100,  367,  129,    0,
       0,    0,  112,    0,
       0,  242,    0,    0,
       0,  280,    0,  496,
     378,  645,  494,    0,
     225,    0,    0,  513,
     147,  277,    0,  570,
     403,  516,   52,  554,
       0,  489,    0,  213,
       0,  644,    0,    0,
       0,  138,    0,    8,
     203,    7,  200,  353,
     116,  369,  326,    0,
       0,    0,    0,  339,
       0,  286,    0,    0,
       0,  528,    0,    0,
     479,    0,  635,    0,
     508,  419,    0,  263,
     411,    0,   54,  583,
     158,    0,    0,   25,
     464,   48,  130,  441,
     601,    0,   32,    0,
       0,  470,  656,  474,
       0,    0,    0,  113,
       0,    0,  389,    0,
       0,    0,    0,    0,
     237,  152,    0,  256,
       0,  226,  615,  264,
       0,  119,  467,    0,
     571,  401,  521,  175,
     167,  192,  578,  322,
     214,    0,  238,  637,
      13,    0,   40,  230,
       9,  202,   14,  201,
     352,  445,  377,  407,
       0,    0,    0,    0,
       0,    0,  414,   85,
     457,    0,  350,    0,
     560,  482,    0,  614,
       0,  503,  420,    0,
     545,  412,  525,   55,
      61,  548,    0,  625,
      23,  468,  368,  559,
     416,  293,    0,   33,
     434,    0,  102,  653,
     471,    0,    0,    0,
     114,    0,    0,  390,
      83,    0,    0,    0,
       0,  236,    0,    0,
     257,    0,  511,  616,
     430,    0,  565,  172,
     245,  572,  320,  515,
      53,  168,  216,  576,
     456,  314,    0,  239,
     562,  501,    0,  137,
     402,    0,  599,  249,
     477,  573,  117,  316,
     409,    0,    0,    0,
       0,  365,    0,  287,
     269,  652,    0,    0,
       0,  561,   60,    0,
       0,  255,  133,  415,
       0,  544,  360,  549,
       0,   62,  160,    0,
     140,    0,    4,    0,
     604,   65,  294,    0,
      36,  427,    0,  101,
       0,  472,    0,  628,
      76,  602,    0,    0,
     391,   84,  248,    0,
     266,    0,  232,  541,
       0,   74,  626,  215,
     509,  431,  296,  566,
      42,  240,    0,  321,
     514,  536,  169,  229,
     577,  231,  315,    0,
};

static table_t *table_set[] = {
   &table_API_OPENGL,
   &table_API_OPENGLES,
   &table_API_OPENGLES2,
   &table_API_OPENGL_CORE,
   &table_API_OPENGLES3,
   &table_API_OPENGLES31,
   &table_API_OPENGLES32,
};

#define table(api) (*table_set[api])
