"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("core-js/modules/es.typed-array.set.js");

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class QueryService {
  constructor(client) {
    _defineProperty(this, "client", void 0);

    _defineProperty(this, "describeQueryPostInternal", async (request, format, responseFormat, body) => {
      try {
        const params = {
          body: JSON.stringify(body)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });

    _defineProperty(this, "describeQueryJobIdInternal", async (request, format, jobId, responseFormat) => {
      try {
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, {
          jobId: jobId
        });
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });

    _defineProperty(this, "describeQueryGetInternalSync", async (request, format, responseFormat) => {
      try {
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format);
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });

    _defineProperty(this, "describeSQLQuery", async request => {
      return this.describeQueryPostInternal(request, 'sql.sqlQuery', 'json', request.body);
    });

    _defineProperty(this, "describePPLQuery", async request => {
      return this.describeQueryPostInternal(request, 'sql.pplQuery', 'json', request.body);
    });

    _defineProperty(this, "describeSQLCsv", async request => {
      return this.describeQueryPostInternal(request, 'sql.sqlCsv', null, request.body);
    });

    _defineProperty(this, "describePPLCsv", async request => {
      return this.describeQueryPostInternal(request, 'sql.pplCsv', null, request.body);
    });

    _defineProperty(this, "describeSQLJson", async request => {
      return this.describeQueryPostInternal(request, 'sql.sqlJson', 'json', request.body);
    });

    _defineProperty(this, "describePPLJson", async request => {
      return this.describeQueryPostInternal(request, 'sql.pplJson', 'json', request.body);
    });

    _defineProperty(this, "describeSQLText", async request => {
      return this.describeQueryPostInternal(request, 'sql.sqlText', null, request.body);
    });

    _defineProperty(this, "describePPLText", async request => {
      return this.describeQueryPostInternal(request, 'sql.pplText', null, request.body);
    });

    _defineProperty(this, "describeSQLAsyncQuery", async request => {
      return this.describeQueryPostInternal(request, 'sql.sparkSqlQuery', null, request.body);
    });

    _defineProperty(this, "describeSQLAsyncGetQuery", async (request, jobId) => {
      return this.describeQueryJobIdInternal(request, 'sql.sparkSqlGetQuery', jobId, null);
    });

    _defineProperty(this, "describeSyncQueryDataSources", async request => {
      return this.describeQueryGetInternalSync(request, 'sql.datasourcesGetQuery', null);
    });

    _defineProperty(this, "describeAsyncDeleteQuery", async (request, jobId) => {
      return this.describeQueryJobIdInternal(request, 'sql.asyncDeleteQuery', jobId, null);
    });

    this.client = client;
  }

}

exports.default = QueryService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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