/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.List;
import org.jparsec.ListFactory;
import org.jparsec.ParseContext;
import org.jparsec.Parser;

final class DelimitedParser<T>
extends Parser<List<T>> {
    private final Parser<T> parser;
    private final Parser<?> delim;
    private final ListFactory<T> listFactory;

    DelimitedParser(Parser<T> p, Parser<?> delim, ListFactory<T> listFactory) {
        this.parser = p;
        this.delim = delim;
        this.listFactory = listFactory;
    }

    @Override
    final boolean apply(ParseContext ctxt) {
        List<T> result = this.listFactory.newList();
        while (true) {
            int step0 = ctxt.step;
            int at0 = ctxt.at;
            boolean r = ctxt.applyAsDelimiter(this.delim);
            if (!r) {
                ctxt.result = result;
                ctxt.setAt(step0, at0);
                return true;
            }
            int step1 = ctxt.step;
            int at1 = ctxt.at;
            r = this.parser.apply(ctxt);
            if (!r) {
                ctxt.result = result;
                ctxt.setAt(step1, at1);
                return true;
            }
            if (at0 == ctxt.at) {
                ctxt.result = result;
                return true;
            }
            result.add(this.parser.getReturn(ctxt));
        }
    }

    public String toString() {
        return "delimited";
    }
}

