/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Map;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@Singleton
@ChannelHandler.Sharable
public class DriverEventHandler
extends BaseEventHandler {
    private final CacheManager cacheManager;

    @Inject
    public DriverEventHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        if (!PositionUtil.isLatest(this.cacheManager, position)) {
            return null;
        }
        String driverUniqueId = position.getString("driverUniqueId");
        if (driverUniqueId != null) {
            String oldDriverUniqueId = null;
            Position lastPosition = this.cacheManager.getPosition(position.getDeviceId());
            if (lastPosition != null) {
                oldDriverUniqueId = lastPosition.getString("driverUniqueId");
            }
            if (!driverUniqueId.equals(oldDriverUniqueId)) {
                Event event = new Event("driverChanged", position);
                event.set("driverUniqueId", driverUniqueId);
                return Collections.singletonMap(event, position);
            }
        }
        return null;
    }
}

