/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * reflect(0.0, -1.0) => 0.0
 * reflect(0.0, 1.0) => 0.0
 * reflect(-1.33, -1.0) => 1.33
 * reflect(-1.33, 1.0) => 1.33
 * reflect(0.85, -1.0) => -0.85
 * reflect(0.85, 1.0) => -0.85
 */
#version 120

void main()
{
  float[distance(reflect(0.0, -1.0), 0.0) <= 0.0 ? 1 : -1] array0;
  float[distance(reflect(0.0, 1.0), 0.0) <= 0.0 ? 1 : -1] array1;
  float[distance(reflect(-1.33, -1.0), 1.33) <= 1.33e-05 ? 1 : -1] array2;
  float[distance(reflect(-1.33, 1.0), 1.33) <= 1.33e-05 ? 1 : -1] array3;
  float[distance(reflect(0.85, -1.0), -0.85) <= 8.5e-06 ? 1 : -1] array4;
  float[distance(reflect(0.85, 1.0), -0.85) <= 8.5e-06 ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
