/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.BiFunction;

public class UniWithContext<I, O>
extends UniOperator<I, O> {
    private final Uni<I> upstream;
    private final BiFunction<Uni<I>, Context, Uni<O>> builder;

    public UniWithContext(Uni<I> upstream, BiFunction<Uni<I>, Context, Uni<O>> builder) {
        super(upstream);
        this.upstream = upstream;
        this.builder = builder;
    }

    @Override
    public void subscribe(UniSubscriber<? super O> downstream) {
        Uni<O> uni;
        Context context = downstream.context();
        try {
            uni = this.builder.apply(this.upstream, context);
            if (uni == null) {
                downstream.onSubscribe(EmptyUniSubscription.DONE);
                downstream.onFailure(new NullPointerException("The builder function returned null"));
                return;
            }
        }
        catch (Throwable err) {
            downstream.onSubscribe(EmptyUniSubscription.DONE);
            downstream.onFailure(err);
            return;
        }
        Uni<O> pipelineWithContext = Infrastructure.onUniCreation(uni);
        AbstractUni.subscribe(pipelineWithContext, downstream);
    }
}

