/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.net.SocketException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.resource.DriverResources;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.NetStat;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnectDescription;
import oracle.net.nt.NTAdapter;
import org.ietf.jgss.GSSCredential;

public interface Communication {
    public void connect(GSSCredential var1, DMSFactory.DMSNoun var2) throws IOException, NetException;

    default public CompletionStage<Void> connectAsync(GSSCredential gssCredential, DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler loginTimeoutHandler, Executor asyncExecutor) {
        return CompletionStageUtil.failedStage(new UnsupportedOperationException());
    }

    public SessionAtts getSessionAttributes();

    public void cancelTimeout();

    public void disconnect() throws IOException, NetException;

    public void sendBreak() throws IOException, NetException;

    public void sendInterrupt() throws IOException, NetException;

    public void sendReset() throws IOException, NetException;

    public void setAuthSessionKey(byte[] var1) throws NetException, NetException;

    public void doKeyFoldinForExternalAuth();

    public void setOption(int var1, Object var2) throws NetException, IOException;

    public Object getOption(int var1) throws NetException, IOException;

    public void abort() throws NetException, IOException;

    public String getEncryptionName();

    public String getDataIntegrityName();

    public String getAuthenticationAdaptorName();

    public boolean readZeroCopyIO(byte[] var1, int var2, int[] var3) throws IOException;

    public void writeZeroCopyIO(byte[] var1, int var2, int var3) throws IOException;

    public void writeZeroCopyIOHeader(boolean var1, int var2, boolean var3) throws IOException;

    public void writeZeroCopyIOData(byte[] var1, int var2, int var3) throws IOException;

    public boolean isConnectionSocketKeepAlive() throws SocketException;

    public int getSocketReadTimeout() throws NetException, IOException;

    public void setSocketReadTimeout(int var1) throws NetException, IOException;

    public String getConnectionString();

    public int getNegotiatedSDU() throws NetException;

    public String getAccessBanner();

    public NetStat getNetworkStat();

    public boolean isNetworkCompressionEnabled();

    public int getOutboundConnectTimeout();

    public boolean isUsingCustomHostnameResolver();

    public void sendZDP() throws IOException;

    public boolean needsToBeClosed();

    public void readInbandNotification();

    default public boolean isTLSEnabled() {
        SessionAtts sessionAtts = this.getSessionAttributes();
        if (sessionAtts == null) {
            return false;
        }
        NTAdapter ntAdapter = sessionAtts.getNTAdapter();
        if (ntAdapter == null) {
            return false;
        }
        return ntAdapter.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCPS;
    }

    default public void onWriteReady(Consumer<Throwable> callback) {
        try {
            this.getConnectedSessionAttributes().getNTAdapter().registerForNonBlockingWrite(callback);
        }
        catch (Exception exception) {
            callback.accept(exception);
        }
    }

    default public void onReadReady(Consumer<Throwable> callback) {
        try {
            SessionAtts sessionAtts = this.getConnectedSessionAttributes();
            if (sessionAtts.readBuffer.hasRemaining()) {
                callback.accept(null);
            } else {
                sessionAtts.getNTAdapter().registerForNonBlockingRead(callback);
            }
        }
        catch (Exception exception) {
            callback.accept(exception);
        }
    }

    default public void enqueueBlockedWrites(boolean isEnabled) throws IOException {
        this.getConnectedSessionAttributes().getNTAdapter().enqueueBlockedWrites(isEnabled);
    }

    default public boolean completeBlockedWrites() throws IOException {
        return this.getConnectedSessionAttributes().getNTAdapter().completeBlockedWrites();
    }

    default public boolean isOutOfBandDataEnabled() throws IOException {
        return this.getConnectedSessionAttributes().isExpediatedAttentionEnabled();
    }

    default public SessionAtts getConnectedSessionAttributes() throws IOException {
        SessionAtts sessionAtts = this.getSessionAttributes();
        if (sessionAtts == null || !sessionAtts.isConnected()) {
            throw new NetException(17900);
        }
        return sessionAtts;
    }

    public List<ConnectDescription> getConnectDescriptions();

    public ConnectDescription getConnectedDescription();

    public void setDriverResources(DriverResources var1);
}

