/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.websocket;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.websocket.server.JettyWebSocketServletFactory;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.websocket.ColibriWebSocket;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;

class ColibriWebSocketServlet
extends JettyWebSocketServlet {
    private static final Logger logger = new LoggerImpl(ColibriWebSocketServlet.class.getName());
    private final String serverId;
    @NotNull
    private final Videobridge videobridge;

    ColibriWebSocketServlet(@NotNull String serverId2, @NotNull Videobridge videobridge) {
        this.serverId = serverId2;
        this.videobridge = videobridge;
    }

    @Override
    public void configure(JettyWebSocketServletFactory webSocketServletFactory) {
        webSocketServletFactory.setIdleTimeout(Duration.ofMinutes(1L));
        webSocketServletFactory.setCreator((request, response2) -> {
            try {
                return this.createWebSocket(request, response2);
            }
            catch (IOException ioe) {
                response2.setStatusCode(500);
                return null;
            }
        });
    }

    private ColibriWebSocket createWebSocket(JettyServerUpgradeRequest request, JettyServerUpgradeResponse response2) throws IOException {
        AbstractEndpointMessageTransport eventHandler;
        boolean isRelay;
        String path = request.getRequestURI().getPath();
        logger.debug(() -> "Got a create websocket request at path " + path);
        if (path == null) {
            logger.debug(() -> "Received request for an invalid path: " + path);
            response2.sendError(404, "invalid path");
            return null;
        }
        if (path.startsWith("/colibri-ws/")) {
            isRelay = false;
        } else if (path.startsWith("/colibri-relay-ws/")) {
            isRelay = true;
        } else {
            logger.debug(() -> "Received request for an invalid path: " + path);
            response2.sendError(404, "invalid path");
            return null;
        }
        String wsPath = path.substring((isRelay ? "/colibri-relay-ws/" : "/colibri-ws/").length());
        String[] ids = wsPath.split("/");
        if (ids.length < 3) {
            logger.debug(() -> "Received request for an invalid path: " + wsPath);
            response2.sendError(404, "invalid path");
            return null;
        }
        if (!this.serverId.equals(ids[0])) {
            logger.warn("Received request with a mismatching server ID (expected '" + this.serverId + "', received '" + ids[0] + "').");
            response2.sendError(404, "server ID mismatch");
            return null;
        }
        String authFailed = "authentication failed";
        Conference conference = this.videobridge.getConference(ids[1]);
        if (conference == null) {
            logger.warn("Received request for an nonexistent conference: " + ids[1]);
            response2.sendError(403, authFailed);
            return null;
        }
        if (isRelay) {
            Relay relay = conference.getRelay(ids[2]);
            if (relay == null) {
                logger.warn("Received request for a nonexistent relay: " + ids[2] + " (conference " + conference.getID() + ")");
                response2.sendError(403, authFailed);
                return null;
            }
            String pwd = this.getPwd(request.getRequestURI().getQuery());
            if (!relay.acceptWebSocket(pwd)) {
                response2.sendError(403, authFailed);
                return null;
            }
            eventHandler = relay.getMessageTransport();
        } else {
            Endpoint endpoint = conference.getLocalEndpoint(ids[2]);
            if (endpoint == null) {
                logger.warn("Received request for a nonexistent endpoint: " + ids[2] + " (conference " + conference.getID() + ")");
                response2.sendError(403, authFailed);
                return null;
            }
            String pwd = this.getPwd(request.getRequestURI().getQuery());
            if (!endpoint.acceptWebSocket(pwd)) {
                response2.sendError(403, authFailed);
                return null;
            }
            eventHandler = endpoint.getMessageTransport();
        }
        if (!WebsocketServiceConfig.config.shouldEnableCompression()) {
            List<ExtensionConfig> extensions = response2.getExtensions().stream().filter(ext -> !ext.getName().equals("permessage-deflate")).collect(Collectors.toList());
            response2.setExtensions(extensions);
        }
        return new ColibriWebSocket(ids[2], (ColibriWebSocket.EventHandler)((Object)eventHandler));
    }

    private String getPwd(String query) {
        if (query == null) {
            return null;
        }
        if (!query.startsWith("pwd=")) {
            return null;
        }
        return query.substring("pwd=".length());
    }
}

