/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transport.ice;

import com.google.common.net.InetAddresses;
import java.net.Inet6Address;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.LocalCandidate;
import org.jitsi.videobridge.ice.IceConfig;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.CandidateType;
import org.jitsi.xmpp.extensions.jingle.IceCandidatePacketExtension;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\u0005*\u00020\nH\u0002\u001a\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0002\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u0006*\u00020\u0003H\u0002\u00a8\u0006\u000e"}, d2={"generateCandidateId", "", "candidate", "Lorg/ice4j/ice/LocalCandidate;", "ipNeedsResolution", "", "Lorg/jitsi/xmpp/extensions/jingle/CandidatePacketExtension;", "isPrivateAddress", "Lorg/ice4j/TransportAddress;", "isTcpType", "Lorg/ice4j/Transport;", "remoteUfragAndPasswordKnown", "Lorg/ice4j/ice/IceMediaStream;", "toCandidatePacketExtension", "jitsi-videobridge"})
public final class IceTransportKt {
    private static final boolean remoteUfragAndPasswordKnown(IceMediaStream $this$remoteUfragAndPasswordKnown) {
        return $this$remoteUfragAndPasswordKnown.getRemoteUfrag() != null && $this$remoteUfragAndPasswordKnown.getRemotePassword() != null;
    }

    private static final boolean ipNeedsResolution(CandidatePacketExtension $this$ipNeedsResolution) {
        return !InetAddresses.isInetAddress($this$ipNeedsResolution.getIP());
    }

    private static final boolean isPrivateAddress(TransportAddress $this$isPrivateAddress) {
        return $this$isPrivateAddress.getAddress().isSiteLocalAddress() || $this$isPrivateAddress.getAddress() instanceof Inet6Address && ($this$isPrivateAddress.getAddressBytes()[0] & 0xFE) == 252;
    }

    private static final boolean isTcpType(Transport $this$isTcpType) {
        return $this$isTcpType == Transport.TCP || $this$isTcpType == Transport.SSLTCP;
    }

    private static final String generateCandidateId(LocalCandidate candidate) {
        StringBuilder stringBuilder;
        StringBuilder $this$generateCandidateId_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateCandidateId_u24lambda_u2d0.append(Long.toHexString($this$generateCandidateId_u24lambda_u2d0.hashCode()));
        $this$generateCandidateId_u24lambda_u2d0.append(Long.toHexString(candidate.getParentComponent().getParentStream().getParentAgent().hashCode()));
        $this$generateCandidateId_u24lambda_u2d0.append(Long.toHexString(candidate.getParentComponent().getParentStream().getParentAgent().getGeneration()));
        $this$generateCandidateId_u24lambda_u2d0.append(Long.toHexString(candidate.hashCode()));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final CandidatePacketExtension toCandidatePacketExtension(LocalCandidate $this$toCandidatePacketExtension) {
        IceCandidatePacketExtension cpe;
        block5: {
            if (!IceConfig.config.getAdvertisePrivateCandidates()) {
                TransportAddress transportAddress = $this$toCandidatePacketExtension.getTransportAddress();
                Intrinsics.checkNotNullExpressionValue(transportAddress, "transportAddress");
                if (IceTransportKt.isPrivateAddress(transportAddress)) {
                    return null;
                }
            }
            cpe = new IceCandidatePacketExtension();
            cpe.setComponent($this$toCandidatePacketExtension.getParentComponent().getComponentID());
            cpe.setFoundation($this$toCandidatePacketExtension.getFoundation());
            cpe.setGeneration($this$toCandidatePacketExtension.getParentComponent().getParentStream().getParentAgent().getGeneration());
            cpe.setID(IceTransportKt.generateCandidateId($this$toCandidatePacketExtension));
            cpe.setNetwork(0);
            cpe.setPriority($this$toCandidatePacketExtension.getPriority());
            cpe.setProtocol($this$toCandidatePacketExtension.getTransport() == Transport.TCP && $this$toCandidatePacketExtension.isSSL() ? Transport.SSLTCP.toString() : $this$toCandidatePacketExtension.getTransport().toString());
            Transport transport = $this$toCandidatePacketExtension.getTransport();
            Intrinsics.checkNotNullExpressionValue((Object)transport, "transport");
            if (IceTransportKt.isTcpType(transport)) {
                cpe.setTcpType($this$toCandidatePacketExtension.getTcpType().toString());
            }
            String string = $this$toCandidatePacketExtension.getType().toString();
            Intrinsics.checkNotNullExpressionValue(string, "type.toString()");
            cpe.setType(CandidateType.valueOf(string));
            cpe.setIP($this$toCandidatePacketExtension.getTransportAddress().getHostAddress());
            cpe.setPort($this$toCandidatePacketExtension.getTransportAddress().getPort());
            TransportAddress transportAddress = $this$toCandidatePacketExtension.getRelatedAddress();
            if (transportAddress == null) break block5;
            TransportAddress it = transportAddress;
            boolean bl = false;
            if (!IceConfig.config.getAdvertisePrivateCandidates() && IceTransportKt.isPrivateAddress(it)) {
                cpe.setRelAddr("0.0.0.0");
                cpe.setRelPort(9);
            } else {
                cpe.setRelAddr(it.getHostAddress());
                cpe.setRelPort(it.getPort());
            }
        }
        return cpe;
    }

    public static final /* synthetic */ boolean access$remoteUfragAndPasswordKnown(IceMediaStream $receiver) {
        return IceTransportKt.remoteUfragAndPasswordKnown($receiver);
    }

    public static final /* synthetic */ boolean access$isTcpType(Transport $receiver) {
        return IceTransportKt.isTcpType($receiver);
    }

    public static final /* synthetic */ CandidatePacketExtension access$toCandidatePacketExtension(LocalCandidate $receiver) {
        return IceTransportKt.toCandidatePacketExtension($receiver);
    }

    public static final /* synthetic */ boolean access$ipNeedsResolution(CandidatePacketExtension $receiver) {
        return IceTransportKt.ipNeedsResolution($receiver);
    }
}

