/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.provider.KeyStoreConfig;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvX509KeyManager;
import org.bouncycastle.jsse.provider.ProvX509KeyManagerSimple;
import org.bouncycastle.tls.TlsUtils;

class ProvKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    private static final Logger LOG = Logger.getLogger(ProvKeyManagerFactorySpi.class.getName());
    protected final boolean isInFipsMode;
    protected final JcaJceHelper helper;
    protected BCX509ExtendedKeyManager x509KeyManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStoreConfig getDefaultKeyStore() throws Exception {
        String string = KeyStore.getDefaultType();
        String string2 = null;
        char[] cArray = null;
        String string3 = PropertyUtils.getStringSystemProperty("javax.net.ssl.keyStore");
        if (!"NONE".equals(string3) && null != string3 && new File(string3).exists()) {
            string2 = string3;
        }
        KeyStore keyStore = ProvKeyManagerFactorySpi.createKeyStore(string);
        String string4 = PropertyUtils.getSensitiveStringSystemProperty("javax.net.ssl.keyStorePassword");
        if (null != string4) {
            cArray = string4.toCharArray();
        }
        InputStream inputStream = null;
        try {
            if (null == string2) {
                LOG.config("Initializing default key store as empty");
            } else {
                LOG.config("Initializing default key store from path: " + string2);
                inputStream = new BufferedInputStream(new FileInputStream(string2));
            }
            try {
                keyStore.load(inputStream, cArray);
            }
            catch (NullPointerException nullPointerException) {
                keyStore = KeyStore.getInstance("BCFKS");
                keyStore.load(null, null);
            }
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        return new KeyStoreConfig(keyStore, cArray);
    }

    ProvKeyManagerFactorySpi(boolean bl, JcaJceHelper jcaJceHelper) {
        this.isInFipsMode = bl;
        this.helper = jcaJceHelper;
    }

    protected KeyManager[] engineGetKeyManagers() {
        if (null == this.x509KeyManager) {
            throw new IllegalStateException("KeyManagerFactory not initialized");
        }
        return new KeyManager[]{this.x509KeyManager};
    }

    protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.x509KeyManager = new ProvX509KeyManagerSimple(this.isInFipsMode, this.helper, keyStore, cArray);
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (!(managerFactoryParameters instanceof KeyStoreBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters");
        }
        List<KeyStore.Builder> list = ((KeyStoreBuilderParameters)managerFactoryParameters).getParameters();
        this.x509KeyManager = new ProvX509KeyManager(this.isInFipsMode, this.helper, list);
    }

    private static KeyStore createKeyStore(String string) throws NoSuchProviderException, KeyStoreException {
        String string2 = ProvKeyManagerFactorySpi.getKeyStoreType(string);
        String string3 = PropertyUtils.getStringSystemProperty("javax.net.ssl.keyStoreProvider");
        return TlsUtils.isNullOrEmpty(string3) ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string3);
    }

    private static String getKeyStoreType(String string) {
        String string2 = PropertyUtils.getStringSystemProperty("javax.net.ssl.keyStoreType");
        return null == string2 ? string : string2;
    }
}

