/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.FreeColTestUtils;

public class TransportMissionTest
extends FreeColTestCase {
    private static final GoodsType horsesType = TransportMissionTest.spec().getGoodsType("model.goods.horses");
    private static final TileType plainsType = TransportMissionTest.spec().getTileType("model.tile.plains");
    private static final UnitType colonistType = TransportMissionTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType galleonType = TransportMissionTest.spec().getUnitType("model.unit.galleon");
    private static final UnitType privateerType = TransportMissionTest.spec().getUnitType("model.unit.privateer");
    private static final UnitType wagonType = TransportMissionTest.spec().getUnitType("model.unit.wagonTrain");
    private static final LogBuilder lb = new LogBuilder(0);

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    public void testTransportMissionInvalidAfterCombatLost() {
        ServerGame game = ServerTestHelper.startServerGame(TransportMissionTest.getCoastTestMap(plainsType));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        TransportMissionTest.assertNotNull((Object)aiMain);
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        AIPlayer aiPlayer = aiMain.getAIPlayer(dutch);
        Tile tile1 = map.getTile(12, 9);
        ServerUnit galleon = new ServerUnit(game, tile1, dutch, galleonType);
        AIUnit aiUnit = aiMain.getAIUnit(galleon);
        TransportMissionTest.assertNotNull((Object)aiUnit);
        TransportMissionTest.assertTrue((boolean)galleon.hasAbility("model.ability.navalUnit"));
        TransportMissionTest.assertEquals((String)"Galleon should be repaired in Europe", (Object)dutch.getEurope(), (Object)galleon.getRepairLocation());
        ServerUnit colonist = new ServerUnit(game, galleon, dutch, colonistType);
        TransportMissionTest.assertTrue((colonist.getLocation() == galleon ? 1 : 0) != 0);
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        Tile tile2 = map.getTile(11, 9);
        ServerUnit privateer = new ServerUnit(game, tile2, french, privateerType);
        new TransportMission(aiMain, aiUnit);
        igc.combat(dutch, privateer, galleon, this.fakeAttackResult(CombatModel.CombatResult.WIN, privateer, galleon));
        TransportMissionTest.assertTrue((boolean)galleon.isDamaged());
        TransportMissionTest.assertFalse((boolean)aiUnit.getMission().isValid());
        aiPlayer.startWorking();
        TransportMissionTest.assertFalse((boolean)aiUnit.hasMission(TransportMission.class));
    }

    public void testGetNextStopAlreadyAtDestination() {
        ServerGame game = ServerTestHelper.startServerGame(TransportMissionTest.getCoastTestMap(plainsType));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        TransportMissionTest.assertNotNull((Object)aiMain);
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        dutch.exploreMap(true);
        Tile colonyTile = map.getTile(9, 9);
        this.getStandardColony(1, colonyTile.getX(), colonyTile.getY());
        ServerUnit galleon = new ServerUnit(game, colonyTile, dutch, galleonType);
        AIUnit aiUnit = aiMain.getAIUnit(galleon);
        TransportMissionTest.assertNotNull((Object)aiUnit);
        TransportMission mission = new TransportMission(aiMain, aiUnit);
        AIGoods goods = new AIGoods(aiMain, galleon, horsesType, 50, colonyTile);
        mission.queueTransportable(goods, false, lb);
        Location dest = mission.getTarget();
        TransportMissionTest.assertNotNull((String)"Unit should have a destination", (Object)dest);
        TransportMissionTest.assertTrue((String)"Unit should be already at the destination", (boolean)Map.isSameLocation(dest, galleon.getLocation()));
    }

    public void testGetNextStopIsEurope() {
        ServerGame game = ServerTestHelper.startServerGame(TransportMissionTest.getCoastTestMap(plainsType));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        TransportMissionTest.assertNotNull((Object)aiMain);
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        dutch.exploreMap(true);
        Europe europe = dutch.getEurope();
        TransportMissionTest.assertNotNull((String)"Setup error, europe is null", (Object)europe);
        Tile colonyTile = map.getTile(9, 9);
        this.getStandardColony(1, colonyTile.getX(), colonyTile.getY());
        ServerUnit galleon = new ServerUnit(game, colonyTile, dutch, galleonType);
        AIUnit aiUnit = aiMain.getAIUnit(galleon);
        TransportMissionTest.assertNotNull((Object)aiUnit);
        TransportMission mission = new TransportMission(aiMain, aiUnit);
        AIGoods goods = new AIGoods(aiMain, galleon, horsesType, 50, europe);
        TransportMissionTest.assertTrue((String)"Goods should queue", (boolean)mission.queueTransportable(goods, false, lb));
        mission.doMission(lb);
        Location dest = mission.getTarget();
        TransportMissionTest.assertNotNull((String)"Unit should have a destination", (Object)dest);
        TransportMissionTest.assertEquals((String)"Destination should be Europe", (Object)europe, (Object)dest);
        TransportMissionTest.assertTrue((String)"Unit should have a path", (galleon.getTurnsToReach(dest) < 10000 ? 1 : 0) != 0);
    }

    public void testGetNextStopIsColony() {
        ServerGame game = ServerTestHelper.startServerGame(TransportMissionTest.getCoastTestMap(plainsType));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        TransportMissionTest.assertNotNull((Object)aiMain);
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Europe europe = dutch.getEurope();
        TransportMissionTest.assertNotNull((String)"Setup error, europe is null", (Object)europe);
        Tile colonyTile = map.getTile(9, 9);
        TransportMissionTest.assertTrue((boolean)colonyTile.isLand());
        this.getStandardColony(1, colonyTile.getX(), colonyTile.getY());
        Tile galleonTile = map.getTile(10, 9);
        TransportMissionTest.assertFalse((boolean)galleonTile.isLand());
        ServerUnit galleon = new ServerUnit(game, galleonTile, dutch, galleonType);
        AIUnit aiUnit = aiMain.getAIUnit(galleon);
        TransportMissionTest.assertNotNull((Object)aiUnit);
        TransportMission mission = new TransportMission(aiMain, aiUnit);
        AIGoods goods = new AIGoods(aiMain, galleon, horsesType, 50, colonyTile);
        ((TransportableAIObject)goods).setTransportDestination(europe);
        mission.queueTransportable(goods, false, lb);
        mission.doMission(lb);
        Location dest = mission.getTarget();
        TransportMissionTest.assertNotNull((String)"Unit should have a destination", (Object)dest);
        TransportMissionTest.assertEquals((String)"Destination should be the colony", (Object)colonyTile.getColony(), (Object)dest);
    }

    public void testGetDefaultDestination() {
        ServerGame game = ServerTestHelper.startServerGame(TransportMissionTest.getCoastTestMap(plainsType));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        TransportMissionTest.assertNotNull((Object)aiMain);
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        dutch.exploreMap(true);
        Europe europe = dutch.getEurope();
        TransportMissionTest.assertNotNull((String)"Setup error, europe is null", (Object)europe);
        Tile galleonTile = map.getTile(10, 9);
        TransportMissionTest.assertFalse((boolean)galleonTile.isLand());
        ServerUnit galleon = new ServerUnit(game, galleonTile, dutch, galleonType);
        AIUnit aiUnit = aiMain.getAIUnit(galleon);
        TransportMissionTest.assertNotNull((Object)aiUnit);
        TransportMission mission = new TransportMission(aiMain, aiUnit);
        TransportMissionTest.assertTrue((String)"Setup error, player should not have colonies", (boolean)CollectionUtils.none(dutch.getColonies()));
        Location dest = mission.getTarget();
        TransportMissionTest.assertNotNull((String)"Unit should have a destination", (Object)dest);
        TransportMissionTest.assertTrue((String)"Destination should be Europe", (boolean)(dest instanceof Europe));
        Tile colonyTile = map.getTile(9, 9);
        FreeColTestUtils.ColonyBuilder builder = FreeColTestUtils.getColonyBuilder();
        builder.colonyTile(colonyTile).initialColonists(1).player(dutch).build();
        TransportMissionTest.assertTrue((String)"Player should now have a colony", (boolean)CollectionUtils.any(dutch.getColonies()));
        mission = new TransportMission(aiMain, aiUnit);
        dest = mission.getTarget();
        TransportMissionTest.assertNotNull((String)"Unit should have a destination", (Object)dest);
        TransportMissionTest.assertEquals((String)"Destination should be the colony", (Object)colonyTile.getColony(), (Object)dest);
    }

    public void testWagonTrain() {
        ServerGame game = ServerTestHelper.startServerGame(TransportMissionTest.getTestMap());
        Colony one = this.getStandardColony(3, 3, 3);
        one.setName("one");
        Colony two = this.getStandardColony(3, 8, 8);
        two.setName("two");
        TransportMissionTest.assertEquals((Object)one.getOwner(), (Object)two.getOwner());
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        TransportMissionTest.assertNotNull((Object)aiMain);
        ServerUnit wagonTrain = new ServerUnit(game, one.getTile(), (ServerPlayer)one.getOwner(), wagonType);
        AIUnit wagon = aiMain.getAIUnit(wagonTrain);
        TransportMissionTest.assertNotNull((Object)wagon);
        wagon.setMission(null);
        TransportMissionTest.assertNull((String)"Transport mission should be valid.", (Object)TransportMission.invalidMissionReason(wagon));
        TransportMission mission = new TransportMission(aiMain, wagon);
        Location dest = mission.getTarget();
        TransportMissionTest.assertEquals((String)"Destination should be colony one.", (Object)one, (Object)dest);
        wagonTrain.setLocation(one.getTile().getNeighbourOrNull(Direction.NE));
        dest = mission.getTarget();
        TransportMissionTest.assertEquals((String)"Destination should still be colony one.", (Object)one, (Object)dest);
        Goods goods = new Goods(game, two, horsesType, 20);
        two.addGoods(goods);
        AIGoods aiGoods = new AIGoods(aiMain, two, goods.getType(), goods.getAmount(), one);
        mission.queueTransportable(aiGoods, false, lb);
        mission.doMission(lb);
        dest = mission.getTarget();
        TransportMissionTest.assertEquals((String)"Destination should now be colony two", (String)two.getId(), (String)dest.getId());
        TransportMissionTest.assertEquals((String)"Destination should now be colony two.", (Object)two, (Object)dest);
    }
}

