/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Permission;

public final class QueryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryBuilder.class);
    private final Config config;
    private final ObjectMapper objectMapper;
    private final Map<String, List<Integer>> indexMap = new HashMap<String, List<Integer>>();
    private Connection connection;
    private PreparedStatement statement;
    private final String query;
    private final boolean returnGeneratedKeys;

    private QueryBuilder(Config config, DataSource dataSource, ObjectMapper objectMapper, String query, boolean returnGeneratedKeys) throws SQLException {
        this.config = config;
        this.objectMapper = objectMapper;
        this.query = query;
        this.returnGeneratedKeys = returnGeneratedKeys;
        if (query != null) {
            this.connection = dataSource.getConnection();
            String parsedQuery = QueryBuilder.parse(query.trim(), this.indexMap);
            try {
                this.statement = returnGeneratedKeys ? this.connection.prepareStatement(parsedQuery, 1) : this.connection.prepareStatement(parsedQuery);
            }
            catch (SQLException error) {
                this.connection.close();
                throw error;
            }
        }
    }

    private static String parse(String query, Map<String, List<Integer>> paramMap) {
        int length = query.length();
        StringBuilder parsedQuery = new StringBuilder(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int index = 1;
        for (int i = 0; i < length; ++i) {
            int c = query.charAt(i);
            if (inSingleQuote) {
                if (c == 39) {
                    inSingleQuote = false;
                }
            } else if (inDoubleQuote) {
                if (c == 34) {
                    inDoubleQuote = false;
                }
            } else if (c == 39) {
                inSingleQuote = true;
            } else if (c == 34) {
                inDoubleQuote = true;
            } else if (c == 58 && i + 1 < length && Character.isJavaIdentifierStart(query.charAt(i + 1))) {
                int j;
                for (j = i + 2; j < length && Character.isJavaIdentifierPart(query.charAt(j)); ++j) {
                }
                String name = query.substring(i + 1, j);
                c = 63;
                i += name.length();
                name = name.toLowerCase();
                List indexList = paramMap.computeIfAbsent(name, k -> new LinkedList());
                indexList.add(index);
                ++index;
            }
            parsedQuery.append((char)c);
        }
        return parsedQuery.toString();
    }

    public static QueryBuilder create(Config config, DataSource dataSource, ObjectMapper objectMapper, String query) throws SQLException {
        return new QueryBuilder(config, dataSource, objectMapper, query, false);
    }

    public static QueryBuilder create(Config config, DataSource dataSource, ObjectMapper objectMapper, String query, boolean returnGeneratedKeys) throws SQLException {
        return new QueryBuilder(config, dataSource, objectMapper, query, returnGeneratedKeys);
    }

    private List<Integer> indexes(String name) {
        List<Integer> result = this.indexMap.get(name = name.toLowerCase());
        if (result == null) {
            result = new LinkedList<Integer>();
        }
        return result;
    }

    public QueryBuilder setBoolean(String name, boolean value) throws SQLException {
        for (int i : this.indexes(name)) {
            try {
                this.statement.setBoolean(i, value);
            }
            catch (SQLException error) {
                this.statement.close();
                this.connection.close();
                throw error;
            }
        }
        return this;
    }

    public QueryBuilder setInteger(String name, int value) throws SQLException {
        for (int i : this.indexes(name)) {
            try {
                this.statement.setInt(i, value);
            }
            catch (SQLException error) {
                this.statement.close();
                this.connection.close();
                throw error;
            }
        }
        return this;
    }

    public QueryBuilder setLong(String name, long value) throws SQLException {
        return this.setLong(name, value, false);
    }

    public QueryBuilder setLong(String name, long value, boolean nullIfZero) throws SQLException {
        for (int i : this.indexes(name)) {
            try {
                if (value == 0L && nullIfZero) {
                    this.statement.setNull(i, 4);
                    continue;
                }
                this.statement.setLong(i, value);
            }
            catch (SQLException error) {
                this.statement.close();
                this.connection.close();
                throw error;
            }
        }
        return this;
    }

    public QueryBuilder setDouble(String name, double value) throws SQLException {
        for (int i : this.indexes(name)) {
            try {
                this.statement.setDouble(i, value);
            }
            catch (SQLException error) {
                this.statement.close();
                this.connection.close();
                throw error;
            }
        }
        return this;
    }

    public QueryBuilder setString(String name, String value) throws SQLException {
        for (int i : this.indexes(name)) {
            try {
                if (value == null) {
                    this.statement.setNull(i, 12);
                    continue;
                }
                this.statement.setString(i, value);
            }
            catch (SQLException error) {
                this.statement.close();
                this.connection.close();
                throw error;
            }
        }
        return this;
    }

    public QueryBuilder setDate(String name, Date value) throws SQLException {
        for (int i : this.indexes(name)) {
            try {
                if (value == null) {
                    this.statement.setNull(i, 93);
                    continue;
                }
                this.statement.setTimestamp(i, new Timestamp(value.getTime()));
            }
            catch (SQLException error) {
                this.statement.close();
                this.connection.close();
                throw error;
            }
        }
        return this;
    }

    public QueryBuilder setBlob(String name, byte[] value) throws SQLException {
        for (int i : this.indexes(name)) {
            try {
                if (value == null) {
                    this.statement.setNull(i, 2004);
                    continue;
                }
                this.statement.setBytes(i, value);
            }
            catch (SQLException error) {
                this.statement.close();
                this.connection.close();
                throw error;
            }
        }
        return this;
    }

    public QueryBuilder setValue(String name, Object value) throws SQLException {
        if (value instanceof Boolean) {
            this.setBoolean(name, (Boolean)value);
        } else if (value instanceof Integer) {
            this.setInteger(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLong(name, (Long)value);
        } else if (value instanceof Double) {
            this.setDouble(name, (Double)value);
        } else if (value instanceof String) {
            this.setString(name, (String)value);
        } else if (value instanceof Date) {
            this.setDate(name, (Date)value);
        }
        return this;
    }

    public QueryBuilder setObject(Object object, List<String> columns) throws SQLException {
        try {
            for (String column : columns) {
                Method method = object.getClass().getMethod("get" + Character.toUpperCase(column.charAt(0)) + column.substring(1), new Class[0]);
                if (method.getReturnType().equals(Boolean.TYPE)) {
                    this.setBoolean(column, (Boolean)method.invoke(object, new Object[0]));
                    continue;
                }
                if (method.getReturnType().equals(Integer.TYPE)) {
                    this.setInteger(column, (Integer)method.invoke(object, new Object[0]));
                    continue;
                }
                if (method.getReturnType().equals(Long.TYPE)) {
                    this.setLong(column, (Long)method.invoke(object, new Object[0]), column.endsWith("Id"));
                    continue;
                }
                if (method.getReturnType().equals(Double.TYPE)) {
                    this.setDouble(column, (Double)method.invoke(object, new Object[0]));
                    continue;
                }
                if (method.getReturnType().equals(String.class)) {
                    this.setString(column, (String)method.invoke(object, new Object[0]));
                    continue;
                }
                if (method.getReturnType().equals(Date.class)) {
                    this.setDate(column, (Date)method.invoke(object, new Object[0]));
                    continue;
                }
                if (method.getReturnType().equals(byte[].class)) {
                    this.setBlob(column, (byte[])method.invoke(object, new Object[0]));
                    continue;
                }
                this.setString(column, this.objectMapper.writeValueAsString(method.invoke(object, new Object[0])));
            }
        }
        catch (JsonProcessingException | ReflectiveOperationException e) {
            LOGGER.warn("Set object error", e);
        }
        return this;
    }

    private <T> void addProcessors(List<ResultSetProcessor<T>> processors, Class<?> parameterType, Method method, String name) {
        if (parameterType.equals(Boolean.TYPE)) {
            processors.add((object, resultSet) -> {
                try {
                    method.invoke(object, resultSet.getBoolean(name));
                }
                catch (IllegalAccessException | InvocationTargetException error) {
                    LOGGER.warn("Set property error", (Throwable)error);
                }
            });
        } else if (parameterType.equals(Integer.TYPE)) {
            processors.add((object, resultSet) -> {
                try {
                    method.invoke(object, resultSet.getInt(name));
                }
                catch (IllegalAccessException | InvocationTargetException error) {
                    LOGGER.warn("Set property error", (Throwable)error);
                }
            });
        } else if (parameterType.equals(Long.TYPE)) {
            processors.add((object, resultSet) -> {
                try {
                    method.invoke(object, resultSet.getLong(name));
                }
                catch (IllegalAccessException | InvocationTargetException error) {
                    LOGGER.warn("Set property error", (Throwable)error);
                }
            });
        } else if (parameterType.equals(Double.TYPE)) {
            processors.add((object, resultSet) -> {
                try {
                    method.invoke(object, resultSet.getDouble(name));
                }
                catch (IllegalAccessException | InvocationTargetException error) {
                    LOGGER.warn("Set property error", (Throwable)error);
                }
            });
        } else if (parameterType.equals(String.class)) {
            processors.add((object, resultSet) -> {
                try {
                    method.invoke(object, resultSet.getString(name));
                }
                catch (IllegalAccessException | InvocationTargetException error) {
                    LOGGER.warn("Set property error", (Throwable)error);
                }
            });
        } else if (parameterType.equals(Date.class)) {
            processors.add((object, resultSet) -> {
                try {
                    Timestamp timestamp = resultSet.getTimestamp(name);
                    if (timestamp != null) {
                        method.invoke(object, new Date(timestamp.getTime()));
                    }
                }
                catch (IllegalAccessException | InvocationTargetException error) {
                    LOGGER.warn("Set property error", (Throwable)error);
                }
            });
        } else if (parameterType.equals(byte[].class)) {
            processors.add((object, resultSet) -> {
                try {
                    method.invoke(object, new Object[]{resultSet.getBytes(name)});
                }
                catch (IllegalAccessException | InvocationTargetException error) {
                    LOGGER.warn("Set property error", (Throwable)error);
                }
            });
        } else {
            processors.add((object, resultSet) -> {
                String value = resultSet.getString(name);
                if (value != null && !value.isEmpty()) {
                    try {
                        method.invoke(object, this.objectMapper.readValue(value, parameterType));
                    }
                    catch (IOException | IllegalAccessException | InvocationTargetException error) {
                        LOGGER.warn("Set property error", (Throwable)error);
                    }
                }
            });
        }
    }

    private void logQuery() {
        if (this.config.getBoolean(Keys.LOGGER_QUERIES)) {
            LOGGER.info(this.query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> List<T> executeQuery(Class<T> clazz) throws SQLException {
        LinkedList<T> result = new LinkedList<T>();
        if (this.query == null) return result;
        try {
            this.logQuery();
            try (ResultSet resultSet = this.statement.executeQuery();){
                void var9_14;
                Method[] methods;
                ResultSetMetaData resultMetaData = resultSet.getMetaData();
                LinkedList<ResultSetProcessor<T>> processors = new LinkedList<ResultSetProcessor<T>>();
                Method[] methodArray = methods = clazz.getMethods();
                int n = methodArray.length;
                boolean bl = false;
                while (var9_14 < n) {
                    Method method = methodArray[var9_14];
                    if (method.getName().startsWith("set") && method.getParameterTypes().length == 1) {
                        String name = method.getName().substring(3);
                        boolean column = false;
                        for (int i = 1; i <= resultMetaData.getColumnCount(); ++i) {
                            if (!name.equalsIgnoreCase(resultMetaData.getColumnLabel(i))) continue;
                            column = true;
                            break;
                        }
                        if (column) {
                            this.addProcessors(processors, method.getParameterTypes()[0], method, name);
                        }
                    }
                    ++var9_14;
                }
                while (resultSet.next()) {
                    try {
                        T object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        for (ResultSetProcessor resultSetProcessor : processors) {
                            resultSetProcessor.process(object, resultSet);
                        }
                        result.add(object);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new IllegalArgumentException();
                        return result;
                    }
                }
            }
        }
        finally {
            this.statement.close();
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeUpdate() throws SQLException {
        if (this.query != null) {
            try {
                ResultSet resultSet;
                this.logQuery();
                this.statement.execute();
                if (this.returnGeneratedKeys && (resultSet = this.statement.getGeneratedKeys()).next()) {
                    long l = resultSet.getLong(1);
                    return l;
                }
            }
            finally {
                this.statement.close();
                this.connection.close();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Permission> executePermissionsQuery() throws SQLException {
        LinkedList<Permission> result = new LinkedList<Permission>();
        if (this.query != null) {
            try {
                this.logQuery();
                try (ResultSet resultSet = this.statement.executeQuery();){
                    ResultSetMetaData resultMetaData = resultSet.getMetaData();
                    while (resultSet.next()) {
                        LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>();
                        for (int i = 1; i <= resultMetaData.getColumnCount(); ++i) {
                            String label = resultMetaData.getColumnLabel(i);
                            map.put(label, resultSet.getLong(label));
                        }
                        result.add(new Permission(map));
                    }
                }
            }
            finally {
                this.statement.close();
                this.connection.close();
            }
        }
        return result;
    }

    private static interface ResultSetProcessor<T> {
        public void process(T var1, ResultSet var2) throws SQLException;
    }
}

