"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.skippingIndexDataMock = exports.skippingIndexBuilderMockResult2 = exports.skippingIndexBuilderMockResult1 = exports.skippingIndexBuilderMock2 = exports.skippingIndexBuilderMock1 = exports.materializedViewValidDataMock = exports.materializedViewStaleDataMock = exports.materializedViewEmptyTumbleDataMock = exports.materializedViewEmptyDataMock = exports.materializedViewBuilderMockResult2 = exports.materializedViewBuilderMockResult1 = exports.materializedViewBuilderMock2 = exports.materializedViewBuilderMock1 = exports.indexOptionsMockResult3 = exports.indexOptionsMockResult2 = exports.indexOptionsMockResult1 = exports.indexOptionsMock3 = exports.indexOptionsMock2 = exports.indexOptionsMock1 = exports.createAccelerationEmptyDataMock = exports.coveringIndexDataMock = exports.coveringIndexBuilderMockResult2 = exports.coveringIndexBuilderMockResult1 = exports.coveringIndexBuilderMock2 = exports.coveringIndexBuilderMock1 = void 0;

var _constants = require("../../common/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const skippingIndexDataMock = [{
  id: '1',
  fieldName: 'field1',
  dataType: 'string',
  accelerationMethod: 'PARTITION'
}, {
  id: '2',
  fieldName: 'field2',
  dataType: 'number',
  accelerationMethod: 'VALUE_SET'
}];
exports.skippingIndexDataMock = skippingIndexDataMock;
const coveringIndexDataMock = ['field1', 'field2', 'field3'];
exports.coveringIndexDataMock = coveringIndexDataMock;
const materializedViewEmptyDataMock = {
  columnsValues: [],
  groupByTumbleValue: {
    timeField: '',
    tumbleWindow: 0,
    tumbleInterval: ''
  }
};
exports.materializedViewEmptyDataMock = materializedViewEmptyDataMock;
const materializedViewEmptyTumbleDataMock = {
  columnsValues: [{
    id: '1',
    functionName: 'count',
    functionParam: 'field1'
  }],
  groupByTumbleValue: {
    timeField: '',
    tumbleWindow: 0,
    tumbleInterval: 'second'
  }
};
exports.materializedViewEmptyTumbleDataMock = materializedViewEmptyTumbleDataMock;
const materializedViewStaleDataMock = {
  columnsValues: [],
  groupByTumbleValue: {
    timeField: 'timestamp',
    tumbleWindow: 10,
    tumbleInterval: 'hour'
  }
};
exports.materializedViewStaleDataMock = materializedViewStaleDataMock;
const materializedViewValidDataMock = {
  columnsValues: [{
    id: '1',
    functionName: 'count',
    functionParam: 'field1'
  }, {
    id: '2',
    functionName: 'sum',
    functionParam: 'field2'
  }],
  groupByTumbleValue: {
    timeField: 'timestamp',
    tumbleWindow: 5,
    tumbleInterval: 'hour'
  }
};
exports.materializedViewValidDataMock = materializedViewValidDataMock;
const createAccelerationEmptyDataMock = {
  dataSource: '',
  dataTable: '',
  database: '',
  dataTableFields: [],
  accelerationIndexType: 'skipping',
  skippingIndexQueryData: [],
  coveringIndexQueryData: [],
  materializedViewQueryData: {
    columnsValues: [],
    groupByTumbleValue: {
      timeField: '',
      tumbleWindow: 0,
      tumbleInterval: ''
    }
  },
  accelerationIndexName: _constants.ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME,
  primaryShardsCount: 5,
  replicaShardsCount: 1,
  refreshType: 'auto',
  checkpointLocation: undefined,
  refreshIntervalOptions: {
    refreshWindow: 1,
    refreshInterval: _constants.ACCELERATION_TIME_INTERVAL[1].value
  },
  formErrors: {
    dataSourceError: [],
    databaseError: [],
    dataTableError: [],
    skippingIndexError: [],
    coveringIndexError: [],
    materializedViewError: [],
    indexNameError: [],
    primaryShardsError: [],
    replicaShardsError: [],
    refreshIntervalError: [],
    checkpointLocationError: []
  }
};
exports.createAccelerationEmptyDataMock = createAccelerationEmptyDataMock;
const indexOptionsMock1 = { ...createAccelerationEmptyDataMock,
  primaryShardsCount: 3,
  replicaShardsCount: 2,
  refreshType: 'auto'
};
exports.indexOptionsMock1 = indexOptionsMock1;
const indexOptionsMockResult1 = `WITH (
index_settings = '{"number_of_shards":3,"number_of_replicas":2}',
auto_refresh = true
)`;
exports.indexOptionsMockResult1 = indexOptionsMockResult1;
const indexOptionsMock2 = { ...createAccelerationEmptyDataMock,
  primaryShardsCount: 3,
  replicaShardsCount: 2,
  refreshType: 'interval',
  refreshIntervalOptions: {
    refreshWindow: 10,
    refreshInterval: 'minute'
  }
};
exports.indexOptionsMock2 = indexOptionsMock2;
const indexOptionsMockResult2 = `WITH (
index_settings = '{"number_of_shards":3,"number_of_replicas":2}',
auto_refresh = false,
refresh_interval = '10 minutes'
)`;
exports.indexOptionsMockResult2 = indexOptionsMockResult2;
const indexOptionsMock3 = { ...createAccelerationEmptyDataMock,
  primaryShardsCount: 3,
  replicaShardsCount: 2,
  refreshType: 'auto',
  checkpointLocation: 's3://path/to/checkpoint'
};
exports.indexOptionsMock3 = indexOptionsMock3;
const indexOptionsMockResult3 = `WITH (
index_settings = '{"number_of_shards":3,"number_of_replicas":2}',
auto_refresh = true,
checkpoint_location = 's3://path/to/checkpoint'
)`;
exports.indexOptionsMockResult3 = indexOptionsMockResult3;
const skippingIndexBuilderMock1 = { ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  skippingIndexQueryData: [{
    id: '1',
    fieldName: 'field1',
    dataType: 'string',
    accelerationMethod: 'PARTITION'
  }, {
    id: '2',
    fieldName: 'field2',
    dataType: 'int',
    accelerationMethod: 'VALUE_SET'
  }, {
    id: '3',
    fieldName: 'field3',
    dataType: 'boolean',
    accelerationMethod: 'MIN_MAX'
  }],
  primaryShardsCount: 9,
  replicaShardsCount: 2,
  refreshType: 'interval',
  refreshIntervalOptions: {
    refreshWindow: 1,
    refreshInterval: 'minute'
  },
  checkpointLocation: 's3://test/'
};
exports.skippingIndexBuilderMock1 = skippingIndexBuilderMock1;
const skippingIndexBuilderMockResult1 = `CREATE SKIPPING INDEX
ON datasource.database.table (
   field1 PARTITION, 
   field2 VALUE_SET, 
   field3 MIN_MAX
  ) WITH (
index_settings = '{"number_of_shards":9,"number_of_replicas":2}',
auto_refresh = false,
refresh_interval = '1 minute',
checkpoint_location = 's3://test/'
)`;
exports.skippingIndexBuilderMockResult1 = skippingIndexBuilderMockResult1;
const skippingIndexBuilderMock2 = { ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  skippingIndexQueryData: [{
    id: '1',
    fieldName: 'field1',
    dataType: 'string',
    accelerationMethod: 'PARTITION'
  }],
  primaryShardsCount: 5,
  replicaShardsCount: 3,
  refreshType: 'auto',
  checkpointLocation: 's3://test/'
};
exports.skippingIndexBuilderMock2 = skippingIndexBuilderMock2;
const skippingIndexBuilderMockResult2 = `CREATE SKIPPING INDEX
ON datasource.database.table (
   field1 PARTITION
  ) WITH (
index_settings = '{"number_of_shards":5,"number_of_replicas":3}',
auto_refresh = true,
checkpoint_location = 's3://test/'
)`;
exports.skippingIndexBuilderMockResult2 = skippingIndexBuilderMockResult2;
const coveringIndexBuilderMock1 = { ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  accelerationIndexName: 'index_name',
  coveringIndexQueryData: ['field1', 'field2', 'field3'],
  primaryShardsCount: 9,
  replicaShardsCount: 2,
  refreshType: 'interval',
  refreshIntervalOptions: {
    refreshWindow: 1,
    refreshInterval: 'minute'
  },
  checkpointLocation: 's3://test/'
};
exports.coveringIndexBuilderMock1 = coveringIndexBuilderMock1;
const coveringIndexBuilderMockResult1 = `CREATE INDEX index_name
ON datasource.database.table (
   field1, 
   field2, 
   field3
  ) WITH (
index_settings = '{"number_of_shards":9,"number_of_replicas":2}',
auto_refresh = false,
refresh_interval = '1 minute',
checkpoint_location = 's3://test/'
)`;
exports.coveringIndexBuilderMockResult1 = coveringIndexBuilderMockResult1;
const coveringIndexBuilderMock2 = { ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  accelerationIndexName: 'index_name',
  coveringIndexQueryData: ['field1'],
  primaryShardsCount: 5,
  replicaShardsCount: 3,
  refreshType: 'auto',
  checkpointLocation: 's3://test/'
};
exports.coveringIndexBuilderMock2 = coveringIndexBuilderMock2;
const coveringIndexBuilderMockResult2 = `CREATE INDEX index_name
ON datasource.database.table (
   field1
  ) WITH (
index_settings = '{"number_of_shards":5,"number_of_replicas":3}',
auto_refresh = true,
checkpoint_location = 's3://test/'
)`;
exports.coveringIndexBuilderMockResult2 = coveringIndexBuilderMockResult2;
const materializedViewBuilderMock1 = { ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  accelerationIndexName: 'index_name',
  materializedViewQueryData: {
    columnsValues: [{
      id: '1',
      functionName: 'count',
      functionParam: 'field',
      fieldAlias: 'counter'
    }, {
      id: '2',
      functionName: 'count',
      functionParam: '*',
      fieldAlias: 'counter1'
    }, {
      id: '3',
      functionName: 'sum',
      functionParam: 'field2'
    }, {
      id: '4',
      functionName: 'avg',
      functionParam: 'field3',
      fieldAlias: 'average'
    }],
    groupByTumbleValue: {
      timeField: 'timestamp',
      tumbleWindow: 1,
      tumbleInterval: 'minute'
    }
  },
  primaryShardsCount: 9,
  replicaShardsCount: 2,
  refreshType: 'interval',
  refreshIntervalOptions: {
    refreshWindow: 1,
    refreshInterval: 'minute'
  },
  checkpointLocation: 's3://test/'
};
exports.materializedViewBuilderMock1 = materializedViewBuilderMock1;
const materializedViewBuilderMockResult1 = `CREATE MATERIALIZED VIEW datasource.database.index_name
AS SELECT
   count(field) AS counter, 
   count(*) AS counter1, 
   sum(field2), 
   avg(field3) AS average
FROM datasource.database.table
GROUP BY TUMBLE (timestamp, '1 minute')
 WITH (
index_settings = '{"number_of_shards":9,"number_of_replicas":2}',
auto_refresh = false,
refresh_interval = '1 minute',
checkpoint_location = 's3://test/'
)`;
exports.materializedViewBuilderMockResult1 = materializedViewBuilderMockResult1;
const materializedViewBuilderMock2 = { ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  accelerationIndexName: 'index_name',
  materializedViewQueryData: {
    columnsValues: [{
      id: '1',
      functionName: 'count',
      functionParam: 'field'
    }],
    groupByTumbleValue: {
      timeField: 'timestamp',
      tumbleWindow: 2,
      tumbleInterval: 'hour'
    }
  },
  primaryShardsCount: 5,
  replicaShardsCount: 3,
  refreshType: 'auto',
  checkpointLocation: 's3://test/'
};
exports.materializedViewBuilderMock2 = materializedViewBuilderMock2;
const materializedViewBuilderMockResult2 = `CREATE MATERIALIZED VIEW datasource.database.index_name
AS SELECT
   count(field)
FROM datasource.database.table
GROUP BY TUMBLE (timestamp, '2 hours')
 WITH (
index_settings = '{"number_of_shards":5,"number_of_replicas":3}',
auto_refresh = true,
checkpoint_location = 's3://test/'
)`;
exports.materializedViewBuilderMockResult2 = materializedViewBuilderMockResult2;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFjY2VsZXJhdGlvbk1vY2sudHMiXSwibmFtZXMiOlsic2tpcHBpbmdJbmRleERhdGFNb2NrIiwiaWQiLCJmaWVsZE5hbWUiLCJkYXRhVHlwZSIsImFjY2VsZXJhdGlvbk1ldGhvZCIsImNvdmVyaW5nSW5kZXhEYXRhTW9jayIsIm1hdGVyaWFsaXplZFZpZXdFbXB0eURhdGFNb2NrIiwiY29sdW1uc1ZhbHVlcyIsImdyb3VwQnlUdW1ibGVWYWx1ZSIsInRpbWVGaWVsZCIsInR1bWJsZVdpbmRvdyIsInR1bWJsZUludGVydmFsIiwibWF0ZXJpYWxpemVkVmlld0VtcHR5VHVtYmxlRGF0YU1vY2siLCJmdW5jdGlvbk5hbWUiLCJmdW5jdGlvblBhcmFtIiwibWF0ZXJpYWxpemVkVmlld1N0YWxlRGF0YU1vY2siLCJtYXRlcmlhbGl6ZWRWaWV3VmFsaWREYXRhTW9jayIsImNyZWF0ZUFjY2VsZXJhdGlvbkVtcHR5RGF0YU1vY2siLCJkYXRhU291cmNlIiwiZGF0YVRhYmxlIiwiZGF0YWJhc2UiLCJkYXRhVGFibGVGaWVsZHMiLCJhY2NlbGVyYXRpb25JbmRleFR5cGUiLCJza2lwcGluZ0luZGV4UXVlcnlEYXRhIiwiY292ZXJpbmdJbmRleFF1ZXJ5RGF0YSIsIm1hdGVyaWFsaXplZFZpZXdRdWVyeURhdGEiLCJhY2NlbGVyYXRpb25JbmRleE5hbWUiLCJBQ0NFTEVSQVRJT05fREVGVUFMVF9TS0lQUElOR19JTkRFWF9OQU1FIiwicHJpbWFyeVNoYXJkc0NvdW50IiwicmVwbGljYVNoYXJkc0NvdW50IiwicmVmcmVzaFR5cGUiLCJjaGVja3BvaW50TG9jYXRpb24iLCJ1bmRlZmluZWQiLCJyZWZyZXNoSW50ZXJ2YWxPcHRpb25zIiwicmVmcmVzaFdpbmRvdyIsInJlZnJlc2hJbnRlcnZhbCIsIkFDQ0VMRVJBVElPTl9USU1FX0lOVEVSVkFMIiwidmFsdWUiLCJmb3JtRXJyb3JzIiwiZGF0YVNvdXJjZUVycm9yIiwiZGF0YWJhc2VFcnJvciIsImRhdGFUYWJsZUVycm9yIiwic2tpcHBpbmdJbmRleEVycm9yIiwiY292ZXJpbmdJbmRleEVycm9yIiwibWF0ZXJpYWxpemVkVmlld0Vycm9yIiwiaW5kZXhOYW1lRXJyb3IiLCJwcmltYXJ5U2hhcmRzRXJyb3IiLCJyZXBsaWNhU2hhcmRzRXJyb3IiLCJyZWZyZXNoSW50ZXJ2YWxFcnJvciIsImNoZWNrcG9pbnRMb2NhdGlvbkVycm9yIiwiaW5kZXhPcHRpb25zTW9jazEiLCJpbmRleE9wdGlvbnNNb2NrUmVzdWx0MSIsImluZGV4T3B0aW9uc01vY2syIiwiaW5kZXhPcHRpb25zTW9ja1Jlc3VsdDIiLCJpbmRleE9wdGlvbnNNb2NrMyIsImluZGV4T3B0aW9uc01vY2tSZXN1bHQzIiwic2tpcHBpbmdJbmRleEJ1aWxkZXJNb2NrMSIsInNraXBwaW5nSW5kZXhCdWlsZGVyTW9ja1Jlc3VsdDEiLCJza2lwcGluZ0luZGV4QnVpbGRlck1vY2syIiwic2tpcHBpbmdJbmRleEJ1aWxkZXJNb2NrUmVzdWx0MiIsImNvdmVyaW5nSW5kZXhCdWlsZGVyTW9jazEiLCJjb3ZlcmluZ0luZGV4QnVpbGRlck1vY2tSZXN1bHQxIiwiY292ZXJpbmdJbmRleEJ1aWxkZXJNb2NrMiIsImNvdmVyaW5nSW5kZXhCdWlsZGVyTW9ja1Jlc3VsdDIiLCJtYXRlcmlhbGl6ZWRWaWV3QnVpbGRlck1vY2sxIiwiZmllbGRBbGlhcyIsIm1hdGVyaWFsaXplZFZpZXdCdWlsZGVyTW9ja1Jlc3VsdDEiLCJtYXRlcmlhbGl6ZWRWaWV3QnVpbGRlck1vY2syIiwibWF0ZXJpYWxpemVkVmlld0J1aWxkZXJNb2NrUmVzdWx0MiJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUtBOztBQUxBO0FBQ0E7QUFDQTtBQUNBO0FBWU8sTUFBTUEscUJBQTZDLEdBQUcsQ0FDM0Q7QUFDRUMsRUFBQUEsRUFBRSxFQUFFLEdBRE47QUFFRUMsRUFBQUEsU0FBUyxFQUFFLFFBRmI7QUFHRUMsRUFBQUEsUUFBUSxFQUFFLFFBSFo7QUFJRUMsRUFBQUEsa0JBQWtCLEVBQUU7QUFKdEIsQ0FEMkQsRUFPM0Q7QUFDRUgsRUFBQUEsRUFBRSxFQUFFLEdBRE47QUFFRUMsRUFBQUEsU0FBUyxFQUFFLFFBRmI7QUFHRUMsRUFBQUEsUUFBUSxFQUFFLFFBSFo7QUFJRUMsRUFBQUEsa0JBQWtCLEVBQUU7QUFKdEIsQ0FQMkQsQ0FBdEQ7O0FBZUEsTUFBTUMscUJBQStCLEdBQUcsQ0FBQyxRQUFELEVBQVcsUUFBWCxFQUFxQixRQUFyQixDQUF4Qzs7QUFFQSxNQUFNQyw2QkFBNkIsR0FBRztBQUMzQ0MsRUFBQUEsYUFBYSxFQUFFLEVBRDRCO0FBRTNDQyxFQUFBQSxrQkFBa0IsRUFBRTtBQUNsQkMsSUFBQUEsU0FBUyxFQUFFLEVBRE87QUFFbEJDLElBQUFBLFlBQVksRUFBRSxDQUZJO0FBR2xCQyxJQUFBQSxjQUFjLEVBQUU7QUFIRTtBQUZ1QixDQUF0Qzs7QUFTQSxNQUFNQyxtQ0FBOEQsR0FBRztBQUM1RUwsRUFBQUEsYUFBYSxFQUFFLENBQ2I7QUFDRU4sSUFBQUEsRUFBRSxFQUFFLEdBRE47QUFFRVksSUFBQUEsWUFBWSxFQUFFLE9BRmhCO0FBR0VDLElBQUFBLGFBQWEsRUFBRTtBQUhqQixHQURhLENBRDZEO0FBUTVFTixFQUFBQSxrQkFBa0IsRUFBRTtBQUNsQkMsSUFBQUEsU0FBUyxFQUFFLEVBRE87QUFFbEJDLElBQUFBLFlBQVksRUFBRSxDQUZJO0FBR2xCQyxJQUFBQSxjQUFjLEVBQUU7QUFIRTtBQVJ3RCxDQUF2RTs7QUFlQSxNQUFNSSw2QkFBd0QsR0FBRztBQUN0RVIsRUFBQUEsYUFBYSxFQUFFLEVBRHVEO0FBRXRFQyxFQUFBQSxrQkFBa0IsRUFBRTtBQUNsQkMsSUFBQUEsU0FBUyxFQUFFLFdBRE87QUFFbEJDLElBQUFBLFlBQVksRUFBRSxFQUZJO0FBR2xCQyxJQUFBQSxjQUFjLEVBQUU7QUFIRTtBQUZrRCxDQUFqRTs7QUFTQSxNQUFNSyw2QkFBd0QsR0FBRztBQUN0RVQsRUFBQUEsYUFBYSxFQUFFLENBQ2I7QUFDRU4sSUFBQUEsRUFBRSxFQUFFLEdBRE47QUFFRVksSUFBQUEsWUFBWSxFQUFFLE9BRmhCO0FBR0VDLElBQUFBLGFBQWEsRUFBRTtBQUhqQixHQURhLEVBTWI7QUFDRWIsSUFBQUEsRUFBRSxFQUFFLEdBRE47QUFFRVksSUFBQUEsWUFBWSxFQUFFLEtBRmhCO0FBR0VDLElBQUFBLGFBQWEsRUFBRTtBQUhqQixHQU5hLENBRHVEO0FBYXRFTixFQUFBQSxrQkFBa0IsRUFBRTtBQUNsQkMsSUFBQUEsU0FBUyxFQUFFLFdBRE87QUFFbEJDLElBQUFBLFlBQVksRUFBRSxDQUZJO0FBR2xCQyxJQUFBQSxjQUFjLEVBQUU7QUFIRTtBQWJrRCxDQUFqRTs7QUFvQkEsTUFBTU0sK0JBQXVELEdBQUc7QUFDckVDLEVBQUFBLFVBQVUsRUFBRSxFQUR5RDtBQUVyRUMsRUFBQUEsU0FBUyxFQUFFLEVBRjBEO0FBR3JFQyxFQUFBQSxRQUFRLEVBQUUsRUFIMkQ7QUFJckVDLEVBQUFBLGVBQWUsRUFBRSxFQUpvRDtBQUtyRUMsRUFBQUEscUJBQXFCLEVBQUUsVUFMOEM7QUFNckVDLEVBQUFBLHNCQUFzQixFQUFFLEVBTjZDO0FBT3JFQyxFQUFBQSxzQkFBc0IsRUFBRSxFQVA2QztBQVFyRUMsRUFBQUEseUJBQXlCLEVBQUU7QUFDekJsQixJQUFBQSxhQUFhLEVBQUUsRUFEVTtBQUV6QkMsSUFBQUEsa0JBQWtCLEVBQUU7QUFDbEJDLE1BQUFBLFNBQVMsRUFBRSxFQURPO0FBRWxCQyxNQUFBQSxZQUFZLEVBQUUsQ0FGSTtBQUdsQkMsTUFBQUEsY0FBYyxFQUFFO0FBSEU7QUFGSyxHQVIwQztBQWdCckVlLEVBQUFBLHFCQUFxQixFQUFFQyxtREFoQjhDO0FBaUJyRUMsRUFBQUEsa0JBQWtCLEVBQUUsQ0FqQmlEO0FBa0JyRUMsRUFBQUEsa0JBQWtCLEVBQUUsQ0FsQmlEO0FBbUJyRUMsRUFBQUEsV0FBVyxFQUFFLE1BbkJ3RDtBQW9CckVDLEVBQUFBLGtCQUFrQixFQUFFQyxTQXBCaUQ7QUFxQnJFQyxFQUFBQSxzQkFBc0IsRUFBRTtBQUN0QkMsSUFBQUEsYUFBYSxFQUFFLENBRE87QUFFdEJDLElBQUFBLGVBQWUsRUFBRUMsc0NBQTJCLENBQTNCLEVBQThCQztBQUZ6QixHQXJCNkM7QUF5QnJFQyxFQUFBQSxVQUFVLEVBQUU7QUFDVkMsSUFBQUEsZUFBZSxFQUFFLEVBRFA7QUFFVkMsSUFBQUEsYUFBYSxFQUFFLEVBRkw7QUFHVkMsSUFBQUEsY0FBYyxFQUFFLEVBSE47QUFJVkMsSUFBQUEsa0JBQWtCLEVBQUUsRUFKVjtBQUtWQyxJQUFBQSxrQkFBa0IsRUFBRSxFQUxWO0FBTVZDLElBQUFBLHFCQUFxQixFQUFFLEVBTmI7QUFPVkMsSUFBQUEsY0FBYyxFQUFFLEVBUE47QUFRVkMsSUFBQUEsa0JBQWtCLEVBQUUsRUFSVjtBQVNWQyxJQUFBQSxrQkFBa0IsRUFBRSxFQVRWO0FBVVZDLElBQUFBLG9CQUFvQixFQUFFLEVBVlo7QUFXVkMsSUFBQUEsdUJBQXVCLEVBQUU7QUFYZjtBQXpCeUQsQ0FBaEU7O0FBd0NBLE1BQU1DLGlCQUF5QyxHQUFHLEVBQ3ZELEdBQUdqQywrQkFEb0Q7QUFFdkRXLEVBQUFBLGtCQUFrQixFQUFFLENBRm1DO0FBR3ZEQyxFQUFBQSxrQkFBa0IsRUFBRSxDQUhtQztBQUl2REMsRUFBQUEsV0FBVyxFQUFFO0FBSjBDLENBQWxEOztBQU9BLE1BQU1xQix1QkFBdUIsR0FBSTtBQUN4QztBQUNBO0FBQ0EsRUFITzs7QUFLQSxNQUFNQyxpQkFBeUMsR0FBRyxFQUN2RCxHQUFHbkMsK0JBRG9EO0FBRXZEVyxFQUFBQSxrQkFBa0IsRUFBRSxDQUZtQztBQUd2REMsRUFBQUEsa0JBQWtCLEVBQUUsQ0FIbUM7QUFJdkRDLEVBQUFBLFdBQVcsRUFBRSxVQUowQztBQUt2REcsRUFBQUEsc0JBQXNCLEVBQUU7QUFDdEJDLElBQUFBLGFBQWEsRUFBRSxFQURPO0FBRXRCQyxJQUFBQSxlQUFlLEVBQUU7QUFGSztBQUwrQixDQUFsRDs7QUFXQSxNQUFNa0IsdUJBQXVCLEdBQUk7QUFDeEM7QUFDQTtBQUNBO0FBQ0EsRUFKTzs7QUFNQSxNQUFNQyxpQkFBeUMsR0FBRyxFQUN2RCxHQUFHckMsK0JBRG9EO0FBRXZEVyxFQUFBQSxrQkFBa0IsRUFBRSxDQUZtQztBQUd2REMsRUFBQUEsa0JBQWtCLEVBQUUsQ0FIbUM7QUFJdkRDLEVBQUFBLFdBQVcsRUFBRSxNQUowQztBQUt2REMsRUFBQUEsa0JBQWtCLEVBQUU7QUFMbUMsQ0FBbEQ7O0FBUUEsTUFBTXdCLHVCQUF1QixHQUFJO0FBQ3hDO0FBQ0E7QUFDQTtBQUNBLEVBSk87O0FBTUEsTUFBTUMseUJBQWlELEdBQUcsRUFDL0QsR0FBR3ZDLCtCQUQ0RDtBQUUvREMsRUFBQUEsVUFBVSxFQUFFLFlBRm1EO0FBRy9ERSxFQUFBQSxRQUFRLEVBQUUsVUFIcUQ7QUFJL0RELEVBQUFBLFNBQVMsRUFBRSxPQUpvRDtBQUsvREksRUFBQUEsc0JBQXNCLEVBQUUsQ0FDdEI7QUFDRXRCLElBQUFBLEVBQUUsRUFBRSxHQUROO0FBRUVDLElBQUFBLFNBQVMsRUFBRSxRQUZiO0FBR0VDLElBQUFBLFFBQVEsRUFBRSxRQUhaO0FBSUVDLElBQUFBLGtCQUFrQixFQUFFO0FBSnRCLEdBRHNCLEVBT3RCO0FBQ0VILElBQUFBLEVBQUUsRUFBRSxHQUROO0FBRUVDLElBQUFBLFNBQVMsRUFBRSxRQUZiO0FBR0VDLElBQUFBLFFBQVEsRUFBRSxLQUhaO0FBSUVDLElBQUFBLGtCQUFrQixFQUFFO0FBSnRCLEdBUHNCLEVBYXRCO0FBQ0VILElBQUFBLEVBQUUsRUFBRSxHQUROO0FBRUVDLElBQUFBLFNBQVMsRUFBRSxRQUZiO0FBR0VDLElBQUFBLFFBQVEsRUFBRSxTQUhaO0FBSUVDLElBQUFBLGtCQUFrQixFQUFFO0FBSnRCLEdBYnNCLENBTHVDO0FBeUIvRHdCLEVBQUFBLGtCQUFrQixFQUFFLENBekIyQztBQTBCL0RDLEVBQUFBLGtCQUFrQixFQUFFLENBMUIyQztBQTJCL0RDLEVBQUFBLFdBQVcsRUFBRSxVQTNCa0Q7QUE0Qi9ERyxFQUFBQSxzQkFBc0IsRUFBRTtBQUN0QkMsSUFBQUEsYUFBYSxFQUFFLENBRE87QUFFdEJDLElBQUFBLGVBQWUsRUFBRTtBQUZLLEdBNUJ1QztBQWdDL0RKLEVBQUFBLGtCQUFrQixFQUFFO0FBaEMyQyxDQUExRDs7QUFtQ0EsTUFBTTBCLCtCQUErQixHQUFJO0FBQ2hEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEVBVk87O0FBWUEsTUFBTUMseUJBQWlELEdBQUcsRUFDL0QsR0FBR3pDLCtCQUQ0RDtBQUUvREMsRUFBQUEsVUFBVSxFQUFFLFlBRm1EO0FBRy9ERSxFQUFBQSxRQUFRLEVBQUUsVUFIcUQ7QUFJL0RELEVBQUFBLFNBQVMsRUFBRSxPQUpvRDtBQUsvREksRUFBQUEsc0JBQXNCLEVBQUUsQ0FDdEI7QUFDRXRCLElBQUFBLEVBQUUsRUFBRSxHQUROO0FBRUVDLElBQUFBLFNBQVMsRUFBRSxRQUZiO0FBR0VDLElBQUFBLFFBQVEsRUFBRSxRQUhaO0FBSUVDLElBQUFBLGtCQUFrQixFQUFFO0FBSnRCLEdBRHNCLENBTHVDO0FBYS9Ed0IsRUFBQUEsa0JBQWtCLEVBQUUsQ0FiMkM7QUFjL0RDLEVBQUFBLGtCQUFrQixFQUFFLENBZDJDO0FBZS9EQyxFQUFBQSxXQUFXLEVBQUUsTUFma0Q7QUFnQi9EQyxFQUFBQSxrQkFBa0IsRUFBRTtBQWhCMkMsQ0FBMUQ7O0FBbUJBLE1BQU00QiwrQkFBK0IsR0FBSTtBQUNoRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQVBPOztBQVNBLE1BQU1DLHlCQUFpRCxHQUFHLEVBQy9ELEdBQUczQywrQkFENEQ7QUFFL0RDLEVBQUFBLFVBQVUsRUFBRSxZQUZtRDtBQUcvREUsRUFBQUEsUUFBUSxFQUFFLFVBSHFEO0FBSS9ERCxFQUFBQSxTQUFTLEVBQUUsT0FKb0Q7QUFLL0RPLEVBQUFBLHFCQUFxQixFQUFFLFlBTHdDO0FBTS9ERixFQUFBQSxzQkFBc0IsRUFBRSxDQUFDLFFBQUQsRUFBVyxRQUFYLEVBQXFCLFFBQXJCLENBTnVDO0FBTy9ESSxFQUFBQSxrQkFBa0IsRUFBRSxDQVAyQztBQVEvREMsRUFBQUEsa0JBQWtCLEVBQUUsQ0FSMkM7QUFTL0RDLEVBQUFBLFdBQVcsRUFBRSxVQVRrRDtBQVUvREcsRUFBQUEsc0JBQXNCLEVBQUU7QUFDdEJDLElBQUFBLGFBQWEsRUFBRSxDQURPO0FBRXRCQyxJQUFBQSxlQUFlLEVBQUU7QUFGSyxHQVZ1QztBQWMvREosRUFBQUEsa0JBQWtCLEVBQUU7QUFkMkMsQ0FBMUQ7O0FBaUJBLE1BQU04QiwrQkFBK0IsR0FBSTtBQUNoRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxFQVZPOztBQVlBLE1BQU1DLHlCQUFpRCxHQUFHLEVBQy9ELEdBQUc3QywrQkFENEQ7QUFFL0RDLEVBQUFBLFVBQVUsRUFBRSxZQUZtRDtBQUcvREUsRUFBQUEsUUFBUSxFQUFFLFVBSHFEO0FBSS9ERCxFQUFBQSxTQUFTLEVBQUUsT0FKb0Q7QUFLL0RPLEVBQUFBLHFCQUFxQixFQUFFLFlBTHdDO0FBTS9ERixFQUFBQSxzQkFBc0IsRUFBRSxDQUFDLFFBQUQsQ0FOdUM7QUFPL0RJLEVBQUFBLGtCQUFrQixFQUFFLENBUDJDO0FBUS9EQyxFQUFBQSxrQkFBa0IsRUFBRSxDQVIyQztBQVMvREMsRUFBQUEsV0FBVyxFQUFFLE1BVGtEO0FBVS9EQyxFQUFBQSxrQkFBa0IsRUFBRTtBQVYyQyxDQUExRDs7QUFhQSxNQUFNZ0MsK0JBQStCLEdBQUk7QUFDaEQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFQTzs7QUFTQSxNQUFNQyw0QkFBb0QsR0FBRyxFQUNsRSxHQUFHL0MsK0JBRCtEO0FBRWxFQyxFQUFBQSxVQUFVLEVBQUUsWUFGc0Q7QUFHbEVFLEVBQUFBLFFBQVEsRUFBRSxVQUh3RDtBQUlsRUQsRUFBQUEsU0FBUyxFQUFFLE9BSnVEO0FBS2xFTyxFQUFBQSxxQkFBcUIsRUFBRSxZQUwyQztBQU1sRUQsRUFBQUEseUJBQXlCLEVBQUU7QUFDekJsQixJQUFBQSxhQUFhLEVBQUUsQ0FDYjtBQUFFTixNQUFBQSxFQUFFLEVBQUUsR0FBTjtBQUFXWSxNQUFBQSxZQUFZLEVBQUUsT0FBekI7QUFBa0NDLE1BQUFBLGFBQWEsRUFBRSxPQUFqRDtBQUEwRG1ELE1BQUFBLFVBQVUsRUFBRTtBQUF0RSxLQURhLEVBRWI7QUFBRWhFLE1BQUFBLEVBQUUsRUFBRSxHQUFOO0FBQVdZLE1BQUFBLFlBQVksRUFBRSxPQUF6QjtBQUFrQ0MsTUFBQUEsYUFBYSxFQUFFLEdBQWpEO0FBQXNEbUQsTUFBQUEsVUFBVSxFQUFFO0FBQWxFLEtBRmEsRUFHYjtBQUFFaEUsTUFBQUEsRUFBRSxFQUFFLEdBQU47QUFBV1ksTUFBQUEsWUFBWSxFQUFFLEtBQXpCO0FBQWdDQyxNQUFBQSxhQUFhLEVBQUU7QUFBL0MsS0FIYSxFQUliO0FBQUViLE1BQUFBLEVBQUUsRUFBRSxHQUFOO0FBQVdZLE1BQUFBLFlBQVksRUFBRSxLQUF6QjtBQUFnQ0MsTUFBQUEsYUFBYSxFQUFFLFFBQS9DO0FBQXlEbUQsTUFBQUEsVUFBVSxFQUFFO0FBQXJFLEtBSmEsQ0FEVTtBQU96QnpELElBQUFBLGtCQUFrQixFQUFFO0FBQ2xCQyxNQUFBQSxTQUFTLEVBQUUsV0FETztBQUVsQkMsTUFBQUEsWUFBWSxFQUFFLENBRkk7QUFHbEJDLE1BQUFBLGNBQWMsRUFBRTtBQUhFO0FBUEssR0FOdUM7QUFtQmxFaUIsRUFBQUEsa0JBQWtCLEVBQUUsQ0FuQjhDO0FBb0JsRUMsRUFBQUEsa0JBQWtCLEVBQUUsQ0FwQjhDO0FBcUJsRUMsRUFBQUEsV0FBVyxFQUFFLFVBckJxRDtBQXNCbEVHLEVBQUFBLHNCQUFzQixFQUFFO0FBQ3RCQyxJQUFBQSxhQUFhLEVBQUUsQ0FETztBQUV0QkMsSUFBQUEsZUFBZSxFQUFFO0FBRkssR0F0QjBDO0FBMEJsRUosRUFBQUEsa0JBQWtCLEVBQUU7QUExQjhDLENBQTdEOztBQTZCQSxNQUFNbUMsa0NBQWtDLEdBQUk7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsRUFiTzs7QUFlQSxNQUFNQyw0QkFBb0QsR0FBRyxFQUNsRSxHQUFHbEQsK0JBRCtEO0FBRWxFQyxFQUFBQSxVQUFVLEVBQUUsWUFGc0Q7QUFHbEVFLEVBQUFBLFFBQVEsRUFBRSxVQUh3RDtBQUlsRUQsRUFBQUEsU0FBUyxFQUFFLE9BSnVEO0FBS2xFTyxFQUFBQSxxQkFBcUIsRUFBRSxZQUwyQztBQU1sRUQsRUFBQUEseUJBQXlCLEVBQUU7QUFDekJsQixJQUFBQSxhQUFhLEVBQUUsQ0FBQztBQUFFTixNQUFBQSxFQUFFLEVBQUUsR0FBTjtBQUFXWSxNQUFBQSxZQUFZLEVBQUUsT0FBekI7QUFBa0NDLE1BQUFBLGFBQWEsRUFBRTtBQUFqRCxLQUFELENBRFU7QUFFekJOLElBQUFBLGtCQUFrQixFQUFFO0FBQ2xCQyxNQUFBQSxTQUFTLEVBQUUsV0FETztBQUVsQkMsTUFBQUEsWUFBWSxFQUFFLENBRkk7QUFHbEJDLE1BQUFBLGNBQWMsRUFBRTtBQUhFO0FBRkssR0FOdUM7QUFjbEVpQixFQUFBQSxrQkFBa0IsRUFBRSxDQWQ4QztBQWVsRUMsRUFBQUEsa0JBQWtCLEVBQUUsQ0FmOEM7QUFnQmxFQyxFQUFBQSxXQUFXLEVBQUUsTUFoQnFEO0FBaUJsRUMsRUFBQUEsa0JBQWtCLEVBQUU7QUFqQjhDLENBQTdEOztBQW9CQSxNQUFNcUMsa0NBQWtDLEdBQUk7QUFDbkQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEVBVE8iLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7XG4gIEFDQ0VMRVJBVElPTl9ERUZVQUxUX1NLSVBQSU5HX0lOREVYX05BTUUsXG4gIEFDQ0VMRVJBVElPTl9USU1FX0lOVEVSVkFMLFxufSBmcm9tICcuLi8uLi9jb21tb24vY29uc3RhbnRzJztcbmltcG9ydCB7XG4gIENyZWF0ZUFjY2VsZXJhdGlvbkZvcm0sXG4gIFNraXBwaW5nSW5kZXhSb3dUeXBlLFxuICBtYXRlcmlhbGl6ZWRWaWV3UXVlcnlUeXBlLFxufSBmcm9tICcuLi8uLi9jb21tb24vdHlwZXMnO1xuXG5leHBvcnQgY29uc3Qgc2tpcHBpbmdJbmRleERhdGFNb2NrOiBTa2lwcGluZ0luZGV4Um93VHlwZVtdID0gW1xuICB7XG4gICAgaWQ6ICcxJyxcbiAgICBmaWVsZE5hbWU6ICdmaWVsZDEnLFxuICAgIGRhdGFUeXBlOiAnc3RyaW5nJyxcbiAgICBhY2NlbGVyYXRpb25NZXRob2Q6ICdQQVJUSVRJT04nLFxuICB9LFxuICB7XG4gICAgaWQ6ICcyJyxcbiAgICBmaWVsZE5hbWU6ICdmaWVsZDInLFxuICAgIGRhdGFUeXBlOiAnbnVtYmVyJyxcbiAgICBhY2NlbGVyYXRpb25NZXRob2Q6ICdWQUxVRV9TRVQnLFxuICB9LFxuXTtcblxuZXhwb3J0IGNvbnN0IGNvdmVyaW5nSW5kZXhEYXRhTW9jazogc3RyaW5nW10gPSBbJ2ZpZWxkMScsICdmaWVsZDInLCAnZmllbGQzJ107XG5cbmV4cG9ydCBjb25zdCBtYXRlcmlhbGl6ZWRWaWV3RW1wdHlEYXRhTW9jayA9IHtcbiAgY29sdW1uc1ZhbHVlczogW10sXG4gIGdyb3VwQnlUdW1ibGVWYWx1ZToge1xuICAgIHRpbWVGaWVsZDogJycsXG4gICAgdHVtYmxlV2luZG93OiAwLFxuICAgIHR1bWJsZUludGVydmFsOiAnJyxcbiAgfSxcbn07XG5cbmV4cG9ydCBjb25zdCBtYXRlcmlhbGl6ZWRWaWV3RW1wdHlUdW1ibGVEYXRhTW9jazogbWF0ZXJpYWxpemVkVmlld1F1ZXJ5VHlwZSA9IHtcbiAgY29sdW1uc1ZhbHVlczogW1xuICAgIHtcbiAgICAgIGlkOiAnMScsXG4gICAgICBmdW5jdGlvbk5hbWU6ICdjb3VudCcsXG4gICAgICBmdW5jdGlvblBhcmFtOiAnZmllbGQxJyxcbiAgICB9LFxuICBdLFxuICBncm91cEJ5VHVtYmxlVmFsdWU6IHtcbiAgICB0aW1lRmllbGQ6ICcnLFxuICAgIHR1bWJsZVdpbmRvdzogMCxcbiAgICB0dW1ibGVJbnRlcnZhbDogJ3NlY29uZCcsXG4gIH0sXG59O1xuXG5leHBvcnQgY29uc3QgbWF0ZXJpYWxpemVkVmlld1N0YWxlRGF0YU1vY2s6IG1hdGVyaWFsaXplZFZpZXdRdWVyeVR5cGUgPSB7XG4gIGNvbHVtbnNWYWx1ZXM6IFtdLFxuICBncm91cEJ5VHVtYmxlVmFsdWU6IHtcbiAgICB0aW1lRmllbGQ6ICd0aW1lc3RhbXAnLFxuICAgIHR1bWJsZVdpbmRvdzogMTAsXG4gICAgdHVtYmxlSW50ZXJ2YWw6ICdob3VyJyxcbiAgfSxcbn07XG5cbmV4cG9ydCBjb25zdCBtYXRlcmlhbGl6ZWRWaWV3VmFsaWREYXRhTW9jazogbWF0ZXJpYWxpemVkVmlld1F1ZXJ5VHlwZSA9IHtcbiAgY29sdW1uc1ZhbHVlczogW1xuICAgIHtcbiAgICAgIGlkOiAnMScsXG4gICAgICBmdW5jdGlvbk5hbWU6ICdjb3VudCcsXG4gICAgICBmdW5jdGlvblBhcmFtOiAnZmllbGQxJyxcbiAgICB9LFxuICAgIHtcbiAgICAgIGlkOiAnMicsXG4gICAgICBmdW5jdGlvbk5hbWU6ICdzdW0nLFxuICAgICAgZnVuY3Rpb25QYXJhbTogJ2ZpZWxkMicsXG4gICAgfSxcbiAgXSxcbiAgZ3JvdXBCeVR1bWJsZVZhbHVlOiB7XG4gICAgdGltZUZpZWxkOiAndGltZXN0YW1wJyxcbiAgICB0dW1ibGVXaW5kb3c6IDUsXG4gICAgdHVtYmxlSW50ZXJ2YWw6ICdob3VyJyxcbiAgfSxcbn07XG5cbmV4cG9ydCBjb25zdCBjcmVhdGVBY2NlbGVyYXRpb25FbXB0eURhdGFNb2NrOiBDcmVhdGVBY2NlbGVyYXRpb25Gb3JtID0ge1xuICBkYXRhU291cmNlOiAnJyxcbiAgZGF0YVRhYmxlOiAnJyxcbiAgZGF0YWJhc2U6ICcnLFxuICBkYXRhVGFibGVGaWVsZHM6IFtdLFxuICBhY2NlbGVyYXRpb25JbmRleFR5cGU6ICdza2lwcGluZycsXG4gIHNraXBwaW5nSW5kZXhRdWVyeURhdGE6IFtdLFxuICBjb3ZlcmluZ0luZGV4UXVlcnlEYXRhOiBbXSxcbiAgbWF0ZXJpYWxpemVkVmlld1F1ZXJ5RGF0YToge1xuICAgIGNvbHVtbnNWYWx1ZXM6IFtdLFxuICAgIGdyb3VwQnlUdW1ibGVWYWx1ZToge1xuICAgICAgdGltZUZpZWxkOiAnJyxcbiAgICAgIHR1bWJsZVdpbmRvdzogMCxcbiAgICAgIHR1bWJsZUludGVydmFsOiAnJyxcbiAgICB9LFxuICB9LFxuICBhY2NlbGVyYXRpb25JbmRleE5hbWU6IEFDQ0VMRVJBVElPTl9ERUZVQUxUX1NLSVBQSU5HX0lOREVYX05BTUUsXG4gIHByaW1hcnlTaGFyZHNDb3VudDogNSxcbiAgcmVwbGljYVNoYXJkc0NvdW50OiAxLFxuICByZWZyZXNoVHlwZTogJ2F1dG8nLFxuICBjaGVja3BvaW50TG9jYXRpb246IHVuZGVmaW5lZCxcbiAgcmVmcmVzaEludGVydmFsT3B0aW9uczoge1xuICAgIHJlZnJlc2hXaW5kb3c6IDEsXG4gICAgcmVmcmVzaEludGVydmFsOiBBQ0NFTEVSQVRJT05fVElNRV9JTlRFUlZBTFsxXS52YWx1ZSxcbiAgfSxcbiAgZm9ybUVycm9yczoge1xuICAgIGRhdGFTb3VyY2VFcnJvcjogW10sXG4gICAgZGF0YWJhc2VFcnJvcjogW10sXG4gICAgZGF0YVRhYmxlRXJyb3I6IFtdLFxuICAgIHNraXBwaW5nSW5kZXhFcnJvcjogW10sXG4gICAgY292ZXJpbmdJbmRleEVycm9yOiBbXSxcbiAgICBtYXRlcmlhbGl6ZWRWaWV3RXJyb3I6IFtdLFxuICAgIGluZGV4TmFtZUVycm9yOiBbXSxcbiAgICBwcmltYXJ5U2hhcmRzRXJyb3I6IFtdLFxuICAgIHJlcGxpY2FTaGFyZHNFcnJvcjogW10sXG4gICAgcmVmcmVzaEludGVydmFsRXJyb3I6IFtdLFxuICAgIGNoZWNrcG9pbnRMb2NhdGlvbkVycm9yOiBbXSxcbiAgfSxcbn07XG5cbmV4cG9ydCBjb25zdCBpbmRleE9wdGlvbnNNb2NrMTogQ3JlYXRlQWNjZWxlcmF0aW9uRm9ybSA9IHtcbiAgLi4uY3JlYXRlQWNjZWxlcmF0aW9uRW1wdHlEYXRhTW9jayxcbiAgcHJpbWFyeVNoYXJkc0NvdW50OiAzLFxuICByZXBsaWNhU2hhcmRzQ291bnQ6IDIsXG4gIHJlZnJlc2hUeXBlOiAnYXV0bycsXG59O1xuXG5leHBvcnQgY29uc3QgaW5kZXhPcHRpb25zTW9ja1Jlc3VsdDEgPSBgV0lUSCAoXG5pbmRleF9zZXR0aW5ncyA9ICd7XCJudW1iZXJfb2Zfc2hhcmRzXCI6MyxcIm51bWJlcl9vZl9yZXBsaWNhc1wiOjJ9JyxcbmF1dG9fcmVmcmVzaCA9IHRydWVcbilgO1xuXG5leHBvcnQgY29uc3QgaW5kZXhPcHRpb25zTW9jazI6IENyZWF0ZUFjY2VsZXJhdGlvbkZvcm0gPSB7XG4gIC4uLmNyZWF0ZUFjY2VsZXJhdGlvbkVtcHR5RGF0YU1vY2ssXG4gIHByaW1hcnlTaGFyZHNDb3VudDogMyxcbiAgcmVwbGljYVNoYXJkc0NvdW50OiAyLFxuICByZWZyZXNoVHlwZTogJ2ludGVydmFsJyxcbiAgcmVmcmVzaEludGVydmFsT3B0aW9uczoge1xuICAgIHJlZnJlc2hXaW5kb3c6IDEwLFxuICAgIHJlZnJlc2hJbnRlcnZhbDogJ21pbnV0ZScsXG4gIH0sXG59O1xuXG5leHBvcnQgY29uc3QgaW5kZXhPcHRpb25zTW9ja1Jlc3VsdDIgPSBgV0lUSCAoXG5pbmRleF9zZXR0aW5ncyA9ICd7XCJudW1iZXJfb2Zfc2hhcmRzXCI6MyxcIm51bWJlcl9vZl9yZXBsaWNhc1wiOjJ9JyxcbmF1dG9fcmVmcmVzaCA9IGZhbHNlLFxucmVmcmVzaF9pbnRlcnZhbCA9ICcxMCBtaW51dGVzJ1xuKWA7XG5cbmV4cG9ydCBjb25zdCBpbmRleE9wdGlvbnNNb2NrMzogQ3JlYXRlQWNjZWxlcmF0aW9uRm9ybSA9IHtcbiAgLi4uY3JlYXRlQWNjZWxlcmF0aW9uRW1wdHlEYXRhTW9jayxcbiAgcHJpbWFyeVNoYXJkc0NvdW50OiAzLFxuICByZXBsaWNhU2hhcmRzQ291bnQ6IDIsXG4gIHJlZnJlc2hUeXBlOiAnYXV0bycsXG4gIGNoZWNrcG9pbnRMb2NhdGlvbjogJ3MzOi8vcGF0aC90by9jaGVja3BvaW50Jyxcbn07XG5cbmV4cG9ydCBjb25zdCBpbmRleE9wdGlvbnNNb2NrUmVzdWx0MyA9IGBXSVRIIChcbmluZGV4X3NldHRpbmdzID0gJ3tcIm51bWJlcl9vZl9zaGFyZHNcIjozLFwibnVtYmVyX29mX3JlcGxpY2FzXCI6Mn0nLFxuYXV0b19yZWZyZXNoID0gdHJ1ZSxcbmNoZWNrcG9pbnRfbG9jYXRpb24gPSAnczM6Ly9wYXRoL3RvL2NoZWNrcG9pbnQnXG4pYDtcblxuZXhwb3J0IGNvbnN0IHNraXBwaW5nSW5kZXhCdWlsZGVyTW9jazE6IENyZWF0ZUFjY2VsZXJhdGlvbkZvcm0gPSB7XG4gIC4uLmNyZWF0ZUFjY2VsZXJhdGlvbkVtcHR5RGF0YU1vY2ssXG4gIGRhdGFTb3VyY2U6ICdkYXRhc291cmNlJyxcbiAgZGF0YWJhc2U6ICdkYXRhYmFzZScsXG4gIGRhdGFUYWJsZTogJ3RhYmxlJyxcbiAgc2tpcHBpbmdJbmRleFF1ZXJ5RGF0YTogW1xuICAgIHtcbiAgICAgIGlkOiAnMScsXG4gICAgICBmaWVsZE5hbWU6ICdmaWVsZDEnLFxuICAgICAgZGF0YVR5cGU6ICdzdHJpbmcnLFxuICAgICAgYWNjZWxlcmF0aW9uTWV0aG9kOiAnUEFSVElUSU9OJyxcbiAgICB9LFxuICAgIHtcbiAgICAgIGlkOiAnMicsXG4gICAgICBmaWVsZE5hbWU6ICdmaWVsZDInLFxuICAgICAgZGF0YVR5cGU6ICdpbnQnLFxuICAgICAgYWNjZWxlcmF0aW9uTWV0aG9kOiAnVkFMVUVfU0VUJyxcbiAgICB9LFxuICAgIHtcbiAgICAgIGlkOiAnMycsXG4gICAgICBmaWVsZE5hbWU6ICdmaWVsZDMnLFxuICAgICAgZGF0YVR5cGU6ICdib29sZWFuJyxcbiAgICAgIGFjY2VsZXJhdGlvbk1ldGhvZDogJ01JTl9NQVgnLFxuICAgIH0sXG4gIF0sXG4gIHByaW1hcnlTaGFyZHNDb3VudDogOSxcbiAgcmVwbGljYVNoYXJkc0NvdW50OiAyLFxuICByZWZyZXNoVHlwZTogJ2ludGVydmFsJyxcbiAgcmVmcmVzaEludGVydmFsT3B0aW9uczoge1xuICAgIHJlZnJlc2hXaW5kb3c6IDEsXG4gICAgcmVmcmVzaEludGVydmFsOiAnbWludXRlJyxcbiAgfSxcbiAgY2hlY2twb2ludExvY2F0aW9uOiAnczM6Ly90ZXN0LycsXG59O1xuXG5leHBvcnQgY29uc3Qgc2tpcHBpbmdJbmRleEJ1aWxkZXJNb2NrUmVzdWx0MSA9IGBDUkVBVEUgU0tJUFBJTkcgSU5ERVhcbk9OIGRhdGFzb3VyY2UuZGF0YWJhc2UudGFibGUgKFxuICAgZmllbGQxIFBBUlRJVElPTiwgXG4gICBmaWVsZDIgVkFMVUVfU0VULCBcbiAgIGZpZWxkMyBNSU5fTUFYXG4gICkgV0lUSCAoXG5pbmRleF9zZXR0aW5ncyA9ICd7XCJudW1iZXJfb2Zfc2hhcmRzXCI6OSxcIm51bWJlcl9vZl9yZXBsaWNhc1wiOjJ9JyxcbmF1dG9fcmVmcmVzaCA9IGZhbHNlLFxucmVmcmVzaF9pbnRlcnZhbCA9ICcxIG1pbnV0ZScsXG5jaGVja3BvaW50X2xvY2F0aW9uID0gJ3MzOi8vdGVzdC8nXG4pYDtcblxuZXhwb3J0IGNvbnN0IHNraXBwaW5nSW5kZXhCdWlsZGVyTW9jazI6IENyZWF0ZUFjY2VsZXJhdGlvbkZvcm0gPSB7XG4gIC4uLmNyZWF0ZUFjY2VsZXJhdGlvbkVtcHR5RGF0YU1vY2ssXG4gIGRhdGFTb3VyY2U6ICdkYXRhc291cmNlJyxcbiAgZGF0YWJhc2U6ICdkYXRhYmFzZScsXG4gIGRhdGFUYWJsZTogJ3RhYmxlJyxcbiAgc2tpcHBpbmdJbmRleFF1ZXJ5RGF0YTogW1xuICAgIHtcbiAgICAgIGlkOiAnMScsXG4gICAgICBmaWVsZE5hbWU6ICdmaWVsZDEnLFxuICAgICAgZGF0YVR5cGU6ICdzdHJpbmcnLFxuICAgICAgYWNjZWxlcmF0aW9uTWV0aG9kOiAnUEFSVElUSU9OJyxcbiAgICB9LFxuICBdLFxuICBwcmltYXJ5U2hhcmRzQ291bnQ6IDUsXG4gIHJlcGxpY2FTaGFyZHNDb3VudDogMyxcbiAgcmVmcmVzaFR5cGU6ICdhdXRvJyxcbiAgY2hlY2twb2ludExvY2F0aW9uOiAnczM6Ly90ZXN0LycsXG59O1xuXG5leHBvcnQgY29uc3Qgc2tpcHBpbmdJbmRleEJ1aWxkZXJNb2NrUmVzdWx0MiA9IGBDUkVBVEUgU0tJUFBJTkcgSU5ERVhcbk9OIGRhdGFzb3VyY2UuZGF0YWJhc2UudGFibGUgKFxuICAgZmllbGQxIFBBUlRJVElPTlxuICApIFdJVEggKFxuaW5kZXhfc2V0dGluZ3MgPSAne1wibnVtYmVyX29mX3NoYXJkc1wiOjUsXCJudW1iZXJfb2ZfcmVwbGljYXNcIjozfScsXG5hdXRvX3JlZnJlc2ggPSB0cnVlLFxuY2hlY2twb2ludF9sb2NhdGlvbiA9ICdzMzovL3Rlc3QvJ1xuKWA7XG5cbmV4cG9ydCBjb25zdCBjb3ZlcmluZ0luZGV4QnVpbGRlck1vY2sxOiBDcmVhdGVBY2NlbGVyYXRpb25Gb3JtID0ge1xuICAuLi5jcmVhdGVBY2NlbGVyYXRpb25FbXB0eURhdGFNb2NrLFxuICBkYXRhU291cmNlOiAnZGF0YXNvdXJjZScsXG4gIGRhdGFiYXNlOiAnZGF0YWJhc2UnLFxuICBkYXRhVGFibGU6ICd0YWJsZScsXG4gIGFjY2VsZXJhdGlvbkluZGV4TmFtZTogJ2luZGV4X25hbWUnLFxuICBjb3ZlcmluZ0luZGV4UXVlcnlEYXRhOiBbJ2ZpZWxkMScsICdmaWVsZDInLCAnZmllbGQzJ10sXG4gIHByaW1hcnlTaGFyZHNDb3VudDogOSxcbiAgcmVwbGljYVNoYXJkc0NvdW50OiAyLFxuICByZWZyZXNoVHlwZTogJ2ludGVydmFsJyxcbiAgcmVmcmVzaEludGVydmFsT3B0aW9uczoge1xuICAgIHJlZnJlc2hXaW5kb3c6IDEsXG4gICAgcmVmcmVzaEludGVydmFsOiAnbWludXRlJyxcbiAgfSxcbiAgY2hlY2twb2ludExvY2F0aW9uOiAnczM6Ly90ZXN0LycsXG59O1xuXG5leHBvcnQgY29uc3QgY292ZXJpbmdJbmRleEJ1aWxkZXJNb2NrUmVzdWx0MSA9IGBDUkVBVEUgSU5ERVggaW5kZXhfbmFtZVxuT04gZGF0YXNvdXJjZS5kYXRhYmFzZS50YWJsZSAoXG4gICBmaWVsZDEsIFxuICAgZmllbGQyLCBcbiAgIGZpZWxkM1xuICApIFdJVEggKFxuaW5kZXhfc2V0dGluZ3MgPSAne1wibnVtYmVyX29mX3NoYXJkc1wiOjksXCJudW1iZXJfb2ZfcmVwbGljYXNcIjoyfScsXG5hdXRvX3JlZnJlc2ggPSBmYWxzZSxcbnJlZnJlc2hfaW50ZXJ2YWwgPSAnMSBtaW51dGUnLFxuY2hlY2twb2ludF9sb2NhdGlvbiA9ICdzMzovL3Rlc3QvJ1xuKWA7XG5cbmV4cG9ydCBjb25zdCBjb3ZlcmluZ0luZGV4QnVpbGRlck1vY2syOiBDcmVhdGVBY2NlbGVyYXRpb25Gb3JtID0ge1xuICAuLi5jcmVhdGVBY2NlbGVyYXRpb25FbXB0eURhdGFNb2NrLFxuICBkYXRhU291cmNlOiAnZGF0YXNvdXJjZScsXG4gIGRhdGFiYXNlOiAnZGF0YWJhc2UnLFxuICBkYXRhVGFibGU6ICd0YWJsZScsXG4gIGFjY2VsZXJhdGlvbkluZGV4TmFtZTogJ2luZGV4X25hbWUnLFxuICBjb3ZlcmluZ0luZGV4UXVlcnlEYXRhOiBbJ2ZpZWxkMSddLFxuICBwcmltYXJ5U2hhcmRzQ291bnQ6IDUsXG4gIHJlcGxpY2FTaGFyZHNDb3VudDogMyxcbiAgcmVmcmVzaFR5cGU6ICdhdXRvJyxcbiAgY2hlY2twb2ludExvY2F0aW9uOiAnczM6Ly90ZXN0LycsXG59O1xuXG5leHBvcnQgY29uc3QgY292ZXJpbmdJbmRleEJ1aWxkZXJNb2NrUmVzdWx0MiA9IGBDUkVBVEUgSU5ERVggaW5kZXhfbmFtZVxuT04gZGF0YXNvdXJjZS5kYXRhYmFzZS50YWJsZSAoXG4gICBmaWVsZDFcbiAgKSBXSVRIIChcbmluZGV4X3NldHRpbmdzID0gJ3tcIm51bWJlcl9vZl9zaGFyZHNcIjo1LFwibnVtYmVyX29mX3JlcGxpY2FzXCI6M30nLFxuYXV0b19yZWZyZXNoID0gdHJ1ZSxcbmNoZWNrcG9pbnRfbG9jYXRpb24gPSAnczM6Ly90ZXN0LydcbilgO1xuXG5leHBvcnQgY29uc3QgbWF0ZXJpYWxpemVkVmlld0J1aWxkZXJNb2NrMTogQ3JlYXRlQWNjZWxlcmF0aW9uRm9ybSA9IHtcbiAgLi4uY3JlYXRlQWNjZWxlcmF0aW9uRW1wdHlEYXRhTW9jayxcbiAgZGF0YVNvdXJjZTogJ2RhdGFzb3VyY2UnLFxuICBkYXRhYmFzZTogJ2RhdGFiYXNlJyxcbiAgZGF0YVRhYmxlOiAndGFibGUnLFxuICBhY2NlbGVyYXRpb25JbmRleE5hbWU6ICdpbmRleF9uYW1lJyxcbiAgbWF0ZXJpYWxpemVkVmlld1F1ZXJ5RGF0YToge1xuICAgIGNvbHVtbnNWYWx1ZXM6IFtcbiAgICAgIHsgaWQ6ICcxJywgZnVuY3Rpb25OYW1lOiAnY291bnQnLCBmdW5jdGlvblBhcmFtOiAnZmllbGQnLCBmaWVsZEFsaWFzOiAnY291bnRlcicgfSxcbiAgICAgIHsgaWQ6ICcyJywgZnVuY3Rpb25OYW1lOiAnY291bnQnLCBmdW5jdGlvblBhcmFtOiAnKicsIGZpZWxkQWxpYXM6ICdjb3VudGVyMScgfSxcbiAgICAgIHsgaWQ6ICczJywgZnVuY3Rpb25OYW1lOiAnc3VtJywgZnVuY3Rpb25QYXJhbTogJ2ZpZWxkMicgfSxcbiAgICAgIHsgaWQ6ICc0JywgZnVuY3Rpb25OYW1lOiAnYXZnJywgZnVuY3Rpb25QYXJhbTogJ2ZpZWxkMycsIGZpZWxkQWxpYXM6ICdhdmVyYWdlJyB9LFxuICAgIF0sXG4gICAgZ3JvdXBCeVR1bWJsZVZhbHVlOiB7XG4gICAgICB0aW1lRmllbGQ6ICd0aW1lc3RhbXAnLFxuICAgICAgdHVtYmxlV2luZG93OiAxLFxuICAgICAgdHVtYmxlSW50ZXJ2YWw6ICdtaW51dGUnLFxuICAgIH0sXG4gIH0sXG4gIHByaW1hcnlTaGFyZHNDb3VudDogOSxcbiAgcmVwbGljYVNoYXJkc0NvdW50OiAyLFxuICByZWZyZXNoVHlwZTogJ2ludGVydmFsJyxcbiAgcmVmcmVzaEludGVydmFsT3B0aW9uczoge1xuICAgIHJlZnJlc2hXaW5kb3c6IDEsXG4gICAgcmVmcmVzaEludGVydmFsOiAnbWludXRlJyxcbiAgfSxcbiAgY2hlY2twb2ludExvY2F0aW9uOiAnczM6Ly90ZXN0LycsXG59O1xuXG5leHBvcnQgY29uc3QgbWF0ZXJpYWxpemVkVmlld0J1aWxkZXJNb2NrUmVzdWx0MSA9IGBDUkVBVEUgTUFURVJJQUxJWkVEIFZJRVcgZGF0YXNvdXJjZS5kYXRhYmFzZS5pbmRleF9uYW1lXG5BUyBTRUxFQ1RcbiAgIGNvdW50KGZpZWxkKSBBUyBjb3VudGVyLCBcbiAgIGNvdW50KCopIEFTIGNvdW50ZXIxLCBcbiAgIHN1bShmaWVsZDIpLCBcbiAgIGF2ZyhmaWVsZDMpIEFTIGF2ZXJhZ2VcbkZST00gZGF0YXNvdXJjZS5kYXRhYmFzZS50YWJsZVxuR1JPVVAgQlkgVFVNQkxFICh0aW1lc3RhbXAsICcxIG1pbnV0ZScpXG4gV0lUSCAoXG5pbmRleF9zZXR0aW5ncyA9ICd7XCJudW1iZXJfb2Zfc2hhcmRzXCI6OSxcIm51bWJlcl9vZl9yZXBsaWNhc1wiOjJ9JyxcbmF1dG9fcmVmcmVzaCA9IGZhbHNlLFxucmVmcmVzaF9pbnRlcnZhbCA9ICcxIG1pbnV0ZScsXG5jaGVja3BvaW50X2xvY2F0aW9uID0gJ3MzOi8vdGVzdC8nXG4pYDtcblxuZXhwb3J0IGNvbnN0IG1hdGVyaWFsaXplZFZpZXdCdWlsZGVyTW9jazI6IENyZWF0ZUFjY2VsZXJhdGlvbkZvcm0gPSB7XG4gIC4uLmNyZWF0ZUFjY2VsZXJhdGlvbkVtcHR5RGF0YU1vY2ssXG4gIGRhdGFTb3VyY2U6ICdkYXRhc291cmNlJyxcbiAgZGF0YWJhc2U6ICdkYXRhYmFzZScsXG4gIGRhdGFUYWJsZTogJ3RhYmxlJyxcbiAgYWNjZWxlcmF0aW9uSW5kZXhOYW1lOiAnaW5kZXhfbmFtZScsXG4gIG1hdGVyaWFsaXplZFZpZXdRdWVyeURhdGE6IHtcbiAgICBjb2x1bW5zVmFsdWVzOiBbeyBpZDogJzEnLCBmdW5jdGlvbk5hbWU6ICdjb3VudCcsIGZ1bmN0aW9uUGFyYW06ICdmaWVsZCcgfV0sXG4gICAgZ3JvdXBCeVR1bWJsZVZhbHVlOiB7XG4gICAgICB0aW1lRmllbGQ6ICd0aW1lc3RhbXAnLFxuICAgICAgdHVtYmxlV2luZG93OiAyLFxuICAgICAgdHVtYmxlSW50ZXJ2YWw6ICdob3VyJyxcbiAgICB9LFxuICB9LFxuICBwcmltYXJ5U2hhcmRzQ291bnQ6IDUsXG4gIHJlcGxpY2FTaGFyZHNDb3VudDogMyxcbiAgcmVmcmVzaFR5cGU6ICdhdXRvJyxcbiAgY2hlY2twb2ludExvY2F0aW9uOiAnczM6Ly90ZXN0LycsXG59O1xuXG5leHBvcnQgY29uc3QgbWF0ZXJpYWxpemVkVmlld0J1aWxkZXJNb2NrUmVzdWx0MiA9IGBDUkVBVEUgTUFURVJJQUxJWkVEIFZJRVcgZGF0YXNvdXJjZS5kYXRhYmFzZS5pbmRleF9uYW1lXG5BUyBTRUxFQ1RcbiAgIGNvdW50KGZpZWxkKVxuRlJPTSBkYXRhc291cmNlLmRhdGFiYXNlLnRhYmxlXG5HUk9VUCBCWSBUVU1CTEUgKHRpbWVzdGFtcCwgJzIgaG91cnMnKVxuIFdJVEggKFxuaW5kZXhfc2V0dGluZ3MgPSAne1wibnVtYmVyX29mX3NoYXJkc1wiOjUsXCJudW1iZXJfb2ZfcmVwbGljYXNcIjozfScsXG5hdXRvX3JlZnJlc2ggPSB0cnVlLFxuY2hlY2twb2ludF9sb2NhdGlvbiA9ICdzMzovL3Rlc3QvJ1xuKWA7XG4iXX0=