"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelRouter = void 0;

var _configSchema = require("@osd/config-schema");

var _common = require("../../common");

var _server = require("../../../../src/core/server");

var _services = require("../services");

var _constants = require("./constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const modelSortQuerySchema = _configSchema.schema.oneOf([_configSchema.schema.literal('name-asc'), _configSchema.schema.literal('name-desc'), _configSchema.schema.literal('model_state-asc'), _configSchema.schema.literal('model_state-desc'), _configSchema.schema.literal('id-asc'), _configSchema.schema.literal('id-desc')]);

const modelStateSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_common.MODEL_STATE.loadFailed), _configSchema.schema.literal(_common.MODEL_STATE.loaded), _configSchema.schema.literal(_common.MODEL_STATE.loading), _configSchema.schema.literal(_common.MODEL_STATE.partiallyLoaded), _configSchema.schema.literal(_common.MODEL_STATE.trained), _configSchema.schema.literal(_common.MODEL_STATE.uploaded), _configSchema.schema.literal(_common.MODEL_STATE.unloaded), _configSchema.schema.literal(_common.MODEL_STATE.uploading)]);

const modelRouter = router => {
  router.get({
    path: _constants.MODEL_API_ENDPOINT,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number({
          min: 0
        }),
        size: _configSchema.schema.number({
          max: 50
        }),
        sort: _configSchema.schema.maybe(_configSchema.schema.oneOf([modelSortQuerySchema, _configSchema.schema.arrayOf(modelSortQuerySchema)])),
        states: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(modelStateSchema), modelStateSchema])),
        nameOrId: _configSchema.schema.maybe(_configSchema.schema.string()),
        extra_query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))
      })
    }
  }, async (context, request) => {
    const {
      from,
      size,
      sort,
      states,
      nameOrId,
      extra_query: extraQuery
    } = request.query;

    try {
      const payload = await _services.ModelService.search({
        client: context.core.opensearch.client,
        from,
        size,
        sort: typeof sort === 'string' ? [sort] : sort,
        states: typeof states === 'string' ? [states] : states,
        nameOrId,
        extraQuery
      });
      return _server.opensearchDashboardsResponseFactory.ok({
        body: payload
      });
    } catch (err) {
      return _server.opensearchDashboardsResponseFactory.badRequest({
        body: err.message
      });
    }
  });
};

exports.modelRouter = modelRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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