/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.util;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.logstash.RubyUtil;

public class TimeValue {
    private final long duration;
    private final TimeUnit timeUnit;

    public static TimeValue fromValue(Object value) {
        if (value instanceof TimeValue) {
            return (TimeValue)value;
        }
        if (value instanceof String) {
            String normalized = ((String)value).toLowerCase().trim();
            if (normalized.endsWith("nanos")) {
                return new TimeValue((long)TimeValue.parse(normalized, 5), TimeUnit.NANOSECONDS);
            }
            if (normalized.endsWith("micros")) {
                return new TimeValue((long)TimeValue.parse(normalized, 6), TimeUnit.MICROSECONDS);
            }
            if (normalized.endsWith("ms")) {
                return new TimeValue((long)TimeValue.parse(normalized, 2), TimeUnit.MILLISECONDS);
            }
            if (normalized.endsWith("s")) {
                return new TimeValue((long)TimeValue.parse(normalized, 1), TimeUnit.SECONDS);
            }
            if (normalized.endsWith("m")) {
                return new TimeValue((long)TimeValue.parse(normalized, 1), TimeUnit.MINUTES);
            }
            if (normalized.endsWith("h")) {
                return new TimeValue((long)TimeValue.parse(normalized, 1), TimeUnit.HOURS);
            }
            if (normalized.endsWith("d")) {
                return new TimeValue((long)TimeValue.parse(normalized, 1), TimeUnit.DAYS);
            }
            if (normalized.matches("^-0*1")) {
                return new TimeValue(-1L, TimeUnit.NANOSECONDS);
            }
            throw RubyUtil.RUBY.newArgumentError("invalid time unit: \"" + value + "\"");
        }
        throw RubyUtil.RUBY.newArgumentError("value is not a string: " + value + " [" + value.getClass().getName() + "]");
    }

    private static int parse(String value, int suffix) {
        String numericPart = value.substring(0, value.length() - suffix).trim();
        try {
            return Integer.parseInt(numericPart);
        }
        catch (NumberFormatException ex) {
            throw RubyUtil.RUBY.newArgumentError("invalid value for Integer(): \"" + numericPart + "\"");
        }
    }

    public TimeValue(int duration, String timeUnit) {
        this((long)duration, TimeUnit.valueOf((timeUnit + "s").toUpperCase()));
    }

    protected TimeValue(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getTimeUnit() {
        String value = this.timeUnit.toString();
        return value.substring(0, value.length() - 1);
    }

    public long toNanos() {
        return this.timeUnit.toNanos(this.duration);
    }

    public long toSeconds() {
        return this.timeUnit.toSeconds(this.duration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeValue timeValue = (TimeValue)o;
        return this.duration == timeValue.duration && this.timeUnit == timeValue.timeUnit || this.toNanos() == timeValue.toNanos();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.duration, this.timeUnit});
    }

    public String toString() {
        return "TimeValue{duration=" + this.duration + ", timeUnit=" + this.timeUnit + "}";
    }
}

