/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.ErrorInitializer;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.WithOrigin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface SectionHelperFactory<T extends SectionHelper> {
    public static final String MAIN_BLOCK_NAME = "$main";

    default public List<String> getDefaultAliases() {
        return Collections.emptyList();
    }

    default public ParametersInfo getParameters() {
        return ParametersInfo.EMPTY;
    }

    default public List<String> getBlockLabels() {
        return Collections.emptyList();
    }

    default public boolean cacheFactoryConfig() {
        return true;
    }

    default public boolean treatUnknownSectionsAsBlocks() {
        return false;
    }

    public T initialize(SectionInitContext var1);

    default public Scope initializeBlock(Scope outerScope, BlockInfo block) {
        return outerScope;
    }

    default public MissingEndTagStrategy missingEndTagStrategy() {
        return MissingEndTagStrategy.ERROR;
    }

    public static final class ParametersInfo
    implements Iterable<List<Parameter>> {
        public static final ParametersInfo EMPTY = ParametersInfo.builder().build();
        private final Map<String, List<Parameter>> parameters;
        private final boolean checkNumberOfParams;

        public static Builder builder() {
            return new Builder();
        }

        private ParametersInfo(Map<String, List<Parameter>> parameters, boolean checkNumberOfParams) {
            this.parameters = new HashMap<String, List<Parameter>>(parameters);
            this.checkNumberOfParams = checkNumberOfParams;
        }

        public List<Parameter> get(String blockLabel) {
            return this.parameters.getOrDefault(blockLabel, Collections.emptyList());
        }

        @Override
        public Iterator<List<Parameter>> iterator() {
            return this.parameters.values().iterator();
        }

        public boolean isCheckNumberOfParams() {
            return this.checkNumberOfParams;
        }

        public static class Builder {
            private final Map<String, List<Parameter>> parameters = new HashMap<String, List<Parameter>>();
            private boolean checkNumberOfParams = true;

            Builder() {
            }

            public Builder addParameter(String name) {
                return this.addParameter(Parameter.builder(name));
            }

            public Builder addParameter(String name, String defaultValue) {
                return this.addParameter(Parameter.builder(name).defaultValue(defaultValue));
            }

            public Builder addParameter(Parameter.Builder param) {
                return this.addParameter(param.build());
            }

            public Builder addParameter(Parameter param) {
                return this.addParameter(SectionHelperFactory.MAIN_BLOCK_NAME, param);
            }

            public Builder addParameter(String blockLabel, String name, String defaultValue) {
                return this.addParameter(blockLabel, Parameter.builder(name).defaultValue(defaultValue));
            }

            public Builder addParameter(String blockLabel, Parameter.Builder parameter) {
                return this.addParameter(blockLabel, parameter.build());
            }

            public Builder addParameter(String blockLabel, Parameter parameter) {
                this.parameters.computeIfAbsent(blockLabel, c -> new ArrayList()).add(parameter);
                return this;
            }

            public Builder checkNumberOfParams(boolean value) {
                this.checkNumberOfParams = value;
                return this;
            }

            public ParametersInfo build() {
                return new ParametersInfo(this.parameters, this.checkNumberOfParams);
            }
        }
    }

    public static interface SectionInitContext
    extends ParserDelegate {
        default public Map<String, String> getParameters() {
            return this.getBlocks().get((int)0).parameters;
        }

        default public boolean hasParameter(String name) {
            return this.getParameters().containsKey(name);
        }

        default public String getParameter(String name) {
            return this.getParameters().get(name);
        }

        default public String getParameterOrDefault(String name, String defaultValue) {
            String param = this.getParameter(name);
            return param == null || "$empty$".equals(param) ? defaultValue : param;
        }

        public Expression getExpression(String var1);

        public Expression parseValue(String var1);

        public List<SectionBlock> getBlocks();

        default public SectionBlock getBlock(String label) {
            for (SectionBlock block : this.getBlocks()) {
                if (!label.equals(block.label)) continue;
                return block;
            }
            return null;
        }

        public Engine getEngine();

        default public TemplateNode.Origin getOrigin() {
            return this.getBlocks().get((int)0).origin;
        }

        public Supplier<Template> getCurrentTemplate();
    }

    public static interface BlockInfo
    extends ParserDelegate,
    WithOrigin {
        public String getLabel();

        public Map<String, String> getParameters();

        default public String getParameter(String name) {
            return this.getParameters().get(name);
        }

        default public boolean hasParameter(String name) {
            return this.getParameters().containsKey(name);
        }

        public Expression addExpression(String var1, String var2);
    }

    public static interface ParserDelegate
    extends ErrorInitializer {
        default public TemplateException createParserError(String message) {
            return this.error(message).build();
        }
    }

    public static enum MissingEndTagStrategy {
        ERROR,
        BIND_TO_PARENT;

    }
}

