/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.customized;

import io.agroal.api.AgroalDataSource;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusConnectionProvider;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class QuarkusConnectionProviderInitiator
implements StandardServiceInitiator<ConnectionProvider> {
    public static final QuarkusConnectionProviderInitiator INSTANCE = new QuarkusConnectionProviderInitiator();

    public Class<ConnectionProvider> getServiceInitiated() {
        return ConnectionProvider.class;
    }

    public ConnectionProvider initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        MultiTenancyStrategy strategy = MultiTenancyStrategy.determineMultiTenancyStrategy(configurationValues);
        if (strategy == MultiTenancyStrategy.DATABASE || strategy == MultiTenancyStrategy.SCHEMA) {
            return null;
        }
        Object o = configurationValues.get("hibernate.connection.datasource");
        if (o != null) {
            AgroalDataSource ds;
            try {
                ds = (AgroalDataSource)o;
            }
            catch (ClassCastException cce) {
                throw new HibernateException("A Datasource was configured as Connection Pool, but it's not the Agroal connection pool. In Quarkus, you need to use Agroal.");
            }
            return new QuarkusConnectionProvider(ds);
        }
        return ConnectionProviderInitiator.INSTANCE.initiateService(configurationValues, registry);
    }
}

