/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AccessControlListHandler
implements HttpHandler {
    private volatile HttpHandler next;
    private volatile boolean defaultAllow = false;
    private final ExchangeAttribute attribute;
    private final List<AclMatch> acl = new CopyOnWriteArrayList<AclMatch>();

    public AccessControlListHandler(HttpHandler next, ExchangeAttribute attribute) {
        this.next = next;
        this.attribute = attribute;
    }

    public AccessControlListHandler(ExchangeAttribute attribute) {
        this.attribute = attribute;
        this.next = ResponseCodeHandler.HANDLE_404;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String attribute = this.attribute.readAttribute(exchange);
        if (this.isAllowed(attribute)) {
            this.next.handleRequest(exchange);
        } else {
            exchange.setStatusCode(403);
            exchange.endExchange();
        }
    }

    boolean isAllowed(String attribute) {
        if (attribute != null) {
            for (AclMatch rule : this.acl) {
                if (!rule.matches(attribute)) continue;
                return !rule.isDeny();
            }
        }
        return this.defaultAllow;
    }

    public boolean isDefaultAllow() {
        return this.defaultAllow;
    }

    public AccessControlListHandler setDefaultAllow(boolean defaultAllow) {
        this.defaultAllow = defaultAllow;
        return this;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public AccessControlListHandler setNext(HttpHandler next) {
        this.next = next;
        return this;
    }

    public AccessControlListHandler addAllow(String pattern) {
        return this.addRule(pattern, false);
    }

    public AccessControlListHandler addDeny(String pattern) {
        return this.addRule(pattern, true);
    }

    public AccessControlListHandler clearRules() {
        this.acl.clear();
        return this;
    }

    private AccessControlListHandler addRule(String userAgent, boolean deny) {
        this.acl.add(new AclMatch(deny, userAgent));
        return this;
    }

    static class AclMatch {
        private final boolean deny;
        private final Pattern pattern;

        protected AclMatch(boolean deny, String pattern) {
            this.deny = deny;
            this.pattern = this.createPattern(pattern);
        }

        private Pattern createPattern(String pattern) {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw UndertowMessages.MESSAGES.notAValidRegularExpressionPattern(pattern);
            }
        }

        boolean matches(String attribute) {
            return this.pattern.matcher(attribute).matches();
        }

        boolean isDeny() {
            return this.deny;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{deny=" + this.deny + ", pattern='" + this.pattern + '\'' + '}';
        }
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final List<AclMatch> peerMatches;
        private final boolean defaultAllow;
        private final ExchangeAttribute attribute;

        private Wrapper(List<AclMatch> peerMatches, boolean defaultAllow, ExchangeAttribute attribute) {
            this.peerMatches = peerMatches;
            this.defaultAllow = defaultAllow;
            this.attribute = attribute;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            AccessControlListHandler res = new AccessControlListHandler(handler, this.attribute);
            for (AclMatch match : this.peerMatches) {
                if (match.deny) {
                    res.addDeny(match.pattern.pattern());
                    continue;
                }
                res.addAllow(match.pattern.pattern());
            }
            res.setDefaultAllow(this.defaultAllow);
            return res;
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "access-control";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("acl", String[].class);
            params.put("default-allow", Boolean.TYPE);
            params.put("attribute", ExchangeAttribute.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> ret = new HashSet<String>();
            ret.add("acl");
            ret.add("attribute");
            return ret;
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            String[] acl = (String[])config.get("acl");
            Boolean defaultAllow = (Boolean)config.get("default-allow");
            ExchangeAttribute attribute = (ExchangeAttribute)config.get("attribute");
            ArrayList<AclMatch> peerMatches = new ArrayList<AclMatch>();
            for (String rule : acl) {
                String[] parts = rule.split(" ");
                if (parts.length != 2) {
                    throw UndertowMessages.MESSAGES.invalidAclRule(rule);
                }
                if (parts[1].trim().equals("allow")) {
                    peerMatches.add(new AclMatch(false, parts[0].trim()));
                    continue;
                }
                if (parts[1].trim().equals("deny")) {
                    peerMatches.add(new AclMatch(true, parts[0].trim()));
                    continue;
                }
                throw UndertowMessages.MESSAGES.invalidAclRule(rule);
            }
            return new Wrapper(peerMatches, defaultAllow == null ? false : defaultAllow, attribute);
        }
    }
}

