/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.def;

import java.security.Key;
import javax.crypto.Cipher;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;

public class DefaultRsaKeyEncryptionJWEAlgorithmProvider
implements JWEAlgorithmProvider {
    private final String jcaAlgorithmName;

    public DefaultRsaKeyEncryptionJWEAlgorithmProvider(String jcaAlgorithmName) {
        this.jcaAlgorithmName = jcaAlgorithmName;
    }

    public byte[] decodeCek(byte[] encodedCek, Key privateKey) throws Exception {
        Cipher cipher = this.getCipherProvider();
        this.initCipher(cipher, 2, privateKey);
        return cipher.doFinal(encodedCek);
    }

    public byte[] encodeCek(JWEEncryptionProvider encryptionProvider, JWEKeyStorage keyStorage, Key publicKey) throws Exception {
        Cipher cipher = this.getCipherProvider();
        this.initCipher(cipher, 1, publicKey);
        byte[] cekBytes = keyStorage.getCekBytes();
        return cipher.doFinal(cekBytes);
    }

    private Cipher getCipherProvider() throws Exception {
        return Cipher.getInstance(this.jcaAlgorithmName);
    }

    protected void initCipher(Cipher cipher, int mode, Key key) throws Exception {
        cipher.init(mode, key);
    }
}

